/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.StyleProperties = {
  STYLE_PROPERTIES : {
    TEXT : [ 'fontFamily', 'fontColor', 'fontSize', 'fontStyle',
        'fontWeight' ],
    POINT : [ 'pointRadius', 'fillColor', 'strokeWidth', 'strokeColor' ],
    LINE : [ 'strokeWidth', 'strokeColor', 'strokeDashstyle' ],
    POLYGON : [ 'fillColor', 'strokeWidth', 'strokeColor',
        'strokeDashstyle' ]
  }
};

/**
 * Space: lsp
 * Namespace for Legato Style Properties.
 */
/**
 * URI: Namespace URI
 * {http://www.disy.net/legato/styleproperties}
 */
Legato.StyleProperties.NAMESPACE_URI = 'http://www.disy.net/legato/styleproperties';
/**
 * Prefix: Default prefix
 * {lsp}
 */
Legato.StyleProperties.PREFIX = 'lsp';
Legato.StyleProperties.QName = function(localPart) {
  return new Legato.XML.QName(Legato.StyleProperties.NAMESPACE_URI, localPart, Legato.StyleProperties.PREFIX);
};
