/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author$
 * @version $Rev$
 */

Legato.Marker.PopupMarker = OpenLayers.Class(OpenLayers.Marker, {
  popup : null,
  initialize : function(lonlat, icon, popup) {
    OpenLayers.Marker.prototype.initialize.apply(this, arguments);
    Legato.Util.Ensure.ensureExists(popup, 'popup should be defined');
    this.popup = popup;
  },
  destroy : function() {
    OpenLayers.Marker.prototype.destroy.apply(this, arguments);
    this.popup = null;
  },
  draw : function(px) {
    var result = OpenLayers.Marker.prototype.draw.apply(this, arguments);
    if (this.map !== null) {
      this.map.addPopup(this.popup);
    }
    return result;
  },
  moveTo : function(px) {
    var result = OpenLayers.Marker.prototype.moveTo.apply(this, arguments);
    this.popup.moveTo(px);
    return result;
  },
  erase : function() {
    var result = OpenLayers.Marker.prototype.erase.apply(this, arguments);
    if (this.map !== null) {
      this.map.removePopup(this.popup);
    }
    return result;
  },
  CLASS_NAME : "Legato.Marker.PopupMarker"
});