/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @requires Legato/Control.js
 * @requires Legato/Handler.js
 * @requires Legato/Handler/MouseWheel.js
 */

/**
 * Class: Legato.Control.Navigation
 * The navigation control handles map browsing with mouse events (dragging,
 *     double-clicking, and scrolling the wheel).  Create a new navigation 
 *     control with the <Legato.Control.Navigation> control.  
 * 
 *     Note that this control is added to the map by default (if no controls 
 *     array is sent in the options object to the <OpenLayers.Map> 
 *     constructor).
 *     
 *     Extension to OpenLayers:
 *     Use Legato.Handler.MouseWheel to enable zooming by mousewheel while
 *     loading the map
 * 
 * Inherits:
 *  - <OpenLayers.Control.Navigation>
 */
Legato.Control.Navigation = OpenLayers.Class(OpenLayers.Control.Navigation, {
	/**
     * Method: draw
     */
    draw: function() {
        // disable right mouse context menu for support of right click events
        if (this.handleRightClicks) {
            this.map.viewPortDiv.oncontextmenu = OpenLayers.Function.False;
        }

        var clickCallbacks = { 
            'click': this.defaultClick,
            'dblclick': this.defaultDblClick, 
            'dblrightclick': this.defaultDblRightClick 
        };
        var clickOptions = {
            'double': true, 
            'stopDouble': true
        };
        this.handlers.click = new OpenLayers.Handler.Click(
            this, clickCallbacks, clickOptions
        );
        this.dragPan = new OpenLayers.Control.DragPan(
            OpenLayers.Util.extend({
                map: this.map,
                documentDrag: this.documentDrag
            }, this.dragPanOptions)
        );
        this.zoomBox = new OpenLayers.Control.ZoomBox(
                    {map: this.map, keyMask: this.zoomBoxKeyMask});
        this.dragPan.draw();
        this.zoomBox.draw();
        this.handlers.wheel = new Legato.Handler.MouseWheel(
                                    this, {"up"  : this.wheelUp,
                                           "down": this.wheelDown},
                                    this.mouseWheelOptions );
        if (OpenLayers.Control.PinchZoom) {
            this.pinchZoom = new OpenLayers.Control.PinchZoom(
                OpenLayers.Util.extend(
                    {map: this.map}, this.pinchZoomOptions));
        }
    },

  CLASS_NAME : 'Legato.Control.Navigation'
});

/**
 * Structure: lc:Navigation XML based config for a
 * <Legato.Control.Navigation>.
 *
 * See Also: - <OpenLayers.Control.Navigation> - <Legato.Handler.MouseWheel> - <Legato.Beans.BeanFactory> - <QName>
 *
 * A valid config example for a NavigationHistory would be:
 * (start code)
 * <lc:Navigation zoomWheelEnabled="true" />
 * (end)
 */
Legato.Control.Navigation.Bean = Legato.Control.Bean.Extend(
//
'Legato.Control.Navigation',
//
Legato.Control.QName('Navigation'),
//
{
  _constructor : Legato.Control.Navigation,
  options : {
		// TODO dragPan: null,
		// TODO dragPanOptions: null,
		// TODO zoomBox: null,
		/**
		 * Element: zoomWheelEnabled
		 * {Boolean} Whether the mousewheel should zoom the map.
		 */
		zoomWheelEnabled : Legato.Lang.Boolean,

		/**
		 * Element: handleRightClicks
		 * {Boolean} Whether or not to handle  right clicks. Default is false.
		 */
		handleRightClicks : Legato.Lang.Boolean
	}
});