/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Beans.Reference
 * 
 * Models a reference to another bean.
 */
Legato.Beans.Reference = Legato.Lang.Class({
	/*
	 * Property: target
	 * 
	 * {String} Name of the target bean.
	 */
	target : null,
	/*
	 * Constructor: initialize
	 * 
	 * Constructs a new bean reference.
	 * 
	 * Parameters:
	 * 
	 * target - {String} name of the target bean.
	 */
	initialize : function(target) {
		Legato.Util.Ensure.ensureString(target);
		this.target = target;
	},
	/*
	 * Function: getInstance
	 * 
	 * Retrieves target bean from the bean factory.
	 * 
	 * Returns:
	 * 
	 * Target bean from the bean factory.
	 * 
	 * Parameters:
	 * 
	 * beanFactory - {<Legato.Beans.BeanFactory>} bean factory.
	 */
	getInstance : function(beanFactory) {
		Legato.Util.Ensure.ensureObject(beanFactory);
		var instance = beanFactory.getBean(this.target);
		return beanFactory.getBean(this.target);
	},
	/*
	 * Function: Field
	 * 
	 * Creates a field reference relative to the target bean.
	 * 
	 * Returns:
	 *  {<Legato.Beans.Reference.Field>} Field reference relative to the target
	 * bean of this field reference.
	 * 
	 * Parameters:
	 * 
	 * field - {String} name of the field.
	 */
	Field : function(field) {
		Legato.Util.Ensure.ensureString(field);
		return new Legato.Beans.Reference.Field(this, field);
	},
	CLASS_NAME : 'Legato.Beans.Reference'
});
/*
 * Class: Legato.Beans.Reference.Field
 */
Legato.Beans.Reference.Field = Legato.Lang.Class({
	/*
	 * Property: reference
	 * 
	 * Reference to the target bean.
	 */
	reference : null,
	/*
	 * Property: field
	 * 
	 * Name of the field of the target bean.
	 */
	field : null,
	/*
	 * Constructor: initialize
	 * 
	 * Creates a new field reference.
	 * 
	 * Parameters:
	 * 
	 * reference - {<Legato.Beans.Reference>} reference to the target bean.
	 * 
	 * field - {String} name of the field.
	 */
	initialize : function(reference, field) {
		Legato.Util.Ensure.ensureImplements(reference, 'getInstance');
		this.reference = reference;
		Legato.Util.Ensure.ensureString(field);
		this.field = field;
	},
	/*
	 * Function: getInstance
	 * 
	 * Returns:
	 * 
	 * Value of the field of the target bean.
	 * 
	 * Parameters:
	 * 
	 * beanFactory - {<Legato.Beans.BeanFactory>} bean factory.
	 */
	getInstance : function(beanFactory) {
		var instance = this.reference.getInstance(beanFactory);
		return instance[this.field];
	}
});

Legato.Beans.Ref = function(target) {
	return new Legato.Beans.Reference(target);
};

$ref = Legato.Beans.Ref;

/**
 * Component: lb:Reference
 * 
 * See also:
 * - <lb> namespace
 * - {<Legato.Beans.Reference>}
 */
Legato.Beans.Reference.Bean = Legato.Beans.Object.Extend(
		'Legato.Beans.Reference',
		//
		Legato.Beans.QName('Reference'),
		//
		{
			_constructor : Legato.Beans.Reference,
			constructorArguments : {
				/**
				 * Element: target
				 * {String} Name of the referenced bean.
				 */
				target : Legato.Lang.String
			},
			constructorOrder : [ 'target' ]
		});