/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.StyleProperties.SelectElement = OpenLayers.Class(Legato.StyleProperties.AbstractInputElement, {
  
  selectOptions : [],
  
  initialize : function(propertyName, propertyValue, style, layer, options) {
    if(Legato.Lang.ObjectUtils.exists(options.selectOptions)){
      this.selectOptions = options.selectOptions;
    }
    Legato.StyleProperties.AbstractInputElement.prototype.initialize.apply(this, arguments);
  },
  
  createInput : function() {
    var selectElement = document.createElement('select');
    for ( var i = 0; i < this.selectOptions.length; i++) {
      var optionElement = document.createElement('option');
      var selectOption = this.selectOptions[i];
      if(Legato.Lang.ObjectUtils.exists(selectOption.label)){
        optionElement.value = selectOption.value;
        if(Legato.Lang.ObjectUtils.isFunction(selectOption.label)){
          optionElement.innerHTML = selectOption.label();
        }else{
          optionElement.innerHTML = selectOption.label;
        }
      }else{
        optionElement.value = selectOption;
        optionElement.innerHTML = selectOption;
      }
      selectElement.appendChild(optionElement);
    }
    selectElement.value = this.propertyValue;
    selectElement.onchange = OpenLayers.Function.bindAsEventListener(
        this.onInputValueChanged, this);
    return selectElement;
  },
  
  CLASS_NAME : 'Legato.StyleProperties.SelectElement'
});