/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.StyleProperties.Factory = OpenLayers
    .Class({
      SELECT_OPTIONS : {
        fontFamily : [ 'Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Georgia', 'Impact', 'Lucida Console', 'Lucida Sans Unicode', 'Tahoma', 'Times New Roman', 'Verdana'],
        fontStyle : [ 
                       {
                         value : 'normal',
                         label : function(){
                           return Legato.I18n.getMessage('Legato.StyleProperties.Factory.fontStyle.normal');
                         }
                       }, 
                       {
                         value : 'italic',
                         label : function(){
                           return Legato.I18n.getMessage('Legato.StyleProperties.Factory.fontStyle.italic');
                         }
                       } 
                    ],
        fontWeight : [ 
                      {
                        value : 'normal',
                        label : function(){
                          return Legato.I18n.getMessage('Legato.StyleProperties.Factory.fontWeight.normal');
                        }
                      }, 
                      {
                        value : 'bold',
                        label : function(){
                          return Legato.I18n.getMessage('Legato.StyleProperties.Factory.fontWeight.bold');
                        }
                      } 
                     ],
        fontSize : [ '9', '10', '11', '12', '14', '16', '18', '20', '22', '24', '26', '28'],
        pointRadius : [ '2','3','4','5', '6', '7', '8', '9', '10', '12', '14', '16', '18', '20', '22' ],
        strokeWidth : [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10' , '12', '14'],
        strokeDashstyle : [
            {
              value : 'solid',
              label : "&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;"
            },
            {
              value : 'dot',
              label : '&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;'
            },
            {
              value : 'dash',
              label : '&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;'
            }, {
              value : 'dashdot',
              label : '&mdash;&nbsp;&middot;&nbsp;&mdash;&nbsp;&middot;&nbsp;&mdash;&nbsp;&middot;&nbsp;&mdash;&nbsp;&nbsp;&middot;&nbsp;&mdash;&nbsp;&nbsp;&middot;&nbsp;'
            } ]
      },

      SPINNER_OPTIONS : {},

      initialize : function(options) {
      },

      createElement : function(stylePropertyName, stylePropertyValue, style,
          layer) {
        if (this.isSelectProperty(stylePropertyName)) {
          return this.createSelectElement(stylePropertyName,
              stylePropertyValue, style, layer,
              this.SELECT_OPTIONS[stylePropertyName]);
        } else if (this.isColorProperty(stylePropertyName)) {
          return this.createColorElement(stylePropertyName, stylePropertyValue.replace('#',''),
              style, layer);
        } else if (this.isSpinnerProperty(stylePropertyName)) {
          return this.createSpinnerElement(stylePropertyName,
              stylePropertyValue, style, layer,
              this.SPINNER_OPTIONS[stylePropertyName]);
        } else {
          return this.createInputElement(stylePropertyName, stylePropertyValue,
              style, layer);
        }
      },

      createInputElement : function(stylePropertyName, stylePropertyValue,
          style, layer) {
        return new Legato.StyleProperties.InputElement(stylePropertyName,
            stylePropertyValue, style, layer);
      },

      createSelectElement : function(stylePropertyName, stylePropertyValue,
          style, layer, selectOptions) {
        return new Legato.StyleProperties.SelectElement(stylePropertyName,
            stylePropertyValue, style, layer, {
              selectOptions : selectOptions
            });
      },

      createSpinnerElement : function(stylePropertyName, stylePropertyValue,
          style, layer, spinnerOptions) {
        return new Legato.StyleProperties.SelectElement(stylePropertyName,
            stylePropertyValue, style, layer, {
              spinnerOptions : spinnerOptions
            });
      },

      createColorElement : function(stylePropertyName, stylePropertyValue,
          style, layer) {
        return new Legato.StyleProperties.InputElement(stylePropertyName,
            stylePropertyValue, style, layer);
      },

      isSelectProperty : function(stylePropertyName) {
        return this.SELECT_OPTIONS.hasOwnProperty(stylePropertyName);
      },

      isSpinnerProperty : function(stylePropertyName) {
        return this.SPINNER_OPTIONS.hasOwnProperty(stylePropertyName);
      },

      isColorProperty : function(stylePropertyName) {
        var colorSuffix = 'Color';
        return stylePropertyName.indexOf(colorSuffix, stylePropertyName.length
            - colorSuffix.length) !== -1;
      },

      CLASS_NAME : 'Legato.StyleProperties.Factory'
    });
Legato.StyleProperties.Factory.Bean = Legato.Beans.Object.Extend(
    'Legato.StyleProperties.Factory', Legato.StyleProperties.QName('Factory'),
    //
    {
      _constructor : Legato.StyleProperties.Factory,
      options : {}
    });
