/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: jleine $
 * @version $Revision: 953 $
 * @requires Legato.js
 * @requires OpenLayers/Control.js
 */

/**
 * Class: Legato.Style
 * The Legato Style class allows to define a style map. This map may
 * then be used by an control to define the look of a feature layer.
 *
 *
 *
 * Inherits from:
 *  - <Legato.Lang.Class>
 */
Legato.Style = Legato.Lang.Class({

  name: null,

  styles: {},

  initialize : function(options) {
    this.name = options.name;
    this.styles = options.styles;
  },

  CLASS_NAME : 'Legato.Style'
});

/**
 * Space: lc
 * Namespace for Legato Style.
 */
/*
 * URI: Namespace URI
 * {http://www.disy.net/legato/style}
 */
Legato.Style.NAMESPACE_URI = 'http://www.disy.net/legato/style';

/*
 * Prefix: Default prefix
 * {ls}
 */
Legato.Style.PREFIX = 'ls';

Legato.Style.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Style.NAMESPACE_URI, localPart,
      Legato.Style.PREFIX);
};
/**
 * Component: ls:Style
 * Configuration component for Legato Style.
 * See also:
 * - <ls> namespace
 * - <Legato.Style>
 */
Legato.Style.Bean = OpenLayers.Control.Bean.Extend('Legato.Style',
//
Legato.Style.QName('Style'),
//
{
  _constructor : Legato.Style,
  options : {
    name : Legato.Lang.String,
    styles : Legato.Beans.Object.Map()
  }
});
