/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: oll:Markers
 * 
 * Inherits from:
 * - {<oll:Layer>}
 * 
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.Markers>}
 */
OpenLayers.Layer.Markers.Bean = OpenLayers.Layer.Bean.Extend(
		'OpenLayers.Layer.Markers',
		//
		Legato.OpenLayers.Layer.QName('Markers'),
		//
		{
			factoryFunction : function(name, options) {
				if (!Legato.Lang.ObjectUtils.exists(options)) {
					options = {};
				}
				options.isBaseLayer = false;

				return new OpenLayers.Layer.Markers(name, options);
			},
			constructorArguments : {
				/**
				 * Element: name
				 * {String}
				 */
				name : Legato.Lang.String
			},
			constructorOrder : [ 'name' ],
			properties : {
				/**
				 * Element: markers
				 * {Object []}
				 */
				markers : new Legato.Beans.Property(Legato.Beans['Object[]'],
						function(layer, markers) {
							Legato.Util.Ensure.ensureArray(markers);
							for ( var index = 0; index < markers; index++) {
								layer.addControls(markers[index]);
							}
						})
			}
		});

/**
 * Layer type: OL:Markers
 * 
 * See also:
 * - {<oll:Markers>}
 * - {<OpenLayers.Layer.Markers>}
 * 
 */
OpenLayers.Layer.Markers.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : OpenLayers.Layer.Markers.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OL:Markers',
		new OpenLayers.Layer.Markers.LayerFactory());