/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: <olc:KeyboardDefaults>
 * 
 * Adds panning and zooming functions, controlled with the keyboard.
 * By default arrow keys pan, +/- keys zoom, Page Up/Page
 * Down/Home/End scroll by three quarters of a page.
 * 
 * Has no visible appearance.
 *
 * Inherits from:
 *  - <olc:Control>
 *  
 *  See also:
 *  - <olc> namespace
 *  - <OpenLayers.Control.KeyboardDefaults>
 *  
 */
OpenLayers.Control.KeyboardDefaults.Bean = OpenLayers.Control.Bean.Extend(
//
'OpenLayers.Control.KeyboardDefaults',
//
Legato.OpenLayers.Control.QName('KeyboardDefaults'),
//
{
	_constructor : OpenLayers.Control.KeyboardDefaults,
	options : {
		/**
		 * Element: slideFactor
		 * {Integer} Pixels to slide by.
		 */
		slideFactor : Legato.Lang.Integer
	}
});