/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Namespace: Legato.Lang.ObjectUtils
 */
Legato.Lang.ObjectUtils = {
  /*
   * Function: isNull
   *
   * Checks if given value is null (not undefined).
   *
   * Returns:
   *
   * true if the value is null, false otherwise.
   */
  isNull : function(value) {
    return (typeof value != 'undefined' && value === null);
  },
  /*
   * Function: isUndefined
   *
   * Checks if given value is undefined.
   *
   * Returns:
   *
   * true if the value is undefined, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isUndefined : function(value) {
    return (typeof value == 'undefined');
  },
  /*
   * Function: isNullOrUndefined
   *
   * Checks if given value is null or undefined.
   *
   * Returns:
   *
   * true if the value is null or undefined, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isNullOrUndefined : function(value) {
    return (typeof value == 'undefined' || value === null);
  },
  /*
   * Function: exists
   *
   * Checks if given value exists (is neither null nor undefined).
   *
   * Returns:
   *
   * true if the value is neither null nor undefined, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  exists : function(value) {
    return (typeof value != 'undefined' && value !== null);
  },
  /*
   * Function: isString
   *
   * Checks if given value is string.
   *
   * Returns:
   *
   * true if the value is string, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isString : function(value) {
    return (typeof value == 'string');
  },
  /*
   * Function: isBoolean
   *
   * Checks if given value is boolean.
   *
   * Returns:
   *
   * true if the value is boolean, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isBoolean : function(value) {
    return (typeof value == 'boolean');
  },
  /*
   * Function: isTrue
   *
   * Checks if given value is boolean and it is true.
   *
   * Returns:
   *
   * true if the value is boolean and true, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isTrue : function(value) {
    return (typeof value == 'boolean') && value;
  },
  /*
   * Function: isFalse
   *
   * Checks if given value is boolean and it is false.
   *
   * Returns:
   *
   * true if the value is boolean and it is false, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isFalse : function(value) {
    return (typeof value == 'boolean') && !value;
  },
  /*
   * Function: isFunction
   *
   * Checks if given value is function.
   *
   * Returns:
   *
   * true if the value is function, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isFunction : function(value) {
    return (typeof value == 'function');
  },
  /*
   * Function: isRegExp
   *
   * Checks if given value is a RegExp.
   *
   * Returns:
   *
   * true if the value is RegExp, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isRegExp: function(value){
    return value instanceof RegExp;
  },
  /*
   * Function: isDate
   *
   * Checks if given value is a Date.
   *
   * Returns:
   *
   * true if the value is Date, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isDate: function(value){
    return value instanceof Date;
  },
  /*
   * Function: isArray
   *
   * Checks if given value is an array.
   *
   * Returns:
   *
   * true if the value is an array, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isArray : function(value) {
    return (value instanceof Array);
  },
  /*
   * Function: isNotEmptyArray
   *
   * Checks if given value is a not empty array.
   *
   * Returns:
   *
   * true if the value is an array and it is not empty, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isNotEmptyArray : function(value) {
    return (value instanceof Array) && value.length > 0;
  },
  /*
   * Function: isObject
   *
   * Checks if given value is a non-null object.
   *
   * Returns:
   *
   * true if the value is a non-null object, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isObject : function(value) {
    return (typeof value == 'object') && (value !== null);
  },
  /*
   * Function: isNumber
   *
   * Checks if given value is a number.
   *
   * Returns:
   *
   * true if the value is a number, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isNumber: function(value){
    return (typeof value == 'number') && (value !== null);
  },
  /*
   * Function: isEmptyObject
   *
   * Checks if given value is an empty object ({}).
   *
   * Returns:
   *
   * true if the value is an empty object, null or undefined. False otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */  
  isEmptyObject: function( obj ) {
    for (var name in obj) {
      if (obj.hasOwnProperty(name)) {
        return false;
      }
    }
    return true;
  }

};
