/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.I18n.BrowserLocaleFactoryBean = OpenLayers
    .Class( {
      defaultLocale :'en',
      supportedLocales :null,
      supportedLocalesSet :null,
      initialize : function(options) {
        OpenLayers.Util.extend(this, options);
        if (!Legato.Lang.ObjectUtils.exists(this.supportedLocales)) {
          this.supportedLocales = Legato.I18n.Messages.supportedLocales;
        }

        this.supportedLocalesSet = new Legato.Util.HashSet();
        for ( var index = 0; index < this.supportedLocales.length; index++) {
          this.supportedLocalesSet.add(this.supportedLocales[index]);
        }
      },
      getInstance : function() {
        var possibleLocales = [];

        possibleLocales.push(this.defaultLocale);

        var code = (OpenLayers.Util.getBrowserName() == "msie") ? navigator.userLanguage
            : navigator.language;
        var parts = code.split('-');

        if (parts.length >= 1) {
          possibleLocales.push(parts[0].toLowerCase());
        }

        if (parts.length >= 2) {
          possibleLocales.push(parts[0].toLowerCase() + '-'
              + parts[1].toUpperCase());
        }

        if (parts.length >= 3) {
          possibleLocales.push(parts[0].toLowerCase() + '-'
              + parts[1].toUpperCase() + '-' + parts[2]);
        }

        for ( var index = possibleLocales.length - 1; index >= 0; --index) {
          if (this.supportedLocalesSet.contains(possibleLocales[index])) {
            return possibleLocales[index];
          }
        }

        return this.defaultLocale;
      },
      CLASS_NAME :'Legato.I18n.BrowserLocaleFactoryBean'
    });

Legato.I18n.BrowserLocaleFactoryBean.Bean = Legato.Beans.Object.Extend(
    'Legato.I18n.BrowserLocaleFactoryBean',
    //
    Legato.I18n.QName('BrowserLocale'),
    //
    {
      _constructor :Legato.I18n.BrowserLocaleFactoryBean,
      options : {
        defaultLocale :Legato.Lang.String,
        supportedLocales :Legato.Lang.String.List()
      }
    });
