/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.ToggleLayer
 *
 * This control switches the visibility of a layer referenced by a 
 * Legato layerId.
 *
 * Inherits from:
 * - <Legato.Control>
 * 
 *
 */
Legato.Control.ToggleLayer = OpenLayers.Class(Legato.Control, {

  layerId :null,
  
  type :OpenLayers.Control.TYPE_TOGGLE,

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
    if (Legato.Lang.ObjectUtils.exists(options.layerId)) {
      this.layerId = options.layerId;
    }
  },

  /** Function: activate
   * Invoked when the control is activated in toggle mode
   */
  activate: function() {
    this.toggleVisibility();
    this.active = true;
    Legato.Control.prototype.activate.apply(this, arguments);
  },

  /** Function: deactivate
   * Invoked when the layer is deactivated in toggle mode
   */
  deactivate : function() {
    this.toggleVisibility();
    this.active = false;
    Legato.Control.prototype.deactivate.apply(this, arguments);
  },
  
  toggleVisibility : function() {
    var layer = Legato.OpenLayers.Map.Util.getLayerById(this.map.layers, this.layerId);
    if (Legato.Lang.ObjectUtils.isObject(layer)) {
      layer.setVisibility(!layer.visibility);
    }
  },

  CLASS_NAME :"Legato.Control.ToggleLayer"
});

/**
 * Structure: lc:ToggleLayer
 * XML based config for a <Legato.Control.ToggleLayer>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ToggleLayer would be:
 * (start code)
 * <lc:ToggleLayer displayClass="ToggleScaleBarLayer">
 *   <layerId>InternalLayer.ScaleBar</layerId>
 * </lc:ToggleLayer>
 * (end)
 */
Legato.Control.ToggleLayer.Bean = OpenLayers.Control.Bean.Extend(
    'Legato.Control.ToggleLayer', Legato.Control.QName('ToggleLayer'), {
      _constructor : Legato.Control.ToggleLayer,
      options : {
        /**
         * Element: layerId Legato layerId of the layer that will be
         * shown/hidden. Note: The Legato layerId is different to the native
         * OpenLayers layer id.
         */
        layerId : Legato.Lang.String
      }
    });
