/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerRemove
 */
Legato.Control.Legend.Plugin.LayerRemove = OpenLayers.Class(
		Legato.Control.Legend.Plugin, {

			/**
			 * Function: afterSetup
			 */
			afterSetup : function() {
				this.div.onclick = OpenLayers.Function.bindAsEventListener(
						this.onclick, this);
			},

			/**
			 * Function: beforeDestroyed
			 */
			beforeDestroyed : function() {
				this.div.onclick = null;
			},

			/**
			 * Function: onclick
			 */
			onclick : function(event) {
//				this.map.removeLayer(this.layer, true);
				this.layer.destroy(true);
				if (Legato.Lang.ObjectUtils.exists(event)) {
					OpenLayers.Event.stop(event, true);
				}
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerRemove'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerRemove.Factory
 * Factory class wich is able to create a <Legato.Control.Legend.Plugin.LayerRemove>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerRemove.Factory = OpenLayers.Class(
		Legato.Control.Legend.Plugin.Factory, {

			/**
			 * Function: create
			 * Factory method for creating a <Legato.Control.Legend.Plugin.LayerRemove> instance.
			 */
			create : function(layer) {
				return new Legato.Control.Legend.Plugin.LayerRemove(layer,
						this.pluginOptions);
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerRemove.Factory'
		});

/**
 * Component: llp:LayerRemove
 * 
 * Inherits from:
 * - <llp:Plugin>
 * 
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.LayerRemove>}
 */
Legato.Control.Legend.Plugin.LayerRemove.Bean = Legato.Control.Legend.Plugin.Bean
		.Extend('Legato.Control.Legend.Plugin.LayerRemove.Factory',

		Legato.Control.Legend.Plugin.QName('LayerRemove'), {
			_constructor : Legato.Control.Legend.Plugin.LayerRemove.Factory
		});