/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerName
 */
Legato.Control.Legend.Plugin.LayerName = OpenLayers.Class(
		Legato.Control.Legend.Plugin, {

			/**
			 * Function: create
			 */
			update : function() {
				if (Legato.Lang.ObjectUtils.isString(this.layer.title)) {
					this.div.innerHTML = this.layer.title;
				} else {
					this.div.innerHTML = this.layer.name;
				}
				if (this.layer.inRange) {
					this.div.className = this.displayClass;
				} else {
					this.div.className = this.displayClass + 'Disabled';
				}
			},

			/**
			 * Function: afterSetup
			 */
			afterSetup : function() {
				this.map.events.on({
					'changelayer' : this.update,
					scope : this
				});
			},

			/**
			 * Function: beforeDestroyed
			 */
			beforeDestroyed : function() {
				this.map.events.un({
					'changelayer' : this.update,
					scope : this
				});
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerName'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerName.Factory
 * Factory class wich is able to create a <Legato.Control.Legend.Plugin.LayerName>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerName.Factory = OpenLayers.Class(
		Legato.Control.Legend.Plugin.Factory, {

			/**
			 * Function: create
			 * Factory method for creating a <Legato.Control.Legend.Plugin.LayerName> instance.
			 */
			create : function(layer) {
				return new Legato.Control.Legend.Plugin.LayerName(layer,
						this.pluginOptions);
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerName.Factory'

		});

/**
 * Component: llp:LayerName
 * 
 * Displays name of the layer.
 * 
 * Inherits from:
 * - <llp:Plugin>
 * 
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.LayerName>}
 */
Legato.Control.Legend.Plugin.LayerName.Bean = Legato.Control.Legend.Plugin.Bean
		.Extend('Legato.Control.Legend.Plugin.LayerName.Factory',

		Legato.Control.Legend.Plugin.QName('LayerName'), {
			_constructor : Legato.Control.Legend.Plugin.LayerName.Factory
		});