/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 71063 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: Legato.Control.DefaultBaseLayer
 * ValueProvider which gives you the possibility to be notified about every
 * change of the current BBox Selection. The notification could be a JS Callback
 * or a Object where its property will be overwritten each time the watched value
 * changes.
 *
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.DefaultBaseLayer = OpenLayers.Class(Legato.Control,
{
  defaultLayerAdded: false,

  /*
   * Function: initialize
   * Basic ctor
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control
   * The following keys are supported
   * - observer {Object} A hashmap containing an observer
   *
   * The following keys are supported for an observer element
   * - target {object} an object which wants to observe,
   * - property{function|String} the propety or function which should be used for providing the observed value
   * - bBoxProperty {String} any Property name of an <OpenLayers.Bounds> instance
   * - write {Boolean} true = value changes of observer will be given back to current map, false otherwise
   */
  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
    Legato.Util.Ensure.ensureExists(this.layer);
    this.layer.options.legatoIgnore = true;
    this.defaultLayerAdded = false;
  },

  /*
   * Function: destroy
   *
   * See Also:
   * <OpenLayer.Control>
   */
  destroy : function() {
    this.map.events.un( {
      'addlayer' : this.ensureBaseLayer,
      'removelayer' : this.ensureBaseLayer,
      scope : this
    });

    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  /*
   * Function: setMap
   *
   * See Also:
   * <OpenLayer.Control>
   */
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);

    this.map.events.on( {
      'addlayer' : this.ensureBaseLayer,
      'removelayer' : this.ensureBaseLayer,
      scope : this
    });
   },

  /*
   * Function: draw
   *
   * See Also:
   * <OpenLayer.Control>
   */
  draw : function() {
    this.ensureBaseLayer();
    return this.div;
  },

  /*
   * Inits this control by the given option targets based on their
   * given values if exists.
   */
  ensureBaseLayer: function(event){
    var baseLayers = Legato.OpenLayers.Map.Util.getBaseLayers(this.map.layers);

    if(!this.defaultLayerAdded && baseLayers.length !== 0){
      //Remember last deleted baselayer projection
      if(Legato.Lang.ObjectUtils.exists(event) &&
         Legato.Lang.ObjectUtils.exists(event.layer) &&
         event.layer.isBaseLayer){
        this.layer.projection = event.layer.projection;
      }
      return;
    }

    if(this.defaultLayerAdded && baseLayers.length != 1){
      //this.map.setBaseLayer(baseLayers[0]);
      this.map.removeLayer(this.layer);
      this.defaultLayerAdded = false;
      return;
    }

    if(this.defaultLayerAdded === false){
      this.map.addLayer(this.layer);
      this.defaultLayerAdded = true;
    }
  },

  CLASS_NAME : 'Legato.Control.DefaultBaseLayer'
});

/**
 * Structure: lc:DefaultBaseLayer
 * XML based config for a <Legato.Control.DefaultBaseLayer>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a Legend would be:
 * (start code)
 *
 *<lc:DefaultBaseLayer>
 * <layer>
 *  <lla:BlankLayer name="Default Base Layer"/>
 * </layer>
 *<lc:DefaultBaseLayer>
 * (end)
 */
Legato.Control.DefaultBaseLayer.Bean = Legato.Control.Bean.Extend(

  'Legato.Control.DefaultBaseLayer',

  /*
   * Property: QName
   * The qualified name for this control. Needed by XML config to instantiate it.
   */
  Legato.Control.QName('DefaultBaseLayer'),
  {
    _constructor: Legato.Control.DefaultBaseLayer,
    options:
    {
     /*
      * Property: layer
      * The default layer which should been used if none is present
      */
      layer: OpenLayers.Layer.Bean
    }
  }
);
