/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author$
 * @version $Rev$
 */

/**
 * Class: Legato.Util.LayerValueAccessor
 * Small helper class which implements some sort of an setter, getter Pattern.
 * With this class you're able to wrap some other classes so that the wrapped
 * classed is accessed just with the getter setter Pattern.
 */
Legato.Util.ObjectFilter = Legato.Lang.Class({

  property: null,
  value: null,

  /*
   * Function: initialize
   * Basic ctor for the accessor class
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this class
   * The following keys are supported
   * - target {Object} the used target instance
   * - field {String} Optional field specification. Will be used as getter and setter if defined
   * - setter {String} Optional function specification which must exists in target
   * - getter {String} Optional function specification which must exists in target
   */
  initialize : function(options) {
    this.property = options.property;
    this.value    = options.value;
  },

  filter : function(value) {
    var filteredValues = [];

    if(!Legato.Lang.ObjectUtils.isArray(value)){
      throw new Error('Just an Array of object Instances is allowed');
    }

    for(var i = 0; i < value.length; i++){
      if(Legato.Lang.ObjectUtils.isUndefined(value[i][this.property]) ||
         Legato.Lang.ObjectUtils.isFunction(value[i][this.property])){
        filteredValues.push(value[i]);
        continue;
      }
      if(value[i][this.property] != this.value){
        filteredValues.push(value[i]);
      }
    }

    return filteredValues;
  },

  CLASS_NAME : 'Legato.Util.ObjectFilter'
});