/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.PanZoomBar = OpenLayers.Class(OpenLayers.Control.PanZoomBar, {
	initialize : function(options) {
		OpenLayers.Control.PanZoomBar.prototype.initialize.apply(this,
				arguments);
	},
	
  cssDerivations : {
    'panup' : 'Up',
    'panleft': 'Left',
    'panright': 'Right',
    'pandown': 'Down',
    'zoomin': 'In',
    'zoomworld': 'World',
    'zoomout': 'Out'
  },

  removeChildrenAndAddClass: function(element, classSuffix) {
    element.className = element.className + ' ' + this.displayClass + classSuffix;
    if (element.hasChildNodes()) {
      while (element.childNodes.length >= 1) {
        element.removeChild(element.firstChild);       
      } 
    }
  }, 
  
  _addZoomBar: function(centered) {
    var result = OpenLayers.Control.PanZoomBar.prototype._addZoomBar.apply(this, arguments);
    this.removeChildrenAndAddClass(this.slider, 'Slider');
    this.removeChildrenAndAddClass(this.zoombarDiv, 'Scroller');
    return result;
  },
	
  _addButton : function(id, _class, xy, sz) {
    var btn = OpenLayers.Control.PanZoom.prototype._addButton.apply(this, arguments);
    this.removeChildrenAndAddClass(btn, this.cssDerivations[id]);
    return btn;
  },

	CLASS_NAME : "Legato.Control.PanZoomBar"
});

/**
 * Component: lc:PanZoomBar
 * 
 * Inherits from:
 * - {<olc:PanZoomBar>}
 * 
 * See also:
 * - <lc> namespace
 * - {<Legato.Control.PanZoomBar>}
 * - <olc> namespace
 * - {<OpenLayers.Control.PanZoomBar>}
 */
Legato.Control.PanZoomBar.Bean = OpenLayers.Control.PanZoomBar.Bean.Extend(
//
'Legato.Control.PanZoomBar',
//
Legato.Control.QName('PanZoomBar'),
//
{
	_constructor : Legato.Control.PanZoomBar
});