/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ModifyFeature = OpenLayers.Class(OpenLayers.Control.ModifyFeature, {

  vertexModifiedPoint : null,

  initialize : function(layer, options) {
    /*
     * Subscribe for these events so that we're able to determine that an
     * existing geometry has changed cause a new vertex has been added
     * (vertexmodified,featuremodified) and to determine that someone has
     * updated the geometry outside this class (legato.sketchupdated).
     */
    layer.events.on({
      'vertexmodified' : this.onVertexModified,
      'featuremodified' : this.onFeatureModified,
      'legato.sketchupdated' : this.onSketchUpdated,
      scope : this
    });

    OpenLayers.Control.ModifyFeature.prototype.initialize.apply(this, [ layer, options ]);
    this.configureVirtualStyle();
  },

  destroy : function() {
    this.layer.events.un({
      'vertexmodified' : this.onVertexModified,
      'featuremodified' : this.onFeatureModified,
      'legato.sketchupdated' : this.onSketchUpdated,
      scope : this
    });

    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  activate : function() {
    var result = OpenLayers.Control.ModifyFeature.prototype.activate.apply(this, arguments);
    if (this.layer && this.layer.features && (this.layer.features.length === 1)) {
      this.selectControl.clickFeature(this.layer.features[0]);
    }
    return result;
  },

  /*
   * Just remember this changed point or new point
   */
  onVertexModified : function(event) {
    this.vertexModifiedPoint = event.vertex;
  },

  /*
   * Triggers the legato.sketchpointadded event meaning that either a new point
   * has been added to this existing geometry or a given point has been changed.
   */
  onFeatureModified : function(event) {
    this.layer.events.triggerEvent('legato.sketchpointadded', {
      layer : event.feature.layer,
      geometry : event.feature.geometry,
      vertex : this.vertexModifiedPoint
    });
  },

  /*
   * If someone has changed some geometry on this layer reset the vertices for
   * it.
   */
  onSketchUpdated : function() {
    if (this.feature) {
      this.layer.drawFeature(this.feature, this.selectControl.renderIntent);
      this.resetVertices();
    }
  },

  configureVirtualStyle : function() {
    /*
     * Demonstrates how we could customize the vortiual style. This is used by
     * the points which appear if we're adding a new point to our polygon.
     */

    /*
     * this.virtualStyle = OpenLayers.Util.extend( {}, this.layer.style ||
     * this.layer.styleMap.createSymbolizer() ); this.virtualStyle.fillColor =
     * '#000'; this.virtualStyle.strokeColor = '#000';
     */
  },

  CLASS_NAME : 'Legato.Control.ModifyFeature'
});

Legato.Control.ModifyFeature.MODE_RESHAPE = OpenLayers.Control.ModifyFeature.RESHAPE;
Legato.Control.ModifyFeature.MODE_AFFINE = OpenLayers.Control.ModifyFeature.RESIZE | OpenLayers.Control.ModifyFeature.ROTATE
    | OpenLayers.Control.ModifyFeature.DRAG;

Legato.Control.ModifyFeature.Bean = OpenLayers.Control.ModifyFeature.Bean.Extend('Legato.Control.ModifyFeature', Legato.Control.QName('ModifyFeature'), {
  _constructor : Legato.Control.ModifyFeature,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ],
  options : {
    mode : Legato.Lang.Integer.Enum('Legato.Control.ModifyFeature.MODE', {
      'RESHAPE' : Legato.Control.ModifyFeature.MODE_RESHAPE,
      'AFFINE' : Legato.Control.ModifyFeature.MODE_AFFINE
    })
  }
});