/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var Legato = {
	singleFile : true
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

(function() {
    var singleFile = (typeof Legato == "object" && Legato.singleFile);
    /**
     * Relative path of this script.
     */
    var scriptName = (!singleFile) ? "lib/Legato.js" : 'Legato.js';
    var jsFiles = window.Legato;

    window.Legato = {
        _getScriptLocation: (function() {
            var r = new RegExp("(^|(.*?\\/))(" + scriptName + ")(\\?|$)"),
                s = document.getElementsByTagName('script'),
                src, m, l = "";
            for(var i=0, len=s.length; i<len; i++) {
                src = s[i].getAttribute('src');
                if(src) {
                    m = src.match(r);
                    if(m) {
                        l = m[1];
                        break;
                    }
                }
            }
            return (function() { return l; });
        })()
    };

    if(!singleFile) {
      /**
       * PATCH
       */
      //if (!jsFiles) {
      jsFiles = [
                 'Legato/Feature.js',
                 'Legato/Feature/Sketch.js',
                 'Legato/Singleton.js',
                 'Legato/Util.js',
                 'Legato/Lang.js',
                 'Legato/Graph.js',
                 'Legato/Proj4js.js',
                 'Legato/XML.js',
                 'Legato/Lang/Class.js',
                 'Legato/Lang/ObjectUtils.js',
                 'Legato/Lang/ArrayUtils.js',
                 'Legato/Lang/CollectionUtils.js',
                 'Legato/Lang/NumberUtils.js',
                 'Legato/Lang/StringUtils.js',
                 'Legato/Lang/Exception.js',
                 'Legato/Lang/IllegalArgumentException.js',
                 'Legato/Lang/AnyType.js',
                 'Legato/Lang/AnySimpleType.js',
                 'Legato/Lang/List.js',
                 'Legato/Lang/Map.js',
                 'Legato/Lang/Null.js',
                 'Legato/Lang/Enum.js',
                 'Legato/Lang/Boolean.js',
                 'Legato/Lang/Integer.js',
                 'Legato/Lang/Number.js',
                 'Legato/Lang/Double.js',
                 'Legato/Lang/String.js',
                 'Legato/Lang/Element.js',
                 'Legato/Lang/Function.js',
                 'Legato/Lang/RGBColor.js',
                 'Legato/Util/Accessor.js',
                 'Legato/Util/ObjectValueAccessor.js',
                 'Legato/Util/ObjectFilter.js',
                 'Legato/Util/Ensure.js',
                 'Legato/Util/Matcher.js',
                 'Legato/Util/HashSet.js',
                 'Legato/Util/Tag.js',
                 'Legato/Util/DOM.js',
                 'Legato/Util/GeoLocation.js',
                 'Legato/Util/Logger.js',
                 'Legato/Util/Browser.js',
                 'Legato/Graph/DirectedGraph.js',
                 'Legato/Graph/Vertex.js',
                 'Legato/XML/QName.js',
                 'Legato/XML/ElementUtils.js',
                 'Legato/Beans.js',
                 'Legato/Beans/Property.js',
                 'Legato/Beans/BeanDefinition.js',
                 'Legato/Beans/ComplexType.js',
                 'Legato/Beans/Object.js',
                 'Legato/Beans/BeanFactory.js',
                 'Legato/Beans/XMLBeanFactory.js',
                 'Legato/Beans/Reference.js',
                 'Legato/Beans/Evaluate.js',
                 'Legato/Beans/Field.js',
                 'Legato/Predicate.js',
                 'Legato/Predicate/And.js',
                 'Legato/Predicate/Contains.js',
                 'Legato/Predicate/Equals.js',
                 'Legato/Predicate/False.js',
                 'Legato/Predicate/Or.js',
                 'Legato/Predicate/True.js',
                 'Legato/Lang/Library.js',
                 'Legato/Util/Library.js',
                 'Legato/Text.js',
                 'Legato/Text/Format.js',
                 'Legato/Text/DecimalFormat.js',
                 'Legato/Text/PrecisionScaleFormat.js',
                 'Legato/OpenLayers.js',
                 'Legato/OpenLayers/Bounds.js',
                 'Legato/OpenLayers/LonLat.js',
                 'Legato/OpenLayers/Projection.js',
                 'Legato/OpenLayers/Size.js',
                 'Legato/OpenLayers/Pixel.js',
                 'Legato/OpenLayers/Icon.js',
                 'Legato/OpenLayers/Layer.js',
                 'Legato/OpenLayers/Control.js',
                 'Legato/OpenLayers/Map.js',
                 'Legato/OpenLayers/Map/Util.js',
                 'Legato/OpenLayers/Patches/Popup.js',
                 'Legato/OpenLayers/Control/ArgParser.js',
                 'Legato/OpenLayers/Control/Attribution.js',
                 'Legato/OpenLayers/Control/DrawFeature.js',
                 'Legato/OpenLayers/Control/ModifyFeature.js',
                 'Legato/OpenLayers/Control/LayerSwitcher.js',
                 'Legato/OpenLayers/Control/LoadingPanel.js',
                 'Legato/OpenLayers/Control/Scale.js',
                 'Legato/OpenLayers/Control/ScaleLine.js',
                 'Legato/OpenLayers/Control/Navigation.js',
                 'Legato/OpenLayers/Control/NavigationHistory.js',
                 'Legato/OpenLayers/Control/OverviewMap.js',
                 'Legato/OpenLayers/Control/Panel.js',
                 'Legato/OpenLayers/Control/PanZoom.js',
                 'Legato/OpenLayers/Control/PanZoomBar.js',
                 'Legato/OpenLayers/Control/MouseDefaults.js',
                 'Legato/OpenLayers/Control/MousePosition.js',
                 'Legato/OpenLayers/Control/Zoom.js',
                 'Legato/OpenLayers/Control/ZoomBox.js',
                 'Legato/OpenLayers/Control/ZoomInBox.js',
                 'Legato/OpenLayers/Control/ZoomOutBox.js',
                 'Legato/OpenLayers/Control/ZoomOut.js',
                 'Legato/OpenLayers/Control/ZoomToMaxExtent.js',
                 'Legato/OpenLayers/Popup/MarginAwareFramedCloud.js',
                 'Legato/Service.js',
                 'Legato/Service/LayerCapabilities.js',
                 'Legato/Service/CapabilitiesURLs.js',
                 'Legato/Handler.js',
                 'Legato/Handler/Box.js',
                 'Legato/Handler/Path.js',
                 'Legato/Handler/Point.js',
                 'Legato/Handler/Polygon.js',
                 'Legato/Handler/RegularPolygon.js',
                 'Legato/Handler/MouseWheel.js',
                 'Legato/Handler/MultiPoint.js',
                 'Legato/Handler/MultiLineString.js',
                 'Legato/Handler/MultiPolygon.js',
                 'Legato/I18n.js',
                 'Legato/I18n/BrowserLocaleFactoryBean.js',
                 'Legato/I18n/Messages.js',
                 'Legato/I18n/MessageSource.js',
                 'Legato/I18n/Message.js',
                 'Legato/I18n/Messages/de.js',
                 'Legato/I18n/Messages/en.js',
                 'Legato/Popup.js',
                 'Legato/Layer.js',
                 'Legato/Layer/Predicate.js',
                 'Legato/Layer/Predicate/BaseLayer.js',
                 'Legato/Layer/Predicate/LayerId.js',
                 'Legato/Layer/Predicate/LayerWithAttribute.js',
                 'Legato/Layer/Predicate/Overlay.js',
                 'Legato/Layer/Predicate/SelectedLayer.js',
                 'Legato/Layer/Transformer.js',
                 'Legato/Layer/Transformer/SublayerFilteringTransformer.js',
                 'Legato/Marker.js',
                 'Legato/Marker/PopupMarker.js',
                 'Legato/Control.js',
                 'Legato/Control/ArgParser.js',
                 'Legato/Control/BBoxValueProvider.js',
                 'Legato/Control/ControlContainer.js',
                 'Legato/Control/ControlFunction.js',
                 'Legato/Control/ControlSwitcher.js',
                 'Legato/Control/DefaultBaseLayer.js',
                 'Legato/Control/DrawFeature.js',
                 'Legato/Control/DrawBox.js',
                 'Legato/Control/DrawPoint.js',
                 'Legato/Control/DrawLineString.js',
                 'Legato/Control/DrawPolygon.js',
                 'Legato/Control/DrawCircle.js',
                 'Legato/Control/DrawMultiPoint.js',
                 'Legato/Control/DrawMultiLineString.js',
                 'Legato/Control/DrawMultiPolygon.js',
                 'Legato/Control/DrawText.js',
                 'Legato/Control/ExtendedPanel.js',
                 'Legato/Control/FeatureSelector.js',
                 'Legato/Control/LayersValueProvider.js',
                 'Legato/Control/LayerSelection.js',
                 'Legato/Control/SketchLayerEditor.js',
                 'Legato/Control/Legend.js',
                 'Legato/Control/Legend/Plugin.js',
                 'Legato/Control/Legend/Plugin/Layer.js',
                 'Legato/Control/Legend/Plugin/LayerDescription.js',
                 'Legato/Control/Legend/Plugin/LayerFunction.js',
                 'Legato/Control/Legend/Plugin/LayerLink.js',
                 'Legato/Control/Legend/Plugin/LayerName.js',
                 'Legato/Control/Legend/Plugin/LayerPosition.js',
                 'Legato/Control/Legend/Plugin/LayerRemove.js',
                 'Legato/Control/Legend/Plugin/LayerVisibility.js',
                 'Legato/Control/Legend/Plugin/LayerZoomToVisibleScale.js',
                 'Legato/Control/Legend/Plugin/LayerDropDownMenu.js',
                 'Legato/Control/MapAttribution.js',
                 'Legato/Control/MeasureLine.js',
                 'Legato/Control/MeasurePolygon.js',
                 'Legato/Control/ModifyFeature.js',
                 'Legato/Control/ModifyPolygon.js',
                 'Legato/Control/ModifyPoint.js',
                 'Legato/Control/ModifyLineString.js',
                 'Legato/Control/ModifyMultiPoint.js',
                 'Legato/Control/ModifyMultiLineString.js',
                 'Legato/Control/ModifyMultiPolygon.js',
                 'Legato/Control/Navigation.js',
                 'Legato/Control/NavigationHistory.js',
                 'Legato/Control/AbstractNavigationHistoryButton.js',
                 'Legato/Control/NavigationHistoryNext.js',
                 'Legato/Control/NavigationHistoryPrevious.js',
                 'Legato/Control/OverviewBoundingBox.js',
                 'Legato/Control/PanZoom.js',
                 'Legato/Control/PanZoomBar.js',
                 'Legato/Control/SelectionBoxValueProvider.js',
                 'Legato/Control/SetMapSize.js',
                 'Legato/StyleProperties.js',
                 'Legato/StyleProperties/AbstractInputElement.js',
                 'Legato/StyleProperties/InputElement.js',
                 'Legato/StyleProperties/SelectElement.js',
                 'Legato/StyleProperties/Factory.js',
                 'Legato/Control/StylePropertiesEditor.js',
                 'Legato/Control/SyncMapDivSize.js',
                 'Legato/Control/ToggleDisplay.js',
                 'Legato/Control/ToggleDiv.js',
                 'Legato/Control/ToggleLayer.js',
                 'Legato/Control/WMSGetFeatureInfo.js',
                 'Legato/Control/ViewContextValueProvider.js',
                 'Legato/Control/ScaleInput.js',
                 'Legato/Control/SelectBounds.js',
                 'Legato/Control/SelectLonLat.js',
                 'Legato/Control/Separator.js',
                 'Legato/Control/GeoLocation.js',
                 'Legato/Control/CallbackLocker.js',
                 'Legato/Control/SynchronousSnappingResolver.js',
                 'Legato/Control/SnappingController.js',
                 'Legato/Control/SnappableLayerSelector.js',
                 'Legato/Format.js',
                 'Legato/Format/ArcXML.js',
                 'Legato/Format/GML3.js',
                 'Legato/Format/ExtendedWMC.js',
                 'Legato/Format/ExtendedWMC/Model.js',
                 'Legato/Format/ExtendedWMC/Parser.js',
                 'Legato/OpenLayers/Layer/Image.js',
                 'Legato/OpenLayers/Layer/Markers.js',
                 'Legato/OpenLayers/Layer/GeoRSS.js',
                 'Legato/OpenLayers/Layer/Grid.js',
                 'Legato/OpenLayers/Layer/Vector.js',
                 'Legato/OpenLayers/Layer/WMS.js',
                 'Legato/OpenLayers/Layer/WFS.js',
                 'Legato/OpenLayers/Layer/GML.js',
                 'Legato/OpenLayers/Layer/Yahoo.js',
                 'Legato/OpenLayers/Layer/ArcIMS.js',
                 'Legato/OpenLayers/Layer/Google.js',
                 'Legato/OpenLayers/Layer/ArcGIS93Rest.js',
                 'Legato/OpenLayers/Layer/XYZ.js',
                 'Legato/OpenLayers/Layer/OSM.js',
                 'Legato/Layer/Blank.js',
                 'Legato/Layer/VectorOSM.js',
                 'Legato/Layer/GetLegend.js',
                 'Legato/Layer/Legend.js',
                 'Legato/Layer/VectorUpdater.js',
                 'Legato/Layer/Library.js',
                 'Legato/OverviewMap.js',
                 'Legato/Style.js',
                 'Legato/BootLoader.js',
                 'Legato/Util/EventListener.js'
      ]; // etc.
      /**
       * PATCH
       */
      // }

      // use "parser-inserted scripts" for guaranteed execution order
      // http://hsivonen.iki.fi/script-execution/
      var scriptTags = new Array(jsFiles.length);
      var host = Legato._getScriptLocation() + "lib/";
      for (var i=0, len=jsFiles.length; i<len; i++) {
          scriptTags[i] = "<script src='" + host + jsFiles[i] +
                                 "'></script>";
      }
      if (scriptTags.length > 0) {
          document.write(scriptTags.join(""));
      }
    }
})();

/**
 * Constant: VERSION_NUMBER
 */
Legato.VERSION_NUMBER = "$Revision: 1163 $";
Legato.NAMESPACE_URI = "http://www.disy.net/legato";
Legato.PREFIX = 'l';
Legato.QName = function(localPart) {
  return new Legato.XML.QName(Legato.NAMESPACE_URI, localPart,
      Legato.PREFIX);
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Feature = {};

Legato.Feature.Style = {
  DEFAULT_TEXT: {
    label : "",
    labelAlign : "cm",
    labelSelect : true,
    rotation : "0",
    fontColor : "#0000FF",
    fontFamily : "SansSerif",
    fontOpacity : "1",
    fontSize : "12",
    fontStyle : "normal",
    fontWeight : "bold",
    fillOpacity : "0",
    pointRadius : "6",
    strokeWidth : "0"
  },
  DEFAULT_POINT: {
    pointRadius: "4",
    graphicName: "square",
    fillColor: "white",
    fillOpacity: "1",
    strokeWidth: "1",
    strokeOpacity: "1",
    strokeColor: "#333333"
  },
  DEFAULT_LINE: {
    strokeWidth: "3",
    strokeOpacity: "1",
    strokeColor: "#666666",
    strokeDashstyle: "dash"
  },
  DEFAULT_POLYGON: {
    strokeWidth: "2",
    strokeOpacity: "1",
    strokeColor: "#666666",
    fillColor: "white",
    fillOpacity: "0.3"
  },
  HIGHLIGHT_POINT: {
    pointRadius: "4",
    fillColor: "#ff4500",
    fillOpacity: "1",
    strokeWidth: "1",
    strokeOpacity: "1",
    strokeColor: "#000"
  },
  HIGHLIGHT_LINE: {
      strokeWidth: "4",
      strokeOpacity: "1",
      strokeColor: "#000",
      fillColor: "#ff4500",
      strokeDashstyle: "dash"
  },
  HIGHLIGHT_POLYGON: {
      strokeWidth: "4",
      strokeOpacity: "1",
      strokeColor: "#000",
      fillColor: "#ff4500",
      fillOpacity: "0.4"
  }
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Feature.Sketch = {};

Legato.Feature.Sketch.style = {
  'default' : {
    TEXT : {
      labelAlign : "cm",
      labelSelect : true,
      rotation : 0.0,
      fontColor : "#0000FF",
      fontFamily : "Arial",
      fontOpacity : 1,
      fontSize : 12,
      fontStyle : "normal",
      fontWeight : "bold",
      fillOpacity : 0,
      pointRadius : 6,
      strokeWidth : 0
    },
    POINT: {
      strokeColor : "#000000",
      strokeOpacity : 1,
      strokeWidth : 1,
      fillColor : "#FF0000",
      fillOpacity : 1,
      graphicName : "circle",
      pointRadius : 6
    },
    LINE: {
      strokeColor : "#FF0000",
      strokeOpacity : 1,
      strokeWidth : 6,
      strokeLinecap : "square",
      strokeDashstyle : "solid"
    },
    POLYGON: {
      fillColor: "#FF0000",
      fillOpacity: 0.4,
      strokeColor: "#0000FF",
      strokeOpacity: 1,
      strokeLinecap : "square",
      strokeWidth: 4
    }
  },
  'select' : {
    TEXT: {
      fontOpacity : 0.2
    },
    POINT: {
      fillOpacity : 0.2
    },
    LINE: {
      strokeOpacity : 0.2
    },
    POLYGON: {
      fillOpacity: 0.2,
      strokeOpacity: 0.2
    }
  }
};

Legato.Feature.Sketch.Attributes = {
  TEXT: [
    "x-label",
    "x-label-align",
    "rotation",
    "font-family",
    "font-size",
    "font-style",
    "font-weight",
    "font-color",
    "font-opacity"
  ],
  POINT: [
    "stroke",
    "stroke-opacity",
    "stroke-width",
    "fill",
    "fill-opacity",
    "x-graphic-name",
    "x-point-radius"
  ],
  LINE: [
    "stroke",
    "stroke-opacity",
    "stroke-width",
    "x-stroke-dashstyle"
  ],
  POLYGON: [
    "stroke",
    "stroke-opacity",
    "stroke-width",
    "x-stroke-dashstyle",
    "fill",
    "fill-opacity"
  ]
};

Legato.Feature.Sketch.AttributeStyleMap = {
  "x-label": "label",
  "x-label-align" : "labelAlign",
  "x-graphic-name" : "graphicName",
  "x-point-radius" : "pointRadius",
  "x-stroke-dashstyle"  : "strokeDashstyle",
  "rotation" : "rotation",
  "font-family" : "fontFamily",
  "font-size" : "fontSize",
  "font-style" : "fontStyle",
  "font-weight" : "fontWeight",
  "font-color" : "fontColor",
  "font-opacity" : "fontOpacity",
  "stroke" : "strokeColor",
  "stroke-opacity" : "strokeOpacity",
  "stroke-width" : "strokeWidth",
  "fill" : "fillColor",
  "fill-opacity" : "fillOpacity"
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Singleton = OpenLayers.Class({
  initialize: function () {
  },

  _instance: null,

  getInstance: function()
  {
    if (this._instance === null)
    {
      var instance = {};
      OpenLayers.Util.extend(instance, this);
      instance.initialize.apply(instance);
      this._instance = instance;
    }
    return this._instance;
  },

  CLASS_NAME: 'Legato.Singleton'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Revision: 69543 $
 * @requires Legato.js
 * @requires OpenLayers/Control.js
 */

/**
 * Class: Legato.Util
 * Common utiltites for Legato
 *
 */
Legato.Util = {};
Legato.Util.NAMESPACE_URI = 'http://www.disy.net/legato/util';
Legato.Util.PREFIX = 'lu';
Legato.Util.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Util.NAMESPACE_URI, localPart,
      Legato.Util.PREFIX);
};

Legato.Util.extend = function(destination, source) {
  destination = destination || {};
  if (source) {
    /*jslint forin:true*/
    for ( var property in source) {
      var value = source[property];
      if (value !== undefined) {
        destination[property] = value;
      }
    }

    /**
     * IE doesn't include the toString property when iterating over an
     * object's properties with the for(property in object) syntax.
     * Explicitly check if the source has its own toString property.
     */

    /*
     * FF/Windows < 2.0.0.13 reports "Illegal operation on WrappedNative
     * prototype object" when calling hawOwnProperty if the source object is
     * an instance of window.Event.
     */
    var sourceIsEvt = (typeof window.Event == "function" && source instanceof window.Event);

    if (!sourceIsEvt && source.hasOwnProperty
        && source.hasOwnProperty('toString')) {
      destination.toString = source.toString;
    }
  }
  return destination;
};

Legato.Util.getElementById = function(id) {
  return document.getElementById(id);
};

Legato.Util.fireDOMEvent = function(obj, evt) {
  var fireOnThis = obj;
  if (document.createEvent) {
    var evObj = document.createEvent("MouseEvents");
    evObj.initEvent(evt, true, false);
    fireOnThis.dispatchEvent(evObj);
  } else if (document.createEventObject) {
    fireOnThis.fireEvent("on" + evt);
  }
};

Legato.Util.getUrlString = function(urlObject){
  if(!Legato.Lang.ObjectUtils.isObject(urlObject)){
    return false;
  }

  var urlString = urlObject.protocol + "//" + urlObject.host + ":" + urlObject.port + urlObject.pathname;

  if(Legato.Lang.ObjectUtils.isObject(urlObject.args)){
    urlString += "?" + OpenLayers.Util.getParameterString(urlObject.args);
  }

  return urlString;
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang = {};
Legato.Lang.NAMESPACE_URI = 'http://www.disy.net/legato/lang';
Legato.Lang.PREFIX = 'll';
Legato.Lang.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Lang.NAMESPACE_URI, localPart,
      Legato.Lang.PREFIX);
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Revision: 69543 $
 */

/*
 * Namespace: Legato.Graph
 * 
 * Graph package.
 */
Legato.Graph = {};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/* Structure: Proj4js.defs
 * Additional definitions for Proj4js
 * New definitions can be easily added by going to http://spatialreference.org/ref
 */

if (typeof(Proj4js) != "undefined" && Proj4js.defs) {
  //Germany, Gauss-Krueger GK3-5
  Proj4js.defs["EPSG:31466"] = "+proj=tmerc +lat_0=0 +lon_0=6 +k=1 +x_0=2500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs";
  Proj4js.defs["EPSG:31467"] = "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs";
  Proj4js.defs["EPSG:31468"] = "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +datum=potsdam +units=m +no_defs";
  //Austria
  Proj4js.defs["EPSG:31254"] = "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs";
  Proj4js.defs["EPSG:31287"] = "+proj=lcc +lat_1=49 +lat_2=46 +lat_0=47.5 +lon_0=13.33333333333333 +x_0=400000 +y_0=400000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs";
  Proj4js.defs["EPSG:31284"] = "+proj=tmerc +lat_0=0 +lon_0=10.33333333333333 +k=1 +x_0=150000 +y_0=0 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs";
  Proj4js.defs["EPSG:31251"] = "+proj=tmerc +lat_0=0 +lon_0=28 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +pm=ferro +units=m +no_defs";
  Proj4js.defs["EPSG:31252"] = "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +pm=ferro +units=m +no_defs";
  Proj4js.defs["EPSG:31253"] = "+proj=tmerc +lat_0=0 +lon_0=34 +k=1 +x_0=0 +y_0=-5000000 +ellps=bessel +pm=ferro +units=m +no_defs";
  Proj4js.defs["EPSG:31259"] = "+proj=tmerc +lat_0=0 +lon_0=16.33333333333333 +k=1 +x_0=750000 +y_0=-5000000 +ellps=bessel +towgs84=577.326,90.129,463.919,5.137,1.474,5.297,2.4232 +units=m +no_defs";
}
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Revision: 69543 $
 */

Legato.XML = {};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.Class = function() {
  var Class = function() {
    this.initialize.apply(this, arguments);
  };
  var extended = {};
  var parent;
  for ( var i = 0, len = arguments.length; i < len; ++i) {
    if (typeof arguments[i] == "function") {
      // get the prototype of the superclass
      parent = arguments[i].prototype;
    } else {
      // in this case we're extending with the prototype
      parent = arguments[i];
    }
    Legato.Util.extend(extended, parent);
  }
  Class.prototype = extended;
  return Class;
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Namespace: Legato.Lang.ObjectUtils
 */
Legato.Lang.ObjectUtils = {
  /*
   * Function: isNull
   *
   * Checks if given value is null (not undefined).
   *
   * Returns:
   *
   * true if the value is null, false otherwise.
   */
  isNull : function(value) {
    return (typeof value != 'undefined' && value === null);
  },
  /*
   * Function: isUndefined
   *
   * Checks if given value is undefined.
   *
   * Returns:
   *
   * true if the value is undefined, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isUndefined : function(value) {
    return (typeof value == 'undefined');
  },
  /*
   * Function: isNullOrUndefined
   *
   * Checks if given value is null or undefined.
   *
   * Returns:
   *
   * true if the value is null or undefined, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isNullOrUndefined : function(value) {
    return (typeof value == 'undefined' || value === null);
  },
  /*
   * Function: exists
   *
   * Checks if given value exists (is neither null nor undefined).
   *
   * Returns:
   *
   * true if the value is neither null nor undefined, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  exists : function(value) {
    return (typeof value != 'undefined' && value !== null);
  },
  /*
   * Function: isString
   *
   * Checks if given value is string.
   *
   * Returns:
   *
   * true if the value is string, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isString : function(value) {
    return (typeof value == 'string');
  },
  /*
   * Function: isBoolean
   *
   * Checks if given value is boolean.
   *
   * Returns:
   *
   * true if the value is boolean, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isBoolean : function(value) {
    return (typeof value == 'boolean');
  },
  /*
   * Function: isTrue
   *
   * Checks if given value is boolean and it is true.
   *
   * Returns:
   *
   * true if the value is boolean and true, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isTrue : function(value) {
    return (typeof value == 'boolean') && value;
  },
  /*
   * Function: isFalse
   *
   * Checks if given value is boolean and it is false.
   *
   * Returns:
   *
   * true if the value is boolean and it is false, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isFalse : function(value) {
    return (typeof value == 'boolean') && !value;
  },
  /*
   * Function: isFunction
   *
   * Checks if given value is function.
   *
   * Returns:
   *
   * true if the value is function, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isFunction : function(value) {
    return (typeof value == 'function');
  },
  /*
   * Function: isRegExp
   *
   * Checks if given value is a RegExp.
   *
   * Returns:
   *
   * true if the value is RegExp, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isRegExp: function(value){
    return value instanceof RegExp;
  },
  /*
   * Function: isDate
   *
   * Checks if given value is a Date.
   *
   * Returns:
   *
   * true if the value is Date, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isDate: function(value){
    return value instanceof Date;
  },
  /*
   * Function: isArray
   *
   * Checks if given value is an array.
   *
   * Returns:
   *
   * true if the value is an array, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isArray : function(value) {
    return (value instanceof Array);
  },
  /*
   * Function: isNotEmptyArray
   *
   * Checks if given value is a not empty array.
   *
   * Returns:
   *
   * true if the value is an array and it is not empty, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isNotEmptyArray : function(value) {
    return (value instanceof Array) && value.length > 0;
  },
  /*
   * Function: isObject
   *
   * Checks if given value is a non-null object.
   *
   * Returns:
   *
   * true if the value is a non-null object, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isObject : function(value) {
    return (typeof value == 'object') && (value !== null);
  },
  /*
   * Function: isNumber
   *
   * Checks if given value is a number.
   *
   * Returns:
   *
   * true if the value is a number, false otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */
  isNumber: function(value){
    return (typeof value == 'number') && (value !== null);
  },
  /*
   * Function: isEmptyObject
   *
   * Checks if given value is an empty object ({}).
   *
   * Returns:
   *
   * true if the value is an empty object, null or undefined. False otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   */  
  isEmptyObject: function( obj ) {
    for (var name in obj) {
      if (obj.hasOwnProperty(name)) {
        return false;
      }
    }
    return true;
  }

};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/**
 * Class: Legato.Lang.ArrayUtils
 */

Legato.Lang.ArrayUtils = {
  /*
   * Function: get
   * 
   * Returns the element of an array with a given index.
   * 
   * Returns:
   * 
   * The element with the given index, if it exists. Otherwise, it returns
   * something undefined.
   */

  get : function(array, index) {
    if (Legato.Lang.ObjectUtils.isArray(array) && index >= 0 && index < array.length) {
      return array[index];
    }
    else {
      return undefined;
    }
  }
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author$
 * @version $Revision$
 * @requires Legato.js
 * @requires Legato/Util.js
 */

/**
 * Class: Legato.Lang.CollectionUtils
 * Some common utils for collections
 */
Legato.Lang.CollectionUtils = {};

/**
 * Function: Legato.Lang.CollectionUtils.filter
 *
 * Filters given array based on given evaluate method. If evaluate
 * method returns true, arrayelement will been keeped. False otherwise.
 *
 * Parameters:
 * array - {Object} The array to filter
 * evaluate - {Function} the filter function
 *
 * Returns:
 * {Object} The filtered array
 */
Legato.Lang.CollectionUtils.filter = function(array, evaluate){
  Legato.Util.Ensure.ensureArray(array);
  Legato.Util.Ensure.ensureFunction(evaluate);

  var filtered = [];
  for(var i = 0; i < array.length; i++){
    if(evaluate(array[i])){
      filtered.push(array[i]);
    }
  }

  return filtered;
};

/**
 * Function: Legato.Lang.CollectionUtils.filterObject
 *
 * Filters given object based on given evaluate method. If key is in evaluate,
 * object property will be keeped. False otherwise.
 *
 * Parameters:
 * object - {Object} The object to filter
 * evaluate - {Array} the array of properties to keep
 *
 * Returns:
 * {Object} The filtered object
 */
Legato.Lang.CollectionUtils.filterObject = function(object, evaluate){
  Legato.Util.Ensure.ensureObject(object);
  Legato.Util.Ensure.ensureArray(evaluate);

  var filtered = [];
  Legato.Lang.CollectionUtils.copyIfExists(object, filtered, evaluate);
  return filtered;
};

/**
 * Function: Legato.Lang.CollectionUtils.transform
 *
 * Transforms given array based on given transformer method. The new build
 * array will then been returned.
 *
 * Parameters:
 * array - {Object} The array to filter
 * evaluate - {Function} the filter function
 *
 * Returns:
 * {Object} The filtered array
 */
Legato.Lang.CollectionUtils.transform = function(array, transformer){
  Legato.Util.Ensure.ensureArray(array);
  Legato.Util.Ensure.ensureFunction(transformer);

  var transformed = [];

  for(var i = 0; i < array.length; i++){
    transformed.push(transformer(array[i]));
  }

  return transformed;
};

/**
 * Function: Legato.Lang.CollectionUtils.each
 *
 * Calls a given function on each element of an array
 *
 * Parameters:
 * array - {Object} The array to iterate
 * func - {Function} the function to call
 *
 * Returns:
 * nothing
 */
Legato.Lang.CollectionUtils.each = function(array, func) {
  Legato.Util.Ensure.ensureArray(array);
  Legato.Util.Ensure.ensureFunction(func);

  for(var i = 0; i < array.length; i++){
    func(array[i]);
  }
};

/**
 * Function: copyIfExists
 * 
 * Copies all Properties from source to destination if they exist in source
 * 
 * Returns:
 * 
 * nothing
 * 
 * Parameters:
 * 
 * source - source object
 * destination - destination object
 * properties - array with property names
 */
Legato.Lang.CollectionUtils.copyIfExists = function(source, destination, properties) {
  Legato.Util.Ensure.ensureArray(properties);

  Legato.Lang.CollectionUtils.each(properties, function(property) {
    if (Legato.Lang.ObjectUtils.exists(source[property])) {
      destination[property] = source[property];
    }
  });
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author$
 * @version $Revision$
 * @requires Legato.js
 * @requires Legato/Util.js
 */

/**
 * Class: Legato.Lang.NumberUtils Some common util methods for numbers
 */
Legato.Lang.NumberUtils = {};

/**
 * Function: Legato.Lang.NumberUtils.toFloat Try to parse given param into a
 * number and returns it if possible. Throws Exception otherwise.
 *
 * Parameters: value - {String} The String you want to parse into a number
 *
 * Returns: {Number} The parsed value as Number
 */
Legato.Lang.NumberUtils.toFloat = function(value) {
  if (Legato.Lang.ObjectUtils.isNumber(value)) {
    return value;
  }

  if (Legato.Lang.ObjectUtils.isNull(value)) {
    return null;
  }

  if (Legato.Lang.ObjectUtils.isString(value)) {
    var parsedFloat = parseFloat(value);
    if (isNaN(parsedFloat)) {
      throw Error('Given string is not parsable into a float');
    }
    return parsedFloat;
  }

  throw new Error('The object type \'' + typeof value + '\' is not supported');
};

Legato.Lang.NumberUtils.roundScale = function(value, scale) {
  Legato.Util.Ensure.ensureNumber(value);
  var power = Math.round(scale);
  var multiplicator = Math.pow(10, power);
  return Math.round(value * multiplicator) / multiplicator;
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Namespace: Legato.Lang.StringUtils
 * 
 * Contains convenience functions for string manipulation.
 */
Legato.Lang.StringUtils = {
  /*
   * Function: startsWith
   * 
   * Checks if the given string starts with a certain prefix.
   * 
   * Parameters:
   * 
   * string - {String} String to check.
   * 
   * prefix - {String} Prefix.
   * 
   */
  startsWith : function(string, prefix) {
    if (!Legato.Lang.ObjectUtils.isString(string)
        || !Legato.Lang.ObjectUtils.isString(prefix)) {
      return false;
    }
    return (string.length >= prefix.length)
        && (string.substring(0, prefix.length) == prefix);

  },
  /*
   * Function: endsWith
   * 
   * Checks if the given string ends with a certain suffix.
   * 
   * Parameters:
   * 
   * string - {String} String to check.
   * 
   * suffix - {String} Suffix.
   * 
   */
  endsWith : function(string, suffix) {
    if (!Legato.Lang.ObjectUtils.isString(string)
        || !Legato.Lang.ObjectUtils.isString(suffix)) {
      return false;
    }
    return string.indexOf(suffix, string.length - suffix.length) !== -1;
  },
  /*
   * Function: trim
   * 
   * Removes leading and trailing whitespace characters from a string.
   * 
   * Parameters:
   * 
   * string - {String} The (potentially) space padded string. This string is not
   * modified.
   * 
   * Returns:
   * 
   * {String} A trimmed version of the string with all leading and trailing
   * spaces removed.
   */
  trim : function(string) {
    if (Legato.Lang.ObjectUtils.isUndefined(string)) {
      return undefined;
    } else if (Legato.Lang.ObjectUtils.isNull(string)) {
      return null;
    } else {
      Legato.Util.Ensure.ensureString(string);
      return string.replace(/^\s*(.*?)\s*$/, "$1");
    }
  },
  /*
   * Function: isEmpty
   * 
   * Checks if given string is empty.
   * 
   * Returns:
   * 
   * true if the string is null, undefined or empty, false otherwise.
   * 
   * Parameters:
   * 
   * string - string to check.
   */
  isEmpty : function(string) {
    if (!Legato.Lang.ObjectUtils.exists(string)) {
      return true;
    } else {
      Legato.Util.Ensure.ensureString(string);
      if (string.length === 0) {
        return true;
      } else {
        /*
         * for ( var index = 0; index < string.length; index++) { var ch =
         * string.charAt(index); if (!(ch == ' ' || ch == '\t' || ch == '\n' ||
         * ch == '\v' || ch == '\f' || ch == '\r' || ch == '\0')) { return
         * false; } } return true;
         */
        return false;
      }
    }
  }
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Lang.Exception
 */
Legato.Lang.Exception = Legato.Lang.Class( {
  /*
   * Property: message
   *
   * Exception message.
   */
  message :null,
  /*
   * Property: cause
   *
   * Exception cause.
   */
  cause :null,
  /*
   * Constructor: initialize
   *
   * Constructs a new exception.
   *
   * Parameters:
   *
   * message - {String} exception message (optional).
   *
   * cause - exception cause (optional).
   */
  initialize : function(message, cause) {
    if (Legato.Lang.ObjectUtils.exists(message)) {
      Legato.Util.Ensure.ensureString(message);
      this.message = message;
    } else {
      this.message = null;
    }
    if (Legato.Lang.ObjectUtils.exists(cause)) {
      this.cause = cause;
    } else {
      this.cause = null;
    }
  },

  toString: function(){
    return this.CLASS_NAME + ': ' + this.message;
  },

  CLASS_NAME: 'Exception'
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Lang.IllegalArgumentException
 */
Legato.Lang.IllegalArgumentException = Legato.Lang.Class(Legato.Lang.Exception,{
  CLASS_NAME: 'IllegalArgumentException'
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.AnyType = Legato.Lang.Class( {
  typeName :'Legato.Lang.AnyType',
  isList :false,
  isMap :false,
  isInstance : function(value) {
    if (value) {
      return true;
    } else {
      return false;
    }
  },
  initialize : function() {
  },
  List : function() {
    return new Legato.Lang.List(this);
  },
  Map : function() {
    return new Legato.Lang.Map(this);
  },
  Enum : function(typeName, values) {
    return new Legato.Lang.Enum(this, typeName, values);
  },
  toString : function() {
    return this.typeName;
  }
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.AnySimpleType = Legato.Lang.Class(Legato.Lang.AnyType, {
  typeName: 'Legato.Lang.AnySimpleType',
  // Load object from string
  fromString : function(value, beanFactory) {
    Legato.Util.Ensure.ensureString(value);
    return this.fromStringSafe(value, beanFactory);
  },
  fromStringSafe : function(string, beanFactory) {
    throw new Error(
        'Cannot load an object from string, this class does not implement the fromStringSafe method.');
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.List = Legato.Lang.Class(Legato.Lang.AnyType, {
  elementType :null,
  isList :true,
  isInstance : function(value) {
    /* TODO ensure correct element types */
    return (value instanceof Array);
  },
  initialize : function(elementType) {
    this.elementType = elementType;
    this.typeName = elementType.typeName + '[]';
    if (elementType.fromString)
    {
      this.fromString = function(value, beanFactory) {
        if ((typeof value) != 'string') {
          throw new Error('Argument is not a string.');
        } else {
          return this.fromStringSafe(value, beanFactory);
        }
      };
      this.fromStringSafe = function(value, beanFactory) {
        var result = [];
        if (value.length !== 0) {
          var strings = value.split(',');
          for ( var index = 0; index < strings.length; index++) {
            var string = strings[index];
            /* TODO trim */
            result[index] = this.elementType.fromString(string, beanFactory);
          }
        }
        return result;
      };
    }
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.Map = Legato.Lang.Class(Legato.Lang.AnyType, {
  elementType :null,
  isMap :true,
  isInstance : function(value) {
    /* Ensure element types */
    return (typeof value == 'object');
  },
  initialize : function(elementType) {
    this.elementType = elementType;
    this.typeName = elementType.typeName + '{}';
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.Null = Legato.Lang.Class( {
  initialize : function() {
  },
  getInstance : function(beanFactory) {
    return null;
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.Enum = Legato.Lang.Class(Legato.Lang.AnySimpleType, {
  elementType :null,
  values :null,
  isInstance : function(value) {
    if (!this.elementType.isInstance(value)) {
      return false;
    } else {
      for ( var name in this.values) {
        if (this.values[name] == value) {
          return true;
        }
      }
      return false;
    }
  },
  fromStringSafe : function(value) {
    if(Legato.Lang.ObjectUtils.exists(this.values[value])){
      return this.values[value];
    } else {
      throw new Error(
          'Value [' + value + '] could not be found in given enumeration.');
    }
  },
  initialize : function(elementType, typeName, values) {
    this.elementType = elementType;
    this.typeName = typeName;
    this.values = values;
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.Boolean = new (Legato.Lang.Class(Legato.Lang.AnySimpleType, {
	typeName :'Legato.Lang.Boolean',
	isInstance : function(value) {
		return (typeof value) == 'boolean';
	},
	fromStringSafe : function(value) {
		if (value == 'true') {
			return true;
		} else if (value == 'false') {
			return false;
		} else {
			throw Error('Could not parse [' + value + '].');
		}
	}
}))();

Legato.Lang['Boolean{}'] = Legato.Lang.Boolean.Map();
Legato.Lang['Boolean[]'] = Legato.Lang.Boolean.List();
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.Integer = new (Legato.Lang.Class(Legato.Lang.AnySimpleType, {
  typeName: 'Legato.Lang.Integer',
  isInstance : function(value) {
    return ((typeof value) == 'number' && (value % 1 === 0));
  },
  fromStringSafe : function(value) {
    var number = Number(value);
    if (isNaN(number)) {
      throw Error('Could not parse [' + value + '].');
    } else if ((number % 1) !== 0) {
      throw Error('Number is not an integer [' + value + '].');
    } else {
      return number;
    }
  }
}))();

Legato.Lang['Integer{}'] = Legato.Lang.Integer.Map();
Legato.Lang['Integer[]'] = Legato.Lang.Integer.List();
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.Number = new (Legato.Lang.Class(Legato.Lang.AnySimpleType, {
  typeName: 'Legato.Lang.Number',
  isInstance : function(value) {
    return ((typeof value) == 'number');
  },
  fromStringSafe : function(value) {
    var number = Number(value);
    if (isNaN(number)) {
      throw Error('Could not parse [' + value + '].');
    } else {
      return number;
    }
  }
}))();

Legato.Lang['Number{}'] = Legato.Lang.Number.Map();
Legato.Lang['Number[]'] = Legato.Lang.Number.List();
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.Double = new (Legato.Lang.Class(Legato.Lang.AnySimpleType, {
  typeName: 'Legato.Lang.Double',
  isInstance : function(value) {
    return ((typeof value) == 'number' && (!isNaN(value)));
  },
  fromStringSafe : function(value) {
    var number = Number(value);
    if (isNaN(number)) {
      throw Error('Could not parse [' + value + '].');
    } else {
      return number;
    }
  }
}))();


Legato.Lang['Double{}'] = Legato.Lang.Double.Map();
Legato.Lang['Double[]'] = Legato.Lang.Double.List();
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.String = new (Legato.Lang.Class(Legato.Lang.AnySimpleType, {
	typeName: 'Legato.Lang.String',
	isInstance : function(value) {
		return (typeof value) == 'string';
	},
	fromStringSafe : function(value) {
		return value;
	}
}))();

Legato.Lang['String{}'] = Legato.Lang.String.Map();
Legato.Lang['String[]'] = Legato.Lang.String.List();

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.Element = new (Legato.Lang.Class(Legato.Lang.AnySimpleType,
        {
          typeName: 'Legato.Lang.Element',
          isInstance : function(value) {
            return ((typeof value) == 'object'
                && (value.nodeType == 1) && (typeof value.id != 'undefined'));
          },
          fromString : function(value) {
            var element = Legato.Util.getElementById(value);
            if (element) {
              return element;
            } else {
              throw new Error(
                  'Could not find element by id [' + value + '].');
            }
          }
        }))();

/*
Legato.Lang['Element[]'] = Legato.Lang.Element.List();
Legato.Lang['Element{}'] = Legato.Lang.Element.Map();

Legato.Lang.Element.Bean = Legato.Beans.Object.Extend(
  'Legato.Lang.Element',
  //
  Legato.Lang.QName('Element'),
  //
  {
    factoryFunction :Legato.Lang.Element.fromString,
    constructorArguments : {
      id :Legato.Lang.String
    },
    constructorOrder : [ 'id' ]
  }
);
*/
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.Function = new (Legato.Lang.Class(Legato.Lang.AnySimpleType, {
	typeName: 'Legato.Lang.Function',
	isInstance : function(value) {
		return ((typeof value) == 'function');
	}
}))();

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Class: Legato.Lang.RGBColor
 * Simple bean to store RGB color values
 */
Legato.Lang.RGBColor = Legato.Lang.Class({

  /*
   * Property: r
   * {Integer} the red value (0-255)
   */
  r: null,

  /*
   * Property: g
   * {Integer} the green value (0-255)
   */
  g: null,

  /*
   * Property: b
   * {Integer} the blue value (0-255)
   */
  b: null,

  initialize : function() {
    //do nothing
  },
  toString: function(){
    return this.CLASS_NAME + ': r:' + this.r + ', g:' + this.g + ', b:' + this.b;
  },

  CLASS_NAME: 'Legato.Lang.RGBColor'

});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author$
 * @version $Rev$
 */

/**
 * Class: Legato.Util.Accessor
 * Small helper class which implements some sort of an setter, getter Pattern.
 * With this class you're able to wrap some other classes so that the wrapped
 * classed is accessed just with the getter setter Pattern.
 */
Legato.Util.Accessor = Legato.Lang.Class({

  /*
   * Property: target
   * {Object} The wrapped target class
   */
  target: null,

  /*
   * Property: field
   * If defined the field will be used if existing in target
   */
  field: null,

  /*
   * Property: setter
   * If defined this function will be used as setter if existing in target
   */
  setter: null,

  /*
   * Property: getter
   * If defined this function will be used as getter if existing in target
   */
  getter: null,

  /*
   * Function: initialize
   * Basic ctor for the accessor class
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this class
   * The following keys are supported
   * - target {Object} the used target instance
   * - field {String} Optional field specification. Will be used as getter and setter if defined
   * - setter {String} Optional function specification which must exists in target
   * - getter {String} Optional function specification which must exists in target
   */
  initialize : function(options) {
    this.target = options.target || null;
    this.field  = options.field  || null;
    this.setter = options.setter || null;
    this.getter = options.getter || null;

    if(typeof this.target == 'undefined'){
      throw new Error('A target is needed');
    }

    if(typeof this.field != 'string' && (typeof this.target[this.setter] != 'function' || typeof this.target[this.getter] != 'function')){
      throw new Error('You need to specifiy at least the used target field or a setter and getter function which exists in given target');
    }
  },

  /*
   * Function: setValue
   * Setter for wraped target instance value
   *
   * Parameters:
   * value - {Object} The value to set. Could be any type
   */
  setValue : function(value) {
    if (this.field) {
      this.target[this.field] = value;
    } else {
      this.target[this.setter](value);
    }
  },

  /*
   * Function: getValue
   * Getter for wraped target instance value
   *
   * Returns:
   * {Object} Could be any type
   */
  getValue : function() {
    var value = this.field ? this.target[this.field] : this.target[this.getter]();
    return value;
  },

  CLASS_NAME : 'Legato.Util.Accessor'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author$
 * @version $Rev$
 */

/**
 * Class: Legato.Util.LayerValueAccessor
 * Small helper class which implements some sort of an setter, getter Pattern.
 * With this class you're able to wrap some other classes so that the wrapped
 * classed is accessed just with the getter setter Pattern.
 */
Legato.Util.ObjectValueAccessor = Legato.Lang.Class({

  /*
   * Property: target
   * {Object} The wrapped target class
   */
  target: null,

  /*
   * Property: field
   * If defined the field will be used if existing in target
   */
  field: null,

  /*
   * Property: setter
   * If defined this function will be used as setter if existing in target
   */
  setter: null,

  /*
   * Property: getter
   * If defined this function will be used as getter if existing in target
   */
  getter: null,

  objectProperty: null,

  objectFilter: null,

  /*
   * Function: initialize
   * Basic ctor for the accessor class
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this class
   * The following keys are supported
   * - target {Object} the used target instance
   * - field {String} Optional field specification. Will be used as getter and setter if defined
   * - setter {String} Optional function specification which must exists in target
   * - getter {String} Optional function specification which must exists in target
   */
  initialize : function(options) {
    this.target         = options.target || null;
    this.field          = options.field  || null;
    this.setter         = options.setter || null;
    this.getter         = options.getter || null;
    this.objectProperty = options.objectProperty || null;
    this.objectFilter   = options.objectFilter || null;

    if(typeof this.target === null){
      throw new Error('A target is needed');
    }

    if(typeof this.layerProperty === null){
      throw new Error('A object Property is needed');
    }

    if(typeof this.field != 'string' && (typeof this.target[this.setter] != 'function' || typeof this.target[this.getter] != 'function')){
      throw new Error('You need to specifiy at least the used target field or a setter and getter function which exists in given target');
    }
  },

  getFilteredObjects: function(values){
    var filteredObjects = values;

    if(this.objectFilter !== null || Legato.Lang.ObjectUtils.isArray(this.objectFilter)){
      for(var i = 0; i < this.objectFilter.length; i++){
        if(!Legato.Lang.ObjectUtils.isFunction(this.objectFilter[i].filter)){
          continue;
        }
        filteredObjects = this.objectFilter[i].filter(filteredObjects);
      }
    }

    return filteredObjects;
  },

  /*
   * Function: setValue
   * Setter for wraped target instance value
   *
   * Parameters:
   * value - {Object} The value to set. Could be any type
   */
  setValue : function(value) {
    Legato.Util.Ensure.ensureArray(value);
    var filteredObjects = this.getFilteredObjects(value);
    var objectValues    = this.getObjectValues(filteredObjects, this.objectProperty);
    if (this.field) {
      this.target[this.field] = objectValues.toString();
    } else {
      this.target[this.setter](objectValues.toString());
    }
  },

  /*
   *
   */
  getObjectValues: function(objects, value){
    var values = [];

    for(var i = 0; i < objects.length; i++){
      if(!Legato.Lang.ObjectUtils.isObject(objects[i])){
        throw new Error('Just an Array of object Instances is allowed');
      }
      if(typeof objects[i][value] != 'undefined'){
        values.push(objects[i][value]);
      }
    }

    return values;
  },

  /*
   * Function: getValue
   * Getter for wraped target instance value
   *
   * Returns:
   * {Object} Could be any type
   */
  getValue : function() {
    var value = this.field ? this.target[this.field] : this.target[this.getter]();
    return value;
  },

  CLASS_NAME : 'Legato.Util.ObjectValueAccessor'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author$
 * @version $Rev$
 */

/**
 * Class: Legato.Util.LayerValueAccessor
 * Small helper class which implements some sort of an setter, getter Pattern.
 * With this class you're able to wrap some other classes so that the wrapped
 * classed is accessed just with the getter setter Pattern.
 */
Legato.Util.ObjectFilter = Legato.Lang.Class({

  property: null,
  value: null,

  /*
   * Function: initialize
   * Basic ctor for the accessor class
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this class
   * The following keys are supported
   * - target {Object} the used target instance
   * - field {String} Optional field specification. Will be used as getter and setter if defined
   * - setter {String} Optional function specification which must exists in target
   * - getter {String} Optional function specification which must exists in target
   */
  initialize : function(options) {
    this.property = options.property;
    this.value    = options.value;
  },

  filter : function(value) {
    var filteredValues = [];

    if(!Legato.Lang.ObjectUtils.isArray(value)){
      throw new Error('Just an Array of object Instances is allowed');
    }

    for(var i = 0; i < value.length; i++){
      if(Legato.Lang.ObjectUtils.isUndefined(value[i][this.property]) ||
         Legato.Lang.ObjectUtils.isFunction(value[i][this.property])){
        filteredValues.push(value[i]);
        continue;
      }
      if(value[i][this.property] != this.value){
        filteredValues.push(value[i]);
      }
    }

    return filteredValues;
  },

  CLASS_NAME : 'Legato.Util.ObjectFilter'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Namespace: Legato.Util.Ensure
 *
 * Implements ensure utilities.
 */
Legato.Util.Ensure = {
  /*
   * Function: ensureTrue
   *
   * Checks if given argument is the boolean value "true"., throws {<Legato.Lang.IllegalArgumentException>}
   * otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   *
   * message - {String} exception message (optional).
   */
  ensureTrue : function(value, message) {
    if (value !== true) {
      throw new Error(message);
    }
  },
  
  /*
   * Function: ensureFalse
   *
   * Checks if given argument is the boolean value "false"., throws {<Legato.Lang.IllegalArgumentException>}
   * otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   *
   * message - {String} exception message (optional).
   */
  ensureFalse : function(value, message) {
    if (value !== false) {
      throw new Error(message);
    }
  },
  /*
   * Function: ensureExists
   *
   * Checks if given argument exists (not null, not undefined), throws {<Legato.Lang.IllegalArgumentException>}
   * otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   *
   * message - {String} exception message (optional).
   */
  ensureExists : function(value, message) {
    if (!Legato.Lang.ObjectUtils.exists(value)) {
      throw new Error(message);
    }
  },
  /*
   * Function: ensureString
   *
   * Checks if given argument is string, throws {<Legato.Lang.IllegalArgumentException>}
   * otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   *
   * message - {String} exception message (optional).
   */
  ensureString : function(value, message) {
    if (typeof value != 'string') {
      throw new Legato.Lang.IllegalArgumentException(message);
    }
  },
  /*
   * Function: ensureNumber
   *
   * Checks if given argument is number, throws {<Legato.Lang.IllegalArgumentException>}
   * otherwise.
   *
   *  Parameters:
   *
   * value - value to check.
   *
   * message - {String} exception message (optional).
   */
  ensureNumber : function(value, message) {
    if (typeof value != 'number') {
      throw new Legato.Lang.IllegalArgumentException(message);
    }
  },
   /*
   * Function: ensureNotEmptyString
   *
   * Checks if given argument is a non-empty string, throws {<Legato.Lang.IllegalArgumentException>}
   * otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   *
   * message - {String} exception message (optional).
   */
  ensureNotEmptyString : function(value, message) {
    if (typeof value != 'string') {
      throw new Legato.Lang.IllegalArgumentException(message);
    } else {
      if (Legato.Lang.StringUtils.isEmpty(value)) {
        throw new Legato.Lang.IllegalArgumentException(message);
      }
    }
  },
  /*
   * Function: ensureObject
   *
   * Checks if given argument is an object (not null, not undefined), throws {<Legato.Lang.IllegalArgumentException>}
   * otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   *
   * message - {String} exception message (optional).
   */
  ensureObject : function(value, message) {
    if (typeof value != 'object' || value === null) {
      throw new Legato.Lang.IllegalArgumentException(message);
    }
  },
  /*
   * Function: ensureArray
   *
   * Checks if given argument is an array, throws {<Legato.Lang.IllegalArgumentException>}
   * otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   *
   * message - {String} exception message (optional).
   */
  ensureArray : function(value, message) {
    if (!(value instanceof Array)) {
      throw new Legato.Lang.IllegalArgumentException(message);
    }
  },
  /*
   * Function: ensureFunction
   *
   * Checks if given argument is a function, throws {<Legato.Lang.IllegalArgumentException>}
   * otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   *
   * message - {String} exception message (optional).
   */
  ensureFunction : function(value, message) {
    if (typeof value != 'function') {
      throw new Legato.Lang.IllegalArgumentException(message);
    }
  },
  /*
   * Function: ensureInstanceOf
   *
   * Checks if given value is an instance of the given function, throws {<Legato.Lang.IllegalArgumentException>}
   * otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   * f - {Function} potential constructor function.
   *
   * message - {String} exception message (optional).
   */
  ensureInstanceOf : function(value, f, message) {
    Legato.Util.Ensure.ensureFunction(f);
    if (!(value instanceof f))
    {
      throw new Legato.Lang.IllegalArgumentException(message);
    }
  },
  /*
   * Function: ensureImplements
   *
   * Checks if given value implements a function with the given name, throws {<Legato.Lang.IllegalArgumentException>}
   * otherwise.
   *
   * Parameters:
   *
   * value - value to check.
   * functionName - {String} name of the function.
   *
   * message - {String} exception message (optional).
   */
  ensureImplements : function(value, functionName, message) {
    Legato.Util.Ensure.ensureExists(value, message);
    Legato.Util.Ensure.ensureString(functionName, message);
    Legato.Util.Ensure.ensureFunction(value[functionName], message);
  }

};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Revision: 69543 $
 * @requires Legato.js
 * @requires Legato/Util.js
 */

/**
 * Class: Legato.Util.Matcher
 * Basically used by OpenLayers.
 *
 *
 * Inherits from:
 *  - <OpenLayers.Control>
 */
Legato.Util.Matcher = {};

/**
 * Function: Legato.Util.Matcher.IS_TRUE
 *
 * Simple Matcher Class which just returns given
 * value.
 *
 * Inherits from:
 *  - <OpenLayers.Control>
 */
Legato.Util.Matcher.IS_TRUE = {
  test : function(value) {
    return value;
  }
};

/**
 * Function: Legato.Util.Matcher.IS_FALSE
 *
 * Simple Matcher Class which just returns inverted
 * value.
 *
 * Inherits from:
 *  - <OpenLayers.Control>
 */
Legato.Util.Matcher.IS_FALSE = {
  test : function(value) {
    return !value;
  }
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 * @requires Legato.js
 * @requires Legato/Lang.js
 * @requires Legato/Lang/Class.js
 * @requires Legato/Util.js
 */

/*
 * Class: Legato.Util.HashSet
 *
 * Implements a map-backed set of strings.
 */
Legato.Util.HashSet = Legato.Lang.Class( {
  map :null,
  _size :0,
  /*
   * Constructor: initialize
   *
   * Constructs the set.
   */
  initialize : function() {
    this.map = {};
  },
  /*
   * Function: size
   *
   * Returns: {Integer} Number of the elements in the set.
   */
  size : function() {
    return this._size;
  },
  /*
   * Function: isEmpty
   *
   * Returns: {Boolean} True if set is empty, false otherwise.
   */
  isEmpty : function() {
    return (this._size === 0);
  },
  /*
   * Function: contains
   *
   * Checks if the set contains the value or not.
   *
   * Parameters:
   *
   * value - {String} element to add to the set.
   *
   * Returns: {Boolean} True if given value is belongs to this set, false
   * otherwise.
   */
  contains : function(value) {
    Legato.Util.Ensure.ensureString(value);
    var marker = this.map[value];
    if (marker) {
      return true;
    } else {
      return false;
    }

  },
  /*
   * Function: add
   *
   * Adds the value to the set.
   *
   * Parameters:
   *
   * value - {String} element to be added to the set.
   *
   * Returns: {Boolean} True if an element was added to the set, false if it was
   * already a member of the set.
   *
   */
  add : function(value) {
    Legato.Util.Ensure.ensureString(value);
    var marker = this.map[value];
    if (marker) {
      return false;
    } else {
      this.map[value] = true;
      this._size = this._size + 1;
      return true;
    }
  },
  /*
   * Function: addAll
   *
   * Adds all the elements of the given collection to this set.
   *
   * Parameters:
   *
   * set - set of string to be added to this set.
   *
   * Returns: {Boolean} True if new element were added to the set, false
   * otherwise.
   */
  addAll : function(set) {
    Legato.Util.Ensure.ensureObject(set);
    Legato.Util.Ensure.ensureFunction(set.toArray);
    var array = set.toArray();
    var changed = false;
    for (var index = 0; index < array.length; index++) {
      var item = array[index];
      var added = this.add(item);
      changed = (changed || added);
    }
    return changed;

  },
  /*
   * Function: remove
   *
   * Removes the element from the set.
   *
   * Parameters:
   *
   * value - {String} value to be removed from the set.
   *
   * Returns: {Boolean} True if the value was removed from the given set, false
   * if not (i.e. the value was not an element of this set).
   */
  remove : function(value) {
    Legato.Util.Ensure.ensureString(value);
    var marker = this.map[value];
    if (marker) {
      delete this.map[value];
      this._size = this._size - 1;
      return true;
    } else {
      return false;
    }
  },
  /*
   * Function: toArray
   *
   * Returns: {Array(String)} Array of elements contained in this set. The order
   * is not deterministic.
   */
  toArray : function() {
    var array = [];
    for ( var value in this.map)
    {
      if (this.map.hasOwnProperty(value)) {
        array.push(value);
      }
    }
    return array;
  },
  /*
   * Function: clear
   *
   * Clears the set.
   */
  clear : function() {
    this.map = {};
    this._size = 0;
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Util.Tag
 * This class represents a generic tag with string key and value (value is optional).
 */
Legato.Util.Tag = Legato.Lang.Class( {

  /*
   * Property: name
   * 
   * {String} Name of the tag
   */
  name :null,

  /*
   * Property: value
   * 
   * {String} Value of the tag
   */
  value :null,

  /*
   * Constructor: Legato.Util.Tag Create a new tag instance
   * 
   * Parameters: name - {String} The name of the tag value - {String} The value
   * of the tag
   * 
   * Returns: An instance of Legato.Util.Tag
   */
  initialize : function(name, value) {
    Legato.Util.Ensure.ensureString(name);
    this.name = name;
    if (Legato.Lang.ObjectUtils.exists(value)) {
      Legato.Util.Ensure.ensureString(value);
      this.value = value;
    } else {
      this.value = null;
    }
  },

  /*
   * Method: toString Cast this object into a string.
   * 
   * Returns: {String} The string representation of this tag.
   */
  toString : function() {
    return '[' + this.name + (this.value === null ? '' : '=' + this.value)
        + ']';
  },

  /*
   * Method: equals Determines whether one tag is equivalent to another.
   * 
   * Parameters: tag - {<Legato.Util.Tag>}
   * 
   * Returns: {Boolean} The tag passed in as parameter is equal to this.
   */
  equals : function(tag) {
    return (tag !== null) && (this.name == tag.name && this.value == tag.value);
  },

  CLASS_NAME :"Legato.Util.Tag"
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * (c)2006 Jesse Skinner/Dean Edwards/Matthias Miller/John Resig
 * Special thanks to Dan Webb's domready.js Prototype extension
 * and Simon Willison's addLoadEvent
 *
 * For more info, see:
 * http://www.thefutureoftheweb.com/blog/adddomloadevent
 * http://dean.edwards.name/weblog/2006/06/again/
 * http://www.vivabit.com/bollocks/2006/06/21/a-dom-ready-extension-for-prototype
 * http://simon.incutio.com/archive/2004/05/26/addLoadEvent
 *
 *
 * To use: call addDOMLoadEvent one or more times with functions, ie:
 *
 *    function something() {
 *       // do something
 *    }
 *    addDOMLoadEvent(something);
 *
 *    addDOMLoadEvent(function() {
 *        // do other stuff
 *    });
 *
 */

/**
 * Class: Legato.Util.DOM.addDOMLoadEvent
 * Gives you the abbility to specifiy a callback function which will been
 * executed when the DOM has loaded.
 */

Legato.Util.DOM = {
  unloadStack: [],
  oldUnLoad: null,
  done: false
};

Legato.Util.DOM.addDOMLoadEvent = (function() {
  // create event function stack
  var load_events = [], load_timer, script, done, exec, old_onload, init = function() {
    done = true;

    // kill the timer
    clearInterval(load_timer);

    // execute each function in the stack in the order they were added
    exec = load_events.shift();
    while(exec){
      exec();
      exec = load_events.shift();
    }

    if (script){
      script.onreadystatechange = '';
    }

    if(!Legato.Util.DOM.done){
      Legato.Util.DOM.done = true;
      Legato.Util.DOM.oldUnLoad = window.onunload;
      window.onunload = OpenLayers.Function.bind(Legato.Util.DOM.unload, Legato.Util.DOM);
    }
  };

  return function(func) {
    // if the init function was already ran, just run this function now and stop
    if (done){
      return func();
    }

    if (!load_events[0]) {
      // for Mozilla/Opera9
      if (document.addEventListener)
      {
        document.addEventListener("DOMContentLoaded", init, false);
      }

      // for Internet Explorer
      /*@cc_on
      @if (@_win32)
         document.write("<script id=__ie_onload defer src=//0><\/scr"+"ipt>");
         script = document.getElementById("__ie_onload");
         script.onreadystatechange = function() {
           if (this.readyState == "complete"){
             init();
           }
         };
      @end
      @*/

      // for Safari
      if (/WebKit/i.test(navigator.userAgent)) { // sniff
        load_timer = setInterval(function() {
          if (/loaded|complete/.test(document.readyState))
          {
            init(); // call the onload handler
          }
        }, 10);
      }

      // for other browsers set the window.onload, but also execute the old
      // window.onload
      old_onload = window.onload;
      window.onload = function() {
        init();
        if (old_onload){
          old_onload();
        }
      };
    }

    load_events.push(func);
  };
})();

Legato.Util.DOM.unload = function(event){
  // execute each function in the stack in the order they were added
  exec = this.unloadStack.shift();
  while(exec){
    exec();
    exec = this.unloadStack.shift();
  }
  if(this.oldUnLoad){
    this.oldUnLoad();
  }
};

Legato.Util.DOM.addDOMUnLoadEvent = function(callback){
  this.unloadStack.push(callback);
};

if (document.addEventListener)
{
  document.addEventListener("DOMWindowClose", Legato.Util.DOM.unload, false);
}
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Revision: 69543 $
 * @requires Legato.js
 * @requires OpenLayers/Control.js
 */

/**
 * Class: Legato.OpenLayers.Map.Util
 *
 */
Legato.Util.GeoLocation = {};

/*
 * Function: isAvailable
 * Determines if current browser supports the geolocation api.
 *
 * Returns:
 * {boolean} true if available, false otherwise
 */
Legato.Util.GeoLocation.isAvailable = function(){
  if(!Legato.Lang.ObjectUtils.isNullOrUndefined(navigator) &&
     !Legato.Lang.ObjectUtils.isNullOrUndefined(navigator.geolocation)){
    return true;
  }
  return false;
};

Legato.Util.GeoLocation.getCurrentPosition = function(callback, errorCallback){
  if(Legato.Util.GeoLocation.isAvailable()){
    navigator.geolocation.getCurrentPosition(callback, errorCallback);
  }
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Util.Logger
 */
Legato.Util.Logger = {

  /*
   * Property: target
   *
   * Target bean.
   */
  instance: null,

  getLogger: function(){
    /*
     * Beware:
     * Do not use Legato.Lang.ObjectUtils.isObject cause if we're handling
     * with the HTMLUnit Logger instance calling isObject would cause
     * an exception cause the HTMLUnit logger instance does not support
     * the typeof method.
     */
    if(Legato.Util.Logger.instance === null){
      Legato.Util.Logger.instance = Legato.Util.Logger.createLogger();
    }

    return Legato.Util.Logger.instance;
  },

  createLogger : function() {
    var l = null;

    /*
     * This implementation differ from the other mechanism because of HTMLUnit.
     * The defined logger instance does not support the typeof function which is used
     * by Legato.Lang.ObjectUtils.isObject. Therefore we assume that if an global
     * logger instance exists that this one is an object.
     */
    if(window.logger &&
       Legato.Lang.ObjectUtils.isFunction(window.logger.trace) &&
       Legato.Lang.ObjectUtils.isFunction(window.logger.debug) &&
       Legato.Lang.ObjectUtils.isFunction(window.logger.info) &&
       Legato.Lang.ObjectUtils.isFunction(window.logger.warn) &&
       Legato.Lang.ObjectUtils.isFunction(window.logger.error) &&
       Legato.Lang.ObjectUtils.isFunction(window.logger.fatal)){
      l = window.logger;
      return l;
    }

    //log4javascript Logger
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(window.log4javascript) &&
       Legato.Lang.ObjectUtils.isObject(window.log4javascript)){
      l = window.log4javascript.getLogger();

      // Create a PopUpAppender with default options
      var popUpAppender = new log4javascript.PopUpAppender();

      // Change the desired configuration options
      popUpAppender.setFocusPopUp(true);
      popUpAppender.setNewestMessageAtTop(true);

      // Add the appender to the logger
      l.addAppender(popUpAppender);
      return l;
    }

    //Console Logger
    if(Legato.Lang.ObjectUtils.isObject(window.console) &&
       Legato.Lang.ObjectUtils.isFunction(window.console.trace) &&
       Legato.Lang.ObjectUtils.isFunction(window.console.debug) &&
       Legato.Lang.ObjectUtils.isFunction(window.console.info) &&
       Legato.Lang.ObjectUtils.isFunction(window.console.warn) &&
       Legato.Lang.ObjectUtils.isFunction(window.console.error)){

      l = window.console;

      if(!Legato.Lang.ObjectUtils.isFunction(window.console.fatal)){
        //Fatal is not supported by console
        l.fatal = l.error;
      }

      return l;
    }

    //Nothing is defined so use alert if fatal errors may occur
    l = {};
    l.trace = function(msg){};
    l.debug = function(msg){};
    l.info  = function(msg){};
    l.warn  = function(msg){};
    l.error = function(msg){};
    l.fatal = function(msg){
      alert(msg);
    };

    return l;
  }
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Namespace: Legato.Util.Browser
 *
 * Implements browser utilities.
 */
Legato.Util.Browser = {
  /*
   * Function: isTouchCapable
   *
   * Checks if 'ontouchstart' and 'ontouchend' events are available in browser
   *
   */
  isTouchCapable : function() {
    return 'ontouchstart' in document && 'ontouchend' in document;
  }
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Graph.DirectedGraph
 * 
 * Implements a directed graph.
 */
Legato.Graph.DirectedGraph = Legato.Lang.Class( {
  /*
   * Property: vertices
   * 
   * {Object} Name/{<Legato.Graph.Vertex>} map.
   */
  vertices :null,
  /*
   * Constructor: initialize
   * 
   * Constructs a new directed graph.
   */
  initialize : function() {
    this.vertices = {};
  },
  /*
   * Function: getVertex
   * 
   * Returns: {<Legato.Graph.Vertex>} Existing vertex for the given name or
   * null if no vertex found.
   * 
   * Parameters:
   * 
   * name - {String} name of the vertex.
   */
  getVertex : function(name) {
    Legato.Util.Ensure.ensureString(name);
    var vertex = this.vertices[name];
    if (Legato.Lang.ObjectUtils.exists(vertex)) {
      return vertex;
    } else {
      return null;
    }
  },
  /*
   * Function: getOrCreateVertex
   * 
   * Returns: {<Legato.Graph.Vertex>} Either existing or a new vertex for the
   * given name.
   * 
   * Parameters:
   * 
   * name - {String} name of the vertex.
   */
  getOrCreateVertex : function(name) {
    Legato.Util.Ensure.ensureString(name);
    var vertex = this.vertices[name];
    if (!vertex) {
      vertex = new Legato.Graph.Vertex(name);
      this.vertices[name] = vertex;
    }
    return vertex;
  },
  /*
   * Function: addEdge
   * 
   * Creates an edge between two vertices.
   * 
   * Parameters:
   * 
   * parentName - {String} name of the parent vertex. Parameters:
   * 
   * childName - {String} name of the child vertex.
   */
  addEdge : function(parentName, childName) {
    Legato.Util.Ensure.ensureString(parentName);
    Legato.Util.Ensure.ensureString(childName);
    var parentVertex = this.getOrCreateVertex(parentName);
    var childVertex = this.getOrCreateVertex(childName);
    parentVertex.outgoing.add(childName);
    childVertex.incoming.add(parentName);
  },
  /*
   * Function: removeEdge
   * 
   * Removes an edge between two vertices.
   * 
   * Parameters:
   * 
   * parentName - {String} name of the parent vertex. Parameters:
   * 
   * childName - {String} name of the child vertex.
   */
  removeEdge : function(parentName, childName) {
    Legato.Util.Ensure.ensureString(parentName);
    Legato.Util.Ensure.ensureString(childName);
    var parentVertex = this.getVertex(parentName);
    if (parentVertex) {
      parentVertex.outgoing.remove(childName);
    }
    var childVertex = this.getVertex(childName);
    if (childVertex) {
      childVertex.incoming.remove(parentName);
    }
  },
  /*
   * Function: clone
   * 
   * Clones the graph.
   * 
   * Returns: {<Legato.Graph.DirectedGraph>} A clone of this graph.
   */
  clone : function() {
    var graph = new Legato.Graph.DirectedGraph();
    for ( var name in this.vertices) {
      if (this.vertices.hasOwnProperty(name)) {
        graph.vertices[name] = this.vertices[name].clone();
      }
    }
    return graph;
  },
  /*
   * Function: toArray
   * 
   * Performs the topological sorting of the given graph and returns the array
   * of vertex names in the sorted order.
   * 
   * Returns:
   * 
   * {Array(String)} Topologically sorted array of vertex names.
   */
  toArray : function() {
    var graph = this.clone();
    var array = [];
    var roots = [];
    for ( var vertexName in graph.vertices) {
      if (graph.vertices.hasOwnProperty(vertexName)) {
        var vertex = graph.vertices[vertexName];
        if (!vertex.hasIncomingEdges()) {
          roots.push(vertexName);
        }
      }
    }
    while (roots.length > 0) {
      var rootName = roots.shift();
      var rootVertex = graph.getVertex(rootName);
      array.push(rootName);
      var outgoingNames = rootVertex.outgoing.toArray();
      for (var index = 0; index < outgoingNames.length; index++) {
        var outgoingName = outgoingNames[index];
        var outgoingVertex = graph.getVertex(outgoingName);
        graph.removeEdge(rootName, outgoingName);
        if (!outgoingVertex.hasIncomingEdges()) {
          roots.push(outgoingName);
        }
      }
    }
    return array;
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Graph.Vertex
 * 
 * Implements a vertex of the directed graph.
 */
Legato.Graph.Vertex = Legato.Lang.Class( {
  /*
   * Property: name
   * 
   * {String} Name of the vertex.
   */
  name :null,
  /*
   * Property: incoming
   *
   * {<Legato.Util.HashSet>} Set of incoming edges.
   */
  incoming :null,
  /*
   * Property: outgoing
   * 
   * {<Legato.Util.HashSet>} Set of outgoing edges.
   */
  outgoing :null,
  /*
   * Constructor: initialize
   * 
   * Constructs the vertex.
   * 
   * Parameters:
   * 
   * name - {String} name of the vertex.
   */
  initialize : function(name) {
    Legato.Util.Ensure.ensureString(name);
    this.name = name;
    this.incoming = new Legato.Util.HashSet();
    this.outgoing = new Legato.Util.HashSet();
  },
  /*
   * Function: hasIncomingEdges
   * 
   * Returns:
   * 
   * {Boolean} true if vertex has incoming edges, false if not.
   */
  hasIncomingEdges : function() {
    return !this.incoming.isEmpty();
  },
  /*
   * Creates a clone of this vertex.
   * 
   * Returns:
   * 
   * {<Legato.Graph.Vertex>} Clone of this vertex.
   */
  clone : function() {
    var vertex = new Legato.Graph.Vertex(this.name);
    vertex.incoming.addAll(this.incoming);
    vertex.outgoing.addAll(this.outgoing);
    return vertex;
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.XML.QName = Legato.Lang
    .Class( {
      namespaceURI :null,
      localPart :null,
      prefix :null,
      initialize : function(one, two, three) {
        var namespaceURI;
        var localPart;
        var prefix;

        if (typeof two == 'undefined') {
          namespaceURI = "";
          localPart = one;
          prefix = "";
        } else if (typeof three == 'undefined') {
          namespaceURI = one;
          localPart = two;
          prefix = "";
        } else {
          namespaceURI = one;
          localPart = two;
          prefix = three;
        }
        this.namespaceURI = namespaceURI;
        this.localPart = localPart;
        this.prefix = prefix;
      },
      toString : function() {
        var result = '';
        if (this.namespaceURI != '') {
          result = result + '{' + this.namespaceURI + '}';
        }
        if (this.prefix != '') {
          result = result + this.prefix + ':';
        }
        result = result + this.localPart;
        return result;
      },
      clone : function() {
        return new Legato.XML.QName(this.namespaceURI, this.localPart,
            this.prefix);
      },
      equals : function(that) {
        if (!that) {
          return false;
        } else {
          return (this.namespaceURI == that.namespaceURI)
              && (this.localPart == that.localPart);
        }

      },
      CLASS_NAME :"Legato.XML.QName"
    });
Legato.XML.QName.valueOf = function(qNameAsString) {
  var leftBracket = qNameAsString.indexOf('{');
  var rightBracket = qNameAsString.lastIndexOf('}');
  var namespaceURI;
  var prefixedName;
  if ((leftBracket === 0) && (rightBracket > 0)
      && (rightBracket < qNameAsString.length)) {
    namespaceURI = qNameAsString.substring(1, rightBracket);
    prefixedName = qNameAsString.substring(rightBracket + 1);
  } else {
    namespaceURI = '';
    prefixedName = qNameAsString;
  }
  var colonPosition = prefixedName.indexOf(':');
  var prefix;
  var localPart;
  if (colonPosition > 0 && colonPosition < prefixedName.length) {
    prefix = prefixedName.substring(0, colonPosition);
    localPart = prefixedName.substring(colonPosition + 1);
  } else {
    prefix = '';
    localPart = prefixedName;
  }
  return new Legato.XML.QName(namespaceURI, localPart, prefix);
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.XML.ElementUtils = {
    
      hide: function(element) {
        element.style.display = 'none';
      },
      
      show: function(element) {
        element.style.display = '';
      },
    
	    /**
	     * APIMethod: getAttributeNodeNS
	     * Get an attribute node given the namespace URI and local name.
	     * 
	     * Parameters:
	     * node - {Element} Node on which to search for attribute nodes.
	     * uri - {String} Namespace URI.
	     * name - {String} Local name of the attribute (without the prefix).
	     * 
	     * Returns:
	     * {DOMElement} An attribute node or null if none found.
	     */
	    getAttributeNodeNS: function(node, uri, name) {
	        var attributeNode = null;
	        if(node.getAttributeNodeNS) {
	            attributeNode = node.getAttributeNodeNS(uri, name);
	        } else {
	            var attributes = node.attributes;
	            var potentialNode, fullName;
	            for(var i=0, len=attributes.length; i<len; ++i) {
	                potentialNode = attributes[i];
	                if(potentialNode.namespaceURI == uri) {
	                    fullName = (potentialNode.prefix) ?
	                               (potentialNode.prefix + ":" + name) : name;
	                    if(fullName == potentialNode.nodeName) {
	                        attributeNode = potentialNode;
	                        break;
	                    }
	                }
	            }
	        }
	        return attributeNode;
	    },
		
	    /**
	     * APIMethod: getAttributeNS
	     * Get an attribute value given the namespace URI and local name.
	     * 
	     * Parameters:
	     * node - {Element} Node on which to search for an attribute.
	     * uri - {String} Namespace URI.
	     * name - {String} Local name of the attribute (without the prefix).
	     * 
	     * Returns:
	     * {String} An attribute value or and empty string if none found.
	     */
	    getAttributeNS: function(node, uri, name) {
	        var attributeValue = "";
	        if(node.getAttributeNS) {
	            attributeValue = node.getAttributeNS(uri, name) || "";
	        } else {
	            var attributeNode = this.getAttributeNodeNS(node, uri, name);
	            if(attributeNode) {
	                attributeValue = attributeNode.nodeValue;
	            }
	        }
	        return attributeValue;
	    },
	    
	    /**
	     * APIMethod: hasAttributeNS
	     * Determine whether a node has a particular attribute matching the given
	     *     name and namespace.
	     * 
	     * Parameters:
	     * node - {Element} Node on which to search for an attribute.
	     * uri - {String} Namespace URI.
	     * name - {String} Local name of the attribute (without the prefix).
	     * 
	     * Returns:
	     * {Boolean} The node has an attribute matching the name and namespace.
	     */
	    hasAttributeNS: function(node, uri, name) {
	        var found = false;
	        if(node.hasAttributeNS) {
	            found = node.hasAttributeNS(uri, name);
	        } else {
	            found = !!this.getAttributeNodeNS(node, uri, name);
	        }
	        return found;
	    },
	    
	    /**
	     * APIMethod: setAttributeNS
	     * Adds a new attribute or changes the value of an attribute with the given
	     *     namespace and name.
	     *
	     * Parameters:
	     * node - {Element} Element node on which to set the attribute.
	     * uri - {String} Namespace URI for the attribute.
	     * name - {String} Qualified name (prefix:localname) for the attribute.
	     * value - {String} Attribute value.
	     */
	    setAttributeNS: function(node, uri, name, value) {
	        if(node.setAttributeNS) {
	            node.setAttributeNS(uri, name, value);
	        } else {
	            if(this.xmldom) {
	                if(uri) {
	                    var attribute = node.ownerDocument.createNode(
	                        2, name, uri
	                    );
	                    attribute.nodeValue = value;
	                    node.setAttributeNode(attribute);
	                } else {
	                    node.setAttribute(name, value);
	                }
	            } else {
	                throw "setAttributeNS not implemented";
	            }
	        }
	    }
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Beans = {};
/**
 * Space: lb
 * 
 * URI: Namespace URI
 * http://www.disy.net/legato/beans
 */
Legato.Beans.NAMESPACE_URI = 'http://www.disy.net/legato/beans';
/**
 * Prefix: Default prefix
 * lb
 */
Legato.Beans.PREFIX = 'lb';
Legato.Beans.QName = function(localPart) {
	return new Legato.XML.QName(Legato.Beans.NAMESPACE_URI, localPart,
			Legato.Beans.PREFIX);
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Beans.Property
 * 
 * Models a property with type, setter and getter.
 */
Legato.Beans.Property = Legato.Lang.Class( {
  /*
   * Property: type
   * 
   * {<Legato.Lang.AnyType>} Type of the property.
   */
  type :null,
  /*
   * Property: setter
   * 
   * {Function} Setter function for the property.
   */
  setter :null,
  /*
   * Property: getter
   * 
   * {Function} Getter function for the property.
   */
  getter :null,
  /*
   * Constructor: initialize
   * 
   * Constructs a new property.
   * 
   * Parameters:
   * 
   * type - {<Legato.Lang.AnyType>} type of the property.
   * 
   * setter - {Function} setter function.
   *  
   * getter - {Function} getter function. 
   */
  initialize : function(type, setter, getter) {
    Legato.Util.Ensure.ensureObject(type);
    this.type = type;
    if (Legato.Lang.ObjectUtils.exists(setter)) {
      Legato.Util.Ensure.ensureFunction(setter);
      this.setter = setter;
    } else {
      this.setter = null;
    }
    if (Legato.Lang.ObjectUtils.exists(getter)) {
      Legato.Util.Ensure.ensureFunction(getter);
      this.getter = getter;
    } else {
      this.getter = null;
    }
  },
  /*
   * Function: set
   * 
   * Sets value to the given object instance. Throws {<Legato.Lang.Exception>}
   * for read-only property.
   * 
   * Parameters:
   * 
   * instance - instance to set value to.
   * 
   * value - value to be set.
   * 
   */
  set : function(instance, value) {
    Legato.Util.Ensure.ensureExists(instance);
    if (Legato.Lang.ObjectUtils.exists(this.setter)) {
      this.setter(instance, value);
    } else {
      throw new Legato.Lang.Exception(
          'Could not set the value, setter function is not provided.');
    }
  },
  /*
   * Function: get
   * 
   * Gets value from the given object instance. Throws {<Legato.Lang.Exception>}
   * for write-only property.
   * 
   * Returns:
   * 
   * Value of the instance property returned by the getter function.
   * 
   * Parameters:
   * 
   * instance - instance to set value to.
   * 
   */
  get : function(instance) {
    Legato.Util.Ensure.ensureExists(instance);
    if (Legato.Lang.ObjectUtils.exists(this.getter)) {
      this.getter(instance);
    } else {
      throw new Legato.Lang.Exception(
          'Could not set the value, setter function is not provided.');
    }
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Beans.BeanDefinition
 * 
 * Models a bean definition consisting of type and content definition.
 */
Legato.Beans.BeanDefinition = Legato.Lang.Class( {
  /*
   * Property: type {<Legato.Lang.AnyType>} Type of the bean.
   */
  type :null,
  /*
   * Property: definition
   * 
   * {Object} Content definition.
   */
  definition :null,
  /*
   * Constructor: initialize
   * 
   * Creates a new bean definition.
   * 
   * Parameters:
   * 
   * type - {<Legato.Lang.AnyType>} type of the bean.
   * 
   * definition - {Object} content definition.
   */
  initialize : function(type, definition) {
    Legato.Util.Ensure.ensureObject(type);
    this.type = type;
    if (Legato.Lang.ObjectUtils.exists(definition)) {
      this.definition = definition;
    } else {
      this.definition = {};
    }
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Beans.ComplexType = Legato.Lang
    .Class(
        Legato.Lang.AnyType,
        {
          typeName :null,
          qName :null,
          _constructor :null,
          factoryFunction :null,
          constructorArguments :null,
          constructorOrder :null,
          options :null,
          fields :null,
          properties :null,
          components :null,
          afterInstancePopulated :null,
          initialize : function(name, qName, definition) {

            if (typeof name != 'string') {
              throw new Error('Name [' + name + '] must be string.');
            }
            if (!(qName instanceof Legato.XML.QName)) {
              throw new Error(
                  'Qualified name [' + qName.toString() + '] must be an instance of [Legato.XML.QName].');
            }
            if (typeof definition != 'object') {
              throw new Error(
                  'Definition [' + definition + '] must be an object.');
            }

            // TODO Check arguments
            this.typeName = name;
            this.qName = qName;
            this._constructor = definition._constructor;
            this.factoryFunction = definition.factoryFunction;
            this.constructorArguments = definition.constructorArguments;
            this.constructorOrder = (definition.constructorOrder) ? definition.constructorOrder
                : [];
            this.options = (definition.options) ? definition.options : null;
            this.fields = definition.fields;
            this.properties = definition.properties;
            this.afterInstancePopulated = definition.afterInstancePopulated;

            // Register all the components
            this.components = {};
            for ( var constructorArgumentName in this.constructorArguments) {
              if (this.constructorArguments
                  .hasOwnProperty(constructorArgumentName)) {
                this.components[constructorArgumentName] = this.constructorArguments[constructorArgumentName];
              }
            }
            for ( var optionName in this.options) {
              if (this.options.hasOwnProperty(optionName)) {
                this.components[optionName] = this.options[optionName];
              }
            }
            for ( var fieldName in this.fields) {
              if (this.fields.hasOwnProperty(fieldName)) {
                this.components[fieldName] = this.fields[fieldName];
              }
            }
            for ( var propertyName in this.properties) {
              if (this.properties.hasOwnProperty(propertyName)) {
                this.components[propertyName] = this.properties[propertyName].type;
              }
            }
            Legato.Beans.ComplexType.registerTypeNS(this,
                this.qName.namespaceURI, this.qName.localPart);
          },
          Extend : function(name, qName, extension) {
            // TODO Check arguments
          var base = this;
          var extended = {};
          // constructor
          if (extension._constructor) {
            extended._constructor = extension._constructor;
          } else if (extension.factoryFunction) {
            extended.factoryFunction = extension.factoryFunction;
          } else if (base._constructor) {
            extended._constructor = base._constructor;
          } else if (base.factoryFunction) {
            extended.factoryFunction = base.factoryFunction;
          }
          // constructorArguments
          if (extension.constructorArguments) {
            extended.constructorArguments = extension.constructorArguments;
          } else {
            extended.constructorArguments = {};
            for ( var constructorArgumentName in base.constructorArguments) {
              if (base.constructorArguments
                  .hasOwnProperty(constructorArgumentName)) {
                extended.constructorArguments[constructorArgumentName] = base.constructorArguments[constructorArgumentName];
              }
            }
          }
          // constructorOrder
          if (extension.constructorOrder) {
            extended.constructorOrder = extension.constructorOrder;
          } else {
            extended.constructorOrder = [];
            for ( var index = 0; index < base.constructorOrder.length; index++) {
              extended.constructorOrder[index] = base.constructorOrder[index];
            }
          }

          // afterInstancePopulated
          if (extension.afterInstancePopulated) {
            extended.afterInstancePopulated = extension.afterInstancePopulated;
          } else if (base.afterInstancePopulated) {
            extended.afterInstancePopulated = base.afterInstancePopulated;
          } else {
            extended.afterInstancePopulated = null;
          }

          var copy = function(source, target) {
            for ( var name in source) {
              if (source.hasOwnProperty(name))
              {
                target[name] = source[name];
              }
            }
          };

          var merge = function(base, extension, extended) {
            if (base) {
              copy(base, extended);
            }
            if (extension) {
              copy(extension, extended);
            }
          };
          // options
          if (base.options || extension.options) {
            extended.options = {};
            merge(base.options, extension.options, extended.options);
          } else {
            extended.options = null;
          }

          // fields
          extended.fields = {};
          merge(base.fields, extension.fields, extended.fields);
          // properties
          extended.properties = {};
          merge(base.properties, extension.properties, extended.properties);
          return new Legato.Beans.ComplexType(name, qName, extended);
        },
        Components : function() {
          return new Legato.Beans.ComplexType.Components(this);
        },
        define : function(definition) {
          return new Legato.Beans.BeanDefinition(this, definition);
        }
        });

Legato.Beans.ComplexType.Components = Legato.Lang.Class(
    Legato.Beans.ComplexType, {
      initialize : function(type) {
        var name = type.typeName + '.Components';
        var qName = new Legato.XML.QName(type.qName.namespaceURI,
            type.qName.localPart + '-Components', type.qName.prefix);

        var definition = {
          _constructor :Object,
          constructorArguments : {},
          constructorOrder : [],
          fields : {},
          properties : {}
        };
        for ( var componentName in type.components) {
          if (type.components.hasOwnProperty(componentName)) {
            definition.fields[componentName] = type.components[componentName];
          }
        }
        Legato.Beans.ComplexType.prototype.initialize.apply(this, [ name,
            qName, definition ]);
      }
    });

Legato.Beans.ComplexType.types = {};
Legato.Beans.ComplexType.registerTypeNS = function(type, namespaceURI,
    localPart) {
  var qNameAsString = (namespaceURI == '' ? '' : '{' + namespaceURI + '}')
      + localPart;
  Legato.Beans.ComplexType.types[qNameAsString] = type;
};
Legato.Beans.ComplexType.getTypeNS = function(namespaceURI, localPart) {
  var qNameAsString = (namespaceURI == '' ? '' : '{' + namespaceURI + '}')
      + localPart;
  return Legato.Beans.ComplexType.types[qNameAsString];
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Beans.Object = new Legato.Beans.ComplexType('Legato.Lang.Object',
    //
    Legato.Beans.QName('Object'),
    //
    {
      _constructor :Object,
      constructorArguments : {},
      constructorOrder : [],
      fields : {},
      properties : {}
    });

Legato.Beans['Object[]'] = Legato.Beans.Object.List();
Legato.Beans['Object{}'] = Legato.Beans.Object.Map();
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Beans.BeanFactory
 */
Legato.Beans.BeanFactory = Legato.Lang.Class({
  beanDefinitions : null,
  beanNames : null,
  converters : {},
  instances : null,
  unloadDestroy : null,
  /*
   * Constructor: initialize
   *
   * Creates a bean factory with given bean definitions.
   *
   * Parameters:
   *
   * beanDefinitions - {Object} bean definitions.
   */
  initialize : function(beanDefinitions, onSuccess, onFailure) {
    this.instances = this.createDefaultInstances();
    if (Legato.Lang.ObjectUtils.exists(onSuccess)) {
      Legato.Util.Ensure.ensureFunction(onSuccess);
    }
    if (Legato.Lang.ObjectUtils.exists(beanDefinitions)) {
      this.loadBeanDefinitions(beanDefinitions);
    }
    this.unloadDestroy = OpenLayers.Function.bind(this.destroy, this);
    // // always call beanFactory.destroy()
    OpenLayers.Event.observe(window, 'unload', this.unloadDestroy);
  },
  createDefaultInstances : function() {
    var instances = {};
    return instances;
  },
  loadBeanDefinitions : function(beanDefinitions, onSuccess, onFailure) {
    Legato.Util.Ensure.ensureObject(beanDefinitions);
    var osu;
    if (Legato.Lang.ObjectUtils.exists(onSuccess)) {
      Legato.Util.Ensure.ensureFunction(onSuccess);
      osu = onSuccess;
    } else {
      osu = function() {
      };
    }
    var ofa;
    if (Legato.Lang.ObjectUtils.exists(onFailure)) {
      Legato.Util.Ensure.ensureFunction(onFailure);
      ofa = onFailure;
    } else {
      ofa = function() {
      };
    }
    this.setBeanDefinitions(beanDefinitions);
    var beanNames = this.beanNames;
    var beanDefinitionsCopy = this.beanDefinitions;
    var that = this;
    this.createInstances(beanNames, beanDefinitionsCopy,
    // onSuccess
    function(instances) {
      that.populateInstances();
      that.afterInstancesPopulated();
      osu(that);
    },
    // onFailure
    function(e) {
      Legato.Util.Logger.getLogger().fatal('Error creating bean instances.');
      if (!ofa(e)) {
        throw e;
      }
    });
  },
  retrieveBean : function(beanDefinition) {
    var instance = this.createInstance(beanDefinition);
    this.populateInstance(beanDefinition, instance);
    this.afterInstancePopulated(beanDefinition, instance);
    return instance;
  },
  retrieveBeans : function(beanDefinitions) {
    Legato.Util.Ensure.ensureObject(beanDefinitions);
    var result = {};
    for ( var name in beanDefinitions) {
      if (beanDefinitions.hasOwnProperty(name)) {
        result[name] = this.retrieveBean(beanDefinitions[name]);
      }
    }
    return result;
  },
  setBeanDefinitions : function(beanDefinitions) {
    this.beanDefinitions = this.explodeBeanDefinitions(beanDefinitions);
    this.beanNames = this.getBeanNames(this.beanDefinitions);
  },
  explodeBeanDefinitions : function(beans) {
    var beanDefinitions = {};
    for ( var name in beans) {
      if (beans.hasOwnProperty(name)) {
        this.explodeBeanDefinition(beanDefinitions, name, beans[name]);
      }
    }
    return beanDefinitions;
  },
  explodeBeanDefinition : function(beanDefinitions, path, beanDefinition) {
    beanDefinitions[path] = beanDefinition;

    var type = beanDefinition.type;
    var definition = beanDefinition.definition;

    for ( var name in definition) {
      if (definition.hasOwnProperty(name)) {
        var value = definition[name];
        if (this.isBeanDefinition(value)) {
          var newPath = path + '.' + name;
          beanDefinitions[newPath] = value;
          definition[name] = new Legato.Beans.Reference(newPath);
          this.explodeBeanDefinition(beanDefinitions, newPath, value);
        } else if (Legato.Lang.ObjectUtils.isArray(value)) {
          for ( var index = 0; index < value.length; index++) {
            var item = value[index];
            if (this.isBeanDefinition(item)) {
              var newItemPath = path + '.' + name + '[' + index + ']';
              beanDefinitions[newItemPath] = item;
              value[index] = new Legato.Beans.Reference(newItemPath);
              this.explodeBeanDefinition(beanDefinitions, newItemPath, item);
            }
          }
        } else if (Legato.Lang.ObjectUtils.isObject(value)) {
          for ( var propertyName in value) {
            if (value.hasOwnProperty(propertyName)) {
              var propertyValue = value[propertyName];
              if (this.isBeanDefinition(propertyValue)) {
                var newPropertyValuePath = path + '.' + name + '[\'' + propertyName + '\']';
                beanDefinitions[newPropertyValuePath] = propertyValue;
                value[propertyName] = new Legato.Beans.Reference(newPropertyValuePath);
                this.explodeBeanDefinition(beanDefinitions, newPropertyValuePath, propertyValue);
              }
            }
          }
        }
      }
    }
  },
  getBeanNames : function(beanDefinitions) {
    var graph = new Legato.Graph.DirectedGraph();

    var addDependencies = function(graph, name, value) {
      if (value instanceof Legato.Beans.Reference) {
        graph.addEdge(value.target, name);
      } else if (Legato.Lang.ObjectUtils.isArray(value)) {
        for ( var index = 0; index < value.length; index++) {
          addDependencies(graph, name, value[index]);
        }
      } else if (Legato.Lang.ObjectUtils.isObject(value)) {
        for ( var propertyName in value) {
          if (value.hasOwnProperty(propertyName)) {
            addDependencies(graph, name, value[propertyName]);
          }
        }
      }
    };

    for ( var name in beanDefinitions) {
      if (beanDefinitions.hasOwnProperty(name)) {
        var vertex = graph.getOrCreateVertex(name);
        var beanDefinition = beanDefinitions[name];
        var type = beanDefinition.type;
        var definition = beanDefinition.definition;

        var constructorOrder = Legato.Lang.ObjectUtils.exists(type.constructorOrder) ? type.constructorOrder : [];

        for ( var index = 0; index < constructorOrder.length; index++) {
          addDependencies(graph, name, definition[constructorOrder[index]]);
        }

        var options = Legato.Lang.ObjectUtils.exists(type.options) ? type.options : {};

        for ( var optionName in options) {
          if (options.hasOwnProperty(optionName)) {
            addDependencies(graph, name, definition[optionName]);
          }
        }
      }
    }
    return graph.toArray();
  },
  createInstances : function(beanNames, beanDefinitions, onSuccess, onFailure) {
    Legato.Util.Ensure.ensureFunction(onSuccess);
    Legato.Util.Ensure.ensureFunction(onFailure);
    // Create instances
    for ( var index = 0; index < this.beanNames.length; index++) {
      var name = beanNames[index];
      var bean = beanDefinitions[name];
      this.putBean(name, this.createInstance(bean));
    }
    onSuccess(this.instances);
  },
  createInstance : function(bean) {
    var type = bean.type;
    var definition = bean.definition;
    var constructorArguments = type.constructorArguments;
    var constructorOrder = type.constructorOrder;
    var constructorArgumentInstances = [];
    for ( var index = 0; index < constructorOrder.length; index++) {
      var constructorArgumentName = constructorOrder[index];
      var constructorArgumentType = constructorArguments[constructorArgumentName];
      var constructorArgumentInstance = this.convert(constructorArgumentType, definition[constructorArgumentName]);
      constructorArgumentInstances[index] = constructorArgumentInstance;
    }
    if (type.options) {
      var optionsInstance = null;
      for ( var optionName in type.options) {
        if (Legato.Lang.ObjectUtils.exists(definition[optionName])) {
          var optionType = type.options[optionName];
          var optionInstance = this.convert(optionType, definition[optionName]);
          if (optionsInstance === null) {
            optionsInstance = {};
          }
          optionsInstance[optionName] = optionInstance;
        }
      }
      if (optionsInstance !== null) {
        constructorArgumentInstances.push(optionsInstance);
      }
    }
    var instance;
    if (type._constructor) {
      // Note: The _constructor approach doesn't work for all cases as more and more OpenLayers classes
      // check for object equality with "instanceof" -- which fails for the _constructor approach as the
      // objects aren't created using the new() operator. We should consider improving this in the future.
      // Workaround: Use a factoryFunction that creates the object using the new() operator.
      instance = {};
      /*jslint forin:true*/
      for ( var n in type._constructor.prototype) {
        instance[n] = type._constructor.prototype[n];
      }
      type._constructor.apply(instance, constructorArgumentInstances);
    } else if (type.factoryFunction) {
      instance = type.factoryFunction.apply(null, constructorArgumentInstances);
    } else {
      throw new Error('Could not create an instance of type [' + type + '].');
    }
    if (Legato.Lang.ObjectUtils.isFunction(instance.setBeanFactory)) {
      instance.setBeanFactory(this);
    }
    return instance;
  },
  populateInstances : function() {
    var names = this.beanNames;
    // Set fields
    for ( var index = 0; index < names.length; index++) {
      var name = names[index];
      var bean = this.beanDefinitions[name];
      var instance = this.instances[name];
      this.populateInstance(bean, instance);
    }
  },
  populateInstance : function(bean, instance) {
    this.setFields(bean, instance);
    this.setProperties(bean, instance);
  },
  setFields : function(bean, instance) {
    var type = bean.type;
    var fields = type.fields;
    for ( var fieldName in fields) {
      if (fields.hasOwnProperty(fieldName)) {
        var fieldType = fields[fieldName];
        var fieldValue = bean.definition[fieldName];
        if (fieldValue) {
          var fieldInstance = this.convert(fieldType, fieldValue);
          instance[fieldName] = fieldInstance;
        }
      }
    }
  },
  setProperties : function(bean, instance) {
    var type = bean.type;
    var properties = type.properties;
    for ( var propertyName in properties) {
      if (properties.hasOwnProperty(propertyName)) {
        var property = properties[propertyName];
        var propertyType = property.type;
        var propertyValue = bean.definition[propertyName];
        if (propertyValue) {
          var propertyInstance = this.convert(propertyType, propertyValue);
          property.set(instance, propertyInstance);
        }
      }
    }
  },
  afterInstancesPopulated : function() {
    var names = this.beanNames;
    // Call afterInstancePopulated function
    for ( var index = 0; index < names.length; index++) {
      var name = names[index];
      var beanDefinition = this.beanDefinitions[name];
      var instance = this.instances[name];
      this.afterInstancePopulated(beanDefinition, instance);
    }
  },
  afterInstancePopulated : function(beanDefinition, instance) {
    var type = beanDefinition.type;
    if (type.afterInstancePopulated) {
      type.afterInstancePopulated(instance, this);
    }
    if (instance.afterInstancePopulated) {
      instance.afterInstancePopulated(this);
    }
  },
  convert : function(type, value) {
    if ((typeof value) == 'undefined') {
      return undefined;
    } else if (value === null) {
      return null;
    } else if (this.isBeanDefinition(value)) {
      return this.retrieveBean(value);

    } else if ((typeof value) == 'function') {
      return value(this);
    } else if (value instanceof Legato.Beans.Reference) {
      return this.getBean(value.target);
    } else if (((typeof value) == 'object') && Legato.Lang.ObjectUtils.isFunction(value.getInstance)) {
      return value.getInstance(this);
    } else if ((typeof value) == 'string') {
      if (type.isInstance(value)) {
        // No conversion required
        return value;
      } else if (this.converters[type.typeName]) {
        var converter = this.converters[type.typeName];
        return converter.convert(value);
      } else if (type.fromString) {
        return type.fromString(value, this);
      } else {
        return value;
        // throw new Error(
        // 'Could not convert the string value ['
        // + value
        // + '] to the type ['
        // + type.typeName
        // + '].'
        // + 'The type does not support string conversion and there is no
        // registered converter for this type.');
      }
    } else if (((typeof value) == 'object') && (type.isList || type.isMap)) {
      var elementType = type.elementType;
      if (type.isList) {
        var listResult = [];

        if (Legato.Lang.ObjectUtils.isArray(value)) {
          for ( var arrayToArrayIndex = 0; arrayToArrayIndex < value.length; arrayToArrayIndex++) {
            listResult[arrayToArrayIndex] = this.convert(elementType, value[arrayToArrayIndex]);
          }
        } else {
          var objectToArrayIndex = 0;
          for ( var objectToArrayPropertyName in value) {
            if (value.hasOwnProperty(objectToArrayPropertyName)) {
              listResult[objectToArrayIndex] = this.convert(elementType, value[objectToArrayPropertyName]);
              objectToArrayIndex++;
            }
          }
        }

        return listResult;
      } else {
        var objectResult = {};

        if (Legato.Lang.ObjectUtils.isArray(value)) {
          for ( var arrayToObjectIndex = 0; arrayToObjectIndex < value.length; arrayToObjectIndex++) {
            objectResult[arrayToObjectIndex] = this.convert(elementType, value[arrayToObjectIndex]);
          }
        } else {
          for ( var objectToObjectPropertyName in value) {
            if (value.hasOwnProperty(objectToObjectPropertyName)) {
              objectResult[objectToObjectPropertyName] = this.convert(elementType, value[objectToObjectPropertyName]);
            }
          }
        }
        return objectResult;
      }
    } else if (type.isInstance && type.isInstance(value)) {
      // No conversion required
      return value;
    } else {
      throw new Error('Conversion of [' + value + '] to [' + type.typeName + '] is not implemented.');
    }
  },
  /*
   * Function: getBean
   *
   * Retrieves bean instance for the given name.
   *
   * Parameters:
   *
   * name - {String} name of the bean.
   */
  getBean : function(name) {
    Legato.Util.Ensure.ensureNotEmptyString(name);

    if (name.charAt(0) == '&') {
      var realName = name.substring(1);
      var factoryBean = this.instances[realName];
      if (Legato.Lang.ObjectUtils.exists(factoryBean)) {
        return factoryBean;
      } else {
        throw new Legato.Lang.Exception('Bean [' + realName + '] could not be found.');
      }
    } else {
      var bean = this.instances[name];
      if (!Legato.Lang.ObjectUtils.exists(bean)) {
        throw new Legato.Lang.Exception('Bean [' + name + '] could not be found.');
      } else if (Legato.Lang.ObjectUtils.isFunction(bean.getInstance)) {
        return bean.getInstance(this);
      } else {
        return bean;
      }
    }
  },
  /*
   * Function: putBean
   *
   * Puts bean instance to the bean factory.
   *
   * Parameters:
   *
   * name - {String} name of the bean. instance - bean to be added to the bean
   * factory.
   */
  putBean : function(name, instance) {
    Legato.Util.Ensure.ensureString(name);
    Legato.Util.Ensure.ensureExists(instance);
    this.instances[name] = instance;
  },
  destroy : function() {
    // if unloadDestroy is null, we've already been destroyed
    if (!this.unloadDestroy) {
      return false;
    }

    // map has been destroyed. dont do it again!
    OpenLayers.Event.stopObserving(window, 'unload', this.unloadDestroy);
    this.unloadDestroy = null;

    for ( var instanceName in this.instances) {
      if (this.instances.hasOwnProperty(instanceName)) {
        var instance = this.instances[instanceName];
        // if (Legato.Lang.ObjectUtils.isFunction(instance.destroy)) {
        // instance.destroy();
        // }
        instance = null;
      }
    }
    this.instances = null;
    for ( var beanDefinitionName in this.beanDefinitions) {
      if (this.beanDefinitions.hasOwnProperty(beanDefinitionName)) {
        var beanDefinition = this.beanDefinitions[beanDefinitionName];
        if (Legato.Lang.ObjectUtils.isFunction(beanDefinition.destroy)) {
          beanDefinition.destroy();
        }
        beanDefinition = null;
      }
    }
    this.beanDefinitions = null;
    this.beanNames = null;
  },
  isBeanDefinition: function(value)
  {
    return Legato.Lang.ObjectUtils.isObject(value) && Legato.Lang.ObjectUtils.exists(value.type) && Legato.Lang.ObjectUtils.isObject(value.definition);
  },
  CLASS_NAME : 'Legato.Beans.XMLBeanFactory'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Class: Legato.Beans.XMLBeanFactory
 */
Legato.Beans.XMLBeanFactory = Legato.Lang
    .Class(
        Legato.Beans.BeanFactory,
        {
          options :null,
          /*
           * Constructor: initialize
           */
          initialize : function() {
            Legato.Beans.BeanFactory.prototype.initialize
                .apply(this, arguments);
            this.options = {};
          },
          loadURL : function(options) {
            Legato.Util.Ensure.ensureObject(options,
                'Options argument must be an object.');
            Legato.Util.Ensure.ensureString(options.url,
                'Options must contain [url] string element.');
            Legato.Util.Ensure.ensureFunction(options.onSuccess,
                'Options must contain [onSuccess] function element.');
            if (Legato.Lang.ObjectUtils.exists(options.onFailure)) {
              Legato.Util.Ensure.ensureFunction(options.onFailure,
                  'Options element [onFailure] must be a function.');
            }
            // if(typeof options.onSuccess != 'function'){
            // throw new Error('An onSuccess methods needs to be defined');
            // }
            Legato.Util.extend(this.options, options);
            
            var onSuccess = function(request) {
              try{
                var responseText = request.responseText;
                var format = new OpenLayers.Format.XML();
                var doc = format.read(responseText);
                var root = doc.documentElement;
                var beanDefinitions = this.parse(root);
                var that = this;
                var os = function()
                {
                  that.options.onSuccess(request);
                };
                this.loadBeanDefinitions(beanDefinitions, os);
              } catch(e){
                Legato.Util.Logger.getLogger().fatal('Could not parse the resource [' + this.options.url + '].');
                Legato.Util.Logger.getLogger().fatal(e);
                throw e;
              }
            };
            var onFailure = function(request) {
              if (typeof this.options.onFailure == 'function') {
                this.options.onFailure(request);
                return;
              }
              Legato.Util.Logger.getLogger().fatal('Could not load the resource [' + this.options.url + '].');
              throw new Legato.Lang.Exception(
                  'Could not load the resource [' + this.options.url + '].');
            };
            var url;
            var params;
            var questionMarkIndex = this.options.url.indexOf('?');
            if (questionMarkIndex > 0) {
              url = this.options.url.substring(0, questionMarkIndex);
              params = OpenLayers.Util.getParameters(this.options.url);
            } else {
              url = this.options.url;
              params = null;
            }

            var that = this;
            OpenLayers.Request.GET({
              url: url,
              params: params,
              scope: that,
              success: onSuccess,
              failure: onFailure
            });
          },
          retrieveBeansFromElement : function(element) {
            var beanDefinitions = this.parse(element);
            return this.retrieveBeans(beanDefinitions);
          },
          retrieveBeanFromElement : function(element, type) {
            var beanDefinition = this.parseBeanDefinition(element, type);
            return this.retrieveBean(beanDefinition);
          },
          parse : function(root) {
            var children = root.childNodes;
            var beans = {};
            for ( var index = 0; index < children.length; index++) {
              var childNode = children[index];
              if (childNode.nodeType == 1) {
                var element = childNode;
                var namespaceURI = element.namespaceURI;
                var localPart = element.localName
                    || element.nodeName.split(":").pop();
                var draftName = Legato.XML.ElementUtils.getAttributeNS(element,
                    Legato.Beans.NAMESPACE_URI, 'name');
                var beanName = (draftName === null || draftName == '' ? localPart
                    : draftName);
                var beanDefinition = this.parseElement(element);
                beans[beanName] = beanDefinition;
              }
            }
            return beans;
          },
          parseElement : function(element) {
            if (Legato.Lang.StringUtils.isEmpty(element.namespaceURI)) {
              return this.parseSingleComponent(element, Legato.Lang.String);
            } else {
              var type = this.getType(element);
              return this.parseBeanDefinition(element, type);
            }
          },
          parseBeanDefinition : function(element, type) {
            var definition = {};
            for ( var name in type.components) {
              if (type.components.hasOwnProperty(name)) {
                var attributeValue = element.getAttribute(name);
                if (!(attributeValue === null || attributeValue == '')) {
                  definition[name] = attributeValue;
                }
              }
            }
            var children = element.childNodes;
            for ( var index = 0; index < children.length; index++) {
              var childNode = children[index];
              if (childNode.nodeType == 1) {
                var localPart = childNode.localName
                    || childNode.nodeName.split(":").pop();
                if (type.components[localPart]) {
                  var componentName = localPart;
                  var componentType = type.components[componentName];
                  definition[componentName] = this.parseComponent(childNode,
                      componentType);
                }
              }
            }
            var beanDefinition = type.define(definition);
            return beanDefinition;
          },
          parseComponent : function(element, componentType) {
            if (componentType.isList) {
              return this.parseListComponent(element, componentType);
            } else if (componentType.isMap) {
              return this.parseMapComponent(element, componentType);
            } else {
              return this.parseSingleComponent(element, componentType);
            }
          },
          parseListComponent : function(element, componentType) {
            var list = [];
            var children = element.childNodes;
            for ( var index = 0; index < children.length; index++) {
              var childNode = children[index];
              if (childNode.nodeType == 1) {
                var beanDefinition = this.parseElement(childNode);
                list.push(beanDefinition);
              }
            }
            return list;
          },
          parseMapComponent : function(element, componentType) {
            var map = {};
            var attributes = element.attributes;
            for ( var attributeIndex = 0; attributeIndex < attributes.length; attributeIndex++) {
              var attribute = attributes[attributeIndex];
              if (attribute.namespaceURI === null
                  || attribute.namespaceURI == '') {
                var attributeName = attribute.nodeName;
                var attributeValue = attribute.nodeValue;
                map[attributeName] = attributeValue;
              }
            }
            var children = element.childNodes;
            for ( var elementIndex = 0; elementIndex < children.length; elementIndex++) {
              var childNode = children[elementIndex];
              if (childNode.nodeType == 1
                  && (childNode.namespaceURI === null || childNode.namespaceURI == '')) {
                var localPart = childNode.nodeName;
                var draftName = Legato.XML.ElementUtils.getAttributeNS(
                    childNode, Legato.Beans.NAMESPACE_URI, 'name');
                var beanName = (draftName === null || draftName == '' ? localPart
                    : draftName);
                var beanDefinition = this.parseSingleComponent(childNode,
                    componentType.elementType);
                map[beanName] = beanDefinition;
              }
            }
            return map;
          },
          parseSingleComponent : function(element, componentType) {
            var children = element.childNodes;
            for ( var index = 0; index < children.length; index++) {
              var childNode = children[index];
              if (childNode.nodeType == 1) {
                return this.parseElement(childNode);
              } else if (childNode.nodeType == 3
                  && (OpenLayers.String.trim(childNode.nodeValue) != '')) {
                return childNode.nodeValue;
              }
            }
            return null;
          },
          getType : function(element) {
            var namespaceURI = element.namespaceURI;
            var localPart = element.localName
                || element.nodeName.split(":").pop();
            var type = Legato.Beans.ComplexType.getTypeNS(namespaceURI,
                localPart);
            Legato.Util.Ensure.ensureExists(type,
                'Could not load the type for the element [{' + namespaceURI
                    + '}:' + localPart + '].');
            return type;
          },
          CLASS_NAME :'Legato.Beans.XMLBeanFactory'
        });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Beans.Reference
 * 
 * Models a reference to another bean.
 */
Legato.Beans.Reference = Legato.Lang.Class({
	/*
	 * Property: target
	 * 
	 * {String} Name of the target bean.
	 */
	target : null,
	/*
	 * Constructor: initialize
	 * 
	 * Constructs a new bean reference.
	 * 
	 * Parameters:
	 * 
	 * target - {String} name of the target bean.
	 */
	initialize : function(target) {
		Legato.Util.Ensure.ensureString(target);
		this.target = target;
	},
	/*
	 * Function: getInstance
	 * 
	 * Retrieves target bean from the bean factory.
	 * 
	 * Returns:
	 * 
	 * Target bean from the bean factory.
	 * 
	 * Parameters:
	 * 
	 * beanFactory - {<Legato.Beans.BeanFactory>} bean factory.
	 */
	getInstance : function(beanFactory) {
		Legato.Util.Ensure.ensureObject(beanFactory);
		var instance = beanFactory.getBean(this.target);
		return beanFactory.getBean(this.target);
	},
	/*
	 * Function: Field
	 * 
	 * Creates a field reference relative to the target bean.
	 * 
	 * Returns:
	 *  {<Legato.Beans.Reference.Field>} Field reference relative to the target
	 * bean of this field reference.
	 * 
	 * Parameters:
	 * 
	 * field - {String} name of the field.
	 */
	Field : function(field) {
		Legato.Util.Ensure.ensureString(field);
		return new Legato.Beans.Reference.Field(this, field);
	},
	CLASS_NAME : 'Legato.Beans.Reference'
});
/*
 * Class: Legato.Beans.Reference.Field
 */
Legato.Beans.Reference.Field = Legato.Lang.Class({
	/*
	 * Property: reference
	 * 
	 * Reference to the target bean.
	 */
	reference : null,
	/*
	 * Property: field
	 * 
	 * Name of the field of the target bean.
	 */
	field : null,
	/*
	 * Constructor: initialize
	 * 
	 * Creates a new field reference.
	 * 
	 * Parameters:
	 * 
	 * reference - {<Legato.Beans.Reference>} reference to the target bean.
	 * 
	 * field - {String} name of the field.
	 */
	initialize : function(reference, field) {
		Legato.Util.Ensure.ensureImplements(reference, 'getInstance');
		this.reference = reference;
		Legato.Util.Ensure.ensureString(field);
		this.field = field;
	},
	/*
	 * Function: getInstance
	 * 
	 * Returns:
	 * 
	 * Value of the field of the target bean.
	 * 
	 * Parameters:
	 * 
	 * beanFactory - {<Legato.Beans.BeanFactory>} bean factory.
	 */
	getInstance : function(beanFactory) {
		var instance = this.reference.getInstance(beanFactory);
		return instance[this.field];
	}
});

Legato.Beans.Ref = function(target) {
	return new Legato.Beans.Reference(target);
};

$ref = Legato.Beans.Ref;

/**
 * Component: lb:Reference
 * 
 * See also:
 * - <lb> namespace
 * - {<Legato.Beans.Reference>}
 */
Legato.Beans.Reference.Bean = Legato.Beans.Object.Extend(
		'Legato.Beans.Reference',
		//
		Legato.Beans.QName('Reference'),
		//
		{
			_constructor : Legato.Beans.Reference,
			constructorArguments : {
				/**
				 * Element: target
				 * {String} Name of the referenced bean.
				 */
				target : Legato.Lang.String
			},
			constructorOrder : [ 'target' ]
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/**
 * Class: Legato.Beans.Evaluate
 * Evaluates the configured expression an returns the evaluation results.
 */
/*
 * Class: Legato.Beans.Evaluate
 */
Legato.Beans.Evaluate = Legato.Lang.Class({
  /*
   * Property: expression
   * 
   * Expression to evaluate.
   */
  expression : null,
  /*
   * Constructor: initialize
   * 
   * Parameters:
   * 
   * expression - expression to evaluate.
   */
  initialize : function(expression) {
    Legato.Util.Ensure.ensureString(expression);
    this.expression = expression;
  },
  /*
   * Function: getInstance
   * 
   * Returns:
   * 
   * Evaluates the expression and returns the evaluation result;
   * 
   * Parameters:
   * 
   * beanFactory - {<Legato.Beans.BeanFactory>} bean factory.
   */
  getInstance : function(beanFactory) {
    return eval(this.expression);
  }
});

Legato.Beans.Evaluate.Bean = Legato.Beans.Object.Extend('Legato.Beans.Evaluate', Legato.Beans.QName('Evaluate'), {
  _constructor : Legato.Beans.Evaluate,
  constructorArguments : {
    expression : Legato.Lang.String
  },
  constructorOrder : [ 'expression' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Beans.Field
 */
Legato.Beans.Field = Legato.Lang.Class( {
	/*
	 * Property: target
	 * 
	 * Target bean.
	 */
	target :null,
	/*
	 * Property: name
	 * 
	 * Name of the field of the target bean.
	 */
	name :null,
	/*
	 * Constructor: initialize
	 * 
	 * Parameters:
	 * 
	 * target - target bean.
	 * 
	 * field - {String} name of the field.
	 */
	initialize : function(target, name) {
		Legato.Util.Ensure.ensureObject(target);
		this.target = target;
		Legato.Util.Ensure.ensureString(name);
		this.name = name;
	},
	/*
	 * Function: getInstance
	 * 
	 * Returns:
	 * 
	 * Value of the field of the target bean.
	 * 
	 * Parameters:
	 * 
	 * beanFactory - {<Legato.Beans.BeanFactory>} bean factory.
	 */
	getInstance : function(beanFactory) {
		return this.target[this.name];
	}
});

Legato.Beans.Field.Bean = Legato.Beans.Object.Extend(
		'Legato.Beans.Field', Legato.Beans.QName('Field'), {
			_constructor :Legato.Beans.Field,
			constructorArguments : {
				target :Legato.Beans.Object,
				name :Legato.Lang.String
			},
			constructorOrder : [ 'target', 'name' ]
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Predicate = {};
Legato.Predicate.NAMESPACE_URI = 'http://www.disy.net/legato/predicate';
Legato.Predicate.PREFIX = 'lp';
Legato.Predicate.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Predicate.NAMESPACE_URI, localPart, Legato.Predicate.PREFIX);
};
Legato.Predicate.Bean = Legato.Beans.Object.Extend('Legato.Predicate',
//
Legato.Predicate.QName('Bean'),
//
{
  _constructor : Legato.Predicate
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Predicate.And = OpenLayers.Class({
  predicates : null,
  initialize : function(predicates) {
    Legato.Util.Ensure.ensureArray(predicates, 'Predicates must be an array.');
    for ( var index = 0; index < predicates.length; index++) {
      Legato.Util.Ensure.ensureObject(predicates[index], 'Predicate must be an object.');
      Legato.Util.Ensure.ensureFunction(predicates[index].evaluate, 'Predicate must provide an [evaluate] function.');
    }
    this.predicates = predicates;
  },
  destroy : function() {
    this.predicates = null;
  },
  evaluate : function(element) {
    for ( var index = 0; index < this.predicates.length; index++) {
      var predicate = this.predicates[index];
      if (!predicate.evaluate(element)) {
        return false;
      }
    }
    return true;
  },
  CLASS_NAME : 'Legato.Predicate.And'
});

Legato.Predicate.And.Bean = Legato.Predicate.Bean.Extend('Legato.Predicate.And',
//
Legato.Predicate.QName('And'),
//
{
  _constructor : Legato.Predicate.And,
  constructorArguments : {
    predicates : Legato.Beans['Object[]']
  },
  constructorOrder : [ 'predicates' ]

});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Predicate.Contains = OpenLayers.Class({
  value : null,
  initialize : function(value) {
    Legato.Util.Ensure.ensureString(value, 'Value must be a string.');
    this.value = value;
  },
  destroy : function() {
    this.value = null;
  },
  evaluate : function(element) {
    if (Legato.Lang.ObjectUtils.isString(element)) {
      var elements = element.split(' ');
      for ( var index = 0; index < elements.length; index++) {
        if (elements[index] === this.value) {
          return true;
        }
      }
    }
    return false;
  },
  CLASS_NAME : 'Legato.Predicate.Contains'
});

Legato.Predicate.Contains.Bean = Legato.Predicate.Bean.Extend('Legato.Predicate.Contains',
//
Legato.Predicate.QName('Contains'),
//
{
  _constructor : Legato.Predicate.Contains,
  constructorArguments : {
    value : Legato.Lang.String
  },
  constructorOrder : [ 'value' ]

});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Predicate.Equals = OpenLayers.Class({
  value : null,
  initialize : function(value) {
    Legato.Util.Ensure.ensureString(value, 'Value must be a string.');
    this.value = value;
  },
  destroy : function() {
    this.value = null;
  },
  evaluate : function(element) {
    return element === this.value;
  },
  CLASS_NAME : 'Legato.Predicate.Equals'
});

Legato.Predicate.Equals.Bean = Legato.Predicate.Bean.Extend('Legato.Predicate.Equals',
//
Legato.Predicate.QName('Equals'),
//
{
  _constructor : Legato.Predicate.Equals,
  constructorArguments : {
    value : Legato.Lang.String
  },
  constructorOrder : [ 'value' ]

});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Predicate.False = OpenLayers.Class({
  initialize : function() {
  },
  destory : function() {
  },
  evaluate : function(element) {
    return false;
  },
  CLASS_NAME : 'Legato.Predicate.False'
});

Legato.Predicate.False.Bean = Legato.Predicate.Bean.Extend('Legato.Predicate.False',
//
Legato.Predicate.QName('False'),
//
{
  _constructor : Legato.Predicate.False
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Predicate.Or = OpenLayers.Class({
  predicates : null,
  initialize : function(predicates) {
    Legato.Util.Ensure.ensureArray(predicates, 'Predicates must be an array.');
    for ( var index = 0; index < predicates.length; index++) {
      Legato.Util.Ensure.ensureObject(predicates[index], 'Predicate must be an object.');
      Legato.Util.Ensure.ensureFunction(predicates[index].evaluate, 'Predicate must provide an [evaluate] function.');
    }
    this.predicates = predicates;
  },
  destroy : function() {
    this.predicates = null;
  },
  evaluate : function(element) {
    if (this.predicates.length === 0) {
      return true;
    } else {
      for ( var index = 0; index < this.predicates.length; index++) {
        var predicate = this.predicates[index];
        if (predicate.evaluate(element)) {
          return true;
        }
      }
      return false;
    }
  },
  CLASS_NAME : 'Legato.Predicate.Or'
});

Legato.Predicate.Or.Bean = Legato.Predicate.Bean.Extend('Legato.Predicate.Or',
//
Legato.Predicate.QName('Or'),
//
{
  _constructor : Legato.Predicate.Or,
  constructorArguments : {
    predicates : Legato.Beans['Object[]']
  },
  constructorOrder : [ 'predicates' ]

});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Predicate.True = OpenLayers.Class({
  initialize : function() {
  },
  destory : function() {
  },
  evaluate : function(element) {
    return true;
  },
  CLASS_NAME : 'Legato.Predicate.True'
});

Legato.Predicate.True.Bean = Legato.Predicate.Bean.Extend('Legato.Predicate.True',
//
Legato.Predicate.QName('True'),
//
{
  _constructor : Legato.Predicate.True
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Structure: ll:RGBColor
 * XML based config for a <Legato.Lang.RGBColor>.
 *
 * See Also:
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for an RGBColor would be:
 * (start code)
 * <ll:RGBColor r="255" g="255" b="255" />
 * (end)
 */
Legato.Lang.RGBColor.Bean = Legato.Beans.Object.Extend('Legato.Lang.RGBColor',
    //
    Legato.Lang.QName('RGBColor'),
    //
    {
      _constructor : Legato.Lang.RGBColor,
      constructorArguments : {
    },
    constructorOrder : [],
    fields : {

    /*
     * Property: r
     * {Integer} the red value (0-255)
     */
    r : Legato.Lang.Integer,

    /*
     * Property: g
     * {Integer} the green value (0-255)
     */
    g : Legato.Lang.Integer,

    /*
     * Property: b
     * {Integer} the blue value (0-255)
     */
    b : Legato.Lang.Integer
  }
});

/*
 * Structure: ll:Null
 * XML based config for a <Legato.Lang.Null>.
 *
 * A config example would be:
 * (start code)
 * <ll:Null/>
 * (end)
 */
Legato.Lang.Null.Bean = Legato.Beans.Object.Extend('Legato.Lang.Null',
      //
      Legato.Lang.QName('Null'),
      //
      {
        _constructor : Legato.Lang.Null
      }
);
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Structure: lu:Tag
 *
 * XML based config for a <Legato.Util.Tag>.
 *
 * A valid config example for an RGBColor would be:
 * (start code)
 * <lu:Tag name="foo" value="bar"/>
 * <lu:Tag name="foo"/>
 * (end)
 */
Legato.Util.Tag.Bean = Legato.Beans.Object.Extend('Legato.Util.Tag',
//
    Legato.Util.QName('Tag'),
    //
    {
      _constructor :Legato.Util.Tag,
      constructorArguments : {
        name :Legato.Lang.String,
        value :Legato.Lang.String
      },
      constructorOrder : [ 'name', 'value' ]
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Text = {};
Legato.Text.NAMESPACE_URI = 'http://www.disy.net/legato/text';
Legato.Text.PREFIX = 'lt';
Legato.Text.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Text.NAMESPACE_URI, localPart,
      Legato.Text.PREFIX);
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Text.Format = OpenLayers.Class( {

  initialize : function(options) {
  },
  format : function(obj) {
    return obj.toString();
  },
  parse : function(string) {
    return string;
  },
  destroy : function() {
  },
  CLASS_NAME :"Legato.Text.Format"
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Text.DecimalFormat = OpenLayers
    .Class(
        Legato.Text.Format,
        {
          formatSymbols : {
            groupingSeparator :'.',
            decimalSeparator :','
          },
          initialize : function(options) {
          },
          format : function(number) {
            var decimalDigits = 10;
            var groupLength = 3;

            var sign = (number > 0) ? 1 : (number < 0 ? -1 : 0);
            var fractionalPart = Math.abs(number) % 1;
            var integerPart = Math.abs(number) - fractionalPart;

            var signAsString = (sign < 0) ? '-' : '';

            var groupDivider = groupLength > 0 ? Math.pow(10, groupLength) : 10;
            var groupingSeparator = groupLength > 0 ? this.formatSymbols.groupingSeparator
                : '';

            var integerPartAsString = this.calculateIntegerPartAsString(integerPart, groupDivider, groupingSeparator);

            var scale = 10;

            var fractionalPartAsString = this.calculateFranctionalPartAsString(fractionalPart, scale);

            return signAsString + integerPartAsString + fractionalPartAsString;
          },
          calculateIntegerPartAsString: function(integerPart, groupDivider, groupingSeparator) {
            var car = integerPart;
            var cdr = 0;

            var result = (car === 0) ? '0' : '';

            while (car > 0) {
              cdr = car % groupDivider;
              car = (car - cdr) / groupDivider;

              if (car === 0) {
                result = cdr.toString() + result;
              } else {
                result = groupingSeparator
                    + (groupDivider + cdr).toString().substring(1) + result;
              }
            }
            return result;
          },
          calculateFranctionalPartAsString: function(fractionalPart, scale) {
            var car = Math.round(fractionalPart * Math.pow(10, scale));
            var cdr = 0;
            var onlyZeroes = true;
            var result = '';
            for ( var index = 0; index < scale; index++) {
              cdr = car % 10;
              car = (car - cdr) / 10;
              onlyZeroes = onlyZeroes && (cdr === 0);
              if (!onlyZeroes) {
                result = cdr + result;
              }
            }
            return (result.length === 0 ? ''
                : this.formatSymbols.decimalSeparator)
                + result;
          },
          parse : function(string) {
            var one = string.replace(/\./g, '');
            var two = one.replace(/,/, '.');
            return Number(two);
          },
          destroy : function() {
          },
          CLASS_NAME :"Legato.Text.DecimalFormat"
        });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Text.PrecisionScaleFormat = OpenLayers.Class(Legato.Text.Format, {
  precision :20,
  scale :10,
  numberFormat :null,
  initialize : function(precision, scale, options) {
    if (Legato.Lang.ObjectUtils.exists(precision)) {
      this.precision = precision;
    }
    if (Legato.Lang.ObjectUtils.exists(scale)) {
      this.scale = scale;
    }
    if (Legato.Lang.ObjectUtils.exists(options)) {
      OpenLayers.Util.extend(this, options);
    }
    if (!Legato.Lang.ObjectUtils.exists(this.numberFormat)) {
      this.numberFormat = new Legato.Text.DecimalFormat();
    }
  },
  format : function(number) {

    var precised;
    if (this.precision > 0) {
      var digitsRude = Math.floor(Math.log(number) / Math.log(10));
      var digits = (Math.pow(10, digitsRude) < number ? digitsRude + 1
          : digitsRude);
      precised = Math.round(number * Math.pow(10, this.precision - digits))
          * Math.pow(10, digits - this.precision);
    } else {
      precised = number;
    }
    var precisedAndScaled;
    if (this.scale >= 0) {
      precisedAndScaled = Math.round(precised * Math.pow(10, this.scale))
          * Math.pow(10, -this.scale);
    } else {
      precisedAndScaled = precised;
    }
    return this.numberFormat.format(precisedAndScaled);
  },
  parse : function(string) {
    return this.numberFormat.parse(string);
  },
  destroy : function() {
  },
  CLASS_NAME :"Legato.Text.DecimalFormat"
});

Legato.Text.PrecisionScaleFormat.Bean = Legato.Beans.Object.Extend(
    'Legato.Text.PrecisionScaleFormat',
    //
    Legato.Text.QName('PrecisionScaleFormat'),
    //
    {
      _constructor :Legato.Text.PrecisionScaleFormat,
      options : {
        precision :Legato.Lang.Integer,
        scale :Legato.Lang.Integer,
        format :Legato.Beans.Object
      }
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Space: ol
 * Namespace for OpenLayers components. 
 */
Legato.OpenLayers = {};
/**
 * URI: Namespace URI
 * http://www.openlayers.org
 */
Legato.OpenLayers.NAMESPACE_URI = 'http://www.openlayers.org';
/**
 * Prefix: Default prefix
 * ol
 */
Legato.OpenLayers.PREFIX = 'ol';
Legato.OpenLayers.QName = function(localPart, prefix)
{
  return new Legato.XML.QName(Legato.OpenLayers.NAMESPACE_URI, localPart, Legato.OpenLayers.PREFIX);
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: ol:Bounds
 * 
 * See also:
 * - <ol> namespace.
 * - {<OpenLayers.Bounds>}
 */

OpenLayers.Bounds.Bean = Legato.Beans.Object.Extend('OpenLayers.Bounds',
//
Legato.OpenLayers.QName('Bounds'),
//
{
	// Using factoryFunction instead of _constructor approach because
	// OpenLayers now checks for instance equality with "instanceof"
	// which fails if the object isn't created with the new() operator.
	factoryFunction : function(left, bottom, right, top) {
		return new OpenLayers.Bounds(left, bottom, right, top);
	},
	constructorArguments : {
		/**
		 * Element: left
		 * {Number}
		 */
		left : Legato.Lang.Number,
		/**
		 * Element: bottom
		 * {Number}
		 */
		bottom : Legato.Lang.Number,
		/**
		 * Element: right
		 * {Number}
		 */
		right : Legato.Lang.Number,
		/**
		 * Element: top
		 * {Number}
		 */
		top : Legato.Lang.Number

	},
	constructorOrder : [ 'left', 'bottom', 'right', 'top' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: ol:LonLat
 * 
 * See also:
 * - <ol> namespace
 * - {<OpenLayers.LonLat>}
 * 
 */
OpenLayers.LonLat.Bean = Legato.Beans.Object.Extend('OpenLayers.Bounds',
//
Legato.OpenLayers.QName('LonLat'),
//
{
	_constructor : OpenLayers.LonLat,
	constructorArguments : {
		/**
		 * Element: lon
		 * {Number}
		 */
		lon : Legato.Lang.Number,
		/**
		 * Element: lat
		 * {Number}
		 */
		lat : Legato.Lang.Number
	},
	constructorOrder : [ 'lon', 'lat' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: ol:Projection
 * 
 * See also:
 * - <ol> namespace
 * - {<OpenLayers.Projection>}
 */
OpenLayers.Projection.Bean = Legato.Beans.Object.Extend(
		'OpenLayers.Projection',
		//
		Legato.OpenLayers.QName('Projection'),
		//
		{
			// Using factoryFunction instead of _constructor approach because
			// OpenLayers now checks for instance equality with "instanceof" 
			// which fails if the object isn't created with the new() operator.
			factoryFunction : function(projCode) {
				return new OpenLayers.Projection(projCode);
			},
			constructorArguments : {
				/**
				 * Element: projCode
				 * {String}
				 */
				projCode : Legato.Lang.String
			},
			constructorOrder : [ 'projCode' ],
			fromString : function(projCode) {
				return new OpenLayers.Projection(projCode);
			}
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: ol:Size
 * 
 * See also:
 * - <ol> namespace
 * - {<OpenLayers.Size>}
 * 
 */
OpenLayers.Size.Bean = Legato.Beans.Object.Extend('OpenLayers.Size',
//
Legato.OpenLayers.QName('Size'),
//
{
	_constructor : OpenLayers.Size,
	constructorArguments : {
		/**
		 * Element: w
		 * {Number}
		 */
		w : Legato.Lang.Number,
		/**
		 * Element: h
		 * {Number}
		 */
		h : Legato.Lang.Number
	},
	constructorOrder : [ 'w', 'h' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: ol:Pixel
 * 
 * See also:
 * - <ol> namespace
 * - {<OpenLayers.Pixel>}
 */
OpenLayers.Pixel.Bean = Legato.Beans.Object.Extend('OpenLayers.Pixel',
//
Legato.OpenLayers.QName('Pixel'),
//
{
	_constructor : OpenLayers.Pixel,
	constructorArguments : {
		/**
		 * Element: x
		 * {Number}
		 */
		x : Legato.Lang.Number,
		/**
		 * Element: y
		 * {Number}
		 */
		y : Legato.Lang.Number
	},
	constructorOrder : [ 'x', 'y' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: ol:Icon
 * 
 * See also:
 * - <ol> namespace.
 * - {<OpenLayers.Icon>}
 */
OpenLayers.Icon.Bean = Legato.Beans.Object.Extend('OpenLayers.Icon',
    //
    Legato.OpenLayers.QName('Icon'),
    //
    {
	_constructor :OpenLayers.Icon,
	constructorArguments : {
		/**
		 * Element: url
		 * {String}
		 */
		url :Legato.Lang.String,
		/**
		 * Element: size
		 * {<ol:Size>}
		 */
		size :OpenLayers.Size.Bean,
		/**
		 * Element: offset
		 * {<ol:Pixel>}
		 */
		offset: OpenLayers.Pixel.Bean,
		/**
		 * Element: calculateOffset
		 * {Function}	 
		 */
		calculateOffset: Legato.Lang.Function
	},
	constructorOrder : [ 'url', 'size', 'offset', 'calculateOffset' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Layer.prototype.selected = false;
OpenLayers.Layer.prototype.queryable = false;
OpenLayers.Layer.prototype.isFeatureLayer = false;
Legato.OpenLayers.Layer = {};

/**
 * Space: oll
 * Namespace for OpenLayers layers.
 */
/**
 * URI: Namespace URI
 * {http://www.openlayers.org/layer}
 */
Legato.OpenLayers.Layer.NAMESPACE_URI = 'http://www.openlayers.org/layer';
/**
 * Prefix: Default prefix
 * oll
 */
Legato.OpenLayers.Layer.PREFIX = 'oll';

Legato.OpenLayers.Layer.QName = function(localPart) {
  return new Legato.XML.QName(Legato.OpenLayers.Layer.NAMESPACE_URI,
      localPart, Legato.OpenLayers.Layer.PREFIX);
};

/**
 * Component: oll:Layer
 *
 * Abstract base component for layer configurations.
 *
 *  See also:
 *  - <oll> namespace
 *  - {<OpenLayers.Layer>}
 */
OpenLayers.Layer.Bean = Legato.Beans.Object.Extend('OpenLayers.Layer',
    Legato.OpenLayers.QName('Layer'), {
      _constructor : OpenLayers.Layer,
      constructorArguments : {
        /**
         * Element: name
         * {String}
         */
        name : Legato.Lang.String
      },
      constructorOrder : [ 'name' ],
      options : {
        /**
         * Element: id
         * {String}
         */
        id : Legato.Lang.String,
        /**
         * Element: layerId
         * {String}
         */
        layerId : Legato.Lang.String,
        /**
         * Element: title
         * {String}
         */
        title : Legato.Lang.String,
        /**
         * Element: opacity
         * {Number}
         */
        opacity : Legato.Lang.Number,
        /**
         * Element: alwaysInRange
         * {Boolean}
         */
        alwaysInRange : Legato.Lang.Boolean,
        // events ???
        /**
         * Element: isBaseLayer
         * {Boolean}
         */
        isBaseLayer : Legato.Lang.Boolean,
        /**
         * Element: isFeatureLayer
         * {Boolean}
         */
        isFeatureLayer : Legato.Lang.Boolean,
        /**
         * Element: alpha
         * {Boolean}
         */
        alpha : Legato.Lang.Boolean,
        /**
         * Element: displayInLayerSwitcher
         * {Boolean}
         */
        displayInLayerSwitcher : Legato.Lang.Boolean,
        /**
         * Element: visibility
         * {Boolean}
         */
        visibility : Legato.Lang.Boolean,
        /**
         * Element: attribution
         * {String}
         */
        attribution : Legato.Lang.String,
        // eventListeners ???,
        /**
         * Element: gutter
         * {Integer}
         */
        gutter : Legato.Lang.Integer,
        /**
         * Element: projection
         * {<ol:Projection>}
         */
        projection : OpenLayers.Projection.Bean,
        /**
         * Element: units
         * {String}
         */
        units : Legato.Lang.String,
        // scales???
        /**
         * Element: resolutions
         * {Double[]}
         */
        resolutions : Legato.Lang['Double[]'],
        /**
         * Element: maxExtent
         * {<ol:Bounds>}
         */
        maxExtent : OpenLayers.Bounds.Bean,
        /**
         * Element: minExtent
         * {<ol:Bounds>}
         */
        minExtent : OpenLayers.Bounds.Bean,
        /**
         * Element: maxResolution
         * {Number}
         */
        maxResolution : Legato.Lang.Number,
        /**
         * Element: minResolution
         * {Number}
         */
        minResolution : Legato.Lang.Number,
        /**
         * Element: numZoomLevels
         * {Integer}
         */
        numZoomLevels : Legato.Lang.Integer,
        /**
         * Element: maxScale
         * {Number}
         */
        maxScale : Legato.Lang.Number,
        /**
         * Element: minScale
         * {Number}
         */
        minScale : Legato.Lang.Number,
        /**
         * Element: maxScaleDenominator
         * {Number}
         */
        maxScaleDenominator : Legato.Lang.Number,
        /**
         * Element: minScaleDenominator
         * {Number}
         */
        minScaleDenominator : Legato.Lang.Number,
        /**
         * Element: displayOutsideMaxExtent
         * {Boolean}
         */
        displayOutsideMaxExtent : Legato.Lang.Boolean,
        /**
         * Element: wrapDateLine
         * {Boolean}
         */
        wrapDateLine : Legato.Lang.Boolean,
        /**
         * Element: transitionEffect
         * {String}
         */
        transitionEffect : Legato.Lang.String,
        /**
         * Element: legend
         * {Object} Legend provider
         */
        legend : Legato.Beans.Object,
        /**
         * Element: selected
         * {Boolean}
         */
        selected : Legato.Lang.Boolean,
        /**
         * Element: queryable
         * {Boolean}
         */
        queryable : Legato.Lang.Boolean,
        // Future music
        //  plugins :Legato.Beans.Object.List(),
        /**
         * Element: attributes
         */
        attributes : Legato.Beans.Object.Map(),

        /**
         * Element: formatList
         * {String[]}
         */
        formatList : Legato.Lang['String[]']
      }
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.OpenLayers.Control = {};
/**
 * Space: olc
 */
/**
 * URI: Namespace URI
 * http://www.openlayers.org/control
 */
Legato.OpenLayers.Control.NAMESPACE_URI = 'http://www.openlayers.org/control';
/**
 * Prefix: Default Prefix
 * olc
 */
Legato.OpenLayers.Control.PREFIX = 'olc';
Legato.OpenLayers.Control.QName = function(localPart) {
	return new Legato.XML.QName(Legato.OpenLayers.Control.NAMESPACE_URI,
			localPart, Legato.OpenLayers.Control.PREFIX);
};
Legato.Lang['OpenLayers.Control.TYPE'] = Legato.Lang.Integer.Enum(
		'OpenLayers.Control.TYPE', {
			'TYPE_BUTTON' : 1,
			'TYPE_TOGGLE' : 2,
			'TYPE_TOOL' : 3
		});
/**
 * Component: olc:Control
 * Abstract base component for OpenLayers Controls.
 * 
 * See also:
 * - <olc> namespace
 * - {<OpenLayers.Control>}
 * - <lc> namespace
 * - {<Legato.Control>}
 */
OpenLayers.Control.Bean = Legato.Beans.Object.Extend('OpenLayers.Control',
//
Legato.OpenLayers.QName('Control'),
//
{
	_constructor : OpenLayers.Control,
	options : {
		/**
		 * Element: id
		 * {String} id of the control.
		 */
		id : Legato.Lang.String,
		/**
		 * Element: div
		 * {DOMElement} DOM element for the control.
		 */
		div : Legato.Lang.Element,
		/**
		 * Element: type
		 * {<OpenLayers.Control.TYPE>} Type of the control.
		 */
		type : Legato.Lang['OpenLayers.Control.TYPE'],
		/**
		 * Element: allowSelection
		 * {Boolean} 
		 */
		allowSelection : Legato.Lang.Boolean,
		/**
		 * Element: displayClass
		 * {String}
		 */
		displayClass : Legato.Lang.String,
		/**
		 * Element: title
		 * {String}
		 */
		title : Legato.Lang.String
	}
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Hack
/*
OpenLayers.Map.prototype.EVENT_TYPES.push('legato.refresh');
OpenLayers.Map.prototype.EVENT_TYPES.push('legato.selectlayer');
OpenLayers.Map.prototype.EVENT_TYPES.push('legato.deselectlayer');
OpenLayers.Map.prototype.EVENT_TYPES.push('legato.selectobjects');
*/

// Hack
OpenLayers.Map.prototype.Z_INDEX_BASE.BaseLayer = 100; // 100
OpenLayers.Map.prototype.Z_INDEX_BASE.Overlay = 200; // 325
OpenLayers.Map.prototype.Z_INDEX_BASE.Feature = 500; // 725
OpenLayers.Map.prototype.Z_INDEX_BASE.Markers = 800; // 725
OpenLayers.Map.prototype.Z_INDEX_BASE.Popup = 900; // 750
OpenLayers.Map.prototype.Z_INDEX_BASE.Control = 1000; // 1000
OpenLayers.Map.prototype.setLayerZIndex = function(layer, zIdx) {
  if (Legato.Lang.ObjectUtils.isTrue(layer.isMarkersLayer)) {
    layer.setZIndex(this.Z_INDEX_BASE.Markers + zIdx);
  } else if (Legato.Lang.ObjectUtils.isTrue(layer.isFeatureLayer)) {
    layer.setZIndex(this.Z_INDEX_BASE.Feature + zIdx);
  } else if (Legato.Lang.ObjectUtils.isTrue(layer.isBaseLayer)) {
    layer.setZIndex(this.Z_INDEX_BASE.BaseLayer + zIdx * 5);
  } else {
    layer.setZIndex(this.Z_INDEX_BASE.Overlay + zIdx * 5);
  }
};

Legato.OpenLayers.Map = {};

/**
 * Component: ol:Map Configuration component for {<OpenLayers.Map>}.
 * 
 * See also: -
 * <ol>
 * namespace - {<OpenLayers.Map>}
 */
OpenLayers.Map.Bean = Legato.Beans.Object.Extend('OpenLayers.Map', Legato.OpenLayers.QName('Map'),
//
{
  factoryFunction : function(id, options) {
    if (!Legato.Lang.ObjectUtils.exists(options)) {
      options = {};
    }
    if (!Legato.Lang.ObjectUtils.exists(options.controls)) {
      options.controls = [];
    }
    if (!Legato.Lang.ObjectUtils.exists(options.theme)) {
      options.theme = null;
    }
    return new OpenLayers.Map(id, options);
  },
  constructorArguments : {
    /**
     * Element: id {String}
     */
    id : Legato.Lang.String
  },
  constructorOrder : [ 'id' ],
  options : {

    /**
     * Element: projection {<ol:Projection>}
     */
    projection : OpenLayers.Projection.Bean,
    // - theme: Legato.Lang.String,
    /**
     * Element: displayProjection {<ol:Projection>}
     */
    displayProjection : OpenLayers.Projection.Bean,
    /**
     * Element: initialExtent {<ol:Bounds>}
     */
    initialExtent : OpenLayers.Bounds,
    /**
     * Element: tags {<lu:Tag> []}
     */
    tags : Legato.Util.Tag.Bean.List(),
    /**
     * Element: center {<ol:LonLat>}
     */
    center : OpenLayers.LonLat.Bean,
    /**
     * Element: fractionalZoom {Boolean}
     */
    fractionalZoom : Legato.Lang.Boolean,
    /**
     * Element: div {DOMElement}
     */
    div : Legato.Lang.Element,
    /**
     * Element: dragging {Boolean}
     */
    dragging : Legato.Lang.Boolean,
    /**
     * Element: size {<ol:Size>}
     */
    size : OpenLayers.Size.Bean,
    /**
     * Element: viewPortDiv {DOMElement}
     */
    viewPortDiv : Legato.Lang.Element,
    /**
     * Element: layerContainerDiv {DOMElement}
     */
    layerContainerDiv : Legato.Lang.Element,

    // - baseLayer: ???,

    /**
     * Element: resolution {Double}
     */
    resolution : Legato.Lang.Double,

    /**
     * Element: zoom {Integer}
     */
    zoom : Legato.Lang.Integer,

    /**
     * Element: panRatio {Double}
     */
    panRatio : Legato.Lang.Double,

    /**
     * Element: viewRequestID {String}
     */
    viewRequestID : Legato.Lang.String,

    /**
     * Element: tileSize {<ol:Size>}
     */
    tileSize : OpenLayers.Size.Bean,

    /**
     * Element: units {String}
     */
    units : Legato.Lang.String,

    /**
     * Element: dpi {Integer}
     */
    dpi : Legato.Lang.Integer,

    /**
     * Element: resolutions {Double[]}
     */
    resolutions : Legato.Lang['Double[]'],

    /**
     * Element: maxResolution {Double[]}
     */
    maxResolution : Legato.Lang.Double,

    /**
     * Element: minResolution {Double[]}
     */
    minResolution : Legato.Lang.Double,

    /**
     * Element: maxScale {Double[]}
     */
    maxScale : Legato.Lang.Double,

    /**
     * Element: minScale {Double}
     */
    minScale : Legato.Lang.Double,

    /**
     * Element: minExtent {<ol:Bounds>}
     */
    minExtent : OpenLayers.Bounds.Bean,

    /**
     * Element: maxExtent {<ol:Bounds>}
     */
    maxExtent : OpenLayers.Bounds.Bean,

    /**
     * Element: restrictedExtent {<ol:Bounds>}
     */
    restrictedExtent : OpenLayers.Bounds.Bean,

    /**
     * Element: numZoomLevels {Integer}
     */
    numZoomLevels : Legato.Lang.Integer,

    /*
     * Element: fallThrough {Boolean}
     */
    fallThrough : Legato.Lang.Boolean
  },
  properties : {
    /**
     * Element: layers {<oll:Layer> []}
     */
    layers : new Legato.Beans.Property(OpenLayers.Layer.Bean.List(), function(map, layers) {
      map.addLayers(layers);
    }),
    /**
     * Element: controls {<olc:Control> []}
     */
    controls : new Legato.Beans.Property(OpenLayers.Control.Bean.List(), function(map, controls) {
      for ( var index = 0; index < controls.length; index++) {
        map.addControl(controls[index]);
      }
    })
  },
  afterInstancePopulated : function(map) {
    if (Legato.Lang.ObjectUtils.exists(map.initialExtent)) {
      map.zoomToExtent(map.initialExtent, true);
    }
    map.events.triggerEvent("legato.refresh", {});
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Revision: 69543 $
 * @requires Legato.js
 * @requires OpenLayers/Control.js
 */

/**
 * Class: Legato.OpenLayers.Map.Util
 *
 */
Legato.OpenLayers.Map.Util = {};

/*
 * Function: getOverlays
 * Just returns from given layers overlays
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} All found overlays
 */
Legato.OpenLayers.Map.Util.getOverlays = function(layers){
  return Legato.Lang.CollectionUtils.filter(
    layers,
    function(layer){
      return (!layer.isBaseLayer);
    }
  );
};

/*
 * Function: getSelectedLayers
 * Just returns from given layers all selected layers
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} All found selected layers
 */
Legato.OpenLayers.Map.Util.getSelectedLayers = function(layers){
  return Legato.Lang.CollectionUtils.filter(
      layers,
      function(layer){
        return (layer.selected);
      }
  );
};

/*
 * Function: getQueryableLayers
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} Found queryable layers
 */
Legato.OpenLayers.Map.Util.getQueryableLayers = function(layers){
  return Legato.Lang.CollectionUtils.filter( layers,
      function(layer){
        return (Legato.Lang.ObjectUtils.isBoolean(layer.queryable) && layer.queryable);
      }
  );
};

/*
 * Function: getSnappableLayers
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} Found snappable layers
 */
Legato.OpenLayers.Map.Util.getSnappableLayers = function(layers){
  return Legato.Lang.CollectionUtils.filter( layers,
      function(layer){
    return (Legato.Lang.ObjectUtils.isObject(layer.options) &&
      Legato.Lang.ObjectUtils.isObject(layer.options.attributes) &&
      Legato.Lang.ObjectUtils.isString(layer.options.attributes.snappable) &&
      Boolean(layer.options.attributes.snappable));
  }
  );
};


/*
 * Function: getUnselectedLayers
 * Just returns from given layers all unselected layers
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} All found unselected layers
 */
Legato.OpenLayers.Map.Util.getUnselectedLayers = function(layers){
  return Legato.Lang.CollectionUtils.filter(
      layers,
      function(layer){
        return (!layer.selected);
      }
  );
};

/*
 * Function: getLayerById
 * Retrieves a layer by the given layerId from the list of layers.
 *
 * Returns:
 * {<OpenLayers.Layer>} Requested layer or null if it is not found
 */
Legato.OpenLayers.Map.Util.getLayerById = function(layers, layerId) {
  var filteredLayers = Legato.Lang.CollectionUtils.filter(layers, 
      function(layer) {
        return layer.layerId === layerId;
      });
  return (filteredLayers.length > 0) ? filteredLayers[0] : null;
};

/*
 * Function: isVectorLayer
 * Determines if given layer is a vector layer.
 *
 * Returns:
 * {Boolean} True if Vector layer, false otherwise
 */
Legato.OpenLayers.Map.Util.isVectorLayer = function(layer){
  return Legato.Lang.ObjectUtils.exists(layer.CLASS_NAME) && layer.CLASS_NAME === 'OpenLayers.Layer.Vector';
};

Legato.OpenLayers.Map.Util.isIgnoredLayer = function(layer) {
  return Legato.Lang.ObjectUtils.isBoolean(layer.options.legatoIgnore) && layer.options.legatoIgnore;
};

/*
 * Function: isListedLayer
 * Determines if given layer should appear in legend list.
 *
 * Returns:
 * (Boolean) True if the layer should appear in legend list, false otherwise
 */
Legato.OpenLayers.Map.Util.isListedLayer = function(layer)
{
  return !(
      (Legato.Lang.ObjectUtils.isBoolean(layer.options.legatoIgnore) && layer.options.legatoIgnore)
      ||
      (Legato.Lang.ObjectUtils.isBoolean(layer.displayInLayerSwitcher) && !layer.displayInLayerSwitcher)
  );
};

Legato.OpenLayers.Map.Util.isListedBaseLayer = function(layer)
{
  return layer.isBaseLayer && Legato.OpenLayers.Map.Util.isListedLayer(layer);
};

Legato.OpenLayers.Map.Util.isListedOverlay = function(layer)
{
  return !layer.isBaseLayer && Legato.OpenLayers.Map.Util.isListedLayer(layer);
};

Legato.OpenLayers.Map.Util.getListedBaseLayers = function(layers)
{
  return Legato.Lang.CollectionUtils.filter(layers, Legato.OpenLayers.Map.Util.isListedBaseLayer);
};

Legato.OpenLayers.Map.Util.getListedOverlays = function(layers)
{
  return Legato.Lang.CollectionUtils.filter(layers, Legato.OpenLayers.Map.Util.isListedOverlay);
};

/*
 * Function: getLayersWithoutLegatoIgnore
 * Just returns from given layers all layers which do'nt have the
 * legatoIgnore flag.
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} All found selected layers without the legatoIgnore flag
 */
Legato.OpenLayers.Map.Util.getLayersWithoutLegatoIgnore = function(layers){
  return Legato.Lang.CollectionUtils.filter(
      layers,
      function(layer){
        return !Legato.OpenLayers.Map.Util.isIgnoredLayer(layer);
      }
  );
};

/*
 * Function: getLayersLegatoIgnore
 * Just returns from given layers all layers which have the
 * legatoIgnore flag set to true.
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} All found selected layers where the legatoIgnore flag is true
 */
Legato.OpenLayers.Map.Util.getLayersLegatoIgnore = function(layers){
  return Legato.Lang.CollectionUtils.filter(
      layers,
      function(layer){
        return Legato.OpenLayers.Map.Util.isIgnoredLayer(layer);
      }
  );
};

/*
 * Function: getBaseLayers
 * Just returns from given layers baselayers
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} All found baselayers
 */
Legato.OpenLayers.Map.Util.getBaseLayers = function(layers){
  return Legato.Lang.CollectionUtils.filter(
    layers,
    function(layer){
      return (layer.isBaseLayer);
    }
  );
};

/*
 * Function: getVisibleLayers
 * Just returns from given layers visible layers
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} All found visible layers
 */
Legato.OpenLayers.Map.Util.getVisibleLayers = function(layers){
  return Legato.Lang.CollectionUtils.filter(
    layers,
    function(layer){
      if (!Legato.OpenLayers.Map.Util.isListedLayer(layer)) {
        return false;
      }
      return layer.visibility;
    }
  );
};

/*
 * Function: getInvisibleLayers
 * Just returns from given layers invisible layers
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} All found invisible layers
 */
Legato.OpenLayers.Map.Util.getInvisibleLayers = function(layers){
  return Legato.Lang.CollectionUtils.filter(
    layers,
    function(layer){
      if (!Legato.OpenLayers.Map.Util.isListedLayer(layer)) {
        return true;
      }
      return !layer.visibility;
    }
  );
};

/*
 * Function: getInvisibleBaseLayers
 * Just returns from given layers invisible baselayers
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} All found invisible baselayers
 */
Legato.OpenLayers.Map.Util.getInvisibleBaseLayers = function(layers){
  //Due we don't expect any performance issues we concatenate
  return Legato.OpenLayers.Map.Util.getInvisibleLayers(Legato.OpenLayers.Map.Util.getBaseLayers(layers));
};

/*
 * Function: getVisibleBaseLayers
 * Just returns from given layers visible baselayers
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} All found visible baselayers
 */
Legato.OpenLayers.Map.Util.getVisibleBaseLayers = function(layers){
  //Due we don't expect any performance issues we concatenate
  return Legato.OpenLayers.Map.Util.getVisibleLayers(Legato.OpenLayers.Map.Util.getBaseLayers(layers));
};

/*
 * Function: getInvisibleOverlays
 * Just returns from given layers invisible overlays
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} All found invisible overlays
 */
Legato.OpenLayers.Map.Util.getInvisibleOverlays = function(layers){
  //Due we don't expect any performance issues we concatenate
  return Legato.OpenLayers.Map.Util.getInvisibleLayers(Legato.OpenLayers.Map.Util.getOverlays(layers));
};

/*
 * Function: getVisibleOverlays
 * Just returns from given layers visible overlays
 *
 * Returns:
 * {Array(<OpenLayers.Layer>)} All found visible overlays
 */
Legato.OpenLayers.Map.Util.getVisibleOverlays = function(layers){
  //Due we don't expect any performance issues we concatenate
  return Legato.OpenLayers.Map.Util.getVisibleLayers(Legato.OpenLayers.Map.Util.getOverlays(layers));
};

/*
 * Function: getLayerIds
 * Extracts from given layers array all layerids and returns them as an array
 *
 * Returns:
 * {Array(String)} All layer ids
 */
Legato.OpenLayers.Map.Util.getLayerIds = function(layers){
  var layerids = [];

  for(var i = 0; i < layers.length; i++){
    var layerid = Legato.Lang.ObjectUtils.isNullOrUndefined(layers[i].layerId) ?
        layers[i].name : layers[i].layerId;
    layerids.push(layerid);
  }

  return layerids;
};

/*
 * Function: getBoxSelectionAsVector
 * Returns a new box vector based on drawn mouse position box.
 *
 * Parameters:
 * params - {Object}
 * map <OpenLayers.Map> an OpenLayers Map
 * position <OpenLayers.Bounds> a Selection which wants to be transformed into a vector layer
 *
 * Returns:
 * {<OpenLayers.Feature.Vector>} - The given Selection as Vector
 */
Legato.OpenLayers.Map.Util.getBoxSelectionAsVector = function(map, position){
  Legato.Util.Ensure.ensureObject(map);
  Legato.Util.Ensure.ensureObject(position);

  var lowerLeftLonLat = map.getLonLatFromPixel(
    new OpenLayers.Pixel(position.left, position.bottom));
  var upperRightLonLat = map.getLonLatFromPixel(
    new OpenLayers.Pixel(position.right, position.top));
  var bounds = new OpenLayers.Bounds(
    lowerLeftLonLat.lon,
    lowerLeftLonLat.lat,
    upperRightLonLat.lon,
    upperRightLonLat.lat
  );

  return new OpenLayers.Feature.Vector(bounds.toGeometry());
};

/*
 * Function: getPointSelectionAsVector
 *
 * Parameters:
 * params
 * map <OpenLayers.Map> an OpenLayers Map
 * position <OpenLayers.Bounds> a Selection which wants to be transformed into a vector layer
 *
 * Returns:
 * {<OpenLayers.Feature.Vector>} - The given Selection as Vector
 */
Legato.OpenLayers.Map.Util.getPointSelectionAsVector = function(map, position){
  Legato.Util.Ensure.ensureObject(map);
  Legato.Util.Ensure.ensureObject(position);

  var lonlat = map.getLonLatFromPixel(position);
  var point = new OpenLayers.Geometry.Point(lonlat.lon, lonlat.lat);

  return new OpenLayers.Feature.Vector(point);
};

/*
 * Function: isValidBBox
 * Validates given BBox if it contains some reasonable values
 *
 * Parameters:
 * bbox - {<OpenLayers.Bounds>} The BBox to validate
 *
 * Returns:
 * {Boolean} - True if valid, false otherwise
 */
Legato.OpenLayers.Map.Util.isValidBBox = function(bbox){
  if(!Legato.Lang.ObjectUtils.isObject(bbox)){
    return false;
  }

  //Now validate that our created bbox does not contain any null values
  if(Legato.Lang.ObjectUtils.isNullOrUndefined(bbox.left) ||
     Legato.Lang.ObjectUtils.isNullOrUndefined(bbox.right) ||
     Legato.Lang.ObjectUtils.isNullOrUndefined(bbox.top) ||
     Legato.Lang.ObjectUtils.isNullOrUndefined(bbox.bottom)){
    return false;
  }

  //And also validate that given values could be allright
  if(((bbox.top - bbox.bottom) <= 0.000001) || ((bbox.right - bbox.left) <= 0.000001)) {
    return false;
  }

  return true;
};

/*
 * TODO: Needed?
 */
Legato.OpenLayers.Map.Util.getDummyLayer = function() {
  return new OpenLayers.Layer.WMS(
      // name
      "dummy",
      // url
      "http://www2.demis.nl/wms/wms.asp?wms=WorldMap&",
      // params
      {
        layers: 'Bathymetry',
        format:'image/png'
      });
};

/*
 * Function: moveLayer
 * Moves the given layer up or down
 *
 * Parameters:
 * params - {Object} a hashmap which contains
 * - layer {<OpenLayers.Layer>} the layer to move
 * - up {Boolean} true =  layer will be moved up, false = moved down
 */
Legato.OpenLayers.Map.Util.moveLayer = function(params){
    var layer    = params.layer;
    var map      = layer.map;
    var overlays = Legato.OpenLayers.Map.Util.getOverlays(map.layers);

    var i = OpenLayers.Util.indexOf(overlays, layer);

    if(params.up){
      --i;
    } else {
      ++i;
    }

    if(i < 0 || i > overlays.length - 1){
      return;
    }

    OpenLayers.Util.removeItem(overlays, layer);
    overlays.splice(i, 0, layer);

    for(var j = 0; j < overlays.length; j++){
      map.removeLayer(overlays[j]);
    }

    map.addLayers(overlays);
};

/*
 * Function: getViewPortPxFromLonLat
 * Returns a pixel location given a map location. This method will return
 * fractional pixel values.
 *
 * Parameters:
 * lonlat - {<OpenLayers.LonLat>}
 * resolution - {Number}
 * extent - {<OpenLayers.Bounds>}
 *
 * Returns:
 * {<OpenLayers.Pixel>} An <OpenLayers.Pixel> which is the passed-in
 * <OpenLayers.LonLat>,translated into view port pixels.
 */
Legato.OpenLayers.Map.Util.getViewPortPxFromLonLat = function (lonlat, resolution, extent) {
  var px = null;
  if (lonlat !== null) {
    px = new OpenLayers.Pixel(
      (1/resolution * (lonlat.lon - extent.left)),
      (1/resolution * (extent.top - lonlat.lat))
    );
  }
  return px;
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Popup.prototype.getSafeContentSize = function(size) {

  var safeContentSize = size.clone();

  // if our contentDiv has a css 'padding' set on it by a stylesheet, we
  //  must add that to the desired "size".
  var contentDivPadding = this.getContentDivPadding();
  var contentDivMargin = this.getContentDivMargin();
  var wMargin = contentDivMargin.left + contentDivMargin.right;
  var hMargin = contentDivMargin.top + contentDivMargin.bottom;
  var wPadding = contentDivPadding.left + contentDivPadding.right;
  var hPadding = contentDivPadding.top + contentDivPadding.bottom;

  // take into account the popup's 'padding' property
  this.fixPadding();
  wPadding += this.padding.left + this.padding.right;
  hPadding += this.padding.top + this.padding.bottom;

  if (this.closeDiv) {
      var closeDivWidth = parseInt(this.closeDiv.style.width, 10);
      wPadding += closeDivWidth + contentDivPadding.right;
  }

  // prevent the popup from being smaller than a specified minimal size
  if (this.minSize) {
      safeContentSize.w = Math.max(safeContentSize.w,
          (this.minSize.w - wPadding - wMargin));
      safeContentSize.h = Math.max(safeContentSize.h,
          (this.minSize.h - hPadding - hMargin));
  }

  // prevent the popup from being bigger than a specified maximum size
  if (this.maxSize) {
      safeContentSize.w = Math.min(safeContentSize.w,
          (this.maxSize.w - wPadding - wMargin));
      safeContentSize.h = Math.min(safeContentSize.h,
          (this.maxSize.h - hPadding - hMargin));
  }

  //make sure the desired size to set doesn't result in a popup that
  // is bigger than the map's viewport.
  //
  if (this.map && this.map.size) {

      var extraX = 0, extraY = 0;
      if (this.keepInMap && !this.panMapIfOutOfView) {
          var px = this.map.getPixelFromLonLat(this.lonlat);
          switch (this.relativePosition) {
              case "tr":
                  extraX = px.x;
                  extraY = this.map.size.h - px.y;
                  break;
              case "tl":
                  extraX = this.map.size.w - px.x;
                  extraY = this.map.size.h - px.y;
                  break;
              case "bl":
                  extraX = this.map.size.w - px.x;
                  extraY = px.y;
                  break;
              case "br":
                  extraX = px.x;
                  extraY = px.y;
                  break;
              default:
                  extraX = px.x;
                  extraY = this.map.size.h - px.y;
                  break;
          }
      }

      var maxY = this.map.size.h -
          this.map.paddingForPopups.top -
          this.map.paddingForPopups.bottom -
          hPadding - extraY;

      var maxX = this.map.size.w -
          this.map.paddingForPopups.left -
          this.map.paddingForPopups.right -
          wPadding - extraX;

      safeContentSize.w = Math.min(safeContentSize.w, maxX);
      safeContentSize.h = Math.min(safeContentSize.h, maxY);
  }

  return safeContentSize;
};

OpenLayers.Popup.prototype.getContentDivMargin = function() {

    if (this.div.parentNode === null) {
      //make the div invisible and add it to the page
        this.div.style.display = "none";
        document.body.appendChild(this.div);
  }

      //read the padding settings from css, put them in an OL.Bounds
      contentDivMargin = new OpenLayers.Bounds(
          OpenLayers.Element.getStyle(this.contentDiv, "margin-left"),
          OpenLayers.Element.getStyle(this.contentDiv, "margin-bottom"),
          OpenLayers.Element.getStyle(this.contentDiv, "margin-right"),
          OpenLayers.Element.getStyle(this.contentDiv, "margin-top")
      );

      if (this.div.parentNode == document.body) {
        //remove the div from the page and make it visible again
        document.body.removeChild(this.div);
        this.div.style.display = "";
      }

  return contentDivMargin;
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:ArgParser
 * 
 * The ArgParser control adds location bar query string parsing functionality.
 * 
 * Inherits from:
 * - <olc:Control>
 * 
 * See also:
 * - <olc> namespace
 * - <OpenLayers.Control.ArgParser>
 */
OpenLayers.Control.ArgParser.Bean = OpenLayers.Control.Bean.Extend(
//
'OpenLayers.Control.ArgParser',
//
Legato.OpenLayers.Control.QName('ArgParser'),
//
{
	_constructor : OpenLayers.Control.ArgParser,
	options : {
		/**
		 * Element: displayProjection
		 * {<ol:Projection>} Requires proj4js support. 
		 * Projection used when reading the coordinates from the URL. This will
		 * reproject the map coordinates from the URL into the map's
		 * projection.
		 */
		displayProjection : OpenLayers.Projection.Bean
	}
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:Attribution
 * 
 * The attribution control adds attribution from layers to the map display. 
 * It uses the 'attribution' property of each layer.
 * 
 * Inherits from:
 * - <olc:Control>
 * 
 * See also:
 * - <olc> namespace
 * - <OpenLayers.Control.Attribution>
 */
OpenLayers.Control.Attribution.Bean = OpenLayers.Control.Bean.Extend(
		'OpenLayers.Control.Attribution', Legato.OpenLayers.Control
				.QName('Attribution'), {
			_constructor : OpenLayers.Control.Attribution,
			options : {
				/**
				 * Element: seperator
				 * {String} String used to seperate layers.
				 */
				separator : Legato.Lang.String
			}
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:DrawFeature
 *
 * Draws point, line or polygon features on a vector layer.
 * 
 * Inherits from:
 * - <olc:Control>
 * 
 * See also:
 * - <olc> namespace
 * - <OpenLayers.Control.DrawFeature>
 * - <lc:DrawFeature>
 * - <lc:DrawPoint>
 * - <lc:DrawLineString>
 * - <lc:DrawPolygon>
 * - <lc:DrawBox>
 * - <lc:ModifyFeature>
 * - <lc:ModifyPoint>
 * - <lc:ModifyLineString>
 * - <lc:ModifyPolygon>
 */
OpenLayers.Control.DrawFeature.Bean = OpenLayers.Control.Bean.Extend(
//
'OpenLayers.Control.DrawFeature',
//
Legato.OpenLayers.Control.QName('DrawFeature'),
//
{
	_constructor : OpenLayers.Control.DrawFeature,
	constructorArguments : {
		/**
		 * Element: layer
		 * {<oll:Vector>} 
		 */
		layer : OpenLayers.Layer.Bean,
		/**
		 * Element: handler
		 * {Function} 
		 */
		handler : Legato.Lang.Function
	},
	constructorOrder : [ 'layer', 'handler' ],
	options : {
		/**
		 * Element: featureAdded
		 * {Function} Called after the feature is added
		 */
		featureAdded : Legato.Lang.Function,
		/**
		 * Element: handlerOptions
		 * {Object} Used to set non-default properties on the control's handler
		 */
		handlerOptions : Legato.Beans.Object
	}
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: <olc:ModifyFeature>
 * 
 * Allows modifying features.
 *
 * Inherits From:
 *  - <olc:Control>
 *  
 *  See also:
 *  - <olc> namespace
 * - <lc:ModifyFeature>
 * - <lc:ModifyPoint>
 * - <lc:ModifyLineString>
 * - <lc:ModifyPolygon>
 * - <lc:DrawFeature>
 * - <lc:DrawPoint>
 * - <lc:DrawLineString>
 * - <lc:DrawPolygon>
 * - <lc:DrawBox>
 */
OpenLayers.Control.ModifyFeature.Bean = OpenLayers.Control.Bean.Extend(
//
'OpenLayers.Control.ModifyFeature',
//
Legato.OpenLayers.Control.QName('ModifyFeature'),
//
{
	_constructor : OpenLayers.Control.ModifyFeature,
	constructorArguments : {
		/**
		 * Element: layer
		 * {<oll:Vector>} 
		 */
		layer : OpenLayers.Layer.Bean
	},
	constructorOrder : [ 'layer' ],
	options : {
		/**
		 * Element: featureAdded
		 * {Function} Called after the feature is added
		 */
		featureAdded : Legato.Lang.Function,
		/**
		 * Element: handlerOptions
		 * {Object} Used to set non-default properties on the control's handler
		 */
		handlerOptions : Legato.Beans.Object,
		/**
		 * Element: geometryTypes
		 * {String []} To restrict modification to a limited set of geometry
		 * types, send a list of strings corresponding to the geometry class
		 * names.
		 */
		geometryTypes : Legato.Lang['String[]'],
		/**
		 * Element: clickout
		 * {Boolean} Unselect features when clicking outside any feature.
		 * Default is true.
		 */
		clickout : Legato.Lang.Boolean,
		/**
		 * Element: toggle
		 * {Boolean} Unselect a selected feature on click. Default is true.
		 */
		toggle : Legato.Lang.Boolean,

		/**
		 * Element: deleteCodes
		 * {Integer []} Keycodes for deleting verticies.
		 */
		deleteCodes : Legato.Lang['Integer[]'],

		/**
		 * APIProperty: virtualStyle
		 * {Object} A symbolizer to be used for virtual vertices.
		 */
		virtualStyle : Legato.Beans.Object,

		/**
		 * APIProperty: mode
		 * {Integer} Bitfields specifying the modification mode.
		 */
		mode : Legato.Lang.Integer
	}
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:LayerSwitcher
 *
 * Displays a table of contents for the map. This allows the user
 * interface to switch between base layers and to show or hide overlays.
 *
 * Inherits from:
 * - <olc:Control>
 *
 * See also:
 * - <olc> namespace
 * - <OpenLayers.Control.LayerSwitcher>
 * - <lc:Legend>
 */
OpenLayers.Control.LayerSwitcher.Bean = OpenLayers.Control.Bean.Extend(
  'OpenLayers.Control.LayerSwitcher',
  Legato.OpenLayers.Control.QName('LayerSwitcher'),
  {
    options : {
      /**
       * Element: ascending
       * {Boolean}
       */
      ascending : Legato.Lang.Boolean,
        /**
         * Element: activeColor
         * {String}
         */
        activeColor: "darkblue"

    },
    _constructor : OpenLayers.Control.LayerSwitcher
  }
);
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:LoadingPanel
 * 
 * Displays a loading panel across the map when map layers are loading.
 *
 * Inherits from:
 *  - <olc:Control>
 *  
 *  See also:
 *  - <olc> namespace
 *  - <OpenLayers.Control.LoadingPanel>
 *  
 */
OpenLayers.Control.LoadingPanel.Bean = OpenLayers.Control.Bean.Extend(
		'OpenLayers.Control.LoadingPanel', Legato.OpenLayers.Control
				.QName('LoadingPanel'), {
			_constructor : OpenLayers.Control.LoadingPanel
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Control.Scale.Bean = OpenLayers.Control.Bean.Extend(
    'OpenLayers.Control.Scale',
    //
    Legato.OpenLayers.Control.QName('Scale'),
    //
    {
      _constructor :OpenLayers.Control.Scale,
      constructorArguments:
      {
        div: Legato.Lang.Element
      },
      constructorOrder: ['div']
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Control.ScaleLine.Bean = OpenLayers.Control.Bean.Extend(
    'OpenLayers.Control.ScaleLine',
    //
    Legato.OpenLayers.Control.QName('ScaleLine'),
    //
    {
      //_constructor :OpenLayers.Control.ScaleLine,
      factoryFunction : function(options) {

        if (!Legato.Lang.ObjectUtils.exists(options)) {
          options = [];
        }

        if (!Legato.Lang.ObjectUtils.exists(options.bottomInUnits)) {
          options.bottomInUnits = "";
        }

        if (!Legato.Lang.ObjectUtils.exists(options.bottomOutUnits)) {
          options.bottomOutUnits = "";
        }

        var control = new OpenLayers.Control.ScaleLine(options);
        return control;
      },
      options:
      {
        maxWidth:Legato.Lang.Integer,
        topOutUnits: Legato.Lang.String,
        topInUnits:  Legato.Lang.String,
        bottomOutUnits:  Legato.Lang.String,
        bottomInUnits:  Legato.Lang.String,
        eTop: Legato.Lang.Element,
        eBottom: Legato.Lang.Element
      }
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:Navigation
 * 
 * Inherits from:
 * - {<olc:Control>}
 * 
 * See also:
 * - <olc> namespace
 * - {<OpenLayers.Control.Navigation>}
 */
OpenLayers.Control.Navigation.Bean = OpenLayers.Control.Bean.Extend(
		'OpenLayers.Control.Navigation', Legato.OpenLayers.Control
				.QName('Navigation'), {
			_constructor : OpenLayers.Control.Navigation,
			options : {
				// TODO dragPan: null,
				// TODO dragPanOptions: null,
				// TODO zoomBox: null,
				/**
				 * Element: zoomWheelEnabled
				 * {Boolean} Whether the mousewheel should zoom the map.
				 */
				zoomWheelEnabled : Legato.Lang.Boolean,

				/**
				 * Element: handleRightClicks
				 * {Boolean} Whether or not to handle  right clicks. Default is false.
				 */
				handleRightClicks : Legato.Lang.Boolean
			}

		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Control.NavigationHistory.Bean = OpenLayers.Control.Bean.Extend(
    'OpenLayers.Control.NavigationHistory',
    Legato.OpenLayers.Control.QName('NavigationHistory'),
    {
      factoryFunction : function(nextTitle, previousTitle)
      {
        return new OpenLayers.Control.NavigationHistory({
          nextOptions: {
            title: nextTitle
          },
          previousOptions: {
            title: previousTitle
          }
        });
      },
      constructorArguments:
      {
        nextTitle: Legato.Lang.String,
        previousTitle: Legato.Lang.String
      },
      constructorOrder: ['nextTitle', 'previousTitle']
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Control.OverviewMap.Bean = OpenLayers.Control.Bean.Extend(
		'OpenLayers.Control.OverviewMap', Legato.OpenLayers.Control
				.QName('OverviewMap'), {
			factoryFunction : function(options) {
				if (!Legato.Lang.ObjectUtils.exists(options)) {
					options = {};
				}
				if (!Legato.Lang.ObjectUtils.exists(options.mapOptions)) {
					options.mapOptions = {};
				}
				if (!Legato.Lang.ObjectUtils.exists(options.mapOptions.theme)) {
					options.mapOptions.theme = null;
				}
				return new OpenLayers.Control.OverviewMap(options);
			},
			fields : {
				size :OpenLayers.Size.Bean,
				ovmap: OpenLayers.Map.Bean
			}
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:Panel
 *
 * Inherits from:
 * - {<olc:Control>}
 *
 * See also:
 * - <olc> namespace
 * - {<OpenLayers.Control.Panel>}
 */
OpenLayers.Control.Panel.Bean = OpenLayers.Control.Bean.Extend(
    'OpenLayers.Control.Panel', Legato.OpenLayers.Control.QName('Panel'), {
      _constructor : OpenLayers.Control.Panel,
      fields : {
        /**
         * Element: defaultControl
         * {<olc:Control>}
         */
        defaultControl : OpenLayers.Control.Bean,
        /**
         * Element: activeControls
         * {<olc:Control> []}
         */
        activeControls : OpenLayers.Control.Bean.List()
      },
      properties : {
        /**
         * Element: controls
         * {<olc:Control> []}
         */
        controls : new Legato.Beans.Property(OpenLayers.Control.Bean
            .List(), function(panel, controls) {
          panel.addControls(controls);
        })
      },
      afterInstancePopulated : function(panel) {
        if (Legato.Lang.ObjectUtils.exists(panel.activeControls)) {
          for ( var i = 0; i < panel.activeControls.length; i++) {
            panel.activateControl(panel.activeControls[i]);
          }
        }
        if (Legato.Lang.ObjectUtils.exists(panel.defaultControl)) {
          panel.activateControl(panel.defaultControl);
        }
      }
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Control.PanZoom.Bean = OpenLayers.Control.Bean.Extend(
    'OpenLayers.Control.PanZoom',
    //
    Legato.OpenLayers.Control.QName('PanZoom'),
    //
    {
      _constructor :OpenLayers.Control.PanZoom,
      options: {
      /**
       * Property: slideFactor {Integer} Number of pixels by which we'll pan the
       * map in any direction on clicking the arrow buttons.
       */
      slideFactor: Legato.Lang.Integer,

      /**
       * Property: buttons {Array(DOMElement)} Array of Button Divs
       */
      buttons: Legato.Lang['Element[]'],

      /**
       * Property: position {<OpenLayers.Pixel>}
       */
      position: OpenLayers.Pixel.Bean
    }
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:PanZoomBar
 * 
 * Inherits from:
 * - {<olc:Control>}
 * 
 * See also:
 * - <olc> namespace
 * - {<OpenLayers.Control.PanZoomBar>}
 */
OpenLayers.Control.PanZoomBar.Bean = OpenLayers.Control.Bean.Extend(
		'OpenLayers.Control.PanZoomBar',
		//
		Legato.OpenLayers.Control.QName('PanZoomBar'), {
			_constructor : OpenLayers.Control.PanZoomBar,
			options : {
				/**
				 * Element: zoomStopWidth
				 * {Integer}
				 */
				zoomStopWidth : Legato.Lang.Integer,
				/**
				 * Element: zoomStopHeight
				 * {Integer}
				 */
				zoomStopHeight : Legato.Lang.Integer,
				/**
				 * Element: zoomWorldIcon
				 * {Boolean}
				 */
				zoomWorldIcon : Legato.Lang.Boolean
			}
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Control.MouseDefaults.Bean = OpenLayers.Control.Bean.Extend(
//
    'OpenLayers.Control.MouseDefaults',
    //
    Legato.OpenLayers.Control.QName('MouseDefaults'),
    //
    {
      _constructor :OpenLayers.Control.MouseDefaults
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:MousePosition
 * 
 * Inherits from:
 * - {<olc:Control>}
 * 
 * See also:
 * - <olc> namespace
 * - {<OpenLayers.Control.MousePosition>}
 */
OpenLayers.Control.MousePosition.Bean = OpenLayers.Control.Bean.Extend(
		'OpenLayers.Control.MousePosition', Legato.OpenLayers.Control
				.QName('MousePosition'), {
			_constructor : OpenLayers.Control.MousePosition,
			options : {
				/**
				 * Element: element
				 * {DOMElement}
				 */
				element : Legato.Lang.Element,
				/**
				 * Element: prefix
				 * {String}
				 */
				prefix : Legato.Lang.String,
				/**
				 * Element: separator
				 * {String}
				 */
				separator : Legato.Lang.String,
				/**
				 * Element: suffix
				 * {String}
				 */
				suffix : Legato.Lang.String,
				/**
				 * Element: numDigits
				 * {Integer}
				 */
				numDigits : Legato.Lang.Integer,
				/**
				 * Element: granularity
				 * {Integer}
				 */
				granularity : Legato.Lang.Integer,
				/**
				 * Element: displayProjection
				 * {<ol:Projection>}
				 */
				displayProjection : OpenLayers.Projection.Bean
			}
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:ZoomBox
 * 
 * See also:
 * - <olc> namespace
 * - {<OpenLayers.Control.ZoomBox>}
 */
OpenLayers.Control.Zoom.Bean = OpenLayers.Control.Bean.Extend(
		'OpenLayers.Control.Zoom',
		//
		Legato.OpenLayers.Control.QName('Zoom'),
		//
		{
			_constructor : OpenLayers.Control.Zoom,
			options : {
			  /**
		     * APIProperty: zoomInId
		     * {String}
		     * Instead of having the control create a zoom in link, you can provide 
		     *     the identifier for an anchor element already added to the document.
		     *     By default, an element with id "olZoomInLink" will be searched for
		     *     and used if it exists.
		     */
			  zoomInId: Legato.Lang.String,
			  /**
		     * APIProperty: zoomOutId
		     * {String}
		     * Instead of having the control create a zoom out link, you can provide 
		     *     the identifier for an anchor element already added to the document.
		     *     By default, an element with id "olZoomOutLink" will be searched for
		     *     and used if it exists.
		     */
			  zoomOutId: Legato.Lang.String
			}
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:ZoomBox
 * 
 * See also:
 * - <olc> namespace
 * - {<OpenLayers.Control.ZoomBox>}
 */
OpenLayers.Control.ZoomBox.Bean = OpenLayers.Control.Bean.Extend(
		'OpenLayers.Control.ZoomBox',
		//
		Legato.OpenLayers.Control.QName('ZoomBox'),
		//
		{
			_constructor : OpenLayers.Control.ZoomBox,
			options : {
				/**
				 * Element: out
				 * {Boolean} whether to zoom in or out
				 */
				out : Legato.Lang.Boolean
			}
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Control.ZoomInBox = OpenLayers.Class(OpenLayers.Control.ZoomBox, {

	out : false,
	CLASS_NAME : "OpenLayers.Control.ZoomInBox"
});
/**
 * Component: olc:ZoomInBox
 * 
 * Inherits from:
 * - {<olc:ZoomBox>} 

 * See also:
 * - <olc> namespace
 * - <{OpenLayers.Control.ZoomInBox}>
 * - <{OpenLayers.Control.ZoomBox}>
 */
OpenLayers.Control.ZoomInBox.Bean = OpenLayers.Control.ZoomBox.Bean.Extend(
		'OpenLayers.Control.ZoomInBox',
		//
		Legato.OpenLayers.Control.QName('ZoomInBox'),
		//
		{
			_constructor : OpenLayers.Control.ZoomInBox
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Control.ZoomOutBox = OpenLayers.Class(OpenLayers.Control.ZoomBox, {
	out : true,
	CLASS_NAME : "OpenLayers.Control.ZoomOutBox"
});
/**
 * Component: olc:ZoomOutBox
 * 
 * Inherits from:
 * - {<olc:ZoomBox>} 
 *
 * See also:
 * - <olc> namespace
 * - <{OpenLayers.Control.ZoomOutBox}>
 * - <{OpenLayers.Control.ZoomBox}>
 */
OpenLayers.Control.ZoomOutBox.Bean = OpenLayers.Control.ZoomBox.Bean.Extend(
		'OpenLayers.Control.ZoomOutBox',
		//
		Legato.OpenLayers.Control.QName('ZoomOutBox'),
		//
		{
			_constructor : OpenLayers.Control.ZoomOutBox
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Control.ZoomOut.Bean = OpenLayers.Control.Bean.Extend(
		'OpenLayers.Control.ZoomOut',
    //
    Legato.OpenLayers.Control.QName('ZoomOut'),
    //
		{
		  _constructor :OpenLayers.Control.ZoomOut
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:ZoomToMaxExtent
 * 
 * Zooms out to the maximum extent of the map. It is designed to be used with a 
 * <olc:Panel>.
 * 
 * Inherits from:
 * - <olc:Control>
 * 
 * See also:
 * - <olc> namespace
 * - {<OpenLayers.Control.ZoomToMaxExtent>}
 */
OpenLayers.Control.ZoomToMaxExtent.Bean = OpenLayers.Control.Bean.Extend(
		'OpenLayers.Control.ZoomToMaxExtent',
		//
		Legato.OpenLayers.Control.QName('ZoomToMaxExtent'),
		//
		{
			_constructor : OpenLayers.Control.ZoomToMaxExtent
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Popup.MarginAwareFramedCloud =
  OpenLayers.Class(OpenLayers.Popup.FramedCloud, {
    getContentDivPadding: function() {

      //use cached value if we have it
      var contentDivPadding = this._contentDivPadding;
      if (!contentDivPadding) {

        if (this.div.parentNode === null) {
          //make the div invisible and add it to the page
            this.div.style.display = "none";
            document.body.appendChild(this.div);
        }

        //read the padding settings from css, put them in an OL.Bounds
        var _contentDivPadding = new OpenLayers.Bounds(
            OpenLayers.Element.getStyle(this.contentDiv, "padding-left"),
            OpenLayers.Element.getStyle(this.contentDiv, "padding-bottom"),
            OpenLayers.Element.getStyle(this.contentDiv, "padding-right"),
            OpenLayers.Element.getStyle(this.contentDiv, "padding-top")
        );

        var _contentDivMargin = new OpenLayers.Bounds(
            OpenLayers.Element.getStyle(this.contentDiv, "margin-left"),
            OpenLayers.Element.getStyle(this.contentDiv, "margin-bottom"),
            OpenLayers.Element.getStyle(this.contentDiv, "margin-right"),
            OpenLayers.Element.getStyle(this.contentDiv, "margin-top")
        );

        contentDivPadding  = new OpenLayers.Bounds(
            _contentDivPadding.left + _contentDivMargin.left,
            _contentDivPadding.bottom + _contentDivMargin.bottom,
            _contentDivPadding.right + _contentDivMargin.right,
            _contentDivPadding.top + _contentDivMargin.top
        );

        //cache the value
        this._contentDivPadding = contentDivPadding;

        if (this.div.parentNode === document.body) {
          //remove the div from the page and make it visible again
          document.body.removeChild(this.div);
          this.div.style.display = "";
        }
      }
      return contentDivPadding;
    },
    CLASS_NAME: "OpenLayers.Popup.MarginAwareFramedCloud"
  });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Service
 * Abstract base class for all Legato Services
 */
Legato.Service = OpenLayers.Class({
  initialize: function (options) {
    OpenLayers.Util.extend(this, options);
    this.options = options;
  },

  CLASS_NAME: 'Legato.Service'
});

/*
 * Property: Legato.Service.BUSY
 *
 * Static const which indicates that the current <Legato.Service> is busy and
 * that you should try again later.
 */
Legato.Service.BUSY  = -99;
Legato.Service.ERROR = -999;

Legato.Service.NAMESPACE_URI = 'http://www.disy.net/legato/service';
Legato.Service.PREFIX = 'ls';
Legato.Service.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Service.NAMESPACE_URI, localPart,
      Legato.Service.PREFIX);
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Rev: 70190 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: Legato.Service.LayerCapabilities
 * Central Legato LayerCapabilities Service which provides some additional informations for a
 * given layer.
 *
 * Inherits from: - <Legato.Service>
 */
Legato.Service.LayerCapabilities = OpenLayers.Class(Legato.Singleton, Legato.Service,
{
  /*
   * Used for internal caching. Key is the layer url, value the layers capabilites
   */
  cache: null,

  /*
   * Function: initialize
   * Basic ctor
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control
   */
  initialize : function(options) {
    Legato.Service.prototype.initialize.apply(this, arguments);
    this.cache = [];
  },

  /*
   * common validate functions which ensures that given arguments
   * contain the needed objects.
   *
   * Parameters:
   * args - {Object} A hashmap which contains a layer and a callBack function
   */
  validateArguments: function(args){
    if(typeof args.layer != 'object' ||
       typeof args.layer.CLASS_NAME == 'undefined' ||
       args.layer.CLASS_NAME != 'OpenLayers.Layer.WMS'){
      throw('Need a valid argument layer which needs to be an OpenLayers.Layer.WMS instance');
    }

    if(typeof args.onComplete != 'function'){
      throw ('Missing needed argument onComplete which has to be a function');
    }

    /*
     * Cause this service allways returns its result in given arg hashmap with the named key
     * result we have to ensure
     */
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(args.result)){
      throw new Legato.Lang.IllegalArgumentException('Given arguments allready contain a result. Please ensure that the key result is never used');
    }
  },

  /*
   * Determines if wanted capabilitites are cached allready
   * and if so provides them from cache. If not an AJAX request
   * is triggered.
   *
   * Parameters:
   * args - {Object} A hashmap which contains a <OpenLayers.Layer> and a callBack function
   */
  loadCapabilitites: function(args){
    if(typeof this.cache[args.layer.url] == 'undefined'){
      this.cache[args.layer.url]    = Legato.Service.BUSY;
      try{
        var that = this;
        OpenLayers.Request.GET({
          url: args.layer.url,
          params: ({
            REQUEST: 'GetCapabilities',
            SERVICE: 'WMS'
          }),
          scope: that,
          success: function(request){
            /*
             * Fired if AJAX request returned successfully
             */
             var wms = new OpenLayers.Format.WMSCapabilities();
             var doc = wms.read(request.responseText);
             this.cache[args.layer.url] = doc;
             args.onComplete(this.cache[args.layer.url]);
           },
          failure: function(request){
            /*
             * Fire if AJAX request causes an error
             */
             if(typeof args.onError  != 'function'){
               OpenLayers.Console.warn(request);
               return;
             }
             args.onError(request );
           }
        });
        return;
      } catch(exp){
        this.cache[args.layer.url] = null;
        if(typeof args.onError  != 'function'){
          OpenLayers.Console.warn(exp);
          return;
        }
        args.onError(exp);
      }
    }
    args.onComplete(this.cache[args.layer.url]);
  },

  /*
   * Function: getCapabilitites
   * Gets the capabiltites for given layer. If capabilities could been loaded
   * the onComplete callback method will be executed. All given args will been
   * given back in callback method plus a new key entry 'result' where the capabilities result
   * will be stored into.
   *
   * (start code)
   * //The followin example shows a valid result
   * onComplete(
   *   result: {
   *     capabilities: {
   *       ...
   *     }
   *   }
   * )
   *
   * //This is an example if current service is busy
   * onComplete(
   *   result: Legato.Service.BUSY
   * )
   * (end)
   *
   *
   * Parameters:
   * args - {Object} A hashmap which contains a layer and a callBack function
   *
   * The following keys are supported:
   * - layer {<OpenLayers.Layer>} The layer from which you want its capabilites
   * - onComplete - {Function} fired if capabilites are loaded or if service is currently busy
   *
   * See also:
   * <Legato.Service.BUSY>
   */
  getCapabilitites: function(args){
    this.validateArguments(args);
    this.loadCapabilitites({
      layer: args.layer,
      onComplete: OpenLayers.Function.bind(function(doc){
        var context = doc === Legato.Service.BUSY ?
          this.createResultContext(Legato.Service.BUSY, args) :
          this.createResultContext({capabilitites: doc}, args);
        args.onComplete(context);
        return;
      }, this),
      onError: args.onError
    });
  },

  /*
   * Small helper function which creates a new context hashmap,
   * copies given context into it, appends afterwards given
   * result and returns it.
   */
  createResultContext: function(result, previousContext){
    //Create a new context and put our result in it
    var context = {};
    //Copy the previous context into our new context
    OpenLayers.Util.extend(context, previousContext);
    //Append given result
    context.result = result;
    return context;
  },

  /*
   * Function: getLegendUrl
   * Tries to determine the legendUrl for given layer and executes the callBack method
   * if found.
   * (start code)
   * //The followin example shows a valid result
   * onComplete(
   *   result: {
   *     legendUrl: {
   *       ...
   *     }
   *   }
   * )
   *
   * //This is an example if current service is busy
   * onComplete(
   *   result: Legato.Service.BUSY
   * )
   * (end)
   *
   * Parameters:
   * args - {Object} A hashmap which contains a layer and a callBack function
   *
   * The following keys are supported:
   * - layer {<OpenLayers.Layer>} The layer from which you want its capabilites
   * - onComplete - {Function} fired if capabilites are loaded or if service is currently busy
   *
   * See also:
   * <Legato.Service.BUSY>
   */
  getLegendUrl: function(args){
    this.validateArguments(args);
    this.loadCapabilitites({
      layer: args.layer,
      onComplete: OpenLayers.Function.bind(function(doc){
        if(doc === Legato.Service.BUSY){
          OpenLayers.Console.debug('I am busy right now. Try again later');
          args.onComplete(this.createResultContext(doc, args));
          return;
        }
        var layercapabilities = null;

        if(Legato.Lang.ObjectUtils.isNullOrUndefined(doc) ||
           Legato.Lang.ObjectUtils.isNullOrUndefined(doc.capability) ||
           Legato.Lang.ObjectUtils.isNullOrUndefined(doc.capability.layers)){
          return;
        }

        for(var i = 0; i < doc.capability.layers.length; i++){
          if(doc.capability.layers[i].name != args.layer.name){
            continue;
          }
          layercapabilities = doc.capability.layers[i];
        }

        if(layercapabilities === null || layercapabilities.styles.length === 0){
          OpenLayers.Console.debug('There is no legendUrl');
          args.onComplete(this.createResultContext({legendUrl: null}, args));
          return;
        }

        OpenLayers.Console.debug('There is a legendUrl');
        args.onComplete(this.createResultContext({legendUrl: layercapabilities.styles[0].legend}, args));
        return;
      }, this),
      onError: args.onError
    });
  },

  CLASS_NAME : 'Legato.Service.LayerCapabilities'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Service.CapabilitiesURLs = {};

Legato.Service.CapabilitiesURLs.Bean = Legato.Beans.Object.Extend(
    'Legato.Service.CapabilitiesURLs',
    Legato.Service.QName('CapabilitiesURLs'), {
      factoryFunction : function(urls) {
        return urls;
      },
      constructorArguments : {
        urls :Legato.Lang['String[]']
      },
      constructorOrder : [ 'urls' ],
      afterInstancePopulated : function(urls) {
        for ( var index = 0; index < urls.length; index ++) {
          // logger.info('Registering URL:' + urls[index]);
    }
  }
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Handler = {};
Legato.Handler.NAMESPACE_URI = 'http://www.disy.net/legato/handler';
Legato.Handler.PREFIX = 'lla';
Legato.Handler.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Handler.NAMESPACE_URI, localPart,
      Legato.Handler.PREFIX);
};
Legato.Handler.Bean = Legato.Beans.Object.Extend('Legato.Handler',
    //
    Legato.Handler.QName('Bean'),
    //
    {
  _constructor :Legato.Handler
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Handler.Box = OpenLayers.Class(OpenLayers.Handler.Box, {
  endBox : function(end) {
    var result;
    if (Math.abs(this.dragHandler.start.x - end.x) > 5
        || Math.abs(this.dragHandler.start.y - end.y) > 5) {
      var start = this.dragHandler.start;
      var top = Math.min(start.y, end.y);
      var bottom = Math.max(start.y, end.y);
      var left = Math.min(start.x, end.x);
      var right = Math.max(start.x, end.x);
      
      var lowerLeftLonLat = this.map.getLonLatFromPixel(new OpenLayers.Pixel(
          left, bottom));
      var upperRightLonLat = this.map.getLonLatFromPixel(new OpenLayers.Pixel(
          right, top));
      var bounds = new OpenLayers.Bounds(lowerLeftLonLat.lon,
          lowerLeftLonLat.lat, upperRightLonLat.lon, upperRightLonLat.lat);
      result = bounds.toGeometry();
    } else {
      var xy = this.dragHandler.start.clone();
      var lonLat = this.map.getLonLatFromPixel(xy);
      result = new OpenLayers.Geometry.Point(lonLat.lon, lonLat.lat);
    }
    this.removeBox();
    this.callback("done", [ result ]);
  },

  CLASS_NAME :"Legato.Handler.Box"
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Handler.Path = OpenLayers.Class(OpenLayers.Handler.Path, {
  initialize: function(control, callbacks, options) {
    var opts = options;
    if (!options) {
      opts = {};
    }
    if (!opts.layerOptions) {
      opts.layerOptions = {};
    }
    opts.layerOptions.legatoIgnore = true;
    OpenLayers.Handler.Path.prototype.initialize.apply(this, [control, callbacks, opts]);
  },
  mousedown : function(evt) {
    if (this.drawing && evt.ctrlKey) {
      OpenLayers.Handler.Path.prototype.mousedown.apply(this, arguments);
      this.dblclick(evt);
      return false;
    } else {
      return OpenLayers.Handler.Path.prototype.mousedown.apply(this, arguments);
    }
  },
  geometryClone : function() {
    var originalGeometry = this.line && this.line.geometry;
    if (originalGeometry) {
      var originalGeometryId = originalGeometry.id;
      originalGeometry.id = OpenLayers.Util.createUniqueID(originalGeometry.CLASS_NAME+ "_");
      var clonedGeometry = originalGeometry.clone();
      clonedGeometry.id = originalGeometryId;
      this.line.geometry = clonedGeometry;
      if (this.multi) {
        return new OpenLayers.Geometry.MultiLineString([ originalGeometry ]);
      } else {
        return originalGeometry;
      }
    }
    return originalGeometry;
  },
  CLASS_NAME : "Legato.Handler.Path"
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Handler.Point = OpenLayers.Class(OpenLayers.Handler.Point, {
  initialize: function(control, callbacks, options) {
    var opts = options;
    if (!options) {
      opts = {};
    }
    if (!opts.layerOptions) {
      opts.layerOptions = {};
    }
    opts.layerOptions.legatoIgnore = true;
    OpenLayers.Handler.Point.prototype.initialize.apply(this, [control, callbacks, opts]);
  },
  geometryClone : function() {
    var originalGeometry = this.point && this.point.geometry;
    if (originalGeometry) {
      var originalGeometryId = originalGeometry.id;
      originalGeometry.id = OpenLayers.Util.createUniqueID(originalGeometry.CLASS_NAME+ "_");
      var clonedGeometry = originalGeometry.clone();
      clonedGeometry.id = originalGeometryId;
      this.point.geometry = clonedGeometry;
      if (this.multi) {
        return new OpenLayers.Geometry.MultiPoint([ originalGeometry ]);
      } else {
        return originalGeometry;
      }
    }
    return originalGeometry;
  },
  CLASS_NAME : "Legato.Handler.Point"
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Handler.Polygon = OpenLayers.Class(OpenLayers.Handler.Polygon, {
  initialize: function(control, callbacks, options) {
    var opts = options;
    if (!options) {
      opts = {};
    }
    if (!opts.layerOptions) {
      opts.layerOptions = {};
    }
    opts.layerOptions.legatoIgnore = true;
    OpenLayers.Handler.Polygon.prototype.initialize.apply(this, [control, callbacks, opts]);
  },
  mousedown : function(evt) {
    if (this.drawing && evt.ctrlKey) {
      OpenLayers.Handler.Polygon.prototype.mousedown.apply(this, arguments);
      this.dblclick(evt);
      return false;
    } else {
      return OpenLayers.Handler.Polygon.prototype.mousedown.apply(this, arguments);
    }
  },
  geometryClone : function() {
    var originalGeometry = this.polygon && this.polygon.geometry;
    if (originalGeometry) {
      var originalGeometryId = originalGeometry.id;
      originalGeometry.id = OpenLayers.Util.createUniqueID(originalGeometry.CLASS_NAME+ "_");
      var clonedGeometry = originalGeometry.clone();
      clonedGeometry.id = originalGeometryId;
      this.polygon.geometry = clonedGeometry;
      if (this.multi) {
        return new OpenLayers.Geometry.MultiPolygon([ originalGeometry ]);
      } else {
        return originalGeometry;
      }
    }
    return originalGeometry;
  },
  CLASS_NAME : "Legato.Handler.Polygon"
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Handler.RegularPolygon = OpenLayers.Class(OpenLayers.Handler.RegularPolygon, {
  initialize: function(control, callbacks, options) {
    var opts = options;
    if (!options) {
      opts = {};
    }
    if (!opts.layerOptions) {
      opts.layerOptions = {};
    }
    opts.layerOptions.legatoIgnore = true;
    OpenLayers.Handler.RegularPolygon.prototype.initialize.apply(this, [control, callbacks, opts]);
  },
  mousedown : function(evt) {
    if (this.drawing && evt.ctrlKey) {
      OpenLayers.Handler.RegularPolygon.prototype.mousedown.apply(this, arguments);
      this.dblclick(evt);
      return false;
    } else {
      return OpenLayers.Handler.RegularPolygon.prototype.mousedown.apply(this, arguments);
    }
  },
  geometryClone : function() {
    var originalGeometry = this.feature && this.feature.geometry;
    if (originalGeometry) {
      var originalGeometryId = originalGeometry.id;
      originalGeometry.id = OpenLayers.Util.createUniqueID(originalGeometry.CLASS_NAME+ "_");
      var clonedGeometry = originalGeometry.clone();
      clonedGeometry.id = originalGeometryId;
      this.feature.geometry = clonedGeometry;
      if (this.multi) {
        return new OpenLayers.Geometry.MultiPolygon([ originalGeometry ]);
      } else {
        return originalGeometry;
      }
    }
    return originalGeometry;
  },
  CLASS_NAME : "Legato.Handler.RegularPolygon"
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @requires OpenLayers/Handler.js
 * @requires OpenLayers/Handler/MouseWheel.js
 */

/**
 * Class: Legato.Handler.MouseWheel
 * Handler for wheel up/down events
 *
 * Extension to OpenLayers:
 * Functionality to detect mousewheel-interaction on the map-div itself
 *
 * Inherits from:
 *  - <OpenLayers.Handler.MouseWheel>
 */
Legato.Handler.MouseWheel = OpenLayers.Class(OpenLayers.Handler.MouseWheel, {
    /**
     * Property: interval
     * {Integer} In order to increase server performance, an interval (in
     *     milliseconds) can be set to reduce the number of up/down events
     *     called. If set, a new up/down event will not be set until the
     *     interval has passed.
     *     Defaults to 0, meaning no interval.
     */
    interval: 100,

    /**
     * Constructor: Legato.Handler.MouseWheel
     *
     * Parameters:
     * control - {<OpenLayers.Control>}
     * callbacks - {Object} An object containing a single function to be
     *                          called when the drag operation is finished.
     *                          The callback should expect to recieve a single
     *                          argument, the point geometry.
     * options - {Object}
     */
    initialize: function(control, callbacks, options) {
        OpenLayers.Handler.prototype.initialize.apply(this, arguments);
        this.wheelListener = OpenLayers.Function.bindAsEventListener(
            this.onWheelEvent, this
        );
    },

    /**
     * Method: onWheelEvent
     * Catch the wheel event and handle it xbrowserly
     *
     * Parameters:
     * e - {Event}
     */
    onWheelEvent: function(e){
        // make sure we have a map and check keyboard modifiers
        if (!this.map || !this.checkModifiers(e)) {
            return;
        }

        // Ride up the element's DOM hierarchy to determine if it or any of
        //  its ancestors was:
        //   * specifically marked as scrollable
        //   * one of our layer divs
        //   * the map div
        //
        var overScrollableDiv = false;
        var overLayerDiv = false;
        var overMapDiv = false;

        var elem = OpenLayers.Event.element(e);
        while((elem !== null) && !overMapDiv && !overScrollableDiv) {

            if (!overScrollableDiv) {
                try {
                  var overflow=null;
                    if (elem.currentStyle) {
                        overflow = elem.currentStyle.overflow;
                    } else {
                        var style =
                            document.defaultView.getComputedStyle(elem, null);
                        overflow = style.getPropertyValue("overflow");
                    }
                    overScrollableDiv = ( overflow &&
                        ((overflow === "auto") || (overflow === "scroll") ));
                } catch(err) {
                    //sometimes when scrolling in a popup, this causes
                    // obscure browser error
                }
            }

            if (!overLayerDiv) {
                for(var i=0, len=this.map.layers.length; i<len; i++) {
                    // Are we in the layer div? Note that we have two cases
                    // here: one is to catch EventPane layers, which have a
                    // pane above the layer (layer.pane)
                    if (elem === this.map.layers[i].div
                        || elem === this.map.layers[i].pane
                        || elem === this.map.div) {
                        overLayerDiv = true;
                        break;
                    }
                }
            }
            overMapDiv = (elem === this.map.div);

            elem = elem.parentNode;
        }

        // Logic below is the following:
        //
        // If we are over a scrollable div or not over the map div:
        //  * do nothing (let the browser handle scrolling)
        //
        //    otherwise
        //
        //    If we are over the layer div:
        //     * zoom/in out
        //     then
        //     * kill event (so as not to also scroll the page after zooming)
        //
        //       otherwise
        //
        //       Kill the event (dont scroll the page if we wheel over the
        //        layerswitcher or the pan/zoom control)
        //
        if (!overScrollableDiv && overMapDiv) {
            if (overLayerDiv) {
                var delta = 0;
                if (!e) {
                    e = window.event;
                }
                if (e.wheelDelta) {
                    delta = e.wheelDelta/120;
                    if (window.opera && window.opera.version() < 9.2) {
                        delta = -delta;
                    }
                } else if (e.detail) {
                    delta = -e.detail / 3;
                }
                this.delta = this.delta + delta;

                if(this.interval) {
                    window.clearTimeout(this._timeoutId);
                    this._timeoutId = window.setTimeout(
                        OpenLayers.Function.bind(function(){
                            this.wheelZoom(e);
                        }, this),
                        this.interval
                    );
                } else {
                    this.wheelZoom(e);
                }
            }
            OpenLayers.Event.stop(e);
        }
    },

    CLASS_NAME: "Legato.Handler.MouseWheel"
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Handler.MultiPoint = OpenLayers.Class(Legato.Handler.Point, {
  multi: true,
  CLASS_NAME : "Legato.Handler.MultiPoint"
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Handler.MultiLineString = OpenLayers.Class(Legato.Handler.Path, {
  multi: true,
  CLASS_NAME : "Legato.Handler.MultiLineString"
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Handler.MultiPolygon= OpenLayers.Class(Legato.Handler.Polygon, {
  multi: true,
  CLASS_NAME : "Legato.Handler.MultiPolygon"
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikoc $
 * @version $Revision: 69543 $
 */

Legato.I18n = {};

/**
 * Space: li18n
 * URI: Namespace URI
 * http://www.disy.net/legato/i18n
 */
Legato.I18n.NAMESPACE_URI = 'http://www.disy.net/legato/i18n';

/**
 * Prefix: Default prefix
 * li18n
 */
Legato.I18n.PREFIX = 'li18n';

Legato.I18n.LOCALE = null;

Legato.I18n.MESSAGE_SOURCE = null;

Legato.I18n.QName = function(localPart) {
  return new Legato.XML.QName(Legato.I18n.NAMESPACE_URI, localPart,
      Legato.I18n.PREFIX);
};

Legato.I18n.setLocale = function(locale) {
  Legato.Util.Ensure.ensureNotEmptyString(locale);
  Legato.I18n.LOCALE = locale;
  OpenLayers.Lang.setCode(locale);
};

Legato.I18n.getMessage = function(key, context)
{
  if (!Legato.Lang.ObjectUtils.exists(Legato.I18n.MESSAGE_SOURCE))
  {
    Legato.I18n.MESSAGE_SOURCE = new Legato.I18n.MessageSource({'locale' : Legato.I18n.LOCALE, 'messages' : Legato.I18n.Messages});
  }
  return Legato.I18n.MESSAGE_SOURCE.getMessage(key, context);
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.I18n.BrowserLocaleFactoryBean = OpenLayers
    .Class( {
      defaultLocale :'en',
      supportedLocales :null,
      supportedLocalesSet :null,
      initialize : function(options) {
        OpenLayers.Util.extend(this, options);
        if (!Legato.Lang.ObjectUtils.exists(this.supportedLocales)) {
          this.supportedLocales = Legato.I18n.Messages.supportedLocales;
        }

        this.supportedLocalesSet = new Legato.Util.HashSet();
        for ( var index = 0; index < this.supportedLocales.length; index++) {
          this.supportedLocalesSet.add(this.supportedLocales[index]);
        }
      },
      getInstance : function() {
        var possibleLocales = [];

        possibleLocales.push(this.defaultLocale);

        var code = (OpenLayers.Util.getBrowserName() == "msie") ? navigator.userLanguage
            : navigator.language;
        var parts = code.split('-');

        if (parts.length >= 1) {
          possibleLocales.push(parts[0].toLowerCase());
        }

        if (parts.length >= 2) {
          possibleLocales.push(parts[0].toLowerCase() + '-'
              + parts[1].toUpperCase());
        }

        if (parts.length >= 3) {
          possibleLocales.push(parts[0].toLowerCase() + '-'
              + parts[1].toUpperCase() + '-' + parts[2]);
        }

        for ( var index = possibleLocales.length - 1; index >= 0; --index) {
          if (this.supportedLocalesSet.contains(possibleLocales[index])) {
            return possibleLocales[index];
          }
        }

        return this.defaultLocale;
      },
      CLASS_NAME :'Legato.I18n.BrowserLocaleFactoryBean'
    });

Legato.I18n.BrowserLocaleFactoryBean.Bean = Legato.Beans.Object.Extend(
    'Legato.I18n.BrowserLocaleFactoryBean',
    //
    Legato.I18n.QName('BrowserLocale'),
    //
    {
      _constructor :Legato.I18n.BrowserLocaleFactoryBean,
      options : {
        defaultLocale :Legato.Lang.String,
        supportedLocales :Legato.Lang.String.List()
      }
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikoc $
 * @version $Revision: 69543 $
 */

Legato.I18n.Messages = {};
Legato.I18n.Messages.dictionaries = {};
Legato.I18n.Messages.supportedLocales = [];
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.I18n.MessageSource = OpenLayers.Class( {
  locale :null,
  messages :null,
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
    if (!Legato.Lang.ObjectUtils.exists(this.locale)) {
      this.locale = (new Legato.I18n.BrowserLocaleFactoryBean()).getInstance();
    }
    if (!Legato.Lang.ObjectUtils.exists(this.messages)) {
      this.messages = Legato.I18n.Messages;
    }
  },

  containsMessage : function(key) {
    var dictionary = this.messages.dictionaries[this.locale];

    if (Legato.Lang.ObjectUtils.exists(dictionary)) {
      var message = dictionary[key];
      if (Legato.Lang.ObjectUtils.exists(message)) {
        return true;
      } else {
        return false;
      }
    } else {
      return false;
    }
  },

  getMessage : function(key, context) {

    var dictionary = this.messages.dictionaries[this.locale];

    if (Legato.Lang.ObjectUtils.exists(dictionary)) {
      var message = dictionary[key];
      if (Legato.Lang.ObjectUtils.exists(message)) {
        return OpenLayers.String.format(message, context);
      } else {
        return '???' + key + '???';
      }
    } else {
      return '???' + key + '???';
    }
  },
  CLASS_NAME :'Legato.I18n.MessageSource'
});

Legato.I18n.MessageSource.Bean = Legato.Beans.Object.Extend(
    'Legato.I18n.MessageSource',
    //
    Legato.I18n.QName('MessageSource'),
    //
    {
      _constructor :Legato.I18n.MessageSource,
      options : {
        locale :Legato.Lang.String
      }
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.I18n.Message = OpenLayers.Class( {
  message: '',
  context: null,
  messageSource :null,
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
    if (!Legato.Lang.ObjectUtils.exists(this.messageSource)) {
      this.messageSource = new Legato.I18n.MessageSource();
    }
  },

  getInstance : function() {
    return this.messageSource.getMessage(this.message, this.context);
  },
  CLASS_NAME :'Legato.I18n.Message'
});

Legato.I18n.Message.Bean = Legato.Beans.Object.Extend(
    'Legato.I18n.Message',
    //
    Legato.I18n.QName('Message'),
    //
    {
      _constructor :Legato.I18n.Message,
      options : {
        message :Legato.Lang.String,
        messageSource: Legato.I18n.MessageSource.Bean,
        context: Legato.Beans.Object
      }
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Revision: 69543 $
 */

Legato.I18n.Messages.dictionaries.de = OpenLayers.Lang.de;

Legato.I18n.Messages.dictionaries.de['Legato.Control.SetMapSize'] = "Setzt die Kartengr\u00f6\u00dfe";
Legato.I18n.Messages.dictionaries.de['OpenLayers.Control.ZoomToMaxExtent'] = "Auf maximal Ausschnitt vergr\u00f6\u00dfern";
Legato.I18n.Messages.dictionaries.de['Legato.Control.DrawText.TextPrompt'] = "Geben Sie bitte den Text für das Text-Zeichenobjekt ein.";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.LayerName'] = "Zeichenthema";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.Title'] = "Zeichenwerkzeuge";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.Abstract'] = "Bitte wählen Sie das Zeichenwerkzeug und erfassen oder modifizieren Sie mit der Maus die Geometrie.";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.ControlsPanel.Title'] = "Zeichenwerkzeug";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.Text'] = "Text";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.Point'] = "Punkt";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.Line'] = "Linienzug";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.Polygon'] = "Polygon";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.Circle'] = "Kreis";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.Edit'] = "Bearbeiten";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.Delete'] = "Löschen";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.Execute'] = "Erfassung abschließen";
Legato.I18n.Messages.dictionaries.de['Legato.Control.SketchLayerEditor.Cancel'] = "Abbrechen";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.AbstractInputElement.fontFamily'] = "Schriftart";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.AbstractInputElement.fontColor'] = "Schriftfarbe";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.AbstractInputElement.fontSize'] = "Schriftgrad";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.AbstractInputElement.fontStyle'] = "Schriftschnitt";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.AbstractInputElement.fontWeight'] = "Schriftstärke";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.AbstractInputElement.fillColor'] = "Füllfarbe";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.AbstractInputElement.pointRadius'] = "Radius";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.AbstractInputElement.strokeWidth'] = "Linienstärke";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.AbstractInputElement.strokeColor'] = "Linienfarbe";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.AbstractInputElement.strokeDashstyle'] = "Linientyp";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.Factory.fontStyle.normal'] = "normal";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.Factory.fontStyle.italic'] = "kursiv";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.Factory.fontWeight.normal'] = "normal";
Legato.I18n.Messages.dictionaries.de['Legato.StyleProperties.Factory.fontWeight.bold'] = "fett";

Legato.I18n.Messages.supportedLocales.push('de');

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Revision: 69543 $
 */

Legato.I18n.Messages.dictionaries.en = OpenLayers.Lang.en;

Legato.I18n.Messages.dictionaries.en['Legato.Control.SetMapSize'] = "Sets map size";
Legato.I18n.Messages.dictionaries.en['OpenLayers.Control.ZoomToMaxExtent'] = "Zoom to maximum extent";
Legato.I18n.Messages.dictionaries.en['Legato.Control.DrawText.TextPrompt'] = "Please enter the text for the text object.";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.LayerName'] = "Sketch layer";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.Title'] = "Drawing tools";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.Abstract'] = "Please select the drawing tool and capture or modify the geometry with the mouse.";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.ControlsPanel.Title'] = "Drawing tool";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.Text'] = "Text";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.Point'] = "Point";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.Line'] = "Line";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.Polygon'] = "Polygon";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.Circle'] = "Circle";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.Edit'] = "Edit";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.Delete'] = "Delete";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.Execute'] = "Complete capture";
Legato.I18n.Messages.dictionaries.en['Legato.Control.SketchLayerEditor.Cancel'] = "Cancel";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.AbstractInputElement.fontFamily'] = "Font family";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.AbstractInputElement.fontColor'] = "Color";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.AbstractInputElement.fontSize'] = "Size";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.AbstractInputElement.fontStyle'] = "Style";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.AbstractInputElement.fontWeight'] = "Weight";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.AbstractInputElement.fillColor'] = "Fill color";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.AbstractInputElement.pointRadius'] = "Radius";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.AbstractInputElement.strokeWidth'] = "Stroke width";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.AbstractInputElement.strokeColor'] = "Stroke color";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.AbstractInputElement.strokeDashstyle'] = "Dashstyle";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.Factory.fontStyle.normal'] = "normal";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.Factory.fontStyle.italic'] = "italic";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.Factory.fontWeight.normal'] = "normal";
Legato.I18n.Messages.dictionaries.en['Legato.StyleProperties.Factory.fontWeight.bold'] = "bold";

Legato.I18n.Messages.supportedLocales.push('en');

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Popup = OpenLayers.Class({

  title: null,

  size: null,

  position: null,

  zIndex: null,

  initialize : function(options) {
    Legato.Util.Ensure.ensureExists(options.title, 'title should be defined');
    OpenLayers.Util.extend(this, options);
  },

  openUrl : function(url) {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
      ' must implement the openUrl function from from abstract class ' +
      Legato.Popup.CLASS_NAME);
  },

  open : function(element) {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
      ' must implement the open function from from abstract class ' +
      Legato.Popup.CLASS_NAME);
  },

  close : function() {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
      ' must implement the close function from from abstract class ' +
      Legato.Popup.CLASS_NAME);
  },

  setPosition: function(position){
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(position)){
      if((Legato.Lang.ObjectUtils.isNullOrUndefined(this.maintainPosition) ||
          Legato.Lang.ObjectUtils.isFalse(this.maintainPosition))){
          this.position = position;
          this.dialog.dialog( 'option', 'position', [this.position.x, this.position.y] );
      }
    }
  },

  getPosition: function(){
    return this.position;
  },

  CLASS_NAME :'Legato.Popup'
});

/**
 * Space: lpo
 * Namespace for Legato popups.
 */
/**
 * URI: Namespace URI
 * {http://www.disy.net/legato/popup}
 */
Legato.Popup.NAMESPACE_URI = 'http://www.disy.net/legato/popup';
/**
 * Prefix: Default prefix
 * {lpo}
 */
Legato.Popup.PREFIX = 'lpo';

Legato.Popup.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Popup.NAMESPACE_URI, localPart,
      Legato.Popup.PREFIX);
};

/**
 * Component: lpo:Popup
 *
 * Abstract base component for popup components.
 *
 * See also:
 * - <lpo> namespace
 * - <Legato.Popup>
 */
Legato.Popup.Bean = Legato.Beans.Object.Extend('Legato.Popup',
Legato.Popup.QName('Popup'),
//
{
  _constructor : Legato.Popup,
  options : {
    /**
     * Element: title
     * {String} A popup title.
     */
    title: Legato.Lang.String,

    /**
     * Element: size
     * {<OpenLayers.Size>} The initial size of the popup.
     */
    size: OpenLayers.Size,

    /**
     * Element: position
     * {<OpenLayers.Pixel>} The initial position of the popup.
     */
    position: OpenLayers.Pixel,

    /**
     * Element: zIndex
     * {Integer} The zIndex for the popup.
     */
    zIndex: Legato.Lang.Integer,
    
    /**
     * Element: maxHeight
     * {Integer} The maximum allowed height for the popup.
     */
    maxHeight: Legato.Lang.Integer,
    
    /**
     * Element: height
     * {Integer} The initial height of the popup.
     */    
    height: Legato.Lang.Integer,
    
    /**
     * Element: width
     * {Integer} The initial height of the popup.
     */    
    width: Legato.Lang.Integer,
    
    /**
     * Element: maintainPosition
     * {String} Maintain the last position of the popup set by user
     */
    maintainPosition: Legato.Lang.Boolean
  }

});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer = {};
Legato.Layer.NAMESPACE_URI = 'http://www.disy.net/legato/layer';
Legato.Layer.PREFIX = 'lla';
Legato.Layer.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Layer.NAMESPACE_URI, localPart,
      Legato.Layer.PREFIX);
};
Legato.Layer.Bean = Legato.Beans.Object.Extend('Legato.Layer',
    //
    Legato.Layer.QName('Bean'),
    //
    {
  _constructor :Legato.Layer
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Predicate = OpenLayers.Class({
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(layer) {
    return true;
  },
  CLASS_NAME : 'Legato.Layer.Predicate'
});

/**
 * Space: llpr
 * Namespace for Legato layer predicates.
 */
/**
 * URI: Namespace URI
 * {http://www.disy.net/legato/layer/predicate}
 */
Legato.Layer.Predicate.NAMESPACE_URI = 'http://www.disy.net/legato/layer/predicate';
/**
 * Prefix: Default prefix
 * {llpr}
 */
Legato.Layer.Predicate.PREFIX = 'llpr';

Legato.Layer.Predicate.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Layer.Predicate.NAMESPACE_URI, localPart,
      Legato.Layer.Predicate.PREFIX);
};

Legato.Layer.Predicate.Bean = Legato.Beans.Object.Extend(
    'Legato.Layer.Predicate', Legato.Layer.Predicate.QName('Predicate'), {
      _constructor : Legato.Layer.Predicate
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Predicate.BaseLayer = OpenLayers.Class( {
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(layer) {
    return layer.isBaseLayer;
  },
  CLASS_NAME :'Legato.Layer.Predicate.BaseLayer'
});

Legato.Layer.Predicate.BaseLayer.Bean = Legato.Layer.Predicate.Bean.Extend(
    'Legato.Layer.Predicate.BaseLayer',
    //
    Legato.Layer.Predicate.QName('BaseLayer'),
    //
    {
      _constructor :Legato.Layer.Predicate.BaseLayer
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Predicate.LayerId = OpenLayers.Class( {
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(layer) {
    return layer.layerId === this.value;
  },
  CLASS_NAME :'Legato.Layer.Predicate.LayerId'
});

Legato.Layer.Predicate.LayerId.Bean = Legato.Layer.Predicate.Bean.Extend(
  'Legato.Layer.Predicate.LayerId',
  //
  Legato.Layer.Predicate.QName('LayerId'),
  //
  {
    _constructor: Legato.Layer.Predicate.LayerId,
    options : {
      value : Legato.Lang.String
    }
  }
);

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Predicate.LayerWithAttribute = OpenLayers.Class({
  name : null,
  value : null,
  predicate : null,
  initialize : function(options) {
    Legato.Util.Ensure.ensureString(options.name, 'Attribute name must be a string.');
    this.name = options.name;
    if (Legato.Lang.ObjectUtils.isObject(options.predicate)) {
      Legato.Util.Ensure.ensureFunction(options.predicate.evaluate, 'Predicate must define the [evaluate] function.');
      this.predicate = options.predicate;
    } else if (Legato.Lang.ObjectUtils.isString(options.value)) {
      this.predicate = new Legato.Predicate.Equals(options.value);
    } else {
      this.predicate = null;
    }
  },
  evaluate : function(layer) {
    if (Legato.Lang.ObjectUtils.isString(this.name)) {
      var attributes = layer.attributes;
      if (Legato.Lang.ObjectUtils.isObject(attributes)) {
        if (Legato.Lang.ObjectUtils.exists(this.predicate)) {
          return Legato.Lang.ObjectUtils.exists(attributes[this.name]) && this.predicate.evaluate(attributes[this.name]);
        } else {
          return Legato.Lang.ObjectUtils.exists(attributes[this.name]);
        }
      } else {
        return false;
      }

    } else {
      return true;
    }
  },
  CLASS_NAME : 'Legato.Layer.Predicate.LayerWithAttribute'
});

Legato.Layer.Predicate.LayerWithAttribute.Bean = Legato.Layer.Predicate.Bean.Extend('Legato.Layer.Predicate.LayerWithAttribute',
//
Legato.Layer.Predicate.QName('LayerWithAttribute'),
//
{
  _constructor : Legato.Layer.Predicate.LayerWithAttribute,
  options : {
    name : Legato.Lang.String,
    value : Legato.Lang.String,
    predicate : Legato.Beans.Object
  }
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Predicate.Overlay = OpenLayers.Class( {
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(layer) {
    return !layer.isBaseLayer;
  },
  CLASS_NAME :'Legato.Layer.Predicate.Overlay'
});

Legato.Layer.Predicate.Overlay.Bean = Legato.Layer.Predicate.Bean.Extend(
    'Legato.Layer.Predicate.Overlay',
    //
    Legato.Layer.Predicate.QName('Overlay'),
    //
    {
      _constructor :Legato.Layer.Predicate.Overlay
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Predicate.SelectedLayer = OpenLayers.Class({
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
  },
  evaluate : function(layer) {
    return Legato.Lang.ObjectUtils.isTrue(layer.selected);
  },
  CLASS_NAME : 'Legato.Layer.Predicate.SelectedLayer'
});

Legato.Layer.Predicate.SelectedLayer.Bean = Legato.Layer.Predicate.Bean.Extend('Legato.Layer.Predicate.SelectedLayer',
//
Legato.Layer.Predicate.QName('SelectedLayer'),
//
{
  _constructor : Legato.Layer.Predicate.SelectedLayer
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Transformer = Legato.Lang.Class({

  initialize : function() {
  },

  transform : function(layer) {
    throw new Legato.Lang.Exception(this.CLASS_NAME
        + ' must implement the transform function from from abstract class '
        + Legato.Layer.Transformer.CLASS_NAME);
  },

  CLASS_NAME : 'Legato.Layer.Transformer'

});

/**
 * Space: lltr
 * Namespace for Legato layer transformers.
 */
/**
 * URI: Namespace URI
 * {http://www.disy.net/legato/layer/transformer}
 */
Legato.Layer.Transformer.NAMESPACE_URI = 'http://www.disy.net/legato/layer/transformer';
/**
 * Prefix: Default prefix
 * {lltr}
 */
Legato.Layer.Transformer.PREFIX = 'lltr';

Legato.Layer.Transformer.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Layer.Transformer.NAMESPACE_URI,
      localPart, Legato.Layer.Transformer.PREFIX);
};

/**
 * Component: lltr:Transformer
 *
 * Transforms the layer.
 *
 * See also:
 * - <lltr> namespace
 * - <Legato.Layer.Transformer>
 */
Legato.Layer.Transformer.Bean = Legato.Beans.Object.Extend(
    'Legato.Layer.Transformer', Legato.Layer.Transformer.QName('Transformer'),
    {
      _constructor : Legato.Layer.Transformer
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Transformer.SublayerFilteringTransformer = OpenLayers.Class(
    Legato.Layer.Transformer, {

      predicate : null,

      initialize : function(predicate) {
        Legato.Layer.Transformer.prototype.initialize.apply(this);
        Legato.Util.Ensure.ensureObject(predicate);
        this.predicate = predicate;
      },

      transform : function(layer) {
        var id = layer.layerId.split(',');

        if (id.length === 1) {
          if (this.predicate.evaluate(layer)) {
            return layer;
          }
          return null;
        }

        var evaluatedLayerIds = [];
        var clonedLayer = layer.clone();

        for ( var i = 0; i < id.length; i++) {
          clonedLayer.layerId = id[i];
          clonedLayer.params.LAYERS = id[i];
          if (this.predicate.evaluate(clonedLayer)) {
            evaluatedLayerIds.push(id[i]);
          }
        }

        if (evaluatedLayerIds.length !== 0) {
          var transformedId =  evaluatedLayerIds.join(",");
          clonedLayer.layerId = transformedId;
          clonedLayer.params.LAYERS = transformedId;
          return clonedLayer;
        }
        return null;
      },
      CLASS_NAME : 'Legato.Layer.Transformer.SublayerFilteringTransformer'
    });

/**
 * Component: lltr:SublayerFilteringTransformer
 *
 * The SublayerFilteringTransformer transforms the layer params attribute if configured
 * predicate matches.
 *
 * See also:
 * - <lla> namespace
 */
Legato.Layer.Transformer.SublayerFilteringTransformer.Bean = Legato.Layer.Transformer.Bean
    .Extend(
    //
    'Legato.Layer.Transformer.SublayerFilteringTransformer',
    //
    Legato.Layer.QName('SublayerFilteringTransformer'),
    //
    {
      _constructor : Legato.Layer.Transformer.SublayerFilteringTransformer,
      options : {
        /**
         * Element: predicate
         * {<lp:Predicate>} A predicate. If predicate matches the layer will been transformed.
         */
        predicate : Legato.Predicate
      }
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Marker = {};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author$
 * @version $Rev$
 */

Legato.Marker.PopupMarker = OpenLayers.Class(OpenLayers.Marker, {
  popup : null,
  initialize : function(lonlat, icon, popup) {
    OpenLayers.Marker.prototype.initialize.apply(this, arguments);
    Legato.Util.Ensure.ensureExists(popup, 'popup should be defined');
    this.popup = popup;
  },
  destroy : function() {
    OpenLayers.Marker.prototype.destroy.apply(this, arguments);
    this.popup = null;
  },
  draw : function(px) {
    var result = OpenLayers.Marker.prototype.draw.apply(this, arguments);
    if (this.map !== null) {
      this.map.addPopup(this.popup);
    }
    return result;
  },
  moveTo : function(px) {
    var result = OpenLayers.Marker.prototype.moveTo.apply(this, arguments);
    this.popup.moveTo(px);
    return result;
  },
  erase : function() {
    var result = OpenLayers.Marker.prototype.erase.apply(this, arguments);
    if (this.map !== null) {
      this.map.removePopup(this.popup);
    }
    return result;
  },
  CLASS_NAME : "Legato.Marker.PopupMarker"
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Revision: 69543 $
 * @requires Legato.js
 * @requires OpenLayers/Control.js
 */

/**
 * Class: Legato.Control
 * Abstract base class for all Legato control classes
 *
 * Inherits from:
 *  - <OpenLayers.Control>
 */
Legato.Control = OpenLayers.Class(OpenLayers.Control, {
	CLASS_NAME : 'Legato.Control'
});

/**
 * Space: lc
 * Namespace for Legato controls.
 */
/*
 * URI: Namespace URI
 * {http://www.disy.net/legato/control}
 */
Legato.Control.NAMESPACE_URI = 'http://www.disy.net/legato/control';

/*
 * Prefix: Default prefix
 * {lc}
 */
Legato.Control.PREFIX = 'lc';

Legato.Control.QName = function(localPart) {
	return new Legato.XML.QName(Legato.Control.NAMESPACE_URI, localPart,
			Legato.Control.PREFIX);
};
/**
 * Component: lc:Control
 * Configuration component for Legato Controls.
 * See also:
 * - <lc> namespace
 * - <Legato.Control>
 */
Legato.Control.Bean = OpenLayers.Control.Bean.Extend('Legato.Control',
//
Legato.Control.QName('Control'),
//
{
	_constructor : Legato.Control
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ArgParser = OpenLayers.Class(OpenLayers.Control.ArgParser, {

  /**
   * Parameter: bounds {Array(<OpenLayers.Bounds>)}
   */
  bounds : null,

  /**
   * Constructor: OpenLayers.Control.ArgParser
   * 
   * Parameters: options - {Object}
   */
  initialize : function(options) {
    OpenLayers.Control.ArgParser.prototype.initialize.apply(this, arguments);
  },

  /**
   * Method: setMap Set the map property for the control.
   * 
   * Parameters: map - {<OpenLayers.Map>}
   */
  setMap : function(map) {
    OpenLayers.Control.ArgParser.prototype.setMap.apply(this, arguments);

    var bounds = this.getBounds();

    if (Legato.OpenLayers.Map.Util.isValidBBox(bounds)) {
      this.bounds = bounds;
      this.map.events.register('legato.refresh', this, this.setBounds);
      this.setBounds();
    } else {
      this.bounds = null;
    }
  },

  /**
   * Method: getBounds Tries to parse from current request the BBOX query
   * parameter and returns a bounds instance.
   * 
   * Returns: {<OpenLayers.Bounds>}
   */
  getBounds : function() {
    var args = OpenLayers.Util.getParameters();
    if (Legato.Lang.ObjectUtils.isNullOrUndefined(args.BBOX) || !Legato.Lang.ObjectUtils.isArray(args.BBOX) || args.BBOX.length !== 4) {
      return null;
    }

    try {
      return new OpenLayers.Bounds(Legato.Lang.NumberUtils.toFloat(args.BBOX[0]), Legato.Lang.NumberUtils.toFloat(args.BBOX[1]), Legato.Lang.NumberUtils
          .toFloat(args.BBOX[2]), Legato.Lang.NumberUtils.toFloat(args.BBOX[3]));
    } catch (ex) {
      Legato.Util.Logger.getLogger().warn('Could not parse given parameter BBOX: ' + args.BBOX + ' into a valid Bounds object.');
      Legato.Util.Logger.getLogger().warn(ex);
      return null;
    }
  },

  /**
   * Method: setBounds As soon as the legato.refresh event is triggered we try
   * to zoom to given bounding box and remove ourself from the handler
   */
  setBounds : function() {
    if (this.map.baseLayer) {
      // dont need to listen for this one anymore
      this.map.events.unregister('legato.refresh', this, this.setBounds);
      this.map.setCenter(this.bounds.getCenterLonLat(), this.map.getZoomForExtent(this.bounds, true));
    }
  },

  CLASS_NAME : 'Legato.Control.ArgParser'
});

/**
 * Structure: lc:ArgParser XML based config for a <Legato.Control.ArgParser>.
 * 
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory> - <QName>
 * 
 * A valid config example for a ArgParser would be:
 * (start code)
 * <lc:ArgParser />
 * (end)
 */
Legato.Control.ArgParser.Bean = OpenLayers.Control.ArgParser.Bean.Extend(

'Legato.Control.ArgParser',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Control.QName('ArgParser'),
//
{
  _constructor : Legato.Control.ArgParser,
  options : {
    displayProjection : OpenLayers.Projection.Bean
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: Legato.Control.BBoxValueProvider
 * ValueProvider which gives you the possibility to be notified about every
 * change of the current BBox Selection. The notification could be a JS Callback
 * or a Object where its property will be overwritten each time the watched value
 * changes.
 *
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.BBoxValueProvider = OpenLayers.Class(Legato.Control,
{
  /*
   * Function: initialize
   * Basic ctor
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control
   * The following keys are supported
   * - observer {Object} A hashmap containing an observer
   *
   * The following keys are supported for an observer element
   * - target {object} an object which wants to observe,
   * - property{function|String} the propety or function which should be used for providing the observed value
   * - bBoxProperty {String} any Property name of an <OpenLayers.Bounds> instance
   * - write {Boolean} true = value changes of observer will be given back to current map, false otherwise
   */
  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
  },

  /*
   * Function: destroy
   *
   * See Also:
   * <OpenLayer.Control>
   */
  destroy : function() {
    this.map.events.un( {
      'moveend' : this.propagateValue,
      scope : this
    });

    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  /*
   * Function: setMap
   *
   * See Also:
   * <OpenLayer.Control>
   */
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);

    this.map.events.on( {
      'moveend' : this.propagateValue,
      'legato.refresh' : this.examineValue,
      scope : this
    });
   },

  /*
   * Function: draw
   *
   * See Also:
   * <OpenLayer.Control>
   */
  draw : function() {
    this.examineValue();
    this.propagateValue();
    return this.div;
  },

  /*
   * Inits this control by the given option targets based on their
   * given values if exists.
   */
  examineValue: function(){
    if(!Legato.Lang.ObjectUtils.isFunction(this.getValue)){
      return;
    }
    var bbox = this.getValue();
    if(Legato.OpenLayers.Map.Util.isValidBBox(bbox) &&
       Legato.OpenLayers.Map.Util.getBaseLayers(this.map.layers).length > 0){
      this.map.zoomToExtent(bbox);
    }
  },

  /*
   * updates all subscribed target's values by requesting the current used
   * bbox. Their values will been provided back to given targets
   */
  propagateValue: function(){
    if(!Legato.Lang.ObjectUtils.isFunction(this.setValue)){
      return;
    }

    var bbox = this.map.calculateBounds();

    this.setValue(bbox);
  },

  CLASS_NAME : 'Legato.Control.BBoxValueProvider'
});

/**
 * Structure: lc:BBoxValueProvider
 * XML based config for a <Legato.Control.BBoxValueProvider>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a BBoxValueProvider would be:
 * (start code)
 * <lc:BBoxValueProvider left="bboxLeft" right="bboxRight" top="bboxTop" bottom="bboxBottom"/>
 * (end)
 */
Legato.Control.BBoxValueProvider.Bean = Legato.Control.Bean.Extend(

  'Legato.Control.BBoxValueProvider',

  /*
   * Property: QName
   * The qualified name for this control. Needed by XML config to instantiate it.
   */
  Legato.Control.QName('BBoxValueProvider'),
  {
   /*
    * Creates a basic <Legato.Control.BBoxValueProvider> instance. By default this instance
    * will update the DOMElements by any change made in map. It only provides a basic setter
    * function. So if given DOMElements contain any values the constructed map will load
    * with this initial bbox.
    *
    * Parameters:
    * left - {String} The configured DOMElement ID where the left bbox value should be written into
    * bottom - {String} The configured DOMElement ID where the bottom bbox value should be written into
    * right - {String} The configured DOMElement ID where the right bbox value should be written into
    * top - {String} The configured DOMElement ID where the top bbox value should be written into
    *
    * Returns:
    * <Legato.Control.BBoxValueProvider>
    */
    factoryFunction : function(left, bottom, right, top)
    {
      var leftElement   = null;
      var bottomElement = null;
      var rightElement  = null;
      var topElement    = null;

      if(Legato.Lang.ObjectUtils.isString(left)){
        leftElement = OpenLayers.Util.getElement(left);
        Legato.Util.Ensure.ensureExists(leftElement, 'BBoxValueProvider: The configured DOMElement with the id' + left + ' could not been found.');
      }
      if(Legato.Lang.ObjectUtils.isString(bottom)){
        bottomElement = OpenLayers.Util.getElement(bottom);
        Legato.Util.Ensure.ensureExists(bottomElement, 'BBoxValueProvider: The configured DOMElement with the id' + bottom + ' could not been found.');
      }
      if(Legato.Lang.ObjectUtils.isString(right)){
        rightElement = OpenLayers.Util.getElement(right);
        Legato.Util.Ensure.ensureExists(rightElement, 'BBoxValueProvider: The configured DOMElement with the id' + right + ' could not been found.');
      }
      if(Legato.Lang.ObjectUtils.isString(top)){
        topElement = OpenLayers.Util.getElement(top);
        Legato.Util.Ensure.ensureExists(topElement, 'BBoxValueProvider: The configured DOMElement with the id' + top + ' could not been found.');
      }

      return new Legato.Control.BBoxValueProvider({
        elements: {
          left: leftElement,
          bottom: bottomElement,
          right: rightElement,
          top: topElement
        },
        setValue: function(BBox){
          OpenLayers.Console.debug('BBoxValueProvider.setValue:' + BBox);
          if(!Legato.Lang.ObjectUtils.exists(BBox)){
            return;
          }

          this.elements.left.value   = BBox.left;
          this.elements.right.value  = BBox.right;
          this.elements.top.value    = BBox.top;
          this.elements.bottom.value = BBox.bottom;
        },
        getValue: function(){
          OpenLayers.Console.debug('BBoxValueProvider.getValue');
          try{
            var left    = Legato.Lang.NumberUtils.toFloat(this.elements.left.value);
            var right   = Legato.Lang.NumberUtils.toFloat(this.elements.right.value);
            var top     = Legato.Lang.NumberUtils.toFloat(this.elements.top.value);
            var bottom  = Legato.Lang.NumberUtils.toFloat(this.elements.bottom.value);

            return new OpenLayers.Bounds(left, bottom, right, top);
          }catch(ex){
            OpenLayers.Console.warn(ex);
            return new OpenLayers.Bounds(null, null, null, null);
          }
        }
      });
    },
    constructorArguments:
    {
      /*
      * Property: left
      * Defines the {DOMElement} id where the left <OpenLayers.Bounds> value should be written into.
      * The DOMElement must exists in current DOM. Otherwise an Exception is thrown.
      */
      left: Legato.Lang.String,

     /*
      * Property: right
      * Defines the {DOMElement} id where the right <OpenLayers.Bounds> value should be written into.
      * The DOMElement must exists in current DOM. Otherwise an Exception is thrown.
      */
      right: Legato.Lang.String,

     /*
      * Property: top
      * Defines the {DOMElement} id where the top <OpenLayers.Bounds> value should be written into.
      * The DOMElement must exists in current DOM. Otherwise an Exception is thrown.
      */
      top: Legato.Lang.String,

     /*
      * Property: bottom
      * Defines the {DOMElement} id where the bottom <OpenLayers.Bounds> value should be written into.
      * The DOMElement must exists in current DOM. Otherwise an Exception is thrown.
      */
      bottom: Legato.Lang.String
    },
    constructorOrder: ['left', 'bottom', 'right', 'top']
  }
);

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: nedkov $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: ControlContainer
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.ControlContainer = OpenLayers.Class(Legato.Control,
{
  /**
   * Property: type
   * {OpenLayers.Control.TYPE}
   */
  type: OpenLayers.Control.TYPE_BUTTON,

  /**
   * Property: controls
   * {Array(<OpenLayers.Control>)}
   */
  controls: null,

  panel_div : null,

  panel_div_ul : null,

  /**
   * Property: parentPanel
   * {<Legato.Control.ExtendedPanel>)}
   */
  parentPanel : null,

  drawMode : null,

  menuDrawOptions : null,

  showActiveControl : false,

  activeControl : null,

  childControlActivateDeactivate : {
    activate : function(){},
    deactivate : function(){}
  },

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, [options]);
    this.active = false;
    if(!Legato.Lang.ObjectUtils.exists(this.drawMode)){
      this.drawMode = Legato.Control.ControlContainer.DRAW_MODE_TOOLBAR;
    }
    if(Legato.Lang.StringUtils.isEmpty(options.displayClass) &&
       Legato.Lang.ObjectUtils.exists(this.controls) &&
       this.controls.length > 0){
      this.activeControl = this.controls[0];
      this.displayClass = this.activeControl.displayClass;
    }
    this.menuDrawOptions = OpenLayers.Util.extend({
      headerVisible: true,
      headerPropertyName : 'title',
      iconVisible : true,
      iconPropertyName : 'icon',
      titleVisible : true,
      titlePropertyName : 'title',
      descriptionVisible : true,
      descriptionPropertyName : 'description'
    }, this.menuDrawOptions);

    if(this.showActiveControl && this.drawMode === Legato.Control.ControlContainer.DRAW_MODE_TOOLBAR){
      var controlContainer = this;
      this.childControlActivateDeactivate =  {
          activate : function(){
            var childDisplayClass = this.displayClass;
            var childPanelDiv = this.panel_div;

            var containerPanelDiv = controlContainer.panel_div;
            var containerDisplayClass = controlContainer.displayClass;

            containerPanelDiv.className = containerPanelDiv.className.replace(containerDisplayClass, childDisplayClass);
            controlContainer.displayClass = childDisplayClass;

            controlContainer.activate();
            controlContainer.activeControl = this;
          },
          deactivate : function(){
            controlContainer.deactivate();
          }
      };
    }

    this.createPanelDiv();
    this.appendChildControls(this.controls);
  },

  addControls : function(controls){
    this.controls = this.controls.concat(controls);
    this.appendChildControls(controls);

    if(Legato.Lang.ObjectUtils.exists(this.parentPanel)){
      if (this.parentPanel.map) { // map.addControl() has already been called on the parentPanel
        this.parentPanel.controls = this.parentPanel.controls.concat(controls);
        this.parentPanel.addControlsToMap(controls);
      }
    }
  },

  getPanelDiv : function(){
    return this.panel_div;
  },

  setParentPanel: function(extendedPanel){
    this.parentPanel = extendedPanel;
  },

  createPanelDiv: function(){
    this.panel_div = this.createControlPanelDiv(this);
    OpenLayers.Element.addClass(this.panel_div, 'ControlContainer');

    var container_div = document.createElement('div');
    container_div.style.display = 'none';
    this.panel_div.appendChild(container_div);

    switch(this.drawMode) {
      case Legato.Control.ControlContainer.DRAW_MODE_TOOLBAR:
        OpenLayers.Element.addClass(container_div, 'ToolbarControlContainer');
        break;
      case Legato.Control.ControlContainer.DRAW_MODE_MENU:
        OpenLayers.Element.addClass(container_div, 'MenuControlContainer');
        this.appendHeader(container_div);
        break;
    }

    this.panel_div_ul = document.createElement('ul');
    container_div.appendChild(this.panel_div_ul);

    this.onHoverPanelDiv(this.panel_div);
  },

  createControlPanelDiv: function(control){
    var panel_div = document.createElement("div");

    OpenLayers.Element.addClass(panel_div, control.displayClass
        + "ItemInactive");
    OpenLayers.Element.addClass(panel_div, "ItemInactive");
    OpenLayers.Element.addClass(panel_div, "olButton");

    if (control.title != "" && !panel_div.title) {
      panel_div.title = control.title;
    }

    return panel_div;
  },

  onHoverPanelDiv : function(panel_div){
    panel_div.onmouseover = function(){
      for(var i = 0, length = this.children.length; i < length; i++ ){
        this.children[i].style.display = 'block';
      }
    };

    panel_div.onmouseout = function(){
      for(var i = 0, length = this.children.length; i < length; i++ ){
        this.children[i].style.display = 'none';
      }
    };
  },

  appendHeader: function(container_div){
    if(this.menuDrawOptions.headerVisible){
      var headerValue = this[this.menuDrawOptions.headerPropertyName];
      if(!Legato.Lang.StringUtils.isEmpty(headerValue)){
        var headerTitleDiv = document.createElement('div');
        OpenLayers.Element.addClass(headerTitleDiv, 'MenuHeaderTitle');
        headerTitleDiv.innerHTML = headerValue;
        container_div.appendChild(headerTitleDiv);
      }
    }
  },

  appendChildControls: function(controls){
    var currentControl;
    for ( var j = 0; j < controls.length; j++) {
      currentControl = controls[j];
      currentControl.events.on(this.childControlActivateDeactivate);
      var childControlLi = this.createChildControlLi(currentControl);
      this.panel_div_ul.appendChild(childControlLi);
    }
  },

  createChildControlLi: function(childControl){
    var childControlLi = document.createElement("li");
    var childControlDiv = null;

    switch(this.drawMode) {
      case Legato.Control.ControlContainer.DRAW_MODE_TOOLBAR:
        childControlDiv = this.createControlPanelDiv(childControl);
        OpenLayers.Element.addClass(childControlDiv, 'ControlContainerToolbarItem');
        break;
      case Legato.Control.ControlContainer.DRAW_MODE_MENU:
        childControlDiv = document.createElement('div');
        OpenLayers.Element.addClass(childControlDiv, 'ControlContainerMenuItem');
        OpenLayers.Element.addClass(childControlDiv, childControl.displayClass);
        OpenLayers.Element.addClass(childControlDiv, 'olButton');

        var childControlMenuIcon = document.createElement('span');
        OpenLayers.Element.addClass(childControlMenuIcon, 'MenuIcon');

        if(childControl.hasOwnProperty(this.menuDrawOptions.iconPropertyName) && childControl[this.menuDrawOptions.iconPropertyName] !== null){
          childControlMenuIcon.style.backgroundImage = 'url(' + childControl[this.menuDrawOptions.iconPropertyName] + ')';
          OpenLayers.Element.addClass(childControlMenuIcon, 'CustomMenuIcon');
        }
        childControlDiv.appendChild(childControlMenuIcon);

        var childControlMenuTitle = document.createElement('span');
        if(this.menuDrawOptions.titleVisible && childControl.hasOwnProperty(this.menuDrawOptions.titlePropertyName)){
          OpenLayers.Element.addClass(childControlMenuTitle, 'MenuTitle');
          childControlMenuTitle.innerHTML = childControl[this.menuDrawOptions.titlePropertyName];
          childControlDiv.appendChild(childControlMenuTitle);
        }

        if(this.menuDrawOptions.descriptionVisible && childControl.hasOwnProperty(this.menuDrawOptions.descriptionPropertyName)){
          var childControlMenuSubTitle = document.createElement('span');
          OpenLayers.Element.addClass(childControlMenuSubTitle, 'MenuSubTitle');
          childControlMenuSubTitle.innerHTML = childControl[this.menuDrawOptions.descriptionPropertyName];
          childControlDiv.appendChild(childControlMenuSubTitle);
        }else{
          OpenLayers.Element.addClass(childControlMenuTitle, 'WithoutSubTitle');
        }
        break;
      default:
        throw new Legato.Lang.Exception('Invalid ControlContainer.drawMode = [' + this.drawMode +'].');
    }

    childControl.panel_div = childControlDiv;
    childControlLi.appendChild(childControlDiv);

    var that = this;
    childControlLi.onmouseup = function(){
      that.hideChildren(that.panel_div);
    };

    return childControlLi;
  },

  destroy : function(){
    for(var i = 0, len = this.controls.length; i < len; i++){
      if(Legato.Lang.ObjectUtils.exists(this.controls[i].events)){
        this.controls[i].events.un(this.childControlActivateDeactivate);
      }
    }
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  trigger : function(){
    if(Legato.Lang.ObjectUtils.exists(this.activeControl)){
      this.parentPanel.activateControl(this.activeControl);
      if (!Legato.Util.Browser.isTouchCapable()){
        this.hideChildren(this.panel_div);
      }
    }
  },

  hideChildren: function(element){
    for(var i = 0, length = element.children.length; i < length; i++ ){
      element.children[i].style.display = 'none';
    }
  },

  CLASS_NAME: 'Legato.Control.ControlContainer'
});

Legato.Control.ControlContainer.DRAW_MODE_TOOLBAR = 'TOOLBAR';
Legato.Control.ControlContainer.DRAW_MODE_MENU = 'MENU';

/**
 * Structure: lc:ControlContainer
 * XML based config for a <Legato.Control.ControlContainer>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ControlContainer would be:
 * (start code)
 * <lc:ControlContainer>
 *  <controls>
 *  </controls>
 * </lc:ControlContainer>
 * (end)
 */
Legato.Control.ControlContainer.Bean = Legato.Control.Bean.Extend(
    'Legato.Control.ControlContainer',
    Legato.Control.QName('ControlContainer'),
    {
      _constructor: Legato.Control.ControlContainer,
      options:
      {
        displayClass: Legato.Lang.String,
        controls: OpenLayers.Control.Bean.List(),
        drawMode : Legato.Lang.String.Enum('Legato.Control.ControlContainer.DRAW_MODE', {
          'TOOLBAR' : Legato.Control.ControlContainer.DRAW_MODE_TOOLBAR,
          'MENU' : Legato.Control.ControlContainer.DRAW_MODE_MENU
        }),
        menuDrawOptions: Legato.Beans.Object.Map(),
        showActiveControl: Legato.Lang.Boolean
      }
    }
  );

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: ControlFunction
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.ControlFunction = OpenLayers.Class(Legato.Control,
{
  /**
   * Property: type
   * {OpenLayers.Control.TYPE}
   */
  type: OpenLayers.Control.TYPE_BUTTON,

  /**
   * Constructor: Legato.Control.ControlFunction
   * Create a new control function control displayed as a button. If clicked the given callback
   * method will been executed and the current map will been passed as argument.
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control
   *
   * The following keys are supported for an observer element
   * - callback {function} the callback method wich will been executed if control has been clicked
   *
   */
  initialize : function(options) {
    Legato.Control.prototype.initialize.apply(this, arguments);
    Legato.Util.Ensure.ensureFunction(this.callback,
        'To use ' + this.CLASS_NAME + ' you must specify a callback function.');
  },

  /** Function: trigger
   * Invoked when the control is clicked
   */
  trigger : function() {
    this.callback(this.map);
  },

  CLASS_NAME: 'Legato.Control.ControlFunction'
});

/**
 * Structure: lc:ControlFunction
 * XML based config for a <Legato.Control.ControlFunction>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ControlFunction would be:
 * (start code)
 * <lc:ControlFunction />
 * (end)
 */
Legato.Control.ControlFunction.Bean = Legato.Control.Bean.Extend(

  'Legato.Control.ControlFunction',

  /**
   * Property: QName
   * The qualified name for this control. Needed by XML config to instantiate it.
   */
  Legato.Control.QName('ControlFunction'),
  {
    _constructor: Legato.Control.ControlFunction,
    options:
    {
      callback: Legato.Lang.Function,
      displayClass: Legato.Lang.String
    }
  }
);

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.ControlSwitcher
 * The ControlSwitcher control is able to manage a list of legato controls.
 * The ControlSwitcher always ensures that only one control of given list is active.
 * If a defaultControl has been configured this control will always be active if
 * no other control of given list is active.
 */
Legato.Control.ControlSwitcher = OpenLayers.Class(Legato.Control,
{
  /*
   * Function: initialize
   * Basic ctor
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control
   * The following keys are supported
   * - controls {Object} A hashmap containing all Legato.Control instance which will
   *   been controlled by this control
   * - defaultControl {Object} If configured this control becomes automatically active if all other
   *   ones are deactivated.
   */
  initialize : function(controls, defaultControl, options) {
    this.controls = controls;
    this.defaultControl = defaultControl;
    OpenLayers.Control.prototype.initialize.apply(this, [options]);
  },

  /*
   * Function: destroy
   *
   * See Also:
   * <OpenLayer.Control>
   */
  destroy : function() {
    for(var i = 0; i < this.controls.length; i++){
      this.controls[i].events.un({
        'activate': this.onControlActivate,
        'deactivate': this.onControlDeactivate,
        scope: this
      });
    }

    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  /*
   * Triggered if one control becomes active. We then determine
   * if another control is active as well and if so we'll deactivate
   * it.
   */
  onControlActivate: function(event){
    for(var i = 0; i < this.controls.length; i++){
      if(this.controls[i].active && this.controls[i].id != event.object.id){
        this.controls[i].deactivate();
      }
    }
  },

  /*
   * Triggered if one control becomes inactive. If a defaultControl has been
   * configured we check if at least one control is active and if not we'll
   * activate the configured default control.
   */
  onControlDeactivate: function(event){
    if(Legato.Lang.ObjectUtils.exists(this.defaultControl)){
      var active = false;

      for(var i = 0; i < this.controls.length; i++){
        if(this.controls[i].active){
          active = true;
          break;
        }
      }

      if(!active){
        this.defaultControl.activate();
      }
    }
  },

  /*
   * Function: setMap
   *
   * See Also:
   * <OpenLayer.Control>
   */
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);

    for(var i = 0; i < this.controls.length; i++){
      this.controls[i].events.on({
        'activate': this.onControlActivate,
        'deactivate': this.onControlDeactivate,
        scope: this
      });
    }

    if(Legato.Lang.ObjectUtils.exists(this.defaultControl)){
      this.defaultControl.activate();
    }
   },

  /*
   * Function: draw
   *
   * See Also:
   * <OpenLayer.Control>
   */
  draw : function() {
    return this.div;
  },

  CLASS_NAME : 'Legato.Control.ControlSwitcher'
});

Legato.Control.ControlSwitcher.Bean = Legato.Control.Bean.Extend(
  'Legato.Control.ControlSwitcher',

  /*
   * Property: QName
   * The qualified name for this control. Needed by XML config to instantiate it.
   */
  Legato.Control.QName('ControlSwitcher'),
  {
   /*
    * Creates a basic <Legato.Control.ControlSwitcher> instance. The Controls Switcher will
    * allways ensure that just one control is active. If another control becomes active
    * all other ones will been deactivated.
    *
    * Parameters:
    * controls - {Object}
    *
    * Returns:
    * <Legato.Control.ControlSwitcher>
    */
    factoryFunction : function(controls, defaultControl, options)
    {
      Legato.Util.Ensure.ensureExists(controls, 'ControlSwitcher: To use the ControlSwitcher control you must configure at least one legato control.');

      if(Legato.Lang.ObjectUtils.isArray(controls)){
        for(var i = 0; i < controls.length; i++){
          Legato.Util.Ensure.ensureObject(controls[i], 'ControlSwitcher: All configured controls which are passed to the ControlSwitcher Class must be objetcs.');
        }
      }

      if(Legato.Lang.ObjectUtils.exists(defaultControl)){
        Legato.Util.Ensure.ensureObject(defaultControl, 'ControlSwitcher: If a defaultControl has been configured it needs to be a legato control as well.');
      }

      OpenLayers.Console.debug('Creating ControlSwitcher with: ' + controls);

      return new Legato.Control.ControlSwitcher(controls, defaultControl, options);
    },
    constructorArguments:
    {
     /*factoryFunction
      * Property: controls
      */
      controls: OpenLayers.Control.Bean.List(),

      /*
       * If configured this control becomes automatically active if all other
       * ones are deactivated.
       */
      defaultControl: OpenLayers.Control.Bean
    },
    constructorOrder: ['controls', 'defaultControl']
  }
);

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 71063 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: Legato.Control.DefaultBaseLayer
 * ValueProvider which gives you the possibility to be notified about every
 * change of the current BBox Selection. The notification could be a JS Callback
 * or a Object where its property will be overwritten each time the watched value
 * changes.
 *
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.DefaultBaseLayer = OpenLayers.Class(Legato.Control,
{
  defaultLayerAdded: false,

  /*
   * Function: initialize
   * Basic ctor
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control
   * The following keys are supported
   * - observer {Object} A hashmap containing an observer
   *
   * The following keys are supported for an observer element
   * - target {object} an object which wants to observe,
   * - property{function|String} the propety or function which should be used for providing the observed value
   * - bBoxProperty {String} any Property name of an <OpenLayers.Bounds> instance
   * - write {Boolean} true = value changes of observer will be given back to current map, false otherwise
   */
  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
    Legato.Util.Ensure.ensureExists(this.layer);
    this.layer.options.legatoIgnore = true;
    this.defaultLayerAdded = false;
  },

  /*
   * Function: destroy
   *
   * See Also:
   * <OpenLayer.Control>
   */
  destroy : function() {
    this.map.events.un( {
      'addlayer' : this.ensureBaseLayer,
      'removelayer' : this.ensureBaseLayer,
      scope : this
    });

    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  /*
   * Function: setMap
   *
   * See Also:
   * <OpenLayer.Control>
   */
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);

    this.map.events.on( {
      'addlayer' : this.ensureBaseLayer,
      'removelayer' : this.ensureBaseLayer,
      scope : this
    });
   },

  /*
   * Function: draw
   *
   * See Also:
   * <OpenLayer.Control>
   */
  draw : function() {
    this.ensureBaseLayer();
    return this.div;
  },

  /*
   * Inits this control by the given option targets based on their
   * given values if exists.
   */
  ensureBaseLayer: function(event){
    var baseLayers = Legato.OpenLayers.Map.Util.getBaseLayers(this.map.layers);

    if(!this.defaultLayerAdded && baseLayers.length !== 0){
      //Remember last deleted baselayer projection
      if(Legato.Lang.ObjectUtils.exists(event) &&
         Legato.Lang.ObjectUtils.exists(event.layer) &&
         event.layer.isBaseLayer){
        this.layer.projection = event.layer.projection;
      }
      return;
    }

    if(this.defaultLayerAdded && baseLayers.length != 1){
      //this.map.setBaseLayer(baseLayers[0]);
      this.map.removeLayer(this.layer);
      this.defaultLayerAdded = false;
      return;
    }

    if(this.defaultLayerAdded === false){
      this.map.addLayer(this.layer);
      this.defaultLayerAdded = true;
    }
  },

  CLASS_NAME : 'Legato.Control.DefaultBaseLayer'
});

/**
 * Structure: lc:DefaultBaseLayer
 * XML based config for a <Legato.Control.DefaultBaseLayer>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a Legend would be:
 * (start code)
 *
 *<lc:DefaultBaseLayer>
 * <layer>
 *  <lla:BlankLayer name="Default Base Layer"/>
 * </layer>
 *<lc:DefaultBaseLayer>
 * (end)
 */
Legato.Control.DefaultBaseLayer.Bean = Legato.Control.Bean.Extend(

  'Legato.Control.DefaultBaseLayer',

  /*
   * Property: QName
   * The qualified name for this control. Needed by XML config to instantiate it.
   */
  Legato.Control.QName('DefaultBaseLayer'),
  {
    _constructor: Legato.Control.DefaultBaseLayer,
    options:
    {
     /*
      * Property: layer
      * The default layer which should been used if none is present
      */
      layer: OpenLayers.Layer.Bean
    }
  }
);

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawFeature = OpenLayers.Class(OpenLayers.Control.DrawFeature, {

  mode : 1,

  callback : null,

  style : null,

  attributes : {},

  /*
   * Defined by subclass
   */
  handlerConstructor : null,

  initialize : function(layer, options) {

    this.callbacks = OpenLayers.Util.extend({
      point : function(vertex, geometry) {
        this.layer.events.triggerEvent('legato.sketchpointadded', {
          layer : this.layer,
          vertex : vertex,
          geometry : geometry
        });
      }
    }, this.callbacks);

    /*
     * By default we want to be notified if a new point has been added to this
     * new geometry. If this happenes we're tiggering an layer event which
     * somebody may subscribe or not.
     */
    this.handlerOptions = OpenLayers.Util.extend({
      freehandToggle : null,
      layerOptions : {
        isFeatureLayer : true
      }
    }, options.handlerOptions);

    this.style = options.style || null;
    this.attributes = options.attributes || {};

    OpenLayers.Control.DrawFeature.prototype.initialize.apply(this, [ layer,
        this.handlerConstructor, options ]);

    /*
     * by default we subscribe for an event which is triggered when somebody has
     * changed the drawn geometry from outside. If this may happens we want ot
     * be notified about this.
     */
    layer.events.on({
      'legato.sketchupdated' : this.onSketchUpdated,
      scope : this
    });
  },

  destroy : function() {
    OpenLayers.Control.DrawFeature.prototype.destroy.apply(this, arguments);
  },

  setMap : function(map) {
    OpenLayers.Control.DrawFeature.prototype.setMap.apply(this, arguments);
  },

  drawFeature : function(geometry) {
    var attributes = OpenLayers.Util.extend({}, this.attributes);
    /* 
     * Only set a style if the this.style is not empty. Otherwise the default settings are applied
     * in case of a newly drawn feature and if it is a point geometry, its pointRadius is 0 (taken from
     * OpenLayers.Renderer.defaultSymbolizer), which means that the point is not shown at all. 
     * So we leave the style null and then the highlighted style is applied later on in the call hierarchy. 
     */
    var style = !Legato.Lang.ObjectUtils.isEmptyObject(this.style) ? OpenLayers.Util.extend({}, this.style)
        : null;

    var feature = new OpenLayers.Feature.Vector(geometry, attributes, style);
    var proceed = this.layer.events.triggerEvent('sketchcomplete', {
      feature : feature
    });
    if (proceed !== false) {
      feature.state = OpenLayers.State.INSERT;
      if (this.mode == 1) {
        this.layer.addFeatures([ feature ]);
        this.featureAdded(feature);
        this.events.triggerEvent('featureadded', {
          feature : feature
        });
      }
      if (this.mode == 2) {
        this.layer.destroyFeatures();
        this.layer.addFeatures([ feature ]);
        this.featureAdded(feature);
        this.events.triggerEvent('featureadded', {
          feature : feature
        });
      }
    }
    if (Legato.Lang.ObjectUtils.isFunction(this.callback)) {
      this.callback(geometry);
    }
  },

  /*
   * If someone may have changed the geometry withing this layer we're ensuring
   * that this layer gets redrawn so the the shown geometry is allways up to
   * date.
   */
  onSketchUpdated : function(event) {
    if (this.handler.drawing) {
      this.handler.drawFeature();
    } else {
      this.layer.redraw();
    }
  },

  CLASS_NAME : 'Legato.Control.DrawFeature'
});

Legato.Control.DrawFeature.MODE_ADD_FEATURE = 1;
Legato.Control.DrawFeature.MODE_REPLACE_FEATURE = 2;

Legato.Control.DrawFeature.Bean = OpenLayers.Control.DrawFeature.Bean.Extend(
//
'Legato.Control.DrawFeature',
//
Legato.Control.QName('DrawFeature'),
//
{
  _constructor : Legato.Control.DrawFeature,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ],
  options : {
    mode : Legato.Lang.Integer.Enum('Legato.Control.DrawFeature.MODE', {
      'MODE_ADD_FEATURE' : 1,
      'MODE_REPLACE_FEATURE' : 2
    }),
    callback : Legato.Lang.Function
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawBox = OpenLayers.Class(Legato.Control.DrawFeature, {
  handlerConstructor :Legato.Handler.Box,

  CLASS_NAME :'Legato.Control.DrawBox'
});

Legato.Control.DrawBox.Bean = Legato.Control.DrawFeature.Bean.Extend(
//
    'Legato.Control.DrawBox',
    //
    Legato.Control.QName('DrawBox'),
    //
    {
      _constructor :Legato.Control.DrawBox,
      constructorArguments : {
        layer :OpenLayers.Layer.Bean
      },
      constructorOrder : [ 'layer' ]
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawPoint = OpenLayers.Class(Legato.Control.DrawFeature, {
  handlerConstructor : Legato.Handler.Point,

  initialize : function(layer, options) {
    var that = this;

    this.callbacks = {
      done : function(geometry) {
        this.layer.events.triggerEvent('legato.sketchpointadded', {
          layer : this.layer,
          vertex : this.handler.point.geometry,
          geometry : geometry
        });
        that.drawFeature(geometry);
      }
    };

    Legato.Control.DrawFeature.prototype.initialize.apply(this, [ layer, options ]);
  },
  CLASS_NAME : 'Legato.Control.DrawPoint'
});

Legato.Control.DrawPoint.Bean = Legato.Control.DrawFeature.Bean.Extend(
//
'Legato.Control.DrawPoint',
//
Legato.Control.QName('DrawPoint'),
//
{
  _constructor : Legato.Control.DrawPoint,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawLineString = OpenLayers.Class(Legato.Control.DrawFeature, {
  handlerConstructor :Legato.Handler.Path,

  CLASS_NAME :'Legato.Control.DrawLineString'
});

Legato.Control.DrawLineString.Bean = Legato.Control.DrawFeature.Bean.Extend(
//
    'Legato.Control.DrawLineString',
    //
    Legato.Control.QName('DrawLineString'),
    //
    {
      _constructor :Legato.Control.DrawLineString,
      constructorArguments : {
        layer :OpenLayers.Layer.Bean
      },
      constructorOrder : [ 'layer' ]
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawPolygon = OpenLayers.Class(Legato.Control.DrawFeature, {
  handlerConstructor : Legato.Handler.Polygon,

  CLASS_NAME : 'Legato.Control.DrawPolygon'
});

Legato.Control.DrawPolygon.Bean = Legato.Control.DrawFeature.Bean.Extend(
//
'Legato.Control.DrawPolygon',
//
Legato.Control.QName('DrawPolygon'),
//
{
  _constructor : Legato.Control.DrawPolygon,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawCircle = OpenLayers.Class(Legato.Control.DrawFeature, {
  handlerConstructor : Legato.Handler.RegularPolygon,
  measureDiv : null,

  initialize : function(layer, options) {
    if (options.measureDiv) {
      this.showLength = options.showLength;
      var callbacks = {
        move : this.measureRadius
      };

      this.callbacks = OpenLayers.Util.extend(callbacks, this.callbacks);
    }

    if(Legato.Lang.ObjectUtils.exists(options.handlerOptions)){
      if(!Legato.ObjectUtils.exists(options.handlerOptions.sides)){
        options.handlerOptions = OpenLayers.Util.extend(options.handlerOptions, {sides : 100});
      }
    }else{
      options.handlerOptions = {sides : 100};
    }

    Legato.Control.DrawFeature.prototype.initialize.apply(this, [ layer,
        options ]);
  },

  measureRadius : function(feature) {
    var radius = this.getRadius(feature);
    var out = 'Radius ' + radius[0] + ' ' + radius[1];
    this.measureDiv.innerHTML = out;
  },

  getRadius : function(geometry) {
    var units = [ 'km', 'm' ];
    var unit, length, radius;
    for ( var i = 0, len = units.length; i < len; ++i) {
      unit = units[i];
      length = this.getLength(geometry, unit);
      radius = (length / (2 * Math.PI));
      if (radius > 1) {
        break;
      }
    }
    return [ OpenLayers.Number.format(length / (2 * Math.PI), 3, ".", ","), unit ];
  },

  getLength : function(geometry, units) {
    var length = geometry.getLength();
    var geomUnits = this.map.getUnits();

    var inPerDisplayUnit = OpenLayers.INCHES_PER_UNIT[units];

    if (inPerDisplayUnit) {
      var inPerMapUnit = OpenLayers.INCHES_PER_UNIT[geomUnits];
      length *= (inPerMapUnit / inPerDisplayUnit);
    }

    return length;
  },

  deactivate : function() {
    if(this.measureDiv){
      this.measureDiv.innerHTML = '';
    }
    Legato.Control.DrawFeature.prototype.deactivate.apply(this, arguments);
  },

  CLASS_NAME : 'Legato.Control.DrawCircle'
});

Legato.Control.DrawCircle.Bean = Legato.Control.DrawFeature.Bean.Extend(
//
'Legato.Control.DrawCircle',
//
Legato.Control.QName('DrawCircle'),
//
{
  _constructor : Legato.Control.DrawCircle,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawMultiPoint = OpenLayers.Class(Legato.Control.DrawFeature, {
  handlerConstructor : Legato.Handler.MultiPoint,
  mode : 1,

  initialize : function(layer, options) {
    var that = this;

    this.callbacks = {
      done : function(geometry) {
        this.layer.events.triggerEvent('legato.sketchpointadded', {
          layer : this.layer,
          vertex : this.handler.point.geometry,
          geometry : geometry
        });
        that.drawFeature(geometry);
      }
    };

    Legato.Control.DrawFeature.prototype.initialize.apply(this, [ layer, options ]);
  },
  CLASS_NAME : 'Legato.Control.DrawMultiPoint'
});

Legato.Control.DrawMultiPoint.Bean = Legato.Control.DrawFeature.Bean.Extend(
//
'Legato.Control.DrawMultiPoint',
//
Legato.Control.QName('DrawMultiPoint'),
//
{
  _constructor : Legato.Control.DrawMultiPoint,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawMultiLineString = OpenLayers.Class(Legato.Control.DrawFeature, {
  handlerConstructor : Legato.Handler.MultiLineString,
  mode : 1,
  initialize : function(layer, options) {
    var that = this;

    this.callbacks = {
      done : function(geometry) {
        this.layer.events.triggerEvent('legato.sketchpointadded', {
          layer : this.layer,
          vertex : this.handler.point.geometry,
          geometry : geometry
        });
        that.drawFeature(geometry);
      }
    };

    Legato.Control.DrawFeature.prototype.initialize.apply(this, [ layer, options ]);
  },
  CLASS_NAME : 'Legato.Control.DrawMultiLineString'
});

Legato.Control.DrawMultiLineString.Bean = Legato.Control.DrawFeature.Bean.Extend(
//
'Legato.Control.DrawMultiLineString',
//
Legato.Control.QName('DrawMultiLineString'),
//
{
  _constructor : Legato.Control.DrawMultiLineString,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawMultiPolygon = OpenLayers.Class(Legato.Control.DrawFeature, {
  handlerConstructor : Legato.Handler.MultiPolygon,
  mode : 1,
  initialize : function(layer, options) {
    var that = this;

    this.callbacks = {
      done : function(geometry) {
        this.layer.events.triggerEvent('legato.sketchpointadded', {
          layer : this.layer,
          vertex : this.handler.point.geometry,
          geometry : geometry
        });
        that.drawFeature(geometry);
      }
    };

    Legato.Control.DrawFeature.prototype.initialize.apply(this, [ layer, options ]);
  },
  CLASS_NAME : 'Legato.Control.DrawMultiPolygon'
});

Legato.Control.DrawMultiPolygon.Bean = Legato.Control.DrawFeature.Bean.Extend(
//
'Legato.Control.DrawMultiPolygon',
//
Legato.Control.QName('DrawMultiPolygon'),
//
{
  _constructor : Legato.Control.DrawMultiPolygon,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawText = OpenLayers.Class(Legato.Control.DrawPoint, {
  handlerConstructor : Legato.Handler.Point,
  textPrompt : function(callback) {
    var labelText = prompt(Legato.I18n.getMessage('Legato.Control.DrawText.TextPrompt'), 'TEXT');
    callback(labelText);
  },

  initialize : function(layer, options) {
    Legato.Control.DrawPoint.prototype.initialize.apply(this,
        [ layer, options ]);
  },
  drawFeature : function(geometry) {
    var that = this;
    this.textPrompt(function(label) {
      if (!Legato.Lang.StringUtils.isEmpty(label)) {
        var attributes = OpenLayers.Util.extend({}, that.attributes);
        var style = that.style !== null ? OpenLayers.Util.extend({}, that.style)
            : null;
        var feature = new OpenLayers.Feature.Vector(geometry, attributes, style);
        feature.style.label = label;
        var proceed = that.layer.events.triggerEvent('sketchcomplete', {
          feature : feature
        });
        if (proceed !== false) {
          feature.state = OpenLayers.State.INSERT;
          if (that.mode == 1) {
            that.layer.addFeatures([ feature ]);
            that.featureAdded(feature);
            that.events.triggerEvent('featureadded', {
              feature : feature
            });
          }
          if (that.mode == 2) {
            that.layer.destroyFeatures();
            that.layer.addFeatures([ feature ]);
            that.featureAdded(feature);
            that.events.triggerEvent('featureadded', {
              feature : feature
            });
          }
        }
        if (Legato.Lang.ObjectUtils.isFunction(this.callback)) {
          that.callback(geometry);
        }
      }
    });
  },
  CLASS_NAME : 'Legato.Control.DrawText'
});

Legato.Control.DrawPoint.Bean = Legato.Control.DrawFeature.Bean.Extend(
//
'Legato.Control.DrawText',
//
Legato.Control.QName('DrawText'),
//
{
  _constructor : Legato.Control.DrawPoint,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ]
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ExtendedPanel = OpenLayers.Class(OpenLayers.Control.Panel,
    {
      visibleControls : [],

      addControls : function(controls) {
        if (!(OpenLayers.Util.isArray(controls))) {
          controls = [ controls ];
        }
        var dropDownControls = []; 

        this.visibleControls = this.visibleControls.concat(controls);
        this.controls = this.controls.concat(controls);

        for ( var i = 0, len = controls.length; i < len; i++) {
          var control = controls[i];
          if(this.isControlContainer(control)){
            control.setParentPanel(this);
            this.controls = this.controls.concat(control.controls);
            dropDownControls = dropDownControls.concat(control.controls);
          }else{
            control.panel_div = this.createControlPanelDiv(control);
          }
        }

        if (this.map) { // map.addControl() has already been called on the panel
          this.addControlsToMap(controls.concat(dropDownControls));
          this.redraw();
        }
      },
      
      iconOn: function() {
        OpenLayers.Control.Panel.prototype.iconOn.apply(this, arguments);
        OpenLayers.Element.removeClass(this.panel_div, "ItemInactive");
        OpenLayers.Element.addClass(this.panel_div, "ItemActive");
      },

      iconOff: function() {
        OpenLayers.Control.Panel.prototype.iconOff.apply(this, arguments);
        OpenLayers.Element.removeClass(this.panel_div, "ItemActive");
        OpenLayers.Element.addClass(this.panel_div, "ItemInactive");
      },

      redraw : function() {
        for ( var l = this.div.childNodes.length, i = l - 1; i >= 0; i--) {
          this.div.removeChild(this.div.childNodes[i]);
        }
        this.div.innerHTML = "";
        if (this.active) {
          for ( var j = 0, len = this.visibleControls.length; j < len; j++) {
            this.div.appendChild(this.visibleControls[j].panel_div);
          }
        }
      },
      
      createControlPanelDiv : function(control) {
        var panel_div = document.createElement("div");
        
        OpenLayers.Element.addClass(panel_div, control.displayClass
            + "ItemInactive");
        OpenLayers.Element.addClass(panel_div, "ItemInactive");
        OpenLayers.Element.addClass(panel_div, "olButton");
        
        if (control.title != "" && !panel_div.title) {
          panel_div.title = control.title;
        }
        
        return panel_div;
      },
      
      isControlContainer: function(control){
        return 'Legato.Control.ControlContainer' === control.CLASS_NAME 
            || 'LegatoJQuery.Control.ControlContainer' === control.CLASS_NAME;
      },
      
      CLASS_NAME : "Legato.Control.ExtendedPanel"
    });

/**
 * Class: Legato.Control.Panel
 * 
 * The Panel control is a container for other controls. With it toolbars may be
 * composed.
 * 
 * Inherits from: - <OpenLayers.Control.Panel>
 */
Legato.Control.ExtendedPanel.Bean = OpenLayers.Control.Panel.Bean.Extend(
    'Legato.Control.ExtendedPanel', Legato.Control.QName('ExtendedPanel'), {
      _constructor : Legato.Control.ExtendedPanel
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: FeatureSelector
 *
 * Inherits from: - <OpenLayers.Control>
 */
Legato.Control.FeatureSelector = OpenLayers.Class(Legato.Control, {

  type : OpenLayers.Control.TYPE_TOOL,

  eventTypes : [ 'addlayer', 'removelayer', 'changebaselayer', 'legato.selectlayer', 'legato.deselectlayer' ],

  layerPredicate : null,

  controller : null,

  callback : null,

  exceptionHandler : null,

  handlerConstructor : Legato.Handler.Box,

  enabled : false,

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
    if (!Legato.Lang.ObjectUtils.isFunction(this.callback)) {
      this.callback = function(result) {
      };
    }
    if (!Legato.Lang.ObjectUtils.isFunction(this.exceptionHandler)) {
      this.exceptionHandler = function(message, exception) {
        alert(message);
      };
    }
    if (!Legato.Lang.ObjectUtils.isFunction(this.controller)) {
      this.controller = function(layers, selectionGeometry, mode, callbacks) {
        return callbacks.callback({
          layers : layers,
          selectionGeometry : selectionGeometry,
          mode : mode
        });
      };
    }
    if (!Legato.Lang.ObjectUtils.isObject(this.layerPredicate)) {
      this.layerPredicate = new Legato.Predicate.True();
    }
  },

  /**
   * Method: draw
   */
  createHandlers: function() {
    this.handlers = {};

    this.handlers.clickNone = new this.handlerConstructor(
      this,
      { done : OpenLayers.Function.bind(this.selectGeometry, this, OpenLayers.Handler.MOD_NONE)},
      { keyMask : OpenLayers.Handler.MOD_NONE }
    );

    this.handlers.clickShift = new this.handlerConstructor(
        this,
        { done: OpenLayers.Function.bind(this.selectGeometry, this, OpenLayers.Handler.MOD_SHIFT)},
        { keyMask: OpenLayers.Handler.MOD_SHIFT }
    );

    this.handlers.clickCtrl = new this.handlerConstructor(
        this,
        { done: OpenLayers.Function.bind(this.selectGeometry, this, OpenLayers.Handler.MOD_CTRL)},
        { keyMask: OpenLayers.Handler.MOD_CTRL }
    );
  },
  destroy : function() {
    for ( var index = 0; index < this.eventTypes.length; index++) {
      var eventType = this.eventTypes[index];
      this.map.events.unregister(eventType, this, this.refresh);
    }
    this.layerPredicate = null;
    this.controller = null;
    this.handlerConstructor = null;
    this.enabled = false;
    this.handlers.clickNone.destroy();
    this.handlers.clickCtrl.destroy();
    this.handlers.clickShift.destroy();
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },
  getLayers : function() {
    var layers = [];
    for ( var index = 0; index < this.map.layers.length; index++) {
      var layer = this.map.layers[index];
      if (this.layerPredicate.evaluate(layer)) {
        layers.push(layer);
      }
    }
    return layers;

  },
  selectGeometry : function(mode, selectionGeometry) {
    this.controller(this.getLayers(), selectionGeometry, mode, {
      callback: this.callback,
      exceptionHandler: this.exceptionHandler
    });
  },
  addStatusCssClass : function(element){
    if(this.enabled){
      OpenLayers.Element.addClass(element, 'enabled');
    }
    else {
      OpenLayers.Element.addClass(element, 'disabled');
    }
  },
  removeStatusCssClass : function(element){
    if(this.enabled){
      OpenLayers.Element.removeClass(element, 'enabled');
    }
    else {
      OpenLayers.Element.removeClass(element, 'disabled');
    }
  },
  refresh : function() {
    var layers = this.getLayers();
    this.enabled = (layers.length > 0);
    if (!this.enabled) {
      OpenLayers.Element.removeClass(this.panel_div, 'enabled');
      OpenLayers.Element.addClass(this.panel_div, 'disabled');
      this.deactivate();
    } else {
      OpenLayers.Element.removeClass(this.panel_div, 'disabled');
      OpenLayers.Element.addClass(this.panel_div, 'enabled');
    }
  },
  activate : function() {
    this.removeStatusCssClass(this.panel_div);

    if (this.enabled) {
      this.handlers.clickNone.activate();
      this.handlers.clickCtrl.activate();
      this.handlers.clickShift.activate();
      OpenLayers.Control.prototype.activate.apply(this, arguments);
    }

    this.addStatusCssClass(this.panel_div);
  },
  deactivate : function() {
    this.removeStatusCssClass(this.panel_div);

    this.handlers.clickNone.deactivate();
    this.handlers.clickCtrl.deactivate();
    this.handlers.clickShift.deactivate();
    OpenLayers.Control.prototype.deactivate.apply(this, arguments);

    this.addStatusCssClass(this.panel_div);
  },
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);

    if (!Legato.Lang.ObjectUtils.isObject(this.handlers)) {
      this.createHandlers();
    }

    for ( var index = 0; index < this.eventTypes.length; index++) {
      var eventType = this.eventTypes[index];
      this.map.events.register(eventType, this, this.refresh);
    }
    this.refresh();

  },

  CLASS_NAME : 'Legato.Control.FeatureSelector'
});

Legato.Control.FeatureSelector.Bean = Legato.Control.Bean.Extend(

'Legato.Control.FeatureSelector',

Legato.Control.QName('FeatureSelector'), {
  _constructor : Legato.Control.FeatureSelector,
  options : {
    /*
     * Property: layerPredicate
     *
     * Predicate which tells if a layer should be considered for feature
     * selection or not.
     */
    layerPredicate : Legato.Beans.Object,

    /*
     * Property: controller
     *
     * Feature selection function. Function with an interface function(layers,
     * selectionGeometry, mode, { callback: callback, exceptionHandler: exceptionHandler }).
     */
    controller : Legato.Lang.Function,

    /*
     * Property: callback
     *
     * Callback for selection results. Function with an interface
     * function(result).
     */
    callback : Legato.Lang.Function,
    /*
     * Property: exceptionHandler
     *
     * Callback for exception handler. Function with an interface
     * function(message, exception).
     */
    exceptionHandler : Legato.Lang.Function,

    /*
     * Property: eventTypes
     *
     * Types of map events this control should react to.
     */
    eventTypes : Legato.Lang['String[]']
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: Legato.Control.LayersValueProvider
 * ValueProvider which gives you the possibility to be notified about every
 * change of all current used <OpenLayers.Layer> instances inside the <OpenLayers.Map>.
 *
 * You can watch a defined property of all <OpenLayers.Layer> instances. All layer values
 * will be given back by a comma seperated list.
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.LayersValueProvider = OpenLayers.Class(Legato.Control,
{
  /*
   * Function: initialize
   * Basic ctor
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control
   * The following keys are supported
   * - target {object} an object which wants to observe,
   * - property{function|String} the propety or function which should be used for providing the observed value
   * - layerValue {String} any Property name of an <OpenLayers.Layer> instance
   * - layerVisible {Boolean} true = only watch visible layers, false = only watch invisible layers. Default is true.
   */
  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
  },

  /*
   * Function: destroy
   *
   * See Also:
   * <OpenLayer.Control>
   */
   destroy : function() {
    this.map.events.un( {
      'addlayer' : this.propagateValue,
      'changelayer' : this.propagateValue,
      'removelayer' : this.propagateValue,
      'changebaselayer' : this.propagateValue,
      scope : this
    });

    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  /*
   * Function: setMap
   *
   * See Also:
   * <OpenLayer.Control>
   */
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);

    this.map.events.on( {
      'addlayer' : this.propagateValue,
      'changelayer' : this.propagateValue,
      'removelayer' : this.propagateValue,
      'changebaselayer' : this.propagateValue,
      scope : this
    });
   },

  /*
   * Function: draw
   *
   * See Also:
   * <OpenLayer.Control>
   */
  draw : function() {
    this.propagateValue();
    return this.div;
  },

  /*
   * updates all subscribed target's values by iterating
   * throw all layers and firing the corresponding target setters
   * if valid and present.
   */
  propagateValue: function(){
    if(!Legato.Lang.ObjectUtils.isFunction(this.setValue)){
      return;
    }

    this.setValue(this.map.layers);
  },

  CLASS_NAME : 'Legato.Control.LayersValueProvider'
});

/**
 * Structure: lc:LayersValueProvider
 * XML based config for a <Legato.Control.LayersValueProvider>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a LayersValueProvider would be:
 * (start code)
 * <lc:LayersValueProvider layerList="layerList" layerListVisible="layerListVisible" layerListInvisible="layerListInvisible"/>
 * (end)
 */
Legato.Control.LayersValueProvider.Bean = Legato.Control.Bean.Extend(

  'Legato.Control.LayersValueProvider',

  /*
   * Property: QName
   * The qualified name for this control. Needed by XML config to instantiate it.
   */
  Legato.Control.QName('LayersValueProvider'),
  {
   /*
    * Creates a basic <Legato.Control.LayersValueProvider> instance. By default this control will write
    * into three configured DOMElements. All changes in given DOMElements will not cause an update
    * of given map.
    *
    * Parameters:
    * layerList - {String} The configured DOMElement ID where all layers in their correct order should be written into
    * layerListVisible - {String} The configured DOMElement ID where all visible layers (baselayers and overlays) should be written into
    * layerListInvisible - {String} The configured DOMElement ID where all invisible layers (baselayers and overlays) should be written into
    *
    * Returns:
    * <Legato.Control.LayersValueProvider>
    */
    factoryFunction : function(layerList, layerListVisible, layerListInvisible)
    {
      var layerlistElement = null;
      var layerListVisibleElement = null;
      var layerListInvisibleElement = null;

      if(Legato.Lang.ObjectUtils.isString(layerList)){
        layerlistElement = OpenLayers.Util.getElement(layerList);
        Legato.Util.Ensure.ensureExists(layerlistElement, 'LayersValueProvider: The configured DOMElement with the id' + layerList + ' could not been found.');
      }
      if(Legato.Lang.ObjectUtils.isString(layerListVisible)){
        layerListVisibleElement = OpenLayers.Util.getElement(layerListVisible);
        Legato.Util.Ensure.ensureExists(layerListVisibleElement, 'LayersValueProvider: The configured DOMElement with the id' + layerListVisible + ' could not been found.');
      }
      if(Legato.Lang.ObjectUtils.isString(layerListInvisible)){
        layerListInvisibleElement = OpenLayers.Util.getElement(layerListInvisible);
        Legato.Util.Ensure.ensureExists(layerListInvisibleElement, 'LayersValueProvider: The configured DOMElement with the id' + layerListInvisible + ' could not been found.');
      }

      return new Legato.Control.LayersValueProvider({
        elements: {
          layerList: layerlistElement,
          layerListVisible: layerListVisibleElement,
          layerListInvisible: layerListInvisibleElement
        },
        setValue: function(layers){
            if(!Legato.Lang.ObjectUtils.exists(layers)){
              return;
            }

            this.elements.layerList.value = Legato.Lang.CollectionUtils.transform(layers, function(layer){
              return layer.name;
            }).toString();

            this.elements.layerListVisible.value = Legato.Lang.CollectionUtils.transform(Legato.OpenLayers.Map.Util.getVisibleLayers(layers), function(layer){
              return layer.name;
            }).toString();

            this.elements.layerListInvisible.value = Legato.Lang.CollectionUtils.transform(Legato.OpenLayers.Map.Util.getInvisibleLayers(layers), function(layer){
              return layer.name;
            }).toString();
          }
        });
    },
    constructorArguments:
    {
      /*
      * Property layerList
       * Defines the {DOMElement} id where all <OpenLayers.Layer> names should be written into.
       * The DOMElement must exists in current DOM. Otherwise an Exception is thrown.
      */
      layerList: Legato.Lang.String,

     /*
      * Property: layerListVisible
       * Defines the {DOMElement} id where all visible <OpenLayers.Layer> names should be written into.
       * The DOMElement must exists in current DOM. Otherwise an Exception is thrown.
      */
      layerListVisible: Legato.Lang.String,

     /*
      * Property: layerListInvisible
       * Defines the {DOMElement} id where all invisible <OpenLayers.Layer> names should be written into.
       * The DOMElement must exists in current DOM. Otherwise an Exception is thrown.
      */
      layerListInvisible: Legato.Lang.String
    },
    constructorOrder: ['layerList', 'layerListVisible', 'layerListInvisible']
  }
);
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.LayerSelection = OpenLayers.Class( {
  map :null,
  initialize : function(map) {
    this.map = map;
    this.map.selectLayer = OpenLayers.Function.bind(this.selectLayer, this);
    this.map.deselectLayer = OpenLayers.Function.bind(this.deselectLayer, this);
  },
  selectLayer : function(selectedLayer) {
    for ( var index = 0; index < this.map.layers.length; index++) {
      var deselectedLayer = this.map.layers[index];
      if (Legato.Lang.ObjectUtils.isTrue(deselectedLayer.selected)) {
        deselectedLayer.selected = false;
        this.map.events.triggerEvent("legato.deselectlayer", {
          layer :deselectedLayer
        });
      }
    }
    if (Legato.Lang.ObjectUtils.exists(selectedLayer)) {
      if (Legato.Lang.ObjectUtils.isFalse(selectedLayer.selected)) {
        selectedLayer.selected = true;
        this.map.events.triggerEvent("legato.selectlayer", {
          layer :selectedLayer
        });
      }
    }
  },
  deselectLayer : function(deselectedLayer) {
    if (Legato.Lang.ObjectUtils.exists(deselectedLayer)) {
      if (Legato.Lang.ObjectUtils.isTrue(deselectedLayer.selected)) {
        deselectedLayer.selected = false;
        this.map.events.triggerEvent("legato.deselectlayer", {
          layer :deselectedLayer
        });
      }
    }
  },
  destroy : function() {
    this.map.selectLayer = null;
  },
  CLASS_NAME :'Legato.Control.LayerSelection'
});

Legato.Control.LayerSelection.Bean = Legato.Beans.Object.Extend(

'Legato.Control.LayerSelection',

Legato.Control.QName('LayerSelection'), {
  _constructor :Legato.Control.LayerSelection,
  constructorArguments : {
    map :OpenLayers.Map.Bean
  },
  constructorOrder : [ 'map' ]
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.SketchLayerEditor = OpenLayers
    .Class(
        Legato.Control,
        {
          /**
           * Property: map {OpenLayers.Map} the current used map
           */
          map : null,
          /**
           * Property: layer {OpenLayers.Layer.Vector}
           */
          layer : null,
          /**
           * Property: inputPanel {Legato.Style} a list of named style
           * definitions
           */
          styles : null,
          /**
           * Property: div {DOMElement} parent element
           */
          div : null,
          /**
           * Property: div {DOMElement} parent element
           */
          measureDiv : null,
          /**
           * Property: container {DOMElement} where this sketch layer editor
           * will paint its controls
           */
          container : null,
          /**
           * Property: controlsPanel {OpenLayers.Control.Panel} the main control
           * panel for all input controls
           */
          controlsPanel : null,
          stylePropertiesEditor : null,
          executeCallback : null,
          cancelCallback : null,

          /*
           * Function: initialize
           *
           * See Also: <OpenLayer.Control>
           */
          initialize : function(options) {
            OpenLayers.Control.prototype.initialize.apply(this, arguments);
          },

          /*
           * Function: destroy
           *
           * See Also: <OpenLayer.Control>
           */
          destroy : function() {
            OpenLayers.Control.prototype.destroy.apply(this, arguments);
            this.unregisterLayerEvents();
          },

          draw : function() {
            OpenLayers.Control.prototype.draw.apply(this, arguments);
            return this.div;
          },
          /*
           * Returns a merged style map of configured style definitions and
           * default styles.
           */
          getStyles : function() {
            var defaultSketchStyles = Legato.Feature.Sketch.style['default'];

            if (this.styles) {
              for ( var i = 0; i < this.styles.length; i++) {
                var configuredStyle = this.styles[i];
                var configuredStyleName = configuredStyle.name.toUpperCase();
                if (defaultSketchStyles[configuredStyleName]) {
                  OpenLayers.Util.extend(
                      defaultSketchStyles[configuredStyleName],
                      configuredStyle.styles);
                }
              }
            }

            return defaultSketchStyles;
          },

          execute : function(onExecute, onCancel, hideCancelButton) {
            this.executeCallback = onExecute;
            this.cancelCallback = onCancel;

            if (this.layer !== null) {
              return;
            }
            var layerOptions = {
              calculateInRange : function() {
                return true;
              },
              legatoIgnore : true,
              isFeatureLayer : true
            };
            var layerName = Legato.I18n
                .getMessage('Legato.Control.SketchLayerEditor.LayerName');
            this.layer = new OpenLayers.Layer.Vector(layerName, layerOptions);
            this.registerLayerEvents();
            this.map.addLayer(this.layer);
            this.createForm(onExecute, onCancel, hideCancelButton);
          },

          createForm : function(onExecute, onCancel, hideCancelButton) {
            if (this.container === null) {
              this.container = document.createElement('div');
              this.container.className = 'sketchLayerEditorContainer';
            }

            var abstractElement = document.createElement('div');
            abstractElement.className = 'sketchLayerEditorAbstract';
            abstractElement.innerHTML = Legato.I18n
                .getMessage('Legato.Control.SketchLayerEditor.Abstract');
            this.container.appendChild(abstractElement);

            this.controls = [];
            var controlsContainer = document.createElement('div');
            controlsContainer.className = 'sketchLayerEditorControlsContainer';
            this.container.appendChild(controlsContainer);

            var controlsPanelDiv = document.createElement('div');
            OpenLayers.Element.addClass(controlsPanelDiv, 'olControlPanel');
            controlsContainer.appendChild(controlsPanelDiv);

            if (Legato.Lang.ObjectUtils.exists(this.stylePropertiesEditor)) {
              var stylesPanelDiv = document.createElement('div');
              OpenLayers.Element.addClass(stylesPanelDiv, 'legatoStylesPanel');
              controlsContainer.appendChild(stylesPanelDiv);
              this.stylePropertiesEditor.setLayer(this.layer);
              stylesPanelDiv.appendChild(this.stylePropertiesEditor.div);
              var radiusMeasureDiv = document.createElement('div');
              radiusMeasureDiv.className = 'radiusMeasureStatus';
              controlsContainer.appendChild(radiusMeasureDiv);
              this.measureDiv = radiusMeasureDiv;
            }

            var drawText = this.createDrawControl('TEXT', Legato.I18n
                .getMessage('Legato.Control.SketchLayerEditor.Text'),
                Legato.Control.DrawText);
            var drawPoint = this.createDrawControl('POINT', Legato.I18n
                .getMessage('Legato.Control.SketchLayerEditor.Point'),
                Legato.Control.DrawPoint);
            var drawMultiLineString = this
                .createDrawControl('LINE', Legato.I18n
                    .getMessage('Legato.Control.SketchLayerEditor.Line'),
                    Legato.Control.DrawMultiLineString);
            var drawPolygon = this.createDrawControl('POLYGON', Legato.I18n
                .getMessage('Legato.Control.SketchLayerEditor.Polygon'),
                Legato.Control.DrawPolygon);
            var drawCircle = this.createDrawCircleControl('POLYGON',
                Legato.I18n
                    .getMessage('Legato.Control.SketchLayerEditor.Circle'));

            var modifyFeature = new Legato.Control.ModifyMultiPolygon(
                this.layer, {
                  title : Legato.I18n
                      .getMessage('Legato.Control.SketchLayerEditor.Edit'),
                  mode : Legato.Control.ModifyFeature.MODE_RESHAPE,
                  type : OpenLayers.Control.TYPE_TOOL
                });
            var removeFeature = new OpenLayers.Control.DeleteFeature(
                this.layer, this.onDeleteFeatureSelect,
                this.onDeleteFeatureUnselect, {
                  title : Legato.I18n
                      .getMessage('Legato.Control.SketchLayerEditor.Delete'),
                  type : OpenLayers.Control.TYPE_TOOL
                });

            var panelOptions = {
              div : controlsPanelDiv,
              defaultControl : drawPoint
            };

            this.controlsPanel = new OpenLayers.Control.Panel(panelOptions);
            this.controlsPanel.addControls([ drawText, drawPoint,
                drawMultiLineString, drawPolygon, drawCircle, modifyFeature,
                removeFeature ]);

            for ( var i = 0; i < this.controlsPanel.controls.length; i++) {
              this.controlsPanel.controls[i].events.on({
                'activate' : this.onActivate,
                'deactivate' : this.onDeactivate,
                scope : this
              });
            }
            this.map.addControl(this.controlsPanel);

            var buttonsElement = document.createElement('div');
            buttonsElement.className = 'sketchLayerEditorButtons';
            this.container.appendChild(buttonsElement);

            var executeButton = document.createElement('input');
            executeButton.type = 'button';
            executeButton.value = Legato.I18n
                .getMessage('Legato.Control.SketchLayerEditor.Execute');
            executeButton.onclick = OpenLayers.Function.bindAsEventListener(
                this.executeButtonClicked, this);
            buttonsElement.appendChild(executeButton);

            if (!hideCancelButton) {
              var cancelButton = document.createElement('input');
              cancelButton.type = 'button';
              cancelButton.value = Legato.I18n
              .getMessage('Legato.Control.SketchLayerEditor.Cancel');
              cancelButton.onclick = OpenLayers.Function.bindAsEventListener(
                  this.cancelButtonClicked, this);
              buttonsElement.appendChild(cancelButton);
            }

            this.div.appendChild(this.container);
          },

          createDrawControl : function(type, title, typeClass) {
            var style = this.createStyle(type);
            var attributes = this.createAttributesMap(type);

            return new typeClass(this.layer, {
              title : title,
              type : OpenLayers.Control.TYPE_TOOL,
              style : style,
              attributes : attributes
            });
          },

          createDrawCircleControl : function(type, title) {
            var style = this.createStyle(type);
            var attributes = this.createAttributesMap(type);

            return new Legato.Control.DrawCircle(this.layer, {
              title : title,
              type : OpenLayers.Control.TYPE_TOOL,
              style : style,
              attributes : attributes,
              measureDiv : this.measureDiv
            });
          },

          createStyle : function(type) {
            var featureStyles = this.getStyles();
            return OpenLayers.Util.extend({
              "x-type" : type
            }, featureStyles[type]);
          },

          createAttributesMap : function(type) {
            var attributeList = Legato.Feature.Sketch.Attributes[type];
            var attributesMap = {
              "x-type" : type
            };
            for ( var i = 0; i < attributeList.length; i++) {
              attributesMap[attributeList[i]] = null;
            }
            return attributesMap;
          },

          onDeactivate : function(event) {
            this.events.triggerEvent('deactivate', {
              component : this
            });
            if (Legato.Lang.ObjectUtils.exists(this.stylePropertiesEditor)) {
              this.stylePropertiesEditor.deactivate();
            }
          },

          onActivate : function(event) {
            this.events.triggerEvent('activate', {
              component : this
            });
            var style = event.object.style;
            if (Legato.Lang.ObjectUtils.exists(this.stylePropertiesEditor)) {
              if (Legato.Lang.ObjectUtils.exists(style)) {
                this.stylePropertiesEditor.setStyle(style);
                this.stylePropertiesEditor.activate();
              } else {
                this.stylePropertiesEditor.deactivate();
              }
            }
          },

          activate : function() {
            if (this.controlsPanel) {
              this.controlsPanel.activate();
            }
          },

          deactivate : function() {
            if (this.controlsPanel) {
              for ( var i = 0; i < this.controlsPanel.controls.length; i++) {
                this.controlsPanel.controls[i].deactivate();
              }
              this.controlsPanel.redraw();
            }
          },
          executeButtonClicked : function() {
            var sketchLayerAsGeoJSON = this.getSketchLayerAsGeoJSON();
            this.executeCallback(sketchLayerAsGeoJSON);
          },

          cancelButtonClicked : function() {
            this.cancelCallback();
          },

          onDeleteFeatureSelect : function(feature) {
            var type = feature.attributes['x-type'];
            var selectStyles = Legato.Feature.Sketch.style.select;
            OpenLayers.Util.extend(feature.style, selectStyles[type]);
            this.layer.redraw();
          },

          onDeleteFeatureUnselect : function(feature) {
            var type = feature.attributes['x-type'];
            var selectStyles = Legato.Feature.Sketch.style['default'];
            OpenLayers.Util.extend(feature.style, selectStyles[type]);
            this.layer.redraw();
          },

          onBeforeFeatureModified : function(event){
            var style = event.feature.style;
            if (Legato.Lang.ObjectUtils.exists(this.stylePropertiesEditor)) {
              if (Legato.Lang.ObjectUtils.exists(style)) {
                this.stylePropertiesEditor.setStyle(style);
                this.stylePropertiesEditor.activate();
              } else {
                this.stylePropertiesEditor.deactivate();
              }
            }
          },

          registerLayerEvents : function() {
            this.layer.events.on({
              'beforefeaturemodified' : this.onBeforeFeatureModified,
              scope : this
            });
          },

          unregisterLayerEvents : function() {
            this.layer.events.un({
              'beforefeaturemodified' : this.onBeforeFeatureModified,
              scope : this
            });
          },

          getSketchLayerAsGeoJSON : function() {
            var writer = new OpenLayers.Format.GeoJSON();
            for ( var i = 0; i < this.layer.features.length; i++) {
              var feature = this.layer.features[i];
              var style = feature.style;
              var featureAttributes = feature.attributes;
              /* jslint forin:true */
              for ( var attribute in featureAttributes) {
                if (featureAttributes.hasOwnProperty(attribute)) {
                  var styleAttribute = Legato.Feature.Sketch.AttributeStyleMap[attribute];
                  featureAttributes[attribute] = style[styleAttribute];
                }
              }
              /* jslint forin:false */
            }
            return writer.write(this.layer.features, true);
          },

          reset : function() {
            if (!Legato.Lang.ObjectUtils.isNullOrUndefined(this.layer)
                && !Legato.Lang.ObjectUtils.isNullOrUndefined(this.container)) {
              this.deactivate();
              this.div.removeChild(this.container);
              this.map.removeLayer(this.layer);
              this.map.removeControl(this.controlsPanel);
              this.controlsPanel.destroy();
              this.controlsPanel = null;
              this.layer = null;
              this.container = null;
            }
          },

          CLASS_NAME : "Legato.Control.SketchLayerEditor"
        });
Legato.Control.SketchLayerEditor.Bean = Legato.Control.Bean.Extend(
    'Legato.Control.SketchLayerEditor', Legato.Control
        .QName('SketchLayerEditor'), {
      _constructor : Legato.Control.SketchLayerEditor,
      options : {
        map : OpenLayers.Map,
        div : Legato.Lang.Element,
        measureDiv : Legato.Lang.Element,
        styles : Legato.Beans.Object.List(),
        stylePropertiesEditor : Legato.Control
      }
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.Legend = OpenLayers
		.Class(
				OpenLayers.Control,
				{
					div : null,
					legendDiv : null,
					baseLayersDiv : null,
					overlaysDiv : null,
					/**
					 * Container plugin factory.
					 */
					containerPlugin : null,
					/**
					 * Plugin factories.
					 */
					plugins : null,
					/**
					 * Containers (plugin instances) for base layers.
					 */
					baseLayerContainers : null,
					/**
					 * Containers (plugin instances) for overlays.
					 */
					overlayContainers : null,

					initialize : function(options) {
						OpenLayers.Control.prototype.initialize.apply(this,
								arguments);
						if (!Legato.Lang.ObjectUtils
								.exists(this.containerPlugin)) {
							this.containerPlugin = new Legato.Control.Legend.Plugin.Layer.Factory();
						}
						if (!Legato.Lang.ObjectUtils.exists(this.plugins)) {
							this.plugins = [];
						}
						if (!Legato.Lang.ObjectUtils
								.isBoolean(this.showBaseLayers)) {
							this.showBaseLayers = false;
						}
						if (this.showBaseLayers) {
							this.baseLayerContainers = [];
						}
						this.overlayContainers = [];
					},
					/*
					 * Function: setMap Set the map property for the control.
					 *
					 * Parameters: map - {<OpenLayers.Map>}
					 */
					setMap : function(map) {
						OpenLayers.Control.prototype.setMap.apply(this,
								arguments);

						this.map.events.on({
							'addlayer' : this.layerAdded,
							'changelayer' : this.layerChanged,
							'removelayer' : this.layerRemoved,
							scope : this
						});
					},
					/*
					 * Function: destroy APIMethod: called if destroyed
					 */
					destroy : function() {
						this.map.events.un({
							'addlayer' : this.layerAdded,
							'changelayer' : this.layerChanged,
							'removelayer' : this.layerRemoved,
							scope : this
						});

						this.div.removeChild(this.legendDiv);
						if (this.showBaseLayers) {
							this.legendDiv.removeChild(this.baseLayersDiv);
							this.destroyContainers(this.baseLayerContainers);
							this.baseLayerContainers = null;
							this.baseLayersDiv = null;
						}

						this.legendDiv.removeChild(this.overlaysDiv);
						this.destroyContainers(this.overlayContainers);
						this.overlayContainers = null;
						this.overlaysDiv = null;

						OpenLayers.Control.prototype.destroy.apply(this,
								arguments);
						this.div = null;
						this.legendDiv = null;
						this.plugins = null;
						this.containerPlugin = null;
					},
					layerAdded : function(event) {
						var layer = event.layer;
						if (this.showBaseLayers
								&& this.isListedBaseLayer(layer)) {
							this.doAddLayer(layer, this.baseLayerContainers,
									this.baseLayersDiv);
						}
						if (this.isListedOverlay(layer)) {
							this.doAddLayer(layer, this.overlayContainers,
									this.overlaysDiv);
						}
					},
					doAddLayer : function(layer, containers, element) {
						var container = this.createContainer(layer);
						containers.push(container);
						this.addContainer(element, container);
					},
					layerRemoved : function(event) {
						var layer = event.layer;
						if (this.showBaseLayers
								&& this.isListedBaseLayer(layer)) {
							this.doRemoveLayer(layer, this.baseLayerContainers,
									this.baseLayersDiv);
						}
						if (this.isListedOverlay(layer)) {
							this.doRemoveLayer(layer, this.overlayContainers,
									this.overlaysDiv);
						}
					},
					doRemoveLayer : function(layer, containers, element) {
						var containerIndex = this.findContainerIndex(
								containers, layer);
						if (containerIndex >= 0) {
							this.removeContainer(element,
									containers[containerIndex]);
							containers.splice(containerIndex, 1);
						}
					},
					layerChanged : function(event) {
						var property = event.property;
						if ('order' == event.property) {
							this.layerChangedOrder(event);
						}
					},
					layerChangedOrder : function(event) {
						var layer = event.layer;
						if (this.showBaseLayers
								&& this.isListedBaseLayer(layer)) {
							this.doChangeLayerOrder(layer,
									this.baseLayerContainers,
									this.baseLayersDiv);
						}
						if (this.isListedOverlay(layer)) {
							this.doChangeLayerOrder(layer,
									this.overlayContainers, this.overlaysDiv);
						}
					},
					doChangeLayerOrder : function(layer, containers, element) {
						var containerIndex = this.findContainerIndex(
								containers, layer);
						if (containerIndex >= 0) {
							var newContainerIndex = this.findNewContainerIndex(
									containers, layer);
							if (containerIndex != newContainerIndex) {
								var container = containers[containerIndex];
								element.removeChild(container.div);
								containers.splice(containerIndex, 1);
								if (newContainerIndex < containerIndex) {
									containers.splice(newContainerIndex, 0,
											container);
									if (newContainerIndex - 1 >= 0) {
										element
												.insertBefore(
														container.div,
														containers[newContainerIndex - 1].div);
									} else {
										element.appendChild(container.div);
									}
								} else {
									containers.splice(newContainerIndex - 1, 0,
											container);
									if (newContainerIndex - 2 >= 0) {
										element
												.insertBefore(
														container.div,
														containers[newContainerIndex - 2].div);
									} else {
										element.appendChild(container.div);
									}
								}
							}
						}

					},
					findNewContainerIndex : function(containers, layer) {
						var i = 0;
						var j = 0;
						while ((i < this.map.layers.length)
								&& (j < containers.length)) {
							if (this.map.layers[i] === layer) {
								return j;
							}
							if (this.map.layers[i] === containers[j].layer) {
								i++;
								j++;
							} else if (containers[j].layer === layer) {
								j++;
							} else {
								i++;
							}
						}
						return j;
					},
					findContainerIndex : function(containers, layer) {
						for ( var index = 0; index < containers.length; index++) {
							if (containers[index].layer === layer) {
								return index;
							}
						}
						return -1;
					},
					createContainers : function(layers) {
						var containers = [];
						for ( var index = 0; index < layers.length; index++) {
							containers[index] = this
									.createContainer(layers[index]);
						}
						return containers;
					},
					createContainer : function(layer) {
						var pluginFactories = [];
						for ( var i = 0; i < this.plugins.length; i++) {
							pluginFactories.push(this.plugins[i]);
						}
						//    if (Legato.Lang.ObjectUtils.isArray(layer.plugins))
						//    {
						//      for (var index = 0; index < layer.plugins.length; index++ )
						//      {
						//        pluginFactories.push(layer.plugins[index]);
						//      }
						//    }
						var plugins = [];
						for ( var j = 0; j < pluginFactories.length; j++) {
							if (pluginFactories[j].supports(layer)) {
								plugins.push(pluginFactories[j].create(layer));
							}
						}
						var containerFactory = this.containerPlugin;
						var container = containerFactory.create(layer, plugins);
						return container;
					},
					getListedBaseLayers : function() {
						return Legato.OpenLayers.Map.Util
								.getListedBaseLayers(this.map.layers);
					},
					getListedOverlays : function() {
						return Legato.OpenLayers.Map.Util
								.getListedOverlays(this.map.layers);
					},
					isListedBaseLayer : function(layer) {
						return Legato.OpenLayers.Map.Util
								.isListedBaseLayer(layer);
					},
					isListedOverlay : function(layer) {
						return Legato.OpenLayers.Map.Util
								.isListedOverlay(layer);
					},
					draw : function() {
						OpenLayers.Control.prototype.draw
								.apply(this, arguments);
						this.legendDiv = document.createElement('div');
						this.legendDiv.id = this.id + "_Legend";
						this.legendDiv.className = this.displayClass
								+ "Container";

						this.overlaysDiv = document.createElement('div');
						this.overlaysDiv.id = this.id + "_Overlays";
						this.overlaysDiv.className = this.displayClass
								+ "Overlays";
						this.legendDiv.appendChild(this.overlaysDiv);

						if (this.showBaseLayers) {
							this.baseLayersDiv = document.createElement('div');
							this.baseLayersDiv.id = this.id + "_BaseLayers";
							this.baseLayersDiv.className = this.displayClass
									+ "BaseLayers";
							this.legendDiv.appendChild(this.baseLayersDiv);
						}
						this.div.appendChild(this.legendDiv);
						this.update();
						return this.div;
					},

					update : function() {
						if (this.showBaseLayers) {
							this.removeContainers(this.baseLayersDiv,
									this.baseLayerContainers);
						}
						this.removeContainers(this.overlaysDiv,
								this.overlayContainers);
						if (this.showBaseLayers) {
							this.baseLayerContainers = this
									.createContainers(this
											.getListedBaseLayers());
							this.addContainers(this.baseLayersDiv,
									this.baseLayerContainers);
						}

						this.overlayContainers = this.createContainers(this
								.getListedOverlays());
						this.addContainers(this.overlaysDiv,
								this.overlayContainers);

					},
					addContainer : function(element, container) {
						var containerElement = container.draw();
						if (element.childNodes.length === 0) {
							element.appendChild(containerElement);
						} else {
							element.insertBefore(containerElement,
									element.childNodes[0]);
						}
					},
					addContainers : function(element, containers) {
						for ( var index = 0; index < containers.length; index++) {
							this.addContainer(element, containers[index]);
						}
					},
					removeContainer : function(element, container) {
						element.removeChild(container.div);
						container.destroy();
					},
					removeContainers : function(element, containers) {
						for ( var index = 0; index < containers.length; index++) {
							this.removeContainer(element, containers[index]);
						}
					},
					destroyContainer : function(container) {
						container.destroy();
					},
					destroyContainers : function(containers) {
						for ( var index = 0; index < containers.length; index++) {
							this.destroyContainer(containers[index]);
						}
					},
					CLASS_NAME : 'Legato.Control.Legend'
				});

/**
 * Component: lc:Legend
 * 
 * Inherits from:
 * - <olc:Control>
 * 
 * See also:
 * - <lc> namespace
 * - {<Legato.Control.Legend>}
 */
Legato.Control.Legend.Bean = OpenLayers.Control.Bean.Extend(

'Legato.Control.Legend',

Legato.Control.QName('Legend'), {
	_constructor : Legato.Control.Legend,
	options : {
		/**
		 * Element: div
		 * {DOMElement}
		 */
		div : Legato.Lang.Element,
		/**
		 * Element: showBaseLayers
		 * {Boolean}
		 */
		showBaseLayers : Legato.Lang.Boolean,
		/**
		 * Element: containerPlugin
		 * {<llp:Plugin>}
		 */
		containerPlugin : Legato.Beans.Object,
		/**
		 * Element: plugins
		 * {<llp:Plugin> []}
		 */
		plugins : Legato.Beans.Object.List()
	}
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 */

/**
 * Class: Legato.Control.Legend.Plugin
 *
 * Abstract base class for all <Legato.Legend.Plugin> subclasses.
 * Defines some common behaviour for all plugins.
 * Controlled and used by <Legato.Control.Legend> class.
 */
Legato.Control.Legend.Plugin = OpenLayers.Class({
  EVENT_TYPES : [ 'legato.plugin.visibility.changed'],
  /**
   * Property: id {String}
   */
  id : null,

  /**
   * Property: map {<OpenLayers.Map>} The current map
   */
  map : null,

  /**
   * Property: layer {<OpenLayers.Layer>} layer associated with the plugin
   * instance
   */
  layer : null,

  /**
   * Property: div {DOMElement}
   */
  div : null,

  /**
   * Property: displayClass {string} This property is used for CSS related to
   * the drawing of the Control.
   */
  displayClass : '',

  /**
   * Property: title {string} This property is used for showing a tooltip over
   * the Control.
   */
  title : '',

  /**
   * Property: renderWithTitle {boolean} This property is used to define whether
   * the title should be rendered as separate div element.
   */
  renderWithTitle : false,
  
  events : null,

  /**
   * Function: initialize Basic ctor
   *
   * Parameters: layer - {<OpenLayers.Layer>} The layer where this plugin
   * should be associated with options - {Object} A Hashmap containing option
   * parameters for this control
   */
  initialize : function(layer, options) {
    Legato.Util.Ensure.ensureObject(layer);
    this.map = layer.map;
    this.layer = layer;
    this.displayClass = this.CLASS_NAME.replace(/\./g, "");
    OpenLayers.Util.extend(this, options);
    if (this.id === null) {
      this.id = OpenLayers.Util.createUniqueID(this.CLASS_NAME + "_")
          + ':' + this.layer.id;
    }
    this.events = new OpenLayers.Events(this, null, this.EVENT_TYPES);
    this.afterInitialized();
  },

  /**
   * Function: afterInitialized
   *
   * Called after the initialize method. Overwrite to validate your custom
   * legend plugin
   */
  afterInitialized : function() {
  },

  /**
   * Function: draw
   *
   * Draws this legend plugin
   */
  draw : function() {
    this.setup();
    return this.div;
  },

  /**
   * Function: setup
   *
   * Draws this legend plugin by creating a plugin div, calling the update
   * function and afterSetup method.
   */
  setup : function() {
    if (this.div === null) {
      this.create();
    }
    this.update();
    this.afterSetup();
  },

  /**
   * Function: setRenderWithTitle
   *
   * Sets renderWithTitle property
   */
  setRenderWithTitle : function(renderWithTitle) {
    this.renderWithTitle = renderWithTitle;
  },

  /**
   * Function: create
   *
   * Creates the plugin div
   */
  create : function() {
    var div = document.createElement('div');
    div.id = this.id;
    div.title = this.title;
    div.className = this.displayClass;

    if (this.renderWithTitle) {
      var divContainer = document.createElement('div');
      divContainer.className = 'LegatoControlLegendPluginContainer';

      var divIcon = div;
      divIcon.style.clear = 'left';

      var divTitle = document.createElement('div');
      divTitle.innerHTML = this.title;
      divTitle.className = 'LegatoControlLegendPluginContainerTitle';
      divContainer.appendChild(divIcon);
      divContainer.appendChild(divTitle);

      this.div = divContainer;
    }else{
      this.div = div;
    }

  },

  /**
   * Function: update Implemented by plugin subclasses. Used to update the
   * associated plugin div.
   */
  update : function() {
  },

  /**
   * Function: afterSetup Optional implemented by plugin subclasses. Basically
   * used to register some event handlers, like user clicks the legend plugin
   * div and such.
   */
  afterSetup : function() {
  },

  /**
   * Function: destroy
   *
   * See Also: <OpenLayer.Control>
   */
  destroy : function() {
    this.beforeDestroyed();
    this.layer = null;
    this.div = null;
  },

  /**
   * Function: beforeDestroyed Optionally implemented by subclasses. Basically
   * used to remove all event handlers and such.
   */
  beforeDestroyed : function() {
  },

  isListedBaseLayer : function(layer) {
    return Legato.OpenLayers.Map.Util.isListedBaseLayer(layer);
  },

  isListedOverlay : function(layer) {
    return Legato.OpenLayers.Map.Util.isListedOverlay(layer);
  },
  
  isVisible : function() {
    return OpenLayers.Element.visible(this.div);
  },
  
  setVisible : function(visible){
    var wasVisible = this.isVisible();
    if(Legato.Lang.ObjectUtils.isTrue(visible)){
      Legato.XML.ElementUtils.show(this.div);
    }else{
      Legato.XML.ElementUtils.hide(this.div);
    }
    if(wasVisible !== visible){
      this.events.triggerEvent('legato.plugin.visibility.changed');
    }
  },
  CLASS_NAME : 'Legato.Control.Legend.Plugin'
});

Legato.Control.Legend.Plugin.Factory = OpenLayers
    .Class({
      pluginOptions : null,
      predicate : null,
      initialize : function(options) {
        var pluginOptions = {};
        OpenLayers.Util.extend(pluginOptions, options);

        if (Legato.Lang.ObjectUtils.isObject(pluginOptions.supports)
            && Legato.Lang.ObjectUtils
                .isFunction(pluginOptions.supports.evaluate)) {
          this.predicate = pluginOptions.supports;
          delete pluginOptions.supports;
        }
        this.pluginOptions = pluginOptions;
      },
      destroy : function() {
        this.pluginOptions = null;
      },
      create : function(layer) {
        return new Legato.Control.Legend.Plugin(layer,
            this.pluginOptions);
      },
      supports : function(layer) {
        if (!Legato.Lang.ObjectUtils.exists(layer)) {
          return false;
        } else if (Legato.Lang.ObjectUtils.isObject(this.predicate)
            && Legato.Lang.ObjectUtils
                .isFunction(this.predicate.evaluate)) {
          return this.predicate.evaluate(layer);
        } else {
          return true;
        }
      },
      CLASS_NAME : 'Legato.Control.Legend.Plugin.Factory'

    });

/**
 * Space: llp
 *
 * URI: Namespace URI
 * http://www.disy.net/legato/legend/plugin
 */
Legato.Control.Legend.Plugin.NAMESPACE_URI = 'http://www.disy.net/legato/legend/plugin';
/**
 * Prefix: Default prefix
 * llp
 */
Legato.Control.Legend.Plugin.PREFIX = 'llp';
Legato.Control.Legend.Plugin.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Control.Legend.Plugin.NAMESPACE_URI,
      localPart, Legato.Control.Legend.Plugin.PREFIX);
};

/**
 * Component: llp:Plugin
 *
 * See also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin>}
 */
Legato.Control.Legend.Plugin.Bean = Legato.Beans.Object.Extend(
    'Legato.Control.Legend.Plugin.Factory',

    Legato.Control.Legend.Plugin.QName('Plugin'), {
      _constructor : Legato.Control.Legend.Plugin.Factory,
      options : {
        /**
         * Element: supports
         * {<lp:Predicate>}
         */
        supports : Legato.Beans.Object,
        /**
         * Element: displayClass
         * {String}
         */
        displayClass : Legato.Lang.String,
        /**
         * Element: title
         * {String}
         */
        title : Legato.Lang.String
      }
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.Layer
 */
Legato.Control.Legend.Plugin.Layer = OpenLayers
    .Class(
        Legato.Control.Legend.Plugin,
        {

          /**
           * Property: plugins {Array}
           */
          plugins : null,

          /**
           * Function: create
           */
          create : function() {
            Legato.Control.Legend.Plugin.prototype.create.apply(
                this, arguments);
            for ( var index = 0; index < this.plugins.length; index++) {
              var pluginDiv = this.plugins[index].draw();
              if (Legato.Lang.ObjectUtils.exists(pluginDiv)) {
                this.div.appendChild(pluginDiv);
              }
            }
            // Break after all the plugins
            var br = document.createElement('div');
            br.style.clear = 'both';
            this.div.appendChild(br);
          },

          /**
           * Function: update
           */
          update : function() {
            this.div.className = this.displayClass
                + ' '
                + (this.layer.isBaseLayer ? this.displayClass
                    + 'BaseLayer' : this.displayClass
                    + 'Overlay')
                + ' '
                + (this.layer.selected ? this.displayClass
                    + 'Selected' : this.displayClass
                    + 'Deselected');
          },

          /**
           * Function: onclick
           */
          onclick : function(event) {
            if (Legato.Lang.ObjectUtils
                .isFalse(this.layer.selected)) {
              this.map.selectLayer(this.layer);
            } else if (Legato.Lang.ObjectUtils
                .isTrue(this.layer.selected)) {
              this.map.deselectLayer(this.layer);
            }
            if (Legato.Lang.ObjectUtils.exists(event)) {
              OpenLayers.Event.stop(event, true);
            }
          },

          /**
           * Function: afterSetup
           */
          afterSetup : function() {
            if (Legato.Lang.ObjectUtils
                .isFunction(this.map.selectLayer)) {
              this.div.onclick = OpenLayers.Function
                  .bindAsEventListener(this.onclick, this);
            }
            this.map.events.on({
              'legato.selectlayer' : this.update,
              'legato.deselectlayer' : this.update,
              scope : this
            });
          },

          /**
           * Function: beforeDestroyed
           */
          beforeDestroyed : function() {
            this.div.onclick = null;
            this.map.events.un({
              'legato.selectlayer' : this.update,
              'legato.deselectlayer' : this.update,
              scope : this
            });
          },

          /**
           * Function: destroy
           */
          destroy : function() {
            for ( var index = 0; index < this.plugins.length; index++) {
              this.plugins[index].destroy();
            }
            this.plugins = null;
            Legato.Control.Legend.Plugin.prototype.destroy.apply(
                this, arguments);
          },

          CLASS_NAME : 'Legato.Control.Legend.Plugin.Layer'
        });

/**
 * Class: Legato.Control.Legend.Plugin.Layer.Factory Factory class wich is able
 * to create a <Legato.Control.Legend.Plugin.Layer> instance.
 */
Legato.Control.Legend.Plugin.Layer.Factory = OpenLayers
    .Class(Legato.Control.Legend.Plugin.Factory,
        {
          /**
           * Function: create Factory method for creating a
           * <Legato.Control.Legend.Plugin.Layer> instance.
           */
          create : function(layer, plugins) {
            var pluginOptions = OpenLayers.Util.extend({},
                this.pluginOptions);
            pluginOptions.plugins = Legato.Lang.ObjectUtils
                .exists(plugins) ? plugins : [];
            return new Legato.Control.Legend.Plugin.Layer(layer,
                pluginOptions);
          },
          CLASS_NAME : 'Legato.Control.Legend.Plugin.Layer.Factory'
        });

/**
 * Component: llp:Layer
 *
 * Inherits from:
 * - <llp:Plugin>
 *
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.Layer>}
 *
 * Configuration example:
 * (start code)
 * <llp:Layer>
 *   <displayClass>Foo</displayClass>
 * </llp:Layer>
 * (end)
 */
Legato.Control.Legend.Plugin.Layer.Bean = Legato.Control.Legend.Plugin.Bean
    .Extend('Legato.Control.Legend.Plugin.Layer.Factory',

    Legato.Control.Legend.Plugin.QName('Layer'), {
      _constructor : Legato.Control.Legend.Plugin.Layer.Factory
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerDescription
 */
Legato.Control.Legend.Plugin.LayerDescription = OpenLayers.Class(
    Legato.Control.Legend.Plugin, {

      /**
       * Property: plugins {Array}
       */
      image :null,

      /**
       * Function: create
       */
      create : function() {
        Legato.Control.Legend.Plugin.prototype.create.apply(this, arguments);
        this.image = document.createElement('img');
        this.image.className = this.displayClass + "Image";
        this.div.appendChild(this.image);
      },

      /**
       * Function: update
       */
      update : function() {
        if(!this.layer.visibility || !this.layer.inRange){
          Legato.XML.ElementUtils.hide(this.div);
        } else {
          var legendURL = this.layer.legend.getURL(this.layer);
          this.image.src = legendURL;
          Legato.XML.ElementUtils.show(this.div);
        }
      },

      /**
       * Function: update
       * Parameters:
       * evt - {Object} event
       */
      updateVisibility : function(evt) {
        if (evt.layer && evt.layer === this.layer && evt.property && evt.property === "visibility") {
          this.update();
        }
      },

      /**
       * Function: afterSetup
       */
      afterSetup : function() {
        this.map.events.on( {
          'changelayer' : this.updateVisibility,
          scope : this
        });
        this.layer.events.on( {
          'moveend' : this.update,
          scope : this
        });
        this.layer.events.on( {
          'visibilitychanged' :this.updateVisibility,
          scope :this
        });
      },

      /**
       * Function: beforeDestroyed
       */
      beforeDestroyed : function() {
        this.map.events.un( {
          'changelayer' : this.updateVisibility,
          scope : this
        });
        this.layer.events.un( {
          'moveend' : this.update,
          scope : this
        });
        this.layer.events.un( {
          'visibilitychanged' :this.updateVisibility,
          scope :this
        });
      },
      CLASS_NAME :'Legato.Control.Legend.Plugin.LayerDescription'
    });

/**
 * Class: Legato.Control.Legend.Plugin.LayerDescription.Factory Factory class
 * wich is able to create a <Legato.Control.Legend.Plugin.LayerDescription>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerDescription.Factory = OpenLayers.Class(
    Legato.Control.Legend.Plugin.Factory, {

      /**
       * Function: create Factory method for creating a
       * <Legato.Control.Legend.Plugin.LayerDescription> instance.
       */
      create : function(layer) {
        return new Legato.Control.Legend.Plugin.LayerDescription(layer,
            this.pluginOptions);
      },

      /**
       * Function: supports Just layers wich provide the getURL method are
       * supported.
       */
      supports : function(layer) {
        return Legato.Control.Legend.Plugin.Factory.prototype.supports.apply(this,
            arguments)
            && Legato.Lang.ObjectUtils.exists(layer.legend)
            && Legato.Lang.ObjectUtils.isFunction(layer.legend.getURL);
      },
      CLASS_NAME :'Legato.Control.Legend.Plugin.LayerDescription.Factory'
    });

/**
 * Structure: llp:LayerDescription XML based config for
 * <Legato.Control.Legend.Plugin.LayerDescription>.
 *
 * See Also: - <Legato.Control.Legend.Plugin> - <Legato.Beans.BeanFactory> -
 * <QName>
 *
 * A valid config example for a Layer Plugin would be:
 * (start code)
 * <llp:LayerDescription />
 * (end)
 */
Legato.Control.Legend.Plugin.LayerDescription.Bean = Legato.Control.Legend.Plugin.Bean
    .Extend(

    'Legato.Control.Legend.Plugin.LayerDescription.Factory',

    /**
     * Property: QName The qualified name for this control. Needed by XML config
     * to instantiate it.
     */
    Legato.Control.Legend.Plugin.QName('LayerDescription'), {
      _constructor :Legato.Control.Legend.Plugin.LayerDescription.Factory
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerFunction
 * Legend Plugin wich gives you the control over the associated layer by configuring
 * this plugin with a custom javascript function.
 */
Legato.Control.Legend.Plugin.LayerFunction = OpenLayers.Class(Legato.Control.Legend.Plugin, {

  /**
   * Function: afterInitialized
   * Validates that this instance has been configured right. Throws exception if not.
   */
  afterInitialized : function() {
    Legato.Util.Ensure.ensureFunction(this.callback,
      'To use ' + this.CLASS_NAME + ' you must specify a callback function.');
  },

  /**
   * Function: afterSetup
   * Register the onclick event handler
   */
  afterSetup : function() {
    this.div.onclick = OpenLayers.Function.bindAsEventListener(this.onclick, this);
  },

  /**
   * Function: beforeDestroy
   * Destroys the created plugin div.
   */
  beforeDestroy : function() {
    this.div.onclick = null;
  },

  /**
   * Function: onclick
   * Triggered if users clicks the plugin div
   */
  onclick : function(event) {
    var result = this.callback(this.layer);
    if (Legato.Lang.ObjectUtils.exists(event)) {
      OpenLayers.Event.stop(event, true);
    }
    return result;
  },
  CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerFunction'
});

/**
 * Class: Legato.Control.Legend.Plugin.LayerFunction.Factory
 * Factory class wich is able to create a <Legato.Control.Legend.Plugin.LayerFunction>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerFunction.Factory = OpenLayers.Class(
  Legato.Control.Legend.Plugin.Factory, {

    /**
     * Function: create
     * Factory method for creating a <Legato.Control.Legend.Plugin.LayerFunction> instance.
     */
    create : function(layer) {
        return new Legato.Control.Legend.Plugin.LayerFunction(layer,
            this.pluginOptions);
    },
    CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerFunction.Factory'
  }
);

/**
 * Structure: lpp:LayerFunction
 * XML based config for <Legato.Control.Legend.Plugin.LayerFunction>.
 * If configured this plugin renders a div with a configurable css class. If clicked
 * the associated layer will been passed to configured js callback.
 *
 * See Also:
 * - <Legato.Control.Legend.Plugin>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a LayerLegend Plugin would be:
 * (start code)
 * <llp:LayerFunction>
 *   <callback><lb:Reference target="callbackBean" /></callback>
 *   <displayClass>Foo</displayClass>
 * </llp:LayerFunction>
 * (end)
 */
Legato.Control.Legend.Plugin.LayerFunction.Bean = Legato.Control.Legend.Plugin.Bean.Extend(

  'Legato.Control.Legend.Plugin.LayerFunction.Factory',

 /**
  * Property: QName
  * The qualified name for this control. Needed by XML config to instantiate it.
  */
  Legato.Control.Legend.Plugin.QName('LayerFunction'), {
    _constructor : Legato.Control.Legend.Plugin.LayerFunction.Factory,
    options:
    {
      callback: Legato.Lang.Function
    }
  }
);
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerLink
 */
Legato.Control.Legend.Plugin.LayerLink = OpenLayers.Class(
    Legato.Control.Legend.Plugin, {
      url :null,
      params: null,
      parameterName :'selectedLayer',
      target :null,
      create : function() {
        Legato.Control.Legend.Plugin.prototype.create.apply(this, arguments);
      },
      afterInitialized: function() {

        var questionMarkIndex = this.url.indexOf('?');
        var url;
        var params;
        if (questionMarkIndex > 0) {
          url = this.url.substring(0, questionMarkIndex);
          params = OpenLayers.Util.getParameters(this.url);
        } else {
          url = this.url;
          params = {};
        }
        params[this.parameterName] = Legato.Lang.ObjectUtils.exists(this.layer.layerId) ? this.layer.layerId
            : this.layer.name;
        this.url = url + '?' + OpenLayers.Util.getParameterString(params);
      },
      getURL: function()
      {
        return this.url;
      },
      onclick: function(event)
      {
        var url = this.getURL();
        if (Legato.Lang.ObjectUtils.isString(this.target))
        {
          window.open(url, this.target);
        }
        else
        {
          window.open(url);
        }
        if (Legato.Lang.ObjectUtils.exists(event)) {
          OpenLayers.Event.stop(event, true);
        }
      },
      /**
       * Function: afterSetup
       */
      afterSetup : function() {
        this.div.onclick = OpenLayers.Function.bindAsEventListener(this.onclick, this);
      },

      /**
       * Function: beforeDestroyed
       */
      beforeDestroyed : function() {
        this.div.onclick = null;
      },

      CLASS_NAME :'Legato.Control.Legend.Plugin.LayerLink'
    });

/**
 * Class: Legato.Control.Legend.Plugin.LayerLink.Factory Factory class wich is
 * able to create a <Legato.Control.Legend.Plugin.LayerLink> instance.
 */
Legato.Control.Legend.Plugin.LayerLink.Factory = OpenLayers.Class(
    Legato.Control.Legend.Plugin.Factory, {

      /**
       * Function: create Factory method for creating a
       * <Legato.Control.Legend.Plugin.LayerLink> instance.
       */
      create : function(layer) {
        return new Legato.Control.Legend.Plugin.LayerLink(layer,
            this.pluginOptions);
      },
      CLASS_NAME :'Legato.Control.Legend.Plugin.LayerLink.Factory'

    });

/**
 * Structure: lpp:LayerLink XML based config for
 * <Legato.Control.Legend.Plugin.LayerLink>.
 *
 * See Also: - <Legato.Control.Legend.Plugin> - <Legato.Beans.BeanFactory> -
 * <QName>
 *
 * A valid config example for a LayerLink Plugin would be:
 * (start code)
 * <llp:LayerLink />
 * (end)
 */
Legato.Control.Legend.Plugin.LayerLink.Bean = Legato.Control.Legend.Plugin.Bean
    .Extend('Legato.Control.Legend.Plugin.LayerLink.Factory',

    /**
     * Property: QName The qualified name for this control. Needed by XML config
     * to instantiate it.
     */
    Legato.Control.Legend.Plugin.QName('LayerLink'), {
      _constructor :Legato.Control.Legend.Plugin.LayerLink.Factory,
      options : {
        url :Legato.Lang.String,
        parameterName :Legato.Lang.String,
        target :Legato.Lang.String
      }
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerName
 */
Legato.Control.Legend.Plugin.LayerName = OpenLayers.Class(
		Legato.Control.Legend.Plugin, {

			/**
			 * Function: create
			 */
			update : function() {
				if (Legato.Lang.ObjectUtils.isString(this.layer.title)) {
					this.div.innerHTML = this.layer.title;
				} else {
					this.div.innerHTML = this.layer.name;
				}
				if (this.layer.inRange) {
					this.div.className = this.displayClass;
				} else {
					this.div.className = this.displayClass + 'Disabled';
				}
			},

			/**
			 * Function: afterSetup
			 */
			afterSetup : function() {
				this.map.events.on({
					'changelayer' : this.update,
					scope : this
				});
			},

			/**
			 * Function: beforeDestroyed
			 */
			beforeDestroyed : function() {
				this.map.events.un({
					'changelayer' : this.update,
					scope : this
				});
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerName'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerName.Factory
 * Factory class wich is able to create a <Legato.Control.Legend.Plugin.LayerName>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerName.Factory = OpenLayers.Class(
		Legato.Control.Legend.Plugin.Factory, {

			/**
			 * Function: create
			 * Factory method for creating a <Legato.Control.Legend.Plugin.LayerName> instance.
			 */
			create : function(layer) {
				return new Legato.Control.Legend.Plugin.LayerName(layer,
						this.pluginOptions);
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerName.Factory'

		});

/**
 * Component: llp:LayerName
 * 
 * Displays name of the layer.
 * 
 * Inherits from:
 * - <llp:Plugin>
 * 
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.LayerName>}
 */
Legato.Control.Legend.Plugin.LayerName.Bean = Legato.Control.Legend.Plugin.Bean
		.Extend('Legato.Control.Legend.Plugin.LayerName.Factory',

		Legato.Control.Legend.Plugin.QName('LayerName'), {
			_constructor : Legato.Control.Legend.Plugin.LayerName.Factory
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerPosition
 * Abstract legend plugin control.
 */
Legato.Control.Legend.Plugin.LayerPosition = OpenLayers.Class(
		Legato.Control.Legend.Plugin, {

			/**
			 * Function: create
			 */
			afterSetup : function() {
				this.div.onclick = OpenLayers.Function.bindAsEventListener(
						this.onclick, this);
			},

			/**
			 * Function: beforeDestroyed
			 */
			beforeDestroyed : function() {
				this.div.onclick = null;
			},

			/**
			 * Function: onclick abstract method. Implemented by subclasses.
			 */
			onclick : function(event) {
				if (Legato.Lang.ObjectUtils.exists(event)) {
					OpenLayers.Event.stop(event, true);
				}
			},

			/**
			 * Function: raiseLayer
			 */
			raiseLayer : function(layer, step, filter) {
				var map = this.map;
				var layers = this.map.layers;
				var index = map.getLayerIndex(layer) + step;
				while (index >= 0 && index < layers.length) {
					if (filter(layers[index])) {
						map.setLayerIndex(layer, index);
						return;
					} else {
						index = index + step;
					}
				}
			},
			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerPosition'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerPosition.Factory Abstract factory
 * base class.
 */
Legato.Control.Legend.Plugin.LayerPosition.Factory = OpenLayers.Class(
		Legato.Control.Legend.Plugin.Factory, {

			/**
			 * Function: create Factory method for creating a
			 * <Legato.Control.Legend.Plugin.LayerPosition> instance.
			 */
			create : function(layer) {
				return new Legato.Control.Legend.Plugin.LayerPosition(layer,
						this.pluginOptions);
			},

			/**
			 * Function: supports Just overlay layers are supported
			 */
			supports : function(layer) {
				return Legato.Control.Legend.Plugin.Factory.prototype.supports
						.apply(this, arguments)
						&& !layer.isBaseLayer;
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerPositionUp.Factory'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerPositionUp
 */
Legato.Control.Legend.Plugin.LayerPositionUp = OpenLayers.Class(
		Legato.Control.Legend.Plugin.LayerPosition, {

			/**
			 * Function: onclick
			 */
			onclick : function(event) {
				this.raiseLayer(this.layer, 1,
						(this.layer.isBaseLayer ? this.isListedBaseLayer
								: this.isListedOverlay));
				// The event is stop to avoid containing div to react on "onclick"
				OpenLayers.Event.stop(event);
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerPositionUp'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerPositionUp.Factory Factory class
 * wich is able to create a <Legato.Control.Legend.Plugin.LayerPositionUp>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerPositionUp.Factory = OpenLayers.Class(
		Legato.Control.Legend.Plugin.LayerPosition.Factory, {

			/**
			 * Function: create Factory method for creating a
			 * <Legato.Control.Legend.Plugin.LayerPositionUp> instance.
			 */
			create : function(layer) {
				return new Legato.Control.Legend.Plugin.LayerPositionUp(layer,
						this.pluginOptions);
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerPositionUp.Factory'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerPositionUp
 */
Legato.Control.Legend.Plugin.LayerPositionDown = OpenLayers.Class(
		Legato.Control.Legend.Plugin.LayerPosition, {

			/**
			 * Function: onclick
			 */
			onclick : function(event) {
				this.raiseLayer(this.layer, -1,
						(this.layer.isBaseLayer ? this.isListedBaseLayer
								: this.isListedOverlay));
				// The event is stop to avoid containing div to react on "onclick"
				OpenLayers.Event.stop(event);
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerPositionDown'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerPositionUp.Factory Factory class
 * wich is able to create a <Legato.Control.Legend.Plugin.LayerPositionDown>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerPositionDown.Factory = OpenLayers
		.Class(
				Legato.Control.Legend.Plugin.LayerPosition.Factory,
				{

					/**
					 * Function: create Factory method for creating a
					 * <Legato.Control.Legend.Plugin.LayerPositionDown> instance.
					 */
					create : function(layer) {
						return new Legato.Control.Legend.Plugin.LayerPositionDown(
								layer, this.pluginOptions);
					},
					CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerPositionDown.Factory'
				});

/**
 * Component: llp:LayerPositionUp
 * 
 * Inherits from:
 * - <llp:Plugin>
 * 
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.LayerPositionUp>}
 */
Legato.Control.Legend.Plugin.LayerPositionUp.Bean = Legato.Control.Legend.Plugin.Bean
		.Extend('Legato.Control.Legend.Plugin.LayerPositionUp.Factory',

		Legato.Control.Legend.Plugin.QName('LayerPositionUp'), {
			_constructor : Legato.Control.Legend.Plugin.LayerPositionUp.Factory
		});

/**
 * Component: llp:LayerPositionDown
 * 
 * Inherits from:
 * - <llp:Plugin>
 * 
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.LayerPositionDown>}
 */
Legato.Control.Legend.Plugin.LayerPositionDown.Bean = Legato.Control.Legend.Plugin.Bean
		.Extend(

				'Legato.Control.Legend.Plugin.LayerPositionDown.Factory',

				Legato.Control.Legend.Plugin.QName('LayerPositionDown'),
				{
					_constructor : Legato.Control.Legend.Plugin.LayerPositionDown.Factory
				});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerRemove
 */
Legato.Control.Legend.Plugin.LayerRemove = OpenLayers.Class(
		Legato.Control.Legend.Plugin, {

			/**
			 * Function: afterSetup
			 */
			afterSetup : function() {
				this.div.onclick = OpenLayers.Function.bindAsEventListener(
						this.onclick, this);
			},

			/**
			 * Function: beforeDestroyed
			 */
			beforeDestroyed : function() {
				this.div.onclick = null;
			},

			/**
			 * Function: onclick
			 */
			onclick : function(event) {
//				this.map.removeLayer(this.layer, true);
				this.layer.destroy(true);
				if (Legato.Lang.ObjectUtils.exists(event)) {
					OpenLayers.Event.stop(event, true);
				}
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerRemove'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerRemove.Factory
 * Factory class wich is able to create a <Legato.Control.Legend.Plugin.LayerRemove>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerRemove.Factory = OpenLayers.Class(
		Legato.Control.Legend.Plugin.Factory, {

			/**
			 * Function: create
			 * Factory method for creating a <Legato.Control.Legend.Plugin.LayerRemove> instance.
			 */
			create : function(layer) {
				return new Legato.Control.Legend.Plugin.LayerRemove(layer,
						this.pluginOptions);
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerRemove.Factory'
		});

/**
 * Component: llp:LayerRemove
 * 
 * Inherits from:
 * - <llp:Plugin>
 * 
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.LayerRemove>}
 */
Legato.Control.Legend.Plugin.LayerRemove.Bean = Legato.Control.Legend.Plugin.Bean
		.Extend('Legato.Control.Legend.Plugin.LayerRemove.Factory',

		Legato.Control.Legend.Plugin.QName('LayerRemove'), {
			_constructor : Legato.Control.Legend.Plugin.LayerRemove.Factory
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerVisibility
 */
Legato.Control.Legend.Plugin.LayerVisibility = OpenLayers.Class(
		Legato.Control.Legend.Plugin, {

			/**
			 * Property: afterSetup
			 */
			input : null,

			/**
			 * Function: create
			 */
			create : function() {
				Legato.Control.Legend.Plugin.prototype.create.apply(this,
						arguments);
				this.input = document.createElement('input');
				this.input.value = this.layer.name;
				if (this.layer.isBaseLayer) {
					this.input.type = 'radio';
					// TODO
					this.input.name = 'baseLayer';
					this.input.className = this.displayClass + 'Input' + ' '
							+ this.displayClass + 'InputBaseLayer';

				} else {
					this.input.type = 'checkbox';
					this.input.name = 'overlay';
					this.input.className = this.displayClass + 'Input' + ' '
							+ this.displayClass + 'InputOverlay';
				}
				this.div.appendChild(this.input);
				this.input.value = this.layer.name;
				this.input.defaultChecked = this.layer.visibility;
			},

			/**
			 * Function: update
			 */
			update : function() {
				this.input.value = this.layer.name;
				this.input.checked = this.layer.visibility;
			},

			/**
			 * Function: afterSetup
			 */
			afterSetup : function() {
				this.input.onclick = OpenLayers.Function.bindAsEventListener(
						this.onclick, this);
				this.layer.events.on({
					'visibilitychanged' : this.update,
					scope : this
				});
				// Currently when a base layer is changed, there's no visibilitychanged event
				// for the new base layer which became visible. Therefor we have to watch for
				// changebaselayer events on the map.
				if (this.layer.isBaseLayer) {
					this.map.events.on({
						'changebaselayer' : this.update,
						scope : this
					});
				}
			},

			/**
			 * Function: beforeDestroyed
			 */
			beforeDestroyed : function() {
				this.input.onclick = null;
				this.layer.events.un({
					'visibilitychanged' : this.update,
					scope : this
				});
				this.map.events.un({
					'changebaselayer' : this.update,
					scope : this
				});
			},
			/**
			 * Function: onclick
			 */
			onclick : function(event) {
				if (this.layer.isBaseLayer && this.input.checked) {
					this.layer.map.setBaseLayer(this.layer);
				} else {
					this.layer.setVisibility(this.input.checked);
				}
				if (Legato.Lang.ObjectUtils.exists(event)) {
					OpenLayers.Event.stop(event, true);
				}
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerVisibility'
		});

/**
 * Class: Legato.Control.Legend.Plugin.LayerVisibility.Factory
 * Factory class wich is able to create a <Legato.Control.Legend.Plugin.LayerVisibility>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerVisibility.Factory = OpenLayers.Class(
		Legato.Control.Legend.Plugin.Factory, {

			/**
			 * Function: create
			 * Factory method for creating a <Legato.Control.Legend.Plugin.LayerVisibility> instance.
			 */
			create : function(layer) {
				return new Legato.Control.Legend.Plugin.LayerVisibility(layer,
						this.pluginOptions);
			},

			CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerVisibility.Factory'
		});

/**
 * Component: llp:LayerVisibility
 * 
 * Inherits from:
 * - <llp:Plugin>
 * 
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.LayerVisibility>}
 */
Legato.Control.Legend.Plugin.LayerVisibility.Bean = Legato.Control.Legend.Plugin.Bean
		.Extend('Legato.Control.Legend.Plugin.LayerVisibility.Factory',

		/**
		 * Property: QName
		 * The qualified name for this control. Needed by XML config to instantiate it.
		 */
		Legato.Control.Legend.Plugin.QName('LayerVisibility'), {
			_constructor : Legato.Control.Legend.Plugin.LayerVisibility.Factory
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerZoomToVisibleScale
 */
Legato.Control.Legend.Plugin.LayerZoomToVisibleScale = OpenLayers.Class(
    Legato.Control.Legend.Plugin, {

      afterInitialized: function() {
        //do nothing
      },

      onclick: function(event)
      {
        var currentScale = this.map.getScale();
        if (Legato.Lang.ObjectUtils.isNull(currentScale)) {
          return;
        }
        var scaleToZoom = currentScale;
        if (currentScale > this.layer.minScale) {
          scaleToZoom = this.layer.minScale - 0.000001;
        } else if (currentScale < this.layer.maxScale) {
          scaleToZoom = this.layer.maxScale + 0.000001;
        }
        this.map.zoomToScale(scaleToZoom);
        if (Legato.Lang.ObjectUtils.exists(event)) {
          OpenLayers.Event.stop(event, true);
        }
      },

      afterSetup : function() {
        this.map.events.on( {
          'moveend' :this.update,
          scope :this
        });
        this.div.onclick = OpenLayers.Function.bindAsEventListener(this.onclick, this);
      },

      beforeDestroyed : function() {
        this.map.events.un( {
          'moveend' :this.update,
          scope :this
        });
        this.div.onclick = null;
      },

      update : function() {
        var currentScale = this.map.getScale();
        if (Legato.Lang.ObjectUtils.isNull(currentScale)) {
          this.setVisible(false);
          return;
        }
        if (currentScale > this.layer.minScale || currentScale < this.layer.maxScale) {
          this.setVisible(true);
          this.div.style.display = 'block';
        } else {
          this.setVisible(false);
        }
      },

      CLASS_NAME :'Legato.Control.Legend.Plugin.LayerZoomToVisibleScale'
    });

/**
 * Class: Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory Factory class wich is
 * able to create a <Legato.Control.Legend.Plugin.LayerZoomToVisibleScale> instance.
 */
Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory = OpenLayers.Class(
    Legato.Control.Legend.Plugin.Factory, {

      /**
       * Function: create Factory method for creating a
       * <Legato.Control.Legend.Plugin.LayerZoomToVisibleScale> instance.
       */
      create : function(layer) {
        return new Legato.Control.Legend.Plugin.LayerZoomToVisibleScale(layer,
            this.pluginOptions);
      },
      CLASS_NAME :'Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory'

    });

/**
 * Structure: lpp:LayerZoomToVisibleScale XML based config for
 * <Legato.Control.Legend.Plugin.LayerZoomToVisibleScale>.
 *
 * See Also: - <Legato.Control.Legend.Plugin> - <Legato.Beans.BeanFactory> -
 * <QName>
 *
 * A valid config example for a LayerZoomToVisibleScale Plugin would be:
 * (start code)
 * <llp:LayerZoomToVisibleScale />
 * (end)
 */
Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Bean = Legato.Control.Legend.Plugin.Bean
    .Extend('Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory',

    /**
     * Property: QName The qualified name for this control. Needed by XML config
     * to instantiate it.
     */
    Legato.Control.Legend.Plugin.QName('LayerZoomToVisibleScale'), {
      _constructor :Legato.Control.Legend.Plugin.LayerZoomToVisibleScale.Factory
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: nedkov $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerDropDownMenu
 */
Legato.Control.Legend.Plugin.LayerDropDownMenu = OpenLayers.Class(
    Legato.Control.Legend.Plugin, {

      plugins : [],

      dropDownMenuContainer : null,

      /**
       * Function: create Creates the plugin div
       */
      create : function() {
        Legato.Control.Legend.Plugin.prototype.create.apply(this, arguments);

        var divDropDownMenu = document.createElement('div');
        divDropDownMenu.className = 'LegatoControlLegendPluginLayerDropDownMenuDiv';

        this.dropDownMenuContainer = document.createElement('div');
        this.dropDownMenuContainer.className = 'LegatoControlLegendPluginLayerDropDownMenuDivContainer';

        divDropDownMenu.appendChild(this.div);
        divDropDownMenu.appendChild(this.dropDownMenuContainer);

        this.div = divDropDownMenu;

        for ( var j = 0; j < this.plugins.length; j++) {
          this.dropDownMenuContainer.appendChild(this.plugins[j].draw());
          this.plugins[j].insideDropDownMenu = true;
          this.plugins[j].events.on({
            'legato.plugin.visibility.changed' : this.update,
            scope : this
          });
        }

        Legato.XML.ElementUtils.hide(this.dropDownMenuContainer);
      },

      /**
       * Function: afterSetup
       */
      afterSetup : function() {
        var that = this;
        this.div.onclick = OpenLayers.Function.bindAsEventListener(
            this.onclick, this);
        this.div.onmouseout = function(){
          that.timeOut = setTimeout(
              function(){
                Legato.XML.ElementUtils.hide(that.dropDownMenuContainer);
                },
              500);
        };
        this.div.onmouseover = function(){
          clearTimeout(that.timeOut);
        };
        this.map.events.on({
            'moveend' : this.update,
            scope : this
        });
        this.layer.events.on({
            'visibilitychanged' : this.update,
            scope : this
        });
        // Currently when a base layer is changed, there's no visibilitychanged event
        // for the new base layer which became visible. Therefor we have to watch for
        // changebaselayer events on the map.
        if (this.layer.isBaseLayer) {
            this.map.events.on({
                'changebaselayer' : this.update,
                scope : this
            });
        }
      },

      /**
       * Function: beforeDestroyed
       */
      beforeDestroyed : function() {
        this.div.onclick = null;
        this.map.events.un({
            'moveend' :this.update,
            scope :this
        });
        this.layer.events.un({
            'visibilitychanged' : this.update,
            scope : this
        });
        this.map.events.un({
            'changebaselayer' : this.update,
            scope : this
        });
      },

      update : function(){
        var currentScale = this.map.getScale();
        if ( ( Legato.Lang.ObjectUtils.isNull(currentScale) ||
              !(currentScale > this.layer.minScale || currentScale < this.layer.maxScale)
             ) && this.layer.getVisibility()) {
            for ( var j = 0; j < this.plugins.length; j++) {
              if(this.plugins[j].isVisible()){
                this.setVisible(true);
                return;
              }
            }
        }
        this.setVisible(false);
      },

      /**
       * Function: onclick
       */
      onclick : function(event) {
        OpenLayers.Element.toggle(this.dropDownMenuContainer);
        if (Legato.Lang.ObjectUtils.exists(event)) {
          OpenLayers.Event.stop(event, true);
        }
      },

      /**
       * Function: destroy
       */
      destroy : function() {
        Legato.Control.Legend.Plugin.prototype.destroy.apply(
            this, arguments);
        for ( var index = 0; index < this.plugins.length; index++) {
          this.plugins[index].events.un({
            'legato.plugin.visibility.changed' : this.update,
            scope : this
          });
          this.plugins[index].destroy();
        }
        this.plugins = [];
      },

      CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerDropDownMenu'
    });

/**
 * Class: Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory
 * Factory class wich is able to create a <Legato.Control.Legend.Plugin.LayerDropDownMenu>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory = OpenLayers.Class(
    Legato.Control.Legend.Plugin.Factory, {

      /**
       * Function: create
       * Factory method for creating a <Legato.Control.Legend.Plugin.LayerDropDownMenu> instance.
       */
      create : function(layer) {
        var pluginOptions = OpenLayers.Util.extend({},
            this.pluginOptions);
        pluginOptions.plugins = [];

        var pluginFactories = this.pluginOptions.plugins;

        if(Legato.Lang.ObjectUtils.isNotEmptyArray(pluginFactories)){
          for ( var j = 0; j < pluginFactories.length; j++) {
            if (pluginFactories[j].supports(layer)) {
              var plugin = pluginFactories[j].create(layer);
              plugin.setRenderWithTitle(true);
              pluginOptions.plugins.push(plugin);
            }
          }
        }

        return new Legato.Control.Legend.Plugin.LayerDropDownMenu(layer,
            pluginOptions);
      },

      CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory'
    });

/**
 * Component: llp:LayerDropDownMenu
 *
 * Inherits from:
 * - <llp:Plugin>
 *
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.LayerDropDownMenu>}
 */
Legato.Control.Legend.Plugin.LayerDropDownMenu.Bean = Legato.Control.Legend.Plugin.Bean
    .Extend('Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory',

    Legato.Control.Legend.Plugin.QName('LayerDropDownMenu'), {
      _constructor : Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory,
      options : {
        plugins : Legato.Beans.Object.List()
      }
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * MapAttribution (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 91043 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: Legato.Control.MapAttribution
 * ValueProvider which gives you the possibility to be notified about every
 * change of the current BBox Selection. The notification could be a JS Callback
 * or a Object where its property will be overwritten each time the watched value
 * changes.
 *
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.MapAttribution = OpenLayers.Class(Legato.Control, {

    /**
     * {DOMElement}
     */
    element: null,

    /**
     * Property: text
     * {String} The MapAttribution text
     */
    text: null,

    /**
     * Property: url
     * {String} the MapAttribution hyperlink
     */
    url: null,

    /**
     * Property: image
     * {String} the url to the MapAttribution image
     */
    image: null,

    /**
     * Property: size
     * {Size} the size of the MapAttribution image
     */
    size: null,

    /**
     * Property: imageElement
     * {DOMElement}
     */
    imageElement: null,

    /**
     * Property: stopEvent
     * {Boolean} If configured the event propagation to other map control may be stoppe.
     */
    stopEvent: null,

    /**
     * Constructor: Legato.Control.MapAttribution
     *
     * Parameters:
     * options - {Object} Options for control.
     */
    initialize: function(options) {
        Legato.Control.prototype.initialize.apply(this, arguments);
    },

    /**
     * Method: destroy
     */
     destroy: function() {
         Legato.Control.prototype.destroy.apply(this, arguments);
     },

    /**
     * Method: draw
     * {DOMElement}
     */
    draw: function() {
        Legato.Control.prototype.draw.apply(this, arguments);

        if (!this.element) {
          //Use MapAttribution text
          if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.image)){
            this.div.innerHTML = this.text;
          }
          //Use image
          else {
            this.imageElement = document.createElement('img');
            this.imageElement.src = this.image;

            if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.text)){
              this.imageElement.alt = this.text;
            }

            if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.size)){
              this.imageElement.height = this.size.h;
              this.imageElement.width = this.size.w;
            }
            this.div.appendChild(this.imageElement);
          }

          this.div.onmouseup = OpenLayers.Function.bindAsEventListener(this.onclick, this);
          this.element = this.div;
        }

        return this.div;
    },

    /**
     * Function: onclick
     */
    onclick : function(event) {
      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.url)){
        window.open(this.url);
      }

      if (Legato.Lang.ObjectUtils.exists(event)) {
        //Stop event propagation if config option is set to true
        if(this.stopEvent === true){
          OpenLayers.Event.stop(event, true);
        }

        //Stop event propagation if config is not set and url is configured
        if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.stopEvent) &&
           !Legato.Lang.ObjectUtils.isNullOrUndefined(this.url)){
          OpenLayers.Event.stop(event, true);
        }
      }
    },

    /**
     * Method: setMap
     */
    setMap: function() {
      Legato.Control.prototype.setMap.apply(this, arguments);
    },

    CLASS_NAME: "Legato.Control.MapAttribution"
});

/**
 * Structure: lc:WMSGetFeatureInfo XML based config for a
 * <Legato.Control.WMSGetFeatureInfo>.
 *
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory> - <QName>
 *
 * A valid config example for a WMSGetFeatureInfo would be:
 * (start code)
 * <lc:MapAttribution>
 *   <text>My MapAttribution</text>
 *   <url>http://www.myServer.com/images/MapAttribution.png</url>
 *   <size><ol:Size w="100" h="50" /></size>
 * </lc:MapAttribution>
 * (end)
 */
Legato.Control.MapAttribution.Bean = Legato.Control.Bean.Extend(

'Legato.Control.MapAttribution',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Control.QName('MapAttribution'), {
  _constructor :Legato.Control.MapAttribution,
  options : {
    /*
     * Property: url
     * configures the URL of the MapAttribution image
     */
    url: Legato.Lang.String,

    /*
     * Property: text
     * configures the MapAttribution text
     */
    text: Legato.Lang.String,

    /*
     * Property: image
     * the url of the MapAttribution image
     */
    image: Legato.Lang.String,

    /*
     * Property: size
     *
     * Configures the size for the MapAttribution image
     */
    size: OpenLayers.Size.Bean,

    /*
     * Property: size
     *
     * Optional. If configured with true this control will stop the event propagation
     * to active map controls like the ZoomIn control.
     */
    stopEvent: Legato.Lang.Boolean
  }
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * A control to measure the length of lines
 */
Legato.Control.MeasureLine = OpenLayers.Class(OpenLayers.Control.Measure, {
  /*
   * Function: initialize Basic control for the legend control
   *
   * Parameters: options - {Object} A Hashmap containing option parameters for
   * this control The following keys are supported - div {DOMElement} an
   * optional DOMElement instance where this control should been rendered. If
   * not defined the legend control will render itself inside the map DOMElement
   */
  initialize : function(options) {

    if (!Legato.Lang.ObjectUtils.exists(options)) {
      options = [];
    }

    // style the sketch fancy
    var sketchSymbolizers = {
      Point : Legato.Feature.Style.DEFAULT_POINT,
      Line : Legato.Feature.Style.DEFAULT_LINE,
      Polygon : Legato.Feature.Style.DEFAULT_POLYGON
    };

    if (Legato.Lang.ObjectUtils.isArray(options.styles)) {
      for ( var i = 0; i < options.styles.length; i++) {
        var configuredStyle = options.styles[i];
        switch (configuredStyle.name.toUpperCase()) {
        case 'POINT':
          OpenLayers.Util.extend(sketchSymbolizers.Point,
              configuredStyle.styles);
          break;
        case 'LINE':
          OpenLayers.Util.extend(sketchSymbolizers.Line,
              configuredStyle.styles);
          break;
        case 'POLYGON':
          OpenLayers.Util.extend(sketchSymbolizers.Polygon,
              configuredStyle.styles);
          break;
        default:
          // IGNORE IT
          break;
        }
      }
    }

    var style = new OpenLayers.Style();
    style.addRules([ new OpenLayers.Rule({
      symbolizer : sketchSymbolizers
    }) ]);
    var styleMap = new OpenLayers.StyleMap({
      "default" : style
    });

    options.handlerOptions = {
      layerOptions : {
        styleMap : styleMap,
        legatoIgnore : true
      }
    };

    // options.geodesic = true;

    OpenLayers.Control.Measure.prototype.initialize.apply(this, [
        OpenLayers.Handler.Path, options ]);
    this.events.on({
      "measure" : this.handleMeasurements,
      "measurepartial" : this.handleMeasurements
    });

  },

  /*
   * Function: destroy APIMethod: called if destroyed
   */
  destroy : function() {
    this.events.un({
      "measure" : this.handleMeasurements,
      "measurepartial" : this.handleMeasurements
    });

    OpenLayers.Control.Measure.prototype.destroy.apply(this, arguments);
  },

  /*
   * Function: deactivate APIMethod: called when component is deactivated
   */
  deactivate : function() {
    this.div.innerHTML = "";
    OpenLayers.Control.Measure.prototype.deactivate.apply(this, arguments);
  },

  handleMeasurements : function(event) {
    var geometry = event.geometry;
    var units = event.units;
    var order = event.order;
    var measure = event.measure;
    var out = measure.toFixed(3) + " " + units;
    this.div.innerHTML = out;
  },

  CLASS_NAME : 'Legato.Control.MeasureLine'
});

Legato.Control.MeasureLine.Bean = OpenLayers.Control.Bean.Extend(
    'Legato.Control.MeasureLine',
    //
    Legato.Control.QName('MeasureLine'),
    //
    {
      _constructor : Legato.Control.MeasureLine,
      options : {
        persist : Legato.Lang.Boolean,
        styles : Legato.Beans.Object.List()
      }
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.MeasurePolygon = OpenLayers.Class(OpenLayers.Control.Measure, {
  /*
   * Function: initialize Basic control for the legend control
   *
   * Parameters: options - {Object} A Hashmap containing option parameters for
   * this control The following keys are supported - div {DOMElement} an
   * optional DOMElement instance where this control should been rendered. If
   * not defined the legend control will render itself inside the map DOMElement
   */
  initialize : function(options) {
    if (!Legato.Lang.ObjectUtils.exists(options)) {
      options = [];
    }

    // style the sketch fancy
    var sketchSymbolizers = {
      Point : Legato.Feature.Style.DEFAULT_POINT,
      Line : Legato.Feature.Style.DEFAULT_LINE,
      Polygon : Legato.Feature.Style.DEFAULT_POLYGON
    };

    if (Legato.Lang.ObjectUtils.isArray(options.styles)) {
      for ( var i = 0; i < options.styles.length; i++) {
        var configuredStyle = options.styles[i];
        switch (configuredStyle.name.toUpperCase()) {
        case 'POINT':
          OpenLayers.Util.extend(sketchSymbolizers.Point,
              configuredStyle.styles);
          break;
        case 'LINE':
          OpenLayers.Util.extend(sketchSymbolizers.Line,
              configuredStyle.styles);
          break;
        case 'POLYGON':
          OpenLayers.Util.extend(sketchSymbolizers.Polygon,
              configuredStyle.styles);
          break;
        default:
          // IGNORE IT
          break;
        }
      }
    }

    var style = new OpenLayers.Style();

    style.addRules([ new OpenLayers.Rule({
      symbolizer : sketchSymbolizers
    }) ]);

    var styleMap = new OpenLayers.StyleMap({
      "default" : style
    });

    options.handlerOptions = {
      layerOptions : {
        styleMap : styleMap,
        legatoIgnore : true
      }
    };

    // options.geodesic = true;

    OpenLayers.Control.Measure.prototype.initialize.apply(this, [
        OpenLayers.Handler.Polygon, options ]);
    this.events.on({
      "measure" : this.handleMeasurements,
      "measurepartial" : this.handleMeasurements
    });

  },

  /*
   * Function: destroy APIMethod: called if destroyed
   */
  destroy : function() {
    this.events.un({
      "measure" : this.handleMeasurements,
      "measurepartial" : this.handleMeasurements
    });

    OpenLayers.Control.Measure.prototype.destroy.apply(this, arguments);
  },

  /*
   * Function: deactivate APIMethod: called when component is deactivated
   */
  deactivate : function() {
    this.div.innerHTML = "";
    OpenLayers.Control.Measure.prototype.deactivate.apply(this, arguments);
  },

  handleMeasurements : function(event) {
    var geometry = event.geometry;
    var units = event.units;
    var order = event.order;
    var measure = event.measure;
    var out = measure.toFixed(3) + " " + units + "<sup>2</" + "sup>";
    this.div.innerHTML = out;
  },

  CLASS_NAME : 'Legato.Control.MeasurePolygon'
});

Legato.Control.MeasurePolygon.Bean = OpenLayers.Control.Bean.Extend(
    'Legato.Control.MeasurePolygon',
    //
    Legato.Control.QName('MeasurePolygon'),
    //
    {
      _constructor : Legato.Control.MeasurePolygon,
      options : {
        persist : Legato.Lang.Boolean,
        styles : Legato.Beans.Object.List()
      }
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ModifyFeature = OpenLayers.Class(OpenLayers.Control.ModifyFeature, {

  vertexModifiedPoint : null,

  initialize : function(layer, options) {
    /*
     * Subscribe for these events so that we're able to determine that an
     * existing geometry has changed cause a new vertex has been added
     * (vertexmodified,featuremodified) and to determine that someone has
     * updated the geometry outside this class (legato.sketchupdated).
     */
    layer.events.on({
      'vertexmodified' : this.onVertexModified,
      'featuremodified' : this.onFeatureModified,
      'legato.sketchupdated' : this.onSketchUpdated,
      scope : this
    });

    OpenLayers.Control.ModifyFeature.prototype.initialize.apply(this, [ layer, options ]);
    this.configureVirtualStyle();
  },

  destroy : function() {
    this.layer.events.un({
      'vertexmodified' : this.onVertexModified,
      'featuremodified' : this.onFeatureModified,
      'legato.sketchupdated' : this.onSketchUpdated,
      scope : this
    });

    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  activate : function() {
    var result = OpenLayers.Control.ModifyFeature.prototype.activate.apply(this, arguments);
    if (this.layer && this.layer.features && (this.layer.features.length === 1)) {
      this.selectControl.clickFeature(this.layer.features[0]);
    }
    return result;
  },

  /*
   * Just remember this changed point or new point
   */
  onVertexModified : function(event) {
    this.vertexModifiedPoint = event.vertex;
  },

  /*
   * Triggers the legato.sketchpointadded event meaning that either a new point
   * has been added to this existing geometry or a given point has been changed.
   */
  onFeatureModified : function(event) {
    this.layer.events.triggerEvent('legato.sketchpointadded', {
      layer : event.feature.layer,
      geometry : event.feature.geometry,
      vertex : this.vertexModifiedPoint
    });
  },

  /*
   * If someone has changed some geometry on this layer reset the vertices for
   * it.
   */
  onSketchUpdated : function() {
    if (this.feature) {
      this.layer.drawFeature(this.feature, this.selectControl.renderIntent);
      this.resetVertices();
    }
  },

  configureVirtualStyle : function() {
    /*
     * Demonstrates how we could customize the vortiual style. This is used by
     * the points which appear if we're adding a new point to our polygon.
     */

    /*
     * this.virtualStyle = OpenLayers.Util.extend( {}, this.layer.style ||
     * this.layer.styleMap.createSymbolizer() ); this.virtualStyle.fillColor =
     * '#000'; this.virtualStyle.strokeColor = '#000';
     */
  },

  CLASS_NAME : 'Legato.Control.ModifyFeature'
});

Legato.Control.ModifyFeature.MODE_RESHAPE = OpenLayers.Control.ModifyFeature.RESHAPE;
Legato.Control.ModifyFeature.MODE_AFFINE = OpenLayers.Control.ModifyFeature.RESIZE | OpenLayers.Control.ModifyFeature.ROTATE
    | OpenLayers.Control.ModifyFeature.DRAG;

Legato.Control.ModifyFeature.Bean = OpenLayers.Control.ModifyFeature.Bean.Extend('Legato.Control.ModifyFeature', Legato.Control.QName('ModifyFeature'), {
  _constructor : Legato.Control.ModifyFeature,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ],
  options : {
    mode : Legato.Lang.Integer.Enum('Legato.Control.ModifyFeature.MODE', {
      'RESHAPE' : Legato.Control.ModifyFeature.MODE_RESHAPE,
      'AFFINE' : Legato.Control.ModifyFeature.MODE_AFFINE
    })
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ModifyPolygon = OpenLayers.Class(Legato.Control.ModifyFeature, {
  CLASS_NAME :'Legato.Control.ModifyPolygon'
});

Legato.Control.ModifyPolygon.Bean = Legato.Control.ModifyFeature.Bean.Extend(
//
    'Legato.Control.ModifyPolygon',
    //
    Legato.Control.QName('ModifyPolygon'),
    //
    {
      _constructor :Legato.Control.ModifyPolygon
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ModifyPoint = OpenLayers.Class(Legato.Control.ModifyFeature, {
  CLASS_NAME :'Legato.Control.ModifyPoint'
});

Legato.Control.ModifyPoint.Bean = Legato.Control.ModifyFeature.Bean.Extend(
//
    'Legato.Control.ModifyPoint',
    //
    Legato.Control.QName('ModifyPoint'),
    //
    {
      _constructor :Legato.Control.ModifyPoint
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ModifyLineString = OpenLayers.Class(Legato.Control.ModifyFeature, {

  CLASS_NAME :'Legato.Control.ModifyLineString'
});

Legato.Control.ModifyLineString.Bean = Legato.Control.ModifyFeature.Bean.Extend(
//
    'Legato.Control.ModifyLineString',
    //
    Legato.Control.QName('ModifyLineString'),
    //
    {
      _constructor :Legato.Control.ModifyLineString
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ModifyMultiPoint = OpenLayers.Class(Legato.Control.ModifyFeature, {
  CLASS_NAME :'Legato.Control.ModifyMultiPoint'
});

Legato.Control.ModifyMultiPoint.Bean = Legato.Control.ModifyFeature.Bean.Extend(
//
    'Legato.Control.ModifyMultiPoint',
    //
    Legato.Control.QName('ModifyMultiPoint'),
    //
    {
      _constructor :Legato.Control.ModifyMultiPoint
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ModifyMultiLineString = OpenLayers.Class(Legato.Control.ModifyFeature, {
  CLASS_NAME :'Legato.Control.ModifyMultiLineString'
});

Legato.Control.ModifyMultiLineString.Bean = Legato.Control.ModifyFeature.Bean.Extend(
//
    'Legato.Control.ModifyMultiLineString',
    //
    Legato.Control.QName('ModifyMultiLineString'),
    //
    {
      _constructor :Legato.Control.ModifyMultiLineString
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ModifyMultiPolygon = OpenLayers.Class(Legato.Control.ModifyFeature, {
  CLASS_NAME :'Legato.Control.ModifyMultiPolygon'
});

Legato.Control.ModifyMultiPolygon.Bean = Legato.Control.ModifyFeature.Bean.Extend(
//
    'Legato.Control.ModifyMultiPolygon',
    //
    Legato.Control.QName('ModifyMultiPolygon'),
    //
    {
      _constructor :Legato.Control.ModifyMultiPolygon
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @requires Legato/Control.js
 * @requires Legato/Handler.js
 * @requires Legato/Handler/MouseWheel.js
 */

/**
 * Class: Legato.Control.Navigation
 * The navigation control handles map browsing with mouse events (dragging,
 *     double-clicking, and scrolling the wheel).  Create a new navigation 
 *     control with the <Legato.Control.Navigation> control.  
 * 
 *     Note that this control is added to the map by default (if no controls 
 *     array is sent in the options object to the <OpenLayers.Map> 
 *     constructor).
 *     
 *     Extension to OpenLayers:
 *     Use Legato.Handler.MouseWheel to enable zooming by mousewheel while
 *     loading the map
 * 
 * Inherits:
 *  - <OpenLayers.Control.Navigation>
 */
Legato.Control.Navigation = OpenLayers.Class(OpenLayers.Control.Navigation, {
	/**
     * Method: draw
     */
    draw: function() {
        // disable right mouse context menu for support of right click events
        if (this.handleRightClicks) {
            this.map.viewPortDiv.oncontextmenu = OpenLayers.Function.False;
        }

        var clickCallbacks = { 
            'click': this.defaultClick,
            'dblclick': this.defaultDblClick, 
            'dblrightclick': this.defaultDblRightClick 
        };
        var clickOptions = {
            'double': true, 
            'stopDouble': true
        };
        this.handlers.click = new OpenLayers.Handler.Click(
            this, clickCallbacks, clickOptions
        );
        this.dragPan = new OpenLayers.Control.DragPan(
            OpenLayers.Util.extend({
                map: this.map,
                documentDrag: this.documentDrag
            }, this.dragPanOptions)
        );
        this.zoomBox = new OpenLayers.Control.ZoomBox(
                    {map: this.map, keyMask: this.zoomBoxKeyMask});
        this.dragPan.draw();
        this.zoomBox.draw();
        this.handlers.wheel = new Legato.Handler.MouseWheel(
                                    this, {"up"  : this.wheelUp,
                                           "down": this.wheelDown},
                                    this.mouseWheelOptions );
        if (OpenLayers.Control.PinchZoom) {
            this.pinchZoom = new OpenLayers.Control.PinchZoom(
                OpenLayers.Util.extend(
                    {map: this.map}, this.pinchZoomOptions));
        }
    },

  CLASS_NAME : 'Legato.Control.Navigation'
});

/**
 * Structure: lc:Navigation XML based config for a
 * <Legato.Control.Navigation>.
 *
 * See Also: - <OpenLayers.Control.Navigation> - <Legato.Handler.MouseWheel> - <Legato.Beans.BeanFactory> - <QName>
 *
 * A valid config example for a NavigationHistory would be:
 * (start code)
 * <lc:Navigation zoomWheelEnabled="true" />
 * (end)
 */
Legato.Control.Navigation.Bean = Legato.Control.Bean.Extend(
//
'Legato.Control.Navigation',
//
Legato.Control.QName('Navigation'),
//
{
  _constructor : Legato.Control.Navigation,
  options : {
		// TODO dragPan: null,
		// TODO dragPanOptions: null,
		// TODO zoomBox: null,
		/**
		 * Element: zoomWheelEnabled
		 * {Boolean} Whether the mousewheel should zoom the map.
		 */
		zoomWheelEnabled : Legato.Lang.Boolean,

		/**
		 * Element: handleRightClicks
		 * {Boolean} Whether or not to handle  right clicks. Default is false.
		 */
		handleRightClicks : Legato.Lang.Boolean
	}
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.NavigationHistory
 *
 *
 * Inherits from: - <OpenLayers.Control.NavigationHistory>
 */
Legato.Control.NavigationHistory = OpenLayers.Class(
    OpenLayers.Control.NavigationHistory, {

      EVENT_TYPES : [ "previousChange", "nextChange" ],

      /**
       * Constructor: OpenLayers.Control.NavigationHistory
       *
       * Parameters: options - {Object}
       */
      /*
      initialize : function(options) {
        // To avoid creation of buttons we just copy parts of
        // OpenLayers.Control.NavigationHistory constructor
        OpenLayers.Control.prototype.initialize.apply(this, [ options ]);

        this.registry = OpenLayers.Util.extend({
          "moveend" : function() {
            return {
              center : this.map.getCenter(),
              resolution : this.map.getResolution()
            };
          }
        }, this.registry);

        this.clear();

      },
      */

      /**
       * APIMethod: destroy
       * Destroy the control.
       */
      /*
      destroy : function() {
        // To avoid creation of buttons we just copy parts of
        // OpenLayers.Control.NavigationHistory constructor
        OpenLayers.Control.prototype.destroy.apply(this);
        this.deactivate();
        this.registry = null;
        this.nextStack = null;
        this.previousStack = null;
        this.listeners = null;
      },
      */

      /**
       * Method: onPreviousChange Called when the previous history stack
       * changes.
       *
       * Parameters: state - {Object} An object representing the state to be
       * restored if previous is triggered again or null if no previous states
       * remain. length - {Integer} The number of remaining previous states that
       * can be restored.
       */
      onPreviousChange : function(state, length) {
        this.events.triggerEvent('previousChange', {
          state : state,
          length : length
        });
      },

      /**
       * Method: onNextChange Called when the next history stack changes.
       *
       * Parameters: state - {Object} An object representing the state to be
       * restored if next is triggered again or null if no next states remain.
       * length - {Integer} The number of remaining next states that can be
       * restored.
       */
      onNextChange : function(state, length) {
        this.events.triggerEvent('nextChange', {
          state : state,
          length : length
        });
      },

      /**
       * Method: draw Called when the control is added to the map.
       */
      draw : function() {
        OpenLayers.Control.prototype.draw.apply(this, arguments);
        if (this.activateOnDraw) {
          this.activate();
        }
      },

      /**
       * Method: setMap
       * Set the map property for the control.
       *
       * Parameters:
       * map - {<OpenLayers.Map>}
       */
      setMap : function(map) {
        this.map = map;
      },

      CLASS_NAME : "Legato.Control.NavigationHistory"

    });

/**
 * Structure: lc:NavigationHistory XML based config for a
 * <Legato.Control.NavigationHistory>.
 *
 * See Also: - <OpenLayers.Control.NavigationHistory> - <Legato.Beans.BeanFactory> - <QName>
 *
 * A valid config example for a NavigationHistory would be:
 * (start code)
 * <lc:NavigationHistory limit="50" activateOnDraw="true" clearOnDeactivate="false" />
 * (end)
 */
Legato.Control.NavigationHistory.Bean = Legato.Control.Bean.Extend(
    'Legato.Control.NavigationHistory', Legato.Control
        .QName('NavigationHistory'), {
      _constructor : Legato.Control.NavigationHistory,
      options : {
        limit : Legato.Lang.Integer,

        activateOnDraw : Legato.Lang.Boolean,

        clearOnDeactivate : Legato.Lang.Boolean
      }
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.NavigationHistory
 *
 *
 * Inherits from: - <OpenLayers.Control.NavigationHistory>
 */
Legato.Control.AbstractNavigationHistoryButton = OpenLayers.Class(OpenLayers.Control.Button, {
  
  history: null,
  
  initialize: function(history, options) {
    OpenLayers.Control.Button.prototype.initialize.apply(this, [options]);
    Legato.Util.Ensure.ensureExists(history, "The history parameter doesn't exist.");
    this.history = history;
  },
  
  /**
   * APIMethod: destroy
   * Destroy the control.
   */
  destroy: function() {
      OpenLayers.Control.Button.prototype.destroy.apply(this);
      this.history = null;
  },
  
  CLASS_NAME: "Legato.Control.AbstractNavigationHistoryButton"

});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.NavigationHistoryNext = OpenLayers.Class(
    Legato.Control.AbstractNavigationHistoryButton, {
      /**
       * Property: title  
       * {string}  This property is used for showing a tooltip over the  
       * NavigationHistoryNext control. Default value is "Next".  
       */ 
      title : 'Next',
      
      /**
       * Constructor: OpenLayers.Control.NavigationHistoryNext
       * 
       * Parameters: 
       * history - {Legato.Control.NavigationHistory}
       * options - {Object}
       */
      initialize : function(history, options) {
        Legato.Control.AbstractNavigationHistoryButton.prototype.initialize
            .apply(this, [ history, options ]);
        this.history.events.register("nextChange", this, this.onNextChange);
      },

      /**
       * Method: onNextChange
       * Called when the next history stack changes.
       *
       * Parameters:
       * state - {Object} An object representing the state to be restored
       *     if next is triggered again or null if no next states remain.
       * length - {Integer} The number of remaining next states that can
       *     be restored.
       */
      onNextChange : function(event) {
        var state = event.state;
        if (state && !this.active) {
          this.activate();
        } else if (!state && this.active) {
          this.deactivate();
        }
      },

      /**
       * APIMethod: trigger 
       * Restore the next state. If no items are in the
       * next history stack, this has no effect. The next history stack is
       * populated as states are restored from the previous history stack.
       * 
       * Returns: {Object} Item representing state that was restored. Undefined
       * if no items are in the next history stack.
       */
      trigger : function() {
        var state = this.history.nextStack.shift();
        if (!Legato.Lang.ObjectUtils.isUndefined(state)) {
          this.history.previousStack.unshift(state);
          this.history.restoring = true;
          this.history.restore(state);
          this.history.restoring = false;
          this.history.onPreviousChange(this.history.previousStack[1],
              this.history.previousStack.length - 1);
          this.history.onNextChange(this.history.nextStack[0],
              this.history.nextStack.length);
        }
        return state;
      },

      CLASS_NAME : "Legato.Control.NavigationHistoryNext"

    });

/**
 * Structure: lc:NavigationHistoryNext XML based config for a <Legato.Control.NavigationHistoryNext>.
 * 
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory> - <QName>
 * 
 * A valid config example for a NavigationHistoryNext would be:
 * (start code)
 * <lc:NavigationHistoryNext title="Tooltip for next">
 *   <history>
 *     <lb:Reference target="NavigationHistory" />
 *   </history>
 * </lc:NavigationHistoryNext>
 * (end)
 */
Legato.Control.NavigationHistoryNext.Bean = Legato.Control.Bean.Extend(
    'Legato.Control.NavigationHistoryNext', Legato.Control
        .QName('NavigationHistoryNext'), {
      factoryFunction : function(history, options) {
        return new Legato.Control.NavigationHistoryNext(history, options);
      },
      constructorArguments : {
        history : Legato.Control.NavigationHistory.Bean
      },
      constructorOrder : [ 'history' ]
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.NavigationHistoryPrevious = OpenLayers.Class(Legato.Control.AbstractNavigationHistoryButton, {
  /**
   * Property: title  
   * {string}  This property is used for showing a tooltip over the  
   * NavigationHistoryPrevious control. Default value is "Previous".  
   */ 
  title: 'Previous',

  /**
   * Constructor: OpenLayers.Control.NavigationHistoryPrevious
   * 
   * Parameters: 
   * history - {Legato.Control.NavigationHistory}
   * options - {Object}
   */
  initialize: function(history, options) {
    Legato.Control.AbstractNavigationHistoryButton.prototype.initialize.apply(this, [history, options]);
    this.history.events.register("previousChange", this, this.onPreviousChange);
  },
  
  /**
   * Method: onPreviousChange
   * Called when the previous history stack changes.
   *
   * Parameters:
   * state - {Object} An object representing the state to be restored
   *     if previous is triggered again or null if no previous states remain.
   * length - {Integer} The number of remaining previous states that can
   *     be restored.
   */
  onPreviousChange: function(event) {
      var state = event.state;
      if(state && !this.active) {
          this.activate();
      } else if(!state && this.active) {
          this.deactivate();
      }
  },

  /**
   * APIMethod: trigger
   * Restore the previous state.  If no items are in the previous history
   *     stack, this has no effect.
   *
   * Returns:
   * {Object} Item representing state that was restored.  Undefined if no
   *     items are in the previous history stack.
   */
  trigger: function() {
      var current = this.history.previousStack.shift();
      var state = this.history.previousStack.shift();
      if(!Legato.Lang.ObjectUtils.isUndefined(state)) {
          this.history.nextStack.unshift(current);
          this.history.previousStack.unshift(state);
          this.history.restoring = true;
          this.history.restore(state);
          this.history.restoring = false;
          this.history.onNextChange(this.history.nextStack[0], this.history.nextStack.length);
          this.history.onPreviousChange(
              this.history.previousStack[1], this.history.previousStack.length - 1
          );
      } else {
          this.history.previousStack.unshift(current);
      }
      return state;
  },
  
  CLASS_NAME: "Legato.Control.NavigationHistoryPrevious"

});

/**
 * Structure: lc:NavigationHistoryPrevious XML based config for a <Legato.Control.NavigationHistoryPrevious>.
 * 
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory> - <QName>
 * 
 * A valid config example for a NavigationHistoryPrevious would be:
 * (start code)
 * <lc:NavigationHistoryPrevious title="Tooltip for previous">
 *   <history>
 *     <lb:Reference target="NavigationHistory" />
 *   </history>
 * </lc:NavigationHistoryPrevious>
 * (end)
 */
Legato.Control.NavigationHistoryPrevious.Bean = Legato.Control.Bean.Extend(
    'Legato.Control.NavigationHistoryPrevious',
    Legato.Control.QName('NavigationHistoryPrevious'),
    {
      factoryFunction : function(history, options)
      {
        return new Legato.Control.NavigationHistoryPrevious(history, options);
      },
      constructorArguments : {
        history : Legato.Control.NavigationHistory.Bean
      },
      constructorOrder : [ 'history' ]
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.OverviewBoundingBox
 *
 * This simple control switches the visibility of an arbitrary div which is given in its "div" property.
 *
 * Inherits from:
 * - <Legato.Control>
 *
 */
Legato.Control.OverviewBoundingBox = OpenLayers.Class(Legato.Control, {

  /**
   * Property: handlers
   * {Object}
   */
  handlers: null,

  /** Property: parentMap
   * {OpenLayers.Map}
   */
  parentMap: null,

  extentRectangle: null,
  /**
   * Constructor: OpenLayers.Control.OverviewMap
   * Create a new overview map
   *
   * Parameters:
   * object - {Object} Properties of this object will be set on the overview
   * map object.  Note, to set options on the map object contained in this
   * control, set <mapOptions> as one of the options properties.
   */
  initialize: function(options) {
      this.handlers = {};
      //TODO: Check that parentMap is set in options
      Legato.Control.prototype.initialize.apply(this, [options]);
  },

  /**
   * APIMethod: destroy
   * Deconstruct the control
   */
  destroy: function() {
    if (!this.mapDiv) { // we've already been destroyed
        return;
    }
    if (this.handlers.click) {
      this.handlers.click.destroy();
    }
    if (this.handlers.zoom) {
      this.handlers.zoom.destroy();
    }

    this.map.viewPortDiv.removeChild(this.extentRectangle);
    this.extentRectangle = null;

    this.mapDiv = null;

    this.map.events.un({
        "moveend": this.update,
        scope: this
    });

    if (this.parentMap && this.parentMap.events) {
      this.parentMap.events.un({
        "moveend": this.update,
        scope: this
      });
    }

    Legato.Control.prototype.destroy.apply(this, arguments);
  },

  /**
   * Method: draw
   * Render the control in the browser.
   */
  draw: function() {
    if (!this.parentMap) {
      throw new Legato.Lang.Exception('parent map is not defined');
    }
    Legato.Control.prototype.draw.apply(this, arguments);

    this.mapDiv = this.map.div;

    this.extentRectangle = document.createElement('div');
    this.extentRectangle.style.position = 'absolute';
    this.extentRectangle.style.zIndex = this.map.Z_INDEX_BASE.Popup - 1;
    this.extentRectangle.className = this.displayClass+'ExtentRectangle';
    // Bugfix: OpenLayers.Handler.Box.zoomBox must overflow extentRectangle(equal z-index) 
    // OpenLayers.Handler.Box.zoomBox is appended to map.viewPortDiv
    // therefore extentRectangle must also be appended to map.viewPortDiv before 
    // OpenLayers.Handler.Box.zoomBox
    this.map.viewPortDiv.appendChild(this.extentRectangle);
    if (!(this.mapDiv.style.position === 'absolute' || this.mapDiv.style.position === 'relative')) {
      this.mapDiv.style.position = 'relative'; //HACK
    }

    // check extent rectangle border width
    this.wComp = parseInt(OpenLayers.Element.getStyle(this.extentRectangle,
                                           'border-left-width'), 10) +
                 parseInt(OpenLayers.Element.getStyle(this.extentRectangle,
                                           'border-right-width'), 10);
    this.wComp = (this.wComp) ? this.wComp : 2;
    this.hComp = parseInt(OpenLayers.Element.getStyle(this.extentRectangle,
                                           'border-top-width'), 10) +
                 parseInt(OpenLayers.Element.getStyle(this.extentRectangle,
                                           'border-bottom-width'), 10);
    this.hComp = (this.hComp) ? this.hComp : 2;

    if(this.parentMap.getExtent()) {
        this.update();
    }

    this.parentMap.events.register('moveend', this, this.update);
    this.map.events.register('moveend', this, this.update);

    this.handlers.click = new OpenLayers.Handler.Click(
        this, {
            "click": this.mapDivClick
        },{
            "single": true, "double": false,
            "stopSingle": true, "stopDouble": true,
            "pixelTolerance": 1,
            map: this.map
        }
    );
    this.handlers.click.activate();

    this.handlers.zoom = new OpenLayers.Handler.Box( this,
        {done: this.handleZoomBox}, {keyMask: this.keyMask} );
    this.handlers.zoom.activate();

    /*if (this.map.getProjection() != this.parentMap.getProjection()) {
      var sourceUnits = this.parentMap.getProjectionObject().getUnits() ||
          this.parentMap.units || this.parentMap.baseLayer.units;
      var targetUnits = this.map.getProjectionObject().getUnits() ||
          this.map.units || this.map.baseLayer.units;
      this.resolutionFactor = sourceUnits && targetUnits ?
          OpenLayers.INCHES_PER_UNIT[sourceUnits] /
          OpenLayers.INCHES_PER_UNIT[targetUnits] : 1;
    }*/

    return this.div;
  },

  /**
   * Method: mapDivClick
   * Handle browser events
   *
   * Parameters:
   * evt - {<OpenLayers.Event>} evt
   */
  mapDivClick: function(evt) {
    var pxCenter = this.rectPxBounds.getCenterPixel();
    var deltaX = evt.xy.x - pxCenter.x;
    var deltaY = evt.xy.y - pxCenter.y;
    var top = this.rectPxBounds.top;
    var left = this.rectPxBounds.left;
    var height = Math.abs(this.rectPxBounds.getHeight());
    var width = this.rectPxBounds.getWidth();
    var newTop = Math.max(0, (top + deltaY));
    newTop = Math.min(newTop, this.map.size.h - height);
    var newLeft = Math.max(0, (left + deltaX));
    newLeft = Math.min(newLeft, this.map.size.w - width);
    this.setRectPxBounds(new OpenLayers.Bounds(newLeft,
                                               newTop + height,
                                               newLeft + width,
                                               newTop));
    this.updateMapToRect(false);
  },

  /**
   * Method: update
   * Update the overview map after layers move.
   */
  update: function() {
    // update extent rectangle
    this.updateRectToMap();
  },

  /**
   * Method: updateRectToMap
   * Updates the extent rectangle position and size to match the map extent
   */
  updateRectToMap: function() {
    // If the projections differ we need to reproject
    var bounds;

    /*
     * The projection for our map or the parent map may be null due we create
     * both of them asynchronous. If this is true we just abort.
     */
    if (Legato.Lang.ObjectUtils.isNullOrUndefined(this.map.getProjection()) ||
        Legato.Lang.ObjectUtils.isNullOrUndefined(this.parentMap.getProjection())) {
      return;
    }

    if (this.map.getProjection() != this.parentMap.getProjection()) {
        bounds = this.parentMap.getExtent().transform(
            this.parentMap.getProjectionObject(),
            this.map.getProjectionObject() );
    } else {
        bounds = this.parentMap.getExtent();
    }

    //Do not paint if bounds is not within your maxExtent
    if(!this.map.getExtent().containsBounds(bounds, true, true)){
      bounds = null;
    }

    var pxBounds = this.getRectBoundsFromMapBounds(bounds);
    this.setRectPxBounds(pxBounds);
  },

  /**
   * Method: updateMapToRect
   * Updates the map extent to match the extent rectangle position and size
   */
  updateMapToRect: function(zoom) {
    var lonLatBounds = this.getMapBoundsFromRectBounds(this.rectPxBounds);

    /*
     * Abort if eather our map or the referenced map does not have a projection
     * yet. This could occur at creation time when maps are created asynchronous.
     */
    if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.map.getProjection()) ||
        Legato.Lang.ObjectUtils.isNullOrUndefined(this.parentMap.getProjection())){
      return;
    }

    if (this.map.getProjection() != this.parentMap.getProjection()) {
      lonLatBounds = lonLatBounds.transform(
        this.map.getProjectionObject(),
        this.parentMap.getProjectionObject() );
    }
    if (!zoom) {
      this.parentMap.panTo(lonLatBounds.getCenterLonLat());
    } else {
      this.parentMap.zoomToExtent(lonLatBounds, true);
    }
  },

  /**
   * Method: setRectPxBounds
   * Set extent rectangle pixel bounds.
   *
   * Parameters:
   * pxBounds - {<OpenLayers.Bounds>}
   */
  setRectPxBounds: function(pxBounds) {
    if (pxBounds) {
      this.extentRectangle.className = this.displayClass +
      'ExtentRectangle';
    } else {
      this.extentRectangle.className = this.displayClass +
      'ExtentRectangleOutside';
      pxBounds = new OpenLayers.Bounds(0,this.map.size.h,this.map.size.w,0);
    }
    var top = Math.max(pxBounds.top, 0);
    var left = Math.max(pxBounds.left, 0);
    var bottom = Math.min(pxBounds.top + Math.abs(pxBounds.getHeight()),
                          this.map.size.h - this.hComp);
    var right = Math.min(pxBounds.left + pxBounds.getWidth(),
                         this.map.size.w - this.wComp);
    var width = Math.max(right - left, 0);
    var height = Math.max(bottom - top, 0);
    this.extentRectangle.style.top = Math.round(top) + 'px';
    this.extentRectangle.style.left = Math.round(left) + 'px';
    this.extentRectangle.style.height = Math.round(height) + 'px';
    this.extentRectangle.style.width = Math.round(width) + 'px';
    this.rectPxBounds = new OpenLayers.Bounds(
        Math.round(left), Math.round(bottom),
        Math.round(right), Math.round(top)
    );
  },

  /**
   * Method: getRectBoundsFromMapBounds
   * Get the rect bounds from the map bounds.
   *
   * Parameters:
   * lonLatBounds - {<OpenLayers.Bounds>}
   *
   * Returns:
   * {<OpenLayers.Bounds>}A bounds which is the passed-in map lon/lat extent
   * translated into pixel bounds for the overview map
   */
  getRectBoundsFromMapBounds: function(lonLatBounds) {
    var bounds = null;
    if (lonLatBounds) {
      var leftBottomLonLat = new OpenLayers.LonLat(lonLatBounds.left,
                                                   lonLatBounds.bottom);
      var rightTopLonLat = new OpenLayers.LonLat(lonLatBounds.right,
                                                 lonLatBounds.top);
      var leftBottomPx = this.getOverviewPxFromLonLat(leftBottomLonLat);
      var rightTopPx = this.getOverviewPxFromLonLat(rightTopLonLat);
      if (leftBottomPx && rightTopPx) {
          bounds = new OpenLayers.Bounds(leftBottomPx.x, leftBottomPx.y,
                                         rightTopPx.x, rightTopPx.y);
      }
    }
    return bounds;
  },

  /**
   * Method: getMapBoundsFromRectBounds
   * Get the map bounds from the rect bounds.
   *
   * Parameters:
   * pxBounds - {<OpenLayers.Bounds>}
   *
   * Returns:
   * {<OpenLayers.Bounds>} Bounds which is the passed-in overview rect bounds
   * translated into lon/lat bounds for the overview map
   */
  getMapBoundsFromRectBounds: function(pxBounds) {
    var leftBottomPx = new OpenLayers.Pixel(pxBounds.left,
                                            pxBounds.bottom);
    var rightTopPx = new OpenLayers.Pixel(pxBounds.right,
                                          pxBounds.top);
    var leftBottomLonLat = this.getLonLatFromOverviewPx(leftBottomPx);
    var rightTopLonLat = this.getLonLatFromOverviewPx(rightTopPx);
    return new OpenLayers.Bounds(leftBottomLonLat.lon, leftBottomLonLat.lat,
                                 rightTopLonLat.lon, rightTopLonLat.lat);
  },

  /**
   * Method: getLonLatFromOverviewPx
   * Get a map location from a pixel location
   *
   * Parameters:
   * overviewMapPx - {<OpenLayers.Pixel>}
   *
   * Returns:
   * {<OpenLayers.LonLat>} Location which is the passed-in overview map
   * OpenLayers.Pixel, translated into lon/lat by the overview map
   */
  getLonLatFromOverviewPx: function(overviewMapPx) {
    var size = this.map.size;
    var fullXPixels = size.w - this.wComp;
    var fullYPixels = size.h - this.hComp;
    var fullWidth = this.map.getExtent().getWidth();
    var fullHeight = this.map.getExtent().getHeight();
    var minX = this.map.getExtent().left;
    var maxY = this.map.getExtent().top;

    var delta_x = (overviewMapPx.x / fullXPixels) * fullWidth;
    var delta_y = (overviewMapPx.y / fullYPixels) * fullHeight;

    var xCoord = minX + delta_x;
    var yCoord = maxY - delta_y;

    return new OpenLayers.LonLat(xCoord, yCoord);
  },

  /**
   * Method: getOverviewPxFromLonLat
   * Get a pixel location from a map location
   *
   * Parameters:
   * lonlat - {<OpenLayers.LonLat>}
   *
   * Returns:
   * {<OpenLayers.Pixel>} Location which is the passed-in OpenLayers.LonLat,
   * translated into overview map pixels
   */
  getOverviewPxFromLonLat: function(lonlat) {
    var res  = this.map.getResolution();
    var extent = this.map.getExtent();
    var px = null;
    if (extent) {
      px = new OpenLayers.Pixel(
        Math.round(1/res * (lonlat.lon - extent.left)),
        Math.round(1/res * (extent.top - lonlat.lat))
      );
    }
    return px;
  },

  /**
   * Method: zoomBox
   *
   * Parameters:
   * position - {<OpenLayers.Bounds>} or {<OpenLayers.Pixel>}
   */
  handleZoomBox: function (position) {
    if (position instanceof OpenLayers.Bounds) {
      this.setRectPxBounds(position);
      this.updateMapToRect(true);

        /*var minXY = this.map.getLonLatFromPixel(
                        new OpenLayers.Pixel(position.left, position.bottom));
        var maxXY = this.map.getLonLatFromPixel(
                        new OpenLayers.Pixel(position.right, position.top));
        var bounds = new OpenLayers.Bounds(minXY.lon, minXY.lat,
                                           maxXY.lon, maxXY.lat);

        // always zoom in/out
        this.map.zoomToExtent(bounds);*/

    } else { // it's a pixel
      //Do nothing, the click handler will deal with it.
    }
  },

  CLASS_NAME :"Legato.Control.OverviewBoundingBox"
});

/**
 * Structure: lc:OverviewBoundingBox
 * XML based config for a <Legato.Control.OverviewBoundingBox>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a OverviewBoundingBox would be:
 * (start code)
 * <lc:OverviewBoundingBox div="overviewMap" displayClass="LegatoControlToggleOverviewMap"/>
 * (end)
 */
Legato.Control.OverviewBoundingBox.Bean = OpenLayers.Control.Bean.Extend(
  'Legato.Control.OverviewBoundingBox', Legato.Control.QName('OverviewBoundingBox'), {
    _constructor :Legato.Control.OverviewBoundingBox,
    options:
    {
      parentMap: OpenLayers.Map
    }
  }
);

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.PanZoom = OpenLayers.Class(OpenLayers.Control.PanZoom,
    {
      initialize : function(options) {
        OpenLayers.Control.PanZoom.prototype.initialize.apply(this, arguments);
      },
      
      cssDerivations : {
        'panup' : 'Up',
        'panleft': 'Left',
        'panright': 'Right',
        'pandown': 'Down',
        'zoomin': 'In',
        'zoomworld': 'World',
        'zoomout': 'Out'
      },
    
    _addButton : function(id, _class, xy, sz) {
      var btn = OpenLayers.Control.PanZoom.prototype._addButton.apply(this, arguments);
      btn.className = btn.className + ' ' + this.displayClass + this.cssDerivations[id];
      if (btn.hasChildNodes())
      {
        while (btn.childNodes.length >= 1)
        {
          btn.removeChild(btn.firstChild);       
        } 
      }
      return btn;
    },

    CLASS_NAME :"Legato.Control.PanZoom"
    });

Legato.Control.PanZoom.Bean = OpenLayers.Control.PanZoom.Bean.Extend(
//
    'Legato.Control.PanZoom',
    //
    Legato.Control.QName('PanZoom'),
    //
    {
      _constructor :Legato.Control.PanZoom
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.PanZoomBar = OpenLayers.Class(OpenLayers.Control.PanZoomBar, {
	initialize : function(options) {
		OpenLayers.Control.PanZoomBar.prototype.initialize.apply(this,
				arguments);
	},
	
  cssDerivations : {
    'panup' : 'Up',
    'panleft': 'Left',
    'panright': 'Right',
    'pandown': 'Down',
    'zoomin': 'In',
    'zoomworld': 'World',
    'zoomout': 'Out'
  },

  removeChildrenAndAddClass: function(element, classSuffix) {
    element.className = element.className + ' ' + this.displayClass + classSuffix;
    if (element.hasChildNodes()) {
      while (element.childNodes.length >= 1) {
        element.removeChild(element.firstChild);       
      } 
    }
  }, 
  
  _addZoomBar: function(centered) {
    var result = OpenLayers.Control.PanZoomBar.prototype._addZoomBar.apply(this, arguments);
    this.removeChildrenAndAddClass(this.slider, 'Slider');
    this.removeChildrenAndAddClass(this.zoombarDiv, 'Scroller');
    return result;
  },
	
  _addButton : function(id, _class, xy, sz) {
    var btn = OpenLayers.Control.PanZoom.prototype._addButton.apply(this, arguments);
    this.removeChildrenAndAddClass(btn, this.cssDerivations[id]);
    return btn;
  },

	CLASS_NAME : "Legato.Control.PanZoomBar"
});

/**
 * Component: lc:PanZoomBar
 * 
 * Inherits from:
 * - {<olc:PanZoomBar>}
 * 
 * See also:
 * - <lc> namespace
 * - {<Legato.Control.PanZoomBar>}
 * - <olc> namespace
 * - {<OpenLayers.Control.PanZoomBar>}
 */
Legato.Control.PanZoomBar.Bean = OpenLayers.Control.PanZoomBar.Bean.Extend(
//
'Legato.Control.PanZoomBar',
//
Legato.Control.QName('PanZoomBar'),
//
{
	_constructor : Legato.Control.PanZoomBar
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: Legato.Control.SelectionBoxValueProvider
 * A menu button which integrates the <OpenLayers.Control.Panel>. If triggered an
 * vector will been painted by moving the mouse. If selection is done and the getValue
 * callback function is implemented, you'll reveive the currently painted bbox.
 * On the oposite you have the possibility to initialize this control by implementing
 * the setValue function.
 *
 * Inherits from:
 * - <Legato.Control>
 *
 * See Also:
 * - <OpenLayers.Control.Panel>
 */
Legato.Control.SelectionBoxValueProvider = OpenLayers.Class(Legato.Control,
{
    /*
     * Property: type
     * {String} OpenLayers.Control.TYPE_TOOL
     */
    type: OpenLayers.Control.TYPE_TOOL,

    /*
     * Property: selectionLayer
     * {OpenLayers.Feature.Vector} The vector layer which will be created and
     * managed by this control
     *
     * See Also:
     * <OpenLayers.Feature.Vector>
     */
    selectionLayer: null,

    /*
     * Property: styleMap
     * {<OpenLayers.StyleMap>}
     */
    styleMap: null,

    /*
     * Property: Selection
     * {String} The default name of the selection box layer. Will be used
     * if not defined in ctor.
     */
    defaultLayerName: 'Selection',

    /*
     * Property: defaultOpacity
     * {Number}  The default opacity value of the selectionbox layer. Will be used
     * if not defined in ctor.
     */
    defaultOpacity: 1,

   /*
    * Function: initialize
    * Basic ctor
    *
    * Parameters:
    * options - {Object} A Hashmap containing option parameters for this control
    * The following keys are supported
    * - target {object} an object which wants to observe,
    * - property{function|String} the propety or function which should be used for providing the observed value
    * - bBoxProperty {String} any Property name of an <OpenLayers.Bounds> instance
    */
    initialize : function(options) {
      OpenLayers.Control.prototype.initialize.apply(this, arguments);

      /*
       * Normalize given options
       */
      this.layerName = this.layerName || this.defaultLayerName;
      try{
        this.opacity = Legato.Lang.NumberUtils.toFloat(this.opacity);
      } catch(ex) {
        this.opacity = this.defaultOpacity;
      }
    },

   /*
    * Function: destroy
    *
    * See Also:
    * <OpenLayer.Control>
    */
    destroy : function() {
      OpenLayers.Control.prototype.destroy.apply(this, arguments);
    },

  /*
   * Function: draw
   *
   * See Also:
   * <OpenLayer.Control>
   */
    draw: function() {
        this.initVectorLayer();
        //Initializes the handler and callback methods
        this.handler = new OpenLayers.Handler.Box( this, {
          done: this.onSelectionBoxDrawn
        }, {
          keyMask: this.keyMask
        });
    },

    /*
     * Inits the vector layer
     */
    initVectorLayer: function(){
      if(!Legato.Lang.ObjectUtils.isFunction(this.getValue)){
        return;
      }

      var bbox = this.getValue();

      if(Legato.OpenLayers.Map.Util.isValidBBox(bbox)){
        this.createVectorLayer();
        this.selectionLayer.addFeatures(new OpenLayers.Feature.Vector(bbox.toGeometry()));
      }
    },

    /*
     * Creates the managed vectorlayer which will been used for drawing
     * the mouse selection as a bbox vector.
     */
    createVectorLayer: function(){
      var selectionLayerOptions = {};
      if (Legato.Lang.ObjectUtils.exists(this.styleMap))
      {
        selectionLayerOptions.styleMap = this.styleMap;
      }
      else
      {
        selectionLayerOptions.styleMap = new OpenLayers.StyleMap({
              "default": new OpenLayers.Style({
                  fillColor: "#ffffff",
                  fillOpacity: "0.5",
                  strokeColor: "#ff0000",
                  strokeWidth: "2"
              })
          });
      }

      this.selectionLayer = new OpenLayers.Layer.Vector(this.layerName, selectionLayerOptions);
      this.selectionLayer.setOpacity(this.opacity);
      this.selectionLayer.options.legatoIgnore = true;
      this.map.addLayer(this.selectionLayer);
      var index = Math.max(this.map.Z_INDEX_BASE.Feature - 1,
          this.selectionLayer.getZIndex()) + 1;
      this.selectionLayer.setZIndex(index);
      this.selectionLayer.events.on({
        'featureadded' : this.propagateValue,
        'featureremoved' : this.propagateValue,
        'featuremodified' : this.propagateValue,
        scope : this
      });
    },


    /**
     * Triggered if the managed vector layer is enabled and the mouse
     * has painted a selection box. The painted box and its coordinates
     * will been given as argument.
     *
     * Parameters:
     * position - {<OpenLayers.Pixel>} The current mouse position, a.k. bbox selection
     */
    onSelectionBoxDrawn: function (position) {
      if(this.selectionLayer === null){
        this.createVectorLayer();
      }

      if(this.selectionLayer.features.length > 0){
        this.selectionLayer.destroyFeatures();
      }

      var boxVector = Legato.OpenLayers.Map.Util.getBoxSelectionAsVector(this.map, position);

      this.selectionLayer.addFeatures(boxVector);
    },

   /*
    * updates all subscribed target's values
    */
    propagateValue: function(){
      if(!Legato.Lang.ObjectUtils.isFunction(this.setValue)){
        return;
      }

      var bbox = new OpenLayers.Bounds(null,null,null,null);

      if(this.selectionLayer.features.length == 1){
        bbox = this.selectionLayer.features[0].geometry.getBounds();
      }

      this.setValue(bbox);
    },

    CLASS_NAME : 'Legato.Control.SelectionBoxValueProvider'
});

/**
 * Structure: lc:SelectionBoxValueProvider
 * XML based config for a <Legato.Control.lc:SelectionBoxValueProvider>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a Legend would be:
 * (start code)
 * <lc:SelectionBoxValueProvider opacity="0.5" layerName="Foo" left="selectionLeft" right="selectionRight" top="selectionTop" bottom="selectionBottom"/>
 * (end)
 */
Legato.Control.SelectionBoxValueProvider.Bean = Legato.Control.Bean.Extend(

  'Legato.Control.SelectionBoxValueProvider',

  /*
   * Property: QName
   * The qualified name for this control. Needed by XML config to instantiate it.
   */
  Legato.Control.QName('SelectionBoxValueProvider'),
  {
   /*
    * Creates a basic <Legato.Control.SelectionBoxValueProvider> instance. By default this instance
    * will update the DOMElements by any selection change. If DOMElements contain at construction time
    * their values will been propagated to the ValueProvider which will create a selection box if valid.
    *
    * Parameters:
    * left - {String} The configured DOMElement ID where the left bbox value should be written into
    * bottom - {String} The configured DOMElement ID where the bottom bbox value should be written into
    * right - {String} The configured DOMElement ID where the right bbox value should be written into
    * top - {String} The configured DOMElement ID where the top bbox value should be written into
    *
    * Returns:
    * <Legato.Control.SelectionBoxValueProvider>
    */
    factoryFunction : function(left, bottom, right, top, options)
    {
      var leftElement   = null;
      var bottomElement = null;
      var rightElement  = null;
      var topElement    = null;

      if(Legato.Lang.ObjectUtils.isString(left)){
        leftElement = OpenLayers.Util.getElement(left);
        Legato.Util.Ensure.ensureExists(leftElement, 'SelectionBoxValueProvider: The configured DOMElement with the id' + left + ' could not been found.');
      }
      if(Legato.Lang.ObjectUtils.isString(bottom)){
        bottomElement = OpenLayers.Util.getElement(bottom);
        Legato.Util.Ensure.ensureExists(bottomElement, 'SelectionBoxValueProvider: The configured DOMElement with the id' + bottom + ' could not been found.');
      }
      if(Legato.Lang.ObjectUtils.isString(right)){
        rightElement = OpenLayers.Util.getElement(right);
        Legato.Util.Ensure.ensureExists(rightElement, 'SelectionBoxValueProvider: The configured DOMElement with the id' + right + ' could not been found.');
      }
      if(Legato.Lang.ObjectUtils.isString(top)){
        topElement = OpenLayers.Util.getElement(top);
        Legato.Util.Ensure.ensureExists(topElement, 'SelectionBoxValueProvider: The configured DOMElement with the id' + top + ' could not been found.');
      }

      return new Legato.Control.SelectionBoxValueProvider({
        opacity: options.opacity,
        layerName: options.layerName,
        elements: {
          left: leftElement,
          bottom: bottomElement,
          right: rightElement,
          top: topElement
        },
        setValue: function(BBox){
          if(!Legato.Lang.ObjectUtils.exists(BBox)){
            return;
          }
          this.elements.left.value    = BBox.left;
          this.elements.right.value   = BBox.right;
          this.elements.top.value     = BBox.top;
          this.elements.bottom.value  = BBox.bottom;
        },
        getValue: function(){
          try{
            var left    = Legato.Lang.NumberUtils.toFloat(this.elements.left.value);
            var right   = Legato.Lang.NumberUtils.toFloat(this.elements.right.value);
            var top     = Legato.Lang.NumberUtils.toFloat(this.elements.top.value);
            var bottom  = Legato.Lang.NumberUtils.toFloat(this.elements.bottom.value);

            return new OpenLayers.Bounds(left, bottom, right, top);
          }catch(ex){
            OpenLayers.Console.warn(ex);
            return new OpenLayers.Bounds(null, null, null, null);
          }
        }
      });
    },
    options:
    {
     /*
      * Property: opacity
      * {Number} - A numeric value which defined the opacity of drawn selection box. Must be between
      * 0 and 1. If a non parsable value is specified the default value of the control will
      * been used.
      *
      * See Also:
      * <Legato.Control.SelectionBoxValueProvider.defaultOpacity>
      */
      opacity: Legato.Lang.Number,

     /*
      * Property: layerName
      * {String} - Optional Parameter which defines the name of SelectionBox layer. If not specified
      *
      * See Also:
      * <Legato.Control.SelectionBoxValueProvider.defaultLayerName>
      */
      layerName: Legato.Lang.String
    },
    constructorArguments:
    {
     /*
      * Property: left
      * Defines the {DOMElement} id where the left <OpenLayers.Bounds> value should be written into.
      * The DOMElement must exists in current DOM. Otherwise an Exception is thrown.
      */
      left: Legato.Lang.String,

     /*
      * Property: right
      * Defines the {DOMElement} id where the right <OpenLayers.Bounds> value should be written into.
      * The DOMElement must exists in current DOM. Otherwise an Exception is thrown.
      */
      right: Legato.Lang.String,

     /*
      * Property: top
      * Defines the {DOMElement} id where the top <OpenLayers.Bounds> value should be written into.
      * The DOMElement must exists in current DOM. Otherwise an Exception is thrown.
      */
      top: Legato.Lang.String,

     /*
      * Property: bottom
      * Defines the {DOMElement} id where the bottom <OpenLayers.Bounds> value should be written into.
      * The DOMElement must exists in current DOM. Otherwise an Exception is thrown.
      */
      bottom: Legato.Lang.String
    },
    constructorOrder: ['left', 'bottom', 'right', 'top']
  }
);

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.SetMapSize = OpenLayers.Class(OpenLayers.Control, {

  type : OpenLayers.Control.TYPE_BUTTON,
  selectElement : null,
  customMapSizeName: null,
  mapSizes : null,
  mapSizeOptionElements : null,
  maintainExtent : false,
  zoomToClosest : true,
  widthDifference : 0,
  heightDifference : 0,
  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
    if (!Legato.Lang.ObjectUtils.exists(this.mapSizes)) {
      this.mapSizes = {};
    }
    this.mapSizeOptionElements = {};
  },
  draw : function() {
    var div = OpenLayers.Control.prototype.draw.apply(this, arguments);
    if (!Legato.Lang.ObjectUtils.exists(this.selectElement)) {
      this.selectElement = document.createElement('select');
      this.selectElement.id = this.id + "_SelectElement";
      this.selectElement.name = this.id + "_SelectElement";
      this.selectElement.title = this.title;

      for ( var mapSizeName in this.mapSizes) {
        if (this.mapSizes.hasOwnProperty(mapSizeName)) {
          var mapSize = this.mapSizes[mapSizeName];
          this.addOptionElement(mapSizeName, mapSize);
        }
      }

      this.selectElement.className = this.displayClass + 'SelectElement';
      
      var that = this;
      var refreshFunction = function() {
        var currentSize = that.map.size;
        var currentSizeName = that.getMatchingSizeName(currentSize);
        if (currentSizeName === null) {
          that.addOptionElement(that.customMapSizeName, currentSize);
          that.mapSizes[that.customMapSizeName] = currentSize;
          that.selectElement.value = that.customMapSizeName;
          that.widthDifference = 0;
          that.heightDifference = 0;
          that.updateSize();
        }
      };
      this.map.events.on({"legato.refresh" : refreshFunction});      
      this.updateSize();
      this.selectElement.onchange = OpenLayers.Function
          .bindAsEventListener(this.onChange, this);

      this.div.appendChild(this.selectElement);
      this.ready = true;
    }
    return div;
  },
  addOptionElement : function(sizeName, size) {
    var optionElement = document.createElement('option');
    optionElement.value = sizeName;
    optionElement.innerHTML = sizeName;
    this.selectElement.appendChild(optionElement);
    this.mapSizeOptionElements[sizeName] = optionElement;
    return optionElement;
  },
  removeOptionElement : function(sizeName) {
    var optionElement = this.mapSizeOptionElements[sizeName];
    if (Legato.Lang.ObjectUtils.exists(optionElement)) {
      this.selectElement.removeChild(optionElement);
      delete this.mapSizeOptionElements[sizeName];
    }
  },
  getMatchingSizeName : function(currentSize) {
    for ( var mapSizeName in this.mapSizes) {
      if (this.mapSizes.hasOwnProperty(mapSizeName)) {
        var mapSize = this.mapSizes[mapSizeName];
        if (Legato.Lang.ObjectUtils.exists(currentSize)
            && mapSize.equals(currentSize)) {
          return mapSizeName;
        }
      }
    }
    return null;
  },
  updateSize : function() {
    if (!this.ready) {
      return;
    }
    var currentSize = {
        w: this.map.size.w - this.widthDifference,
        h: this.map.size.h - this.heightDifference
    };
    var currentSizeName = this.getMatchingSizeName(currentSize);
    if (currentSizeName !== null) {
      if (currentSizeName != this.selectElement.value) {
        this.selectElement.value = currentSizeName;
      }
    }
    var selectedMapSize = this.mapSizes[this.selectElement.value];
    this.widthDifference =  currentSize.w - selectedMapSize.w;
    this.heightDifference = currentSize.h - selectedMapSize.h;
  },
  onChange : function() {
    var mapSizeName = this.selectElement.value;
    if (Legato.Lang.ObjectUtils.exists(mapSizeName)) {
      var mapSize = this.mapSizes[mapSizeName];
      if (Legato.Lang.ObjectUtils.exists(mapSize)) {
        var extent = this.maintainExtent ? this.map.getExtent() : null;
        this.map.div.style.width = (mapSize.w + this.widthDifference) + 'px';
        this.map.div.style.height = (mapSize.h + this.heightDifference) + 'px';
        if (Legato.Lang.ObjectUtils.exists(extent)) {
          this.map.zoomToExtent(extent, this.zoomToClosest);
        }
        this.map.updateSize();
      }
    }
  },
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);
    this.map.events.on({
      'moveend' : this.updateSize,
      scope : this
    });
  },
  destroy : function() {
    if (this.selectElement !== null) {
      this.selectElement.onchange = null;
    }
    this.map.events.un({
      'moveend' : this.updateSize,
      scope : this
    });
    this.selectElement = null;
    this.mapSizes = null;
    this.mapSizeOptionElements = null;
    this.otherMapSizeName = null;
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },
  CLASS_NAME : "Legato.Control.SetMapSize"
});

/**
 * Component: lc:SetMapSize
 *
 * Inherits from:
 * - {<olc:Control>}
 *
 * See also:
 * - <lc> namespace
 * - {<Legato.Control.SetMapSize>}
 */
Legato.Control.SetMapSize.Bean = OpenLayers.Control.Bean.Extend(

'Legato.Control.SetMapSize',

Legato.Control.QName('SetMapSize'), {
  _constructor : Legato.Control.SetMapSize,
  options : {
    /**
     * Element: mapSizes
     * {<ol:Size> {}} Map (title/size) of map sizes.
     */
    mapSizes : OpenLayers.Size.Bean.Map(),
    /**
     * Element: maintainExtent
     * {Boolean}
     */
    maintainExtent : Legato.Lang.Boolean,
    /**
     * Element: customMapSizeName
     * {String}
     */
    customMapSizeName : Legato.Lang.String,
    /**
     * Element: zoomToClosest
     * {Boolean}
     */
    zoomToClosest : Legato.Lang.Boolean
  }
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.StyleProperties = {
  STYLE_PROPERTIES : {
    TEXT : [ 'fontFamily', 'fontColor', 'fontSize', 'fontStyle',
        'fontWeight' ],
    POINT : [ 'pointRadius', 'fillColor', 'strokeWidth', 'strokeColor' ],
    LINE : [ 'strokeWidth', 'strokeColor', 'strokeDashstyle' ],
    POLYGON : [ 'fillColor', 'strokeWidth', 'strokeColor',
        'strokeDashstyle' ]
  }
};

/**
 * Space: lsp
 * Namespace for Legato Style Properties.
 */
/**
 * URI: Namespace URI
 * {http://www.disy.net/legato/styleproperties}
 */
Legato.StyleProperties.NAMESPACE_URI = 'http://www.disy.net/legato/styleproperties';
/**
 * Prefix: Default prefix
 * {lsp}
 */
Legato.StyleProperties.PREFIX = 'lsp';
Legato.StyleProperties.QName = function(localPart) {
  return new Legato.XML.QName(Legato.StyleProperties.NAMESPACE_URI, localPart, Legato.StyleProperties.PREFIX);
};

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.StyleProperties.AbstractInputElement = OpenLayers.Class({
  propertyName : null,
  propertyValue : null,
  style : null,
  layer : null,
  titleClass : 'StylePropertyTitle',
  inputClass : 'StylePropertyInput',
  container : null,
  initialize : function(propertyName, propertyValue, style, layer, options) {
    this.propertyName = propertyName;
    this.propertyValue = propertyValue;
    this.style = style;
    this.layer = layer;
    this.create();
  },

  create : function() {
    this.container = document.createElement('div');
    
    var titleElement = document.createElement('div');
    OpenLayers.Element.addClass(titleElement, this.titleClass);
    titleElement.innerHTML = this.getTitle() + ': ';
    this.container.appendChild(titleElement);

    var inputElement = this.createInput();
    OpenLayers.Element.addClass(inputElement, this.inputClass);
    this.container.appendChild(inputElement);
    return this.container;
  },

  appendTo : function(elementsContainer){
    elementsContainer.appendChild(this.container);
  },

  createInput : function() {
    throw new Legato.Lang.Exception(this.CLASS_NAME +
        ' must implement the createInput function from from abstract class ' +
        Legato.StyleProperties.AbstractInputElement.CLASS_NAME); 
  },
  
  getTitle : function(){
    return Legato.I18n.getMessage('Legato.StyleProperties.AbstractInputElement.' + this.propertyName);
  },
  
  onInputValueChanged : function(propertyValue){
    this.style[this.propertyName] = propertyValue;
    this.layer.redraw();
  },

  CLASS_NAME : 'Legato.StyleProperties.AbstractInputElement'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.StyleProperties.InputElement = OpenLayers.Class(Legato.StyleProperties.AbstractInputElement, {
  
  createInput : function() {
    var input = document.createElement('input');
    OpenLayers.Element.addClass(input, this.inputClass);
    input.value = this.propertyValue;
    input.onchange = OpenLayers.Function.bindAsEventListener(
        this.onInputValueChanged, this);
    return input;
  },
  
  CLASS_NAME : 'Legato.StyleProperties.InputElement'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.StyleProperties.SelectElement = OpenLayers.Class(Legato.StyleProperties.AbstractInputElement, {
  
  selectOptions : [],
  
  initialize : function(propertyName, propertyValue, style, layer, options) {
    if(Legato.Lang.ObjectUtils.exists(options.selectOptions)){
      this.selectOptions = options.selectOptions;
    }
    Legato.StyleProperties.AbstractInputElement.prototype.initialize.apply(this, arguments);
  },
  
  createInput : function() {
    var selectElement = document.createElement('select');
    for ( var i = 0; i < this.selectOptions.length; i++) {
      var optionElement = document.createElement('option');
      var selectOption = this.selectOptions[i];
      if(Legato.Lang.ObjectUtils.exists(selectOption.label)){
        optionElement.value = selectOption.value;
        if(Legato.Lang.ObjectUtils.isFunction(selectOption.label)){
          optionElement.innerHTML = selectOption.label();
        }else{
          optionElement.innerHTML = selectOption.label;
        }
      }else{
        optionElement.value = selectOption;
        optionElement.innerHTML = selectOption;
      }
      selectElement.appendChild(optionElement);
    }
    selectElement.value = this.propertyValue;
    selectElement.onchange = OpenLayers.Function.bindAsEventListener(
        this.onInputValueChanged, this);
    return selectElement;
  },
  
  CLASS_NAME : 'Legato.StyleProperties.SelectElement'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.StyleProperties.Factory = OpenLayers
    .Class({
      SELECT_OPTIONS : {
        fontFamily : [ 'Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Georgia', 'Impact', 'Lucida Console', 'Lucida Sans Unicode', 'Tahoma', 'Times New Roman', 'Verdana'],
        fontStyle : [ 
                       {
                         value : 'normal',
                         label : function(){
                           return Legato.I18n.getMessage('Legato.StyleProperties.Factory.fontStyle.normal');
                         }
                       }, 
                       {
                         value : 'italic',
                         label : function(){
                           return Legato.I18n.getMessage('Legato.StyleProperties.Factory.fontStyle.italic');
                         }
                       } 
                    ],
        fontWeight : [ 
                      {
                        value : 'normal',
                        label : function(){
                          return Legato.I18n.getMessage('Legato.StyleProperties.Factory.fontWeight.normal');
                        }
                      }, 
                      {
                        value : 'bold',
                        label : function(){
                          return Legato.I18n.getMessage('Legato.StyleProperties.Factory.fontWeight.bold');
                        }
                      } 
                     ],
        fontSize : [ '9', '10', '11', '12', '14', '16', '18', '20', '22', '24', '26', '28'],
        pointRadius : [ '2','3','4','5', '6', '7', '8', '9', '10', '12', '14', '16', '18', '20', '22' ],
        strokeWidth : [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10' , '12', '14'],
        strokeDashstyle : [
            {
              value : 'solid',
              label : "&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;&mdash;"
            },
            {
              value : 'dot',
              label : '&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;&nbsp;&middot;'
            },
            {
              value : 'dash',
              label : '&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;&nbsp;&mdash;'
            }, {
              value : 'dashdot',
              label : '&mdash;&nbsp;&middot;&nbsp;&mdash;&nbsp;&middot;&nbsp;&mdash;&nbsp;&middot;&nbsp;&mdash;&nbsp;&nbsp;&middot;&nbsp;&mdash;&nbsp;&nbsp;&middot;&nbsp;'
            } ]
      },

      SPINNER_OPTIONS : {},

      initialize : function(options) {
      },

      createElement : function(stylePropertyName, stylePropertyValue, style,
          layer) {
        if (this.isSelectProperty(stylePropertyName)) {
          return this.createSelectElement(stylePropertyName,
              stylePropertyValue, style, layer,
              this.SELECT_OPTIONS[stylePropertyName]);
        } else if (this.isColorProperty(stylePropertyName)) {
          return this.createColorElement(stylePropertyName, stylePropertyValue.replace('#',''),
              style, layer);
        } else if (this.isSpinnerProperty(stylePropertyName)) {
          return this.createSpinnerElement(stylePropertyName,
              stylePropertyValue, style, layer,
              this.SPINNER_OPTIONS[stylePropertyName]);
        } else {
          return this.createInputElement(stylePropertyName, stylePropertyValue,
              style, layer);
        }
      },

      createInputElement : function(stylePropertyName, stylePropertyValue,
          style, layer) {
        return new Legato.StyleProperties.InputElement(stylePropertyName,
            stylePropertyValue, style, layer);
      },

      createSelectElement : function(stylePropertyName, stylePropertyValue,
          style, layer, selectOptions) {
        return new Legato.StyleProperties.SelectElement(stylePropertyName,
            stylePropertyValue, style, layer, {
              selectOptions : selectOptions
            });
      },

      createSpinnerElement : function(stylePropertyName, stylePropertyValue,
          style, layer, spinnerOptions) {
        return new Legato.StyleProperties.SelectElement(stylePropertyName,
            stylePropertyValue, style, layer, {
              spinnerOptions : spinnerOptions
            });
      },

      createColorElement : function(stylePropertyName, stylePropertyValue,
          style, layer) {
        return new Legato.StyleProperties.InputElement(stylePropertyName,
            stylePropertyValue, style, layer);
      },

      isSelectProperty : function(stylePropertyName) {
        return this.SELECT_OPTIONS.hasOwnProperty(stylePropertyName);
      },

      isSpinnerProperty : function(stylePropertyName) {
        return this.SPINNER_OPTIONS.hasOwnProperty(stylePropertyName);
      },

      isColorProperty : function(stylePropertyName) {
        var colorSuffix = 'Color';
        return stylePropertyName.indexOf(colorSuffix, stylePropertyName.length
            - colorSuffix.length) !== -1;
      },

      CLASS_NAME : 'Legato.StyleProperties.Factory'
    });
Legato.StyleProperties.Factory.Bean = Legato.Beans.Object.Extend(
    'Legato.StyleProperties.Factory', Legato.StyleProperties.QName('Factory'),
    //
    {
      _constructor : Legato.StyleProperties.Factory,
      options : {}
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.StylePropertiesEditor = OpenLayers.Class(Legato.Control, {

  style : null,

  factory : null,
  
  layer : null,

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
    this.createDiv();
  },

  setStyle : function(style) {
    this.style = style;
    this.refresh();
  },
  
  setLayer : function(layer){
    this.layer = layer;
  },

  refresh : function() {
    this.div.innerHTML = '';
    var styleType = this.style['x-type'];
    var styleProperties = Legato.StyleProperties.STYLE_PROPERTIES[styleType];
    for ( var i = 0; i < styleProperties.length; i++) {
      var stylePropertyName = styleProperties[i];
      var stylePropertyValue = this.style[stylePropertyName];
      var stylePropertyElement = this.factory.createElement(stylePropertyName,
          stylePropertyValue, this.style, this.layer);
      stylePropertyElement.appendTo(this.div);
    }
  },

  createDiv : function() {
    this.div = OpenLayers.Util.createDiv(this.id);
    this.div.className = this.displayClass;
    this.div.style.position = 'relative';
  },

  deactivate : function() {
    Legato.Control.prototype.deactivate.apply(this, [ arguments ]);
    this.div.style.display = 'none';
  },

  activate : function() {
    Legato.Control.prototype.activate.apply(this, [ arguments ]);
    this.div.style.display = '';
  },

  draw : function(px) {
    if (this.div === null) {
      this.createDiv();
    }
    if (Legato.Lang.ObjectUtils.exists(px)) {
      this.position = px.clone();
    }
    this.moveTo(this.position);
    return this.div;
  },

  CLASS_NAME : 'Legato.Control.StylePropertiesEditor'
});
Legato.Control.StylePropertiesEditor.Bean = Legato.Control.Bean.Extend(
//
'Legato.Control.StylePropertiesEditor',
//
Legato.Control.QName('StylePropertiesEditor'),
//
{
  _constructor : Legato.Control.StylePropertiesEditor,
  options : {
    factory : Legato.StyleProperties.Factory
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
* A control that keeps the height of its div synchronized with the height
* of the map div
*/
Legato.Control.SyncMapDivSize = OpenLayers.Class(OpenLayers.Control, {

  /**
   * Property: syncHeight
   * {Boolean} Sets whether the height should be synced
   */
  syncHeight: false,

  /**
   * Property: syncWidth
   * {Boolean} Sets whether the width should be synced
   */
  syncWidth: false,

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
  },

  updateSize : function() {
    if (this.syncHeight) {
      var mapDivHeight = this.map.div.style.height;
      if (Legato.Lang.ObjectUtils.exists(mapDivHeight)) {
        this.div.style.height = mapDivHeight;
      }
    }
    if (this.syncWidth) {
      var mapDivWidth = this.map.div.style.width;
      if (Legato.Lang.ObjectUtils.exists(mapDivWidth)) {
        this.div.style.width = mapDivWidth;
      }
    }
  },

  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);
    this.map.events.on( {
      'moveend' :this.updateSize,
      scope :this
    });
  },

  destroy : function() {
    this.map.events.un( {
      'moveend' :this.updateSize,
      scope :this
    });
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  CLASS_NAME :"Legato.Control.SyncMapDivSize"

});

Legato.Control.SyncMapDivSize.Bean = OpenLayers.Control.Bean.Extend(

'Legato.Control.SyncMapDivSize',

Legato.Control.QName('SyncMapDivSize'), {
  _constructor :Legato.Control.SyncMapDivSize,

  options : {
    syncWidth :Legato.Lang.Boolean,
    syncHeight :Legato.Lang.Boolean
  }
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.ToggleDisplay
 *
 * This simple control switches the visibility of its given control
 *
 * Inherits from:
 * - <Legato.Control>
 *
 */
Legato.Control.ToggleDisplay = OpenLayers
		.Class(Legato.Control,
				{
					control : null,
					type : OpenLayers.Control.TYPE_TOGGLE,
					initialize : function(options) {
						OpenLayers.Control.prototype.initialize.apply(this,
								arguments);
						if (!Legato.Lang.ObjectUtils
								.exists(options.displayClass)
								&& Legato.Lang.ObjectUtils
										.exists(options.control.displayClass)) {
							this.displayClass = options.control.displayClass
									+ 'Toggle';
						}
					},

					/**
					 * Function: activate
					 * Invoked when the control is activated in toggle mode
					 */
					activate : function() {
						if (Legato.Lang.ObjectUtils.exists(this.control.div)) {
						  Legato.XML.ElementUtils.show(this.control.div);
						}
						this.active = true;
						Legato.Control.prototype.activate
								.apply(this, arguments);
					},

					/**
					 * Function: trigger
					 * Invoked when the control is deactivated in toggle mode
					 */
					deactivate : function() {
						if (Legato.Lang.ObjectUtils.exists(this.control.div)) {
						  Legato.XML.ElementUtils.hide(this.control.div);
						}
						this.active = false;
						Legato.Control.prototype.deactivate.apply(this,
								arguments);
					},

					CLASS_NAME : "Legato.Control.ToggleDisplay"
				});

/**
 * Component: lc:ToggleDisplay
 * 
 * Inherits from:
 * - <olc:Control>
 * 
 * See also:
 * - <lc> namsepace
 * - {<Legato.Control.ToggleDisplay>}
 */
Legato.Control.ToggleDisplay.Bean = OpenLayers.Control.Bean.Extend(
		'Legato.Control.ToggleDisplay', Legato.Control.QName('ToggleDisplay'),
		{
			_constructor : Legato.Control.ToggleDisplay,
			options : {
				/**
				 * Element: control
				 * {<olc:Control>} Control to be toggled.
				 */
				control : OpenLayers.Control.Bean
			}
		});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.ToggleDiv
 *
 * This simple control switches the visibility of an arbitrary div which is given in its "div" property.
 *
 * Inherits from:
 * - <Legato.Control>
 *
 */
Legato.Control.ToggleDiv = OpenLayers.Class(Legato.Control, {

  control :null,

  type :OpenLayers.Control.TYPE_TOGGLE,

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
  },

  /** Function: activate
   * Invoked when the control is activated in toggle mode
   */
  activate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.div)) {
      Legato.XML.ElementUtils.show(this.div);
    }
    this.active = true;
    Legato.Control.prototype.activate.apply(this, arguments);
  },

  /** Function: trigger
   * Invoked when the control is deactivated in toggle mode
   */
  deactivate: function() {
    if (Legato.Lang.ObjectUtils.exists(this.div)) {
      Legato.XML.ElementUtils.hide(this.div);
    }
    this.active = false;
    Legato.Control.prototype.deactivate.apply(this, arguments);
  },

  CLASS_NAME :"Legato.Control.ToggleDiv"
});

/**
 * Structure: lc:ToggleDiv
 * XML based config for a <Legato.Control.ToggleDiv>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ToggleDiv would be:
 * (start code)
 * <lc:ToggleDiv div="overviewMap" displayClass="LegatoControlToggleOverviewMap"/>
 * (end)
 */
Legato.Control.ToggleDiv.Bean = OpenLayers.Control.Bean.Extend(
    'Legato.Control.ToggleDiv', Legato.Control.QName('ToggleDiv'), {
      _constructor :Legato.Control.ToggleDiv
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.ToggleLayer
 *
 * This control switches the visibility of a layer referenced by a 
 * Legato layerId.
 *
 * Inherits from:
 * - <Legato.Control>
 * 
 *
 */
Legato.Control.ToggleLayer = OpenLayers.Class(Legato.Control, {

  layerId :null,
  
  type :OpenLayers.Control.TYPE_TOGGLE,

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
    if (Legato.Lang.ObjectUtils.exists(options.layerId)) {
      this.layerId = options.layerId;
    }
  },

  /** Function: activate
   * Invoked when the control is activated in toggle mode
   */
  activate: function() {
    this.toggleVisibility();
    this.active = true;
    Legato.Control.prototype.activate.apply(this, arguments);
  },

  /** Function: deactivate
   * Invoked when the layer is deactivated in toggle mode
   */
  deactivate : function() {
    this.toggleVisibility();
    this.active = false;
    Legato.Control.prototype.deactivate.apply(this, arguments);
  },
  
  toggleVisibility : function() {
    var layer = Legato.OpenLayers.Map.Util.getLayerById(this.map.layers, this.layerId);
    if (Legato.Lang.ObjectUtils.isObject(layer)) {
      layer.setVisibility(!layer.visibility);
    }
  },

  CLASS_NAME :"Legato.Control.ToggleLayer"
});

/**
 * Structure: lc:ToggleLayer
 * XML based config for a <Legato.Control.ToggleLayer>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ToggleLayer would be:
 * (start code)
 * <lc:ToggleLayer displayClass="ToggleScaleBarLayer">
 *   <layerId>InternalLayer.ScaleBar</layerId>
 * </lc:ToggleLayer>
 * (end)
 */
Legato.Control.ToggleLayer.Bean = OpenLayers.Control.Bean.Extend(
    'Legato.Control.ToggleLayer', Legato.Control.QName('ToggleLayer'), {
      _constructor : Legato.Control.ToggleLayer,
      options : {
        /**
         * Element: layerId Legato layerId of the layer that will be
         * shown/hidden. Note: The Legato layerId is different to the native
         * OpenLayers layer id.
         */
        layerId : Legato.Lang.String
      }
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: Legato.Control.WMSGetFeatureInfo
 *
 * This class represents a compositum of the
 * OpenLayers.Control.WMSGetFeatureInfo class and the
 * OpenLayers.Popup.FramedCloud. If the GetFeatureInfo reuest is made the
 * response will been rendered as a popup.
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.WMSGetFeatureInfo = OpenLayers.Class(Legato.Control, {

  /**
   * Property: reverseSelectedLayers {<boolean>} the information
   * if the selected layer list should be reversed by sending
   */
  reverseSelectedLayers : true,
  /**
   * Property: wmsGetFeatureInfo {<OpenLayers.Control.WMSGetFeatureInfo>} the
   * WMSGetFeatureInfo instance which will been used for requesting
   */
  wmsGetFeatureInfo :null,

  /**
   * Property: wmsGetFeatureInfoGml {<OpenLayers.Control.WMSGetFeatureInfo>} the
   * WMSGetFeatureInfo instance which will been used for requesting using the GML Info Format
   */
  wmsGetFeatureInfoGml :null,

  /**
   * Property: popup {<OpenLayers.Popup>} The popup which will render the
   * reponse
   */
  openLayersPopup :null,

  /**
   * Property: popup {<Legato.Popup>} The popup which will render the
   * reponse
   */
  popup :null,

  initialPopupPosition: null,

  /**
   * Property: popupType {<String>} The popuptype which will been used to
   * render the response. Possible values are Anchored, AnchroedBubble and
   * FramedCloud
   */
  popupType :'',

  /**
   * Property: autoActive {<Boolean>} If set to true the control will allways
   * be enabled and active, meaning that if the user hovers over the map the
   * control will always perform a WMSGetFeatureInfo request.
   */
  autoActive :false,

  /**
   * Property: popupBackgroundColor {<String>} Defines the backgroundColor of the
   * popup. Not used if popuptype is set to AnchroedBubble, cause you can not
   * set the backgroundColor for this type.
   */
  popupBackgroundColor :'',

  /*
   * Property: popupMinSize
   *
   * See Also: <OpenLayers.Popup.minSize>
   */
  popupMinSize : null,

  /*
   * Property: popupMaxSize
   *
   * See Also: <OpenLayers.Popup.maxSize>
   */
  popupMaxSize : null,

  /*
   * Property: popupAutoSize
   *
   * See Also: <OpenLayers.Popup.maxSize>
   */
  popupAutoSize: true,

  /*
   * Property: popupPanMapIfOutOfView
   *
   * See Also: <OpenLayers.Popup.panMapIfOutOfView>
   */
  popupPanMapIfOutOfView: true,

  /*
   * Property: popupKeepInMap
   *
   * See Also: <OpenLayers.Popup.keepInMap>
   */
  popupKeepInMap:  true,

  /*
   * Property: popupCloseOnMove
   *
   * See Also: <OpenLayers.Popup.closeOnMove>
   */
  popupCloseOnMove: false,

  /*
   * Property: popupOpacity
   *
   * See Also: <OpenLayers.Popup.opacity>
   */
  popupOpacity :null,


  /*
   * Property: renderIfNoPopupExists
   *
   * Only render if no other popup exists
   */
  renderIfNoPopupExists: false,


  /*
   * Property: filter
   *
   * A predicate definition which is used to filter the layers for the WMSGetFeatureInfoRequest
   *
   * See also: <Legato.Predicate>
   */
  layerFilter: null,

  /*
   * A LayerTransformer which might be configured for filtering the built WMS GetFeatureInfo request
   *
   * See also: <Legato.Layer.Transformer>
   */
  layerTransformer: null,

  /*
   * Property: highlightGeometry
   *
   * If true the geometry will be hightlightes using GML and SVG, false otherwise.
   */
  highlightGeometry: false,

  highlightGeometryLayerName: 'legato.internal.highlightedFeatures',
  
  scriptedLayerIdTagName: 'map:scriptedLayerId',


  /**
   * Constructor: Legato.Control.WMSGetFeatureInfo Create a WMSGetFeatureInfo.
   *
   * Parameters:
   */
  initialize : function(options) {
    if (!options.delay) {
      options.delay = 500;
    }

    if (!options.popupBackgroundColor) {
      options.popupBackgroundColor = '#fafad2';
    }

    options.handlerOptions = {
      click :options.delay,
      hover :options.delay
    };

    Legato.Control.prototype.initialize.apply(this, [ options ]);

    this.wmsGetFeatureInfo = new OpenLayers.Control.WMSGetFeatureInfo(options);

    /*
     * If highlighting is set to true create a second WMS GetFeatureInfo Control
     * which will fire the same request as our first GetFeatureIInfo Control but
     * this time allways exspect that the answer is GML. This returned GML Feature
     * will then been displayed as a normal vector in this current map.
     */
    if(this.highlightGeometry === true){
      options.infoFormat = 'application/vnd.ogc.gml';
      options.legatoIgnore = true;
      this.wmsGetFeatureInfoGml = new OpenLayers.Control.WMSGetFeatureInfo(options);
    }

    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.layerFilter)){
      this.layerTransformer = new Legato.Layer.Transformer.SublayerFilteringTransformer(this.layerFilter);
    }
    /*
     * Remember initial position. If set then keep this positon. If null then automatically
     * update the position
     */
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup)){
      this.initialPopupPosition = this.popup.getPosition();
    }
  },

  /**
   * Function: draw
   *Legato.LayerTransformer
   * See Also: <OpenLayer.Control>
   */
  draw : function() {
    OpenLayers.Control.prototype.draw.apply(this);
  },

  enableAutoActive : function() {
    if (!this.wmsGetFeatureInfo.active) {
      this.activate();
    }
  },

  /**
   * APIMethod: destroy
   *
   * See Also: <OpenLayer.Control>
   */
  destroy : function() {
    if (this.autoActive) {
      this.map.events.un( {
        'mouseover' :this.enableAutoActive,
        scope :this
      });
    }

    if (this.hover) {
      this.map.events.un( {
        'mousemove' :this.hidePopup,
        scope :this
      });
    }

    this.map.events.un( {
      'legato.selectlayer'    : this.updateSelectedLayers,
      'legato.deselectlayer'  : this.updateSelectedLayers,
      'addlayer'              : this.updateQueryLayers,
      'removelayer'           : this.updateQueryLayers,
      scope :this
    });

    this.wmsGetFeatureInfo.events.un( {
      'getfeatureinfo' :this.renderGetFeatureInfo,
      scope :this
    });
    this.wmsGetFeatureInfo.destroy();

    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){
      this.wmsGetFeatureInfoGml.events.un( {
        'getfeatureinfo' :this.hightlightFeatureInfoGeometry,
        scope :this
      });
      this.wmsGetFeatureInfoGml.destroy();
    }

    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.highlightLayer)){
      this.highlightLayer.destroy();
    }

    if (!Legato.Lang.ObjectUtils.isNullOrUndefined(this.openLayersPopup)) {
      this.map.removePopup(this.openLayersPopup);
      this.openLayersPopup.destroy();
    }

    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup)){
      this.popup.close();
    }

    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  /**
   * APIMethod: activate
   *
   * See Also: <OpenLayer.Control>
   */
  activate : function() {
    OpenLayers.Control.prototype.activate.apply(this, arguments);
    this.updateQueryLayers();
    this.updateSelectedLayers();
    this.updateScriptedLayers();
    this.wmsGetFeatureInfo.activate();

    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){
      this.wmsGetFeatureInfoGml.activate();
    }
  },

  /**
   * APIMethod: deactivate
   *
   * See Also: <OpenLayer.Control>
   */
  deactivate : function() {
    this.wmsGetFeatureInfo.deactivate();
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){
      this.wmsGetFeatureInfoGml.deactivate();
    }
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.highlightLayer)){
      this.highlightLayer.destroyFeatures();
    }
    this.hidePopup();
    OpenLayers.Control.prototype.deactivate.apply(this, arguments);
  },

  /**
   * Hides the current popup if exists
   */
  hidePopup : function() {
    if (!Legato.Lang.ObjectUtils.isNullOrUndefined(this.openLayersPopup)) {
      this.openLayersPopup.hide();
    }
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup)){
      this.popup.close();
    }
  },

  /**
   * Returns all current selectedlayers
   */
  getSelectedLayers: function() {
    return Legato.Lang.CollectionUtils.filter(this.map.layers,
        function(layer) {
          return Legato.OpenLayers.Map.Util.isListedLayer(layer)
              && Legato.Lang.ObjectUtils.isTrue(layer.selected)
              && Legato.Lang.ObjectUtils.isTrue(layer.queryable);
    });
  },

  /**
   * Returns all queryable layers
   */
  getQueryAbleLayers: function(){
    return Legato.Lang.CollectionUtils.filter(this.map.layers,
        function(layer) {
          return Legato.OpenLayers.Map.Util.isListedLayer(layer)
              && Legato.Lang.ObjectUtils.isTrue(layer.queryable);
    });
  },

  /**
   * Returns all layers
   */
  getListedLayers: function(){
    return Legato.Lang.CollectionUtils.filter(this.map.layers,
        function(layer) {
          return Legato.OpenLayers.Map.Util.isListedLayer(layer);
    });
  },

  /**
   * Returns scripted layers
   */
  getScriptedLayerIds: function(){
    var scriptedLayerIds = [];
    var tags = this.map.tags;
    if (Legato.Lang.ObjectUtils.isArray(tags)) {
      for (var index = 0; index < tags.length; index++) {
        var tag = tags[index];
        if (tag.name === this.scriptedLayerIdTagName && Legato.Lang.ObjectUtils.isString(tag.value)) {
          scriptedLayerIds.push(tag.value);
        }
      }
    }
    return scriptedLayerIds;
  },
  
  /**
   * Updates all selected Layers
   */
  updateSelectedLayers: function(){
    if(this.active !== true){
      //No need for updating possible layer. We wait till we're really active
      return;
    }

    var selectedLayers = this.getSelectedLayers();
    if (this.reverseSelectedLayers) {
      selectedLayers.reverse();
    }
    var selectedLayerIds = Legato.OpenLayers.Map.Util.getLayerIds(selectedLayers);
    
    this.wmsGetFeatureInfo.vendorParams.selected_layers = selectedLayerIds;

    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){
      this.wmsGetFeatureInfoGml.vendorParams.selected_layers = selectedLayerIds;
    }
  },
  
  /**
   * Updates all scripted Layers
   */
  updateScriptedLayers: function(){
    if(this.active !== true){
      //No need for updating possible layer. We wait till we're really active
      return;
    }

    var scriptedLayerIds = this.getScriptedLayerIds();
    this.wmsGetFeatureInfo.vendorParams.scripted_layers = scriptedLayerIds;

    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){
      this.wmsGetFeatureInfoGml.vendorParams.scripted_layers = scriptedLayerIds;
    }
  },

  /**
   * Updates all current layers by injecting them into the wrapped
   * WMSGetFeatureInfo control of openlayers.
   */
  updateQueryLayers : function() {

    if(this.active !== true){
      //No need for updating possible layer. We wait till we're really active
      return;
    }

    var queryableLayers = this.getQueryAbleLayers();
    if (this.reverseSelectedLayers) {
      queryableLayers.reverse();
    }
    if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.layerTransformer)){
      this.wmsGetFeatureInfo.layers = queryableLayers;
      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){
        this.wmsGetFeatureInfoGml.layers = this.wmsGetFeatureInfo.layers;
      }
    } else {
      var clonedLayers = [];
      for(var i = 0; i < queryableLayers.length; i++){
        var transformedLayer = this.layerTransformer.transform(queryableLayers[i]);
        if(!Legato.Lang.ObjectUtils.isNullOrUndefined(transformedLayer)){
          clonedLayers.push(transformedLayer);
        }
      }

      this.wmsGetFeatureInfo.layers = clonedLayers;
      if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){
        this.wmsGetFeatureInfoGml.layers = clonedLayers;
      }
    }
  },

  /*
   * APIMethod: setMap
   *
   * See Also: <OpenLayer.Control>
   */
  setMap : function(map) {
    this.wmsGetFeatureInfo.setMap(map);

    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){
      this.wmsGetFeatureInfoGml.setMap(map);
    }

    OpenLayers.Control.prototype.setMap.apply(this, arguments);

    if (this.autoActive) {
      this.map.events.on( {
        'mouseover' :this.enableAutoActive,
        scope :this
      });
    }

    if (this.hover) {
      this.map.events.on( {
        'mousemove' :this.hidePopup,
        scope :this
      });
    }

    this.map.events.on( {
      'legato.selectlayer'    : this.updateSelectedLayers,
      'legato.deselectlayer'  : this.updateSelectedLayers,
      'addlayer'              : this.updateQueryLayers,
      'removelayer'           : this.updateQueryLayers,
      scope :this
    });

    this.wmsGetFeatureInfo.events.on( {
      'getfeatureinfo'       : this.renderGetFeatureInfo,
      'beforegetfeatureinfo' : this.updateScriptedLayers,
      scope :this
    });

    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.wmsGetFeatureInfoGml)){
      this.wmsGetFeatureInfoGml.events.on( {
        'getfeatureinfo'       : this.hightlightFeatureInfoGeometry,
        'beforegetfeatureinfo' : this.updateScriptedLayers,
        scope :this
      });
    }
  },

  /*
   * Hightlights the GML Geomtry by paintinig it into our highlight layer
   */
  hightlightFeatureInfoGeometry: function(featureInfo){
    if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.highlightLayer)){
      var styleMap = this.getStyleMap();
      this.highlightLayer = new OpenLayers.Layer.Vector(this.highlightGeometryLayerName, {
        legatoIgnore: true,
        displayInLayerSwitcher: false,
        isBaseLayer: false,
        styleMap: styleMap
      });

      this.map.addLayer(this.highlightLayer);
    }

    this.highlightLayer.destroyFeatures();
    if (featureInfo.features && featureInfo.features.length) {
      this.highlightLayer.addFeatures(featureInfo.features);
      this.highlightLayer.redraw();
    }
  },

  /*
   * Get the StyleMap for the Highlight Layer
   */
  getStyleMap : function(){
    var highlightStyle = {
      Point: Legato.Feature.Style.HIGHLIGHT_POINT,
      Line: Legato.Feature.Style.HIGHLIGHT_LINE,
      Polygon: Legato.Feature.Style.HIGHLIGHT_POLYGON
    };

    var style = new OpenLayers.Style();
    style.addRules([
        new OpenLayers.Rule({symbolizer: highlightStyle})
    ]);

    return style;
  },

  /*
   * renders the returned response from the GetFeatureInfo request inside a
   * popup.
   */
  renderGetFeatureInfo : function(featureInfo) {
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup)){
      this.popup.close();
    }
    if (!Legato.Lang.ObjectUtils.isNullOrUndefined(this.openLayersPopup)) {
      this.map.removePopup(this.openLayersPopup);
    }

    /*
     * Just render a popup if there is some response
     */
    if (featureInfo.text.length === 0) {
      return;
    }

    /*
     * Abort showing the popup if another popup is allready shown
     * and the config for this control is set to true
     */
    if(this.renderIfNoPopupExists && (this.map.popups.length > 0 || !Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup))){
      return;
    }

    /*
     * Use configured popup control instead of OpenLayers Popup mechnism
     */
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup)){
      if(Legato.Lang.ObjectUtils.isNull(this.initialPopupPosition)){
        this.popup.setPosition(featureInfo.xy);
      }
      this.popup.open(featureInfo.text, 'wmsFeatureInfo', OpenLayers.Function.bind(this.onClosePopup, this));
      return;
    }

    /*
     * OpenLayers Popup mechanism
     */
    switch (this.popupType.toLowerCase()) {
    case 'anchored':
      this.openLayersPopup = new OpenLayers.Popup.Anchored('getFeatureInfo', this.map
          .getLonLatFromPixel(featureInfo.xy), null, featureInfo.text, null,
          !(this.autoActive || this.hover), OpenLayers.Function.bind(this.onClosePopup, this));
      break;
    case 'anchoredbubble':
      this.openLayersPopup = new OpenLayers.Popup.AnchoredBubble('getFeatureInfo',
          this.map.getLonLatFromPixel(featureInfo.xy), null, featureInfo.text,
          null, !(this.autoActive || this.hover), OpenLayers.Function.bind(this.onClosePopup, this));
      break;
    //case 'framedcloud':
    default:
      this.openLayersPopup = new OpenLayers.Popup.MarginAwareFramedCloud('getFeatureInfo', this.map
          .getLonLatFromPixel(featureInfo.xy), null, featureInfo.text, null,
          !(this.autoActive || this.hover), OpenLayers.Function.bind(this.onClosePopup, this));
      break;
    }

    //apply popup options
    this.openLayersPopup.autoSize = this.popupAutoSize;
    this.openLayersPopup.setBackgroundColor(this.popupBackgroundColor);
    if (this.popupMinSize) {
      this.openLayersPopup.minSize = this.popupMinSize;
    }
    if (this.popupMaxSize) {
      this.openLayersPopup.maxSize = this.popupMaxSize;
    }
    if (this.popupOpacity) {
      this.openLayersPopup.setOpacity(this.popupOpacity);
    }
    this.openLayersPopup.panMapIfOutOfView = this.popupPanMapIfOutOfView;
    this.openLayersPopup.keepInMap = this.popupKeepInMap;
    this.openLayersPopup.closeOnMove = this.popupCloseOnMove;

    this.map.addPopup(this.openLayersPopup);
  },

  /*
   * Callback function. Triggered whenever the user clicks its close button
   */
  onClosePopup: function(event){
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.popup)){
      this.popup.close();
    }
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.highlightLayer)){
      this.highlightLayer.destroyFeatures();
    }
    if(!Legato.Lang.ObjectUtils.isNullOrUndefined(this.map) && !Legato.Lang.ObjectUtils.isNullOrUndefined(this.openLayersPopup)){
      this.map.removePopup(this.openLayersPopup);
    }
  },

  CLASS_NAME :'Legato.Control.WMSGetFeatureInfo'
});

/**
 * Component: lc:WMSGetFeatureInfo XML based config for a <Legato.Control.WMSGetFeatureInfo>.
 *
 * A valid config example for a WMSGetFeatureInfo would be:
 * (start code)
 * <lc:WMSGetFeatureInfo>
 *   <infoFormat>text/xml</infoFormat>
 *   <hover>true</hover>
 *   <maxFeatures>1</maxFeatures>
 *   <queryVisible>true</queryVisible>
 *   <handlerOptions>
 *   <hover>
 *    <delay>200</delay>
 *  </hover>
 *  </handlerOptions>
 * </lc:WMSGetFeatureInfo>
 * (end)
 *
 * See Also:
 * - <lc> namespace
 */
Legato.Control.WMSGetFeatureInfo.Bean = Legato.Control.Bean.Extend(

'Legato.Control.WMSGetFeatureInfo',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Control.QName('WMSGetFeatureInfo'), {
  _constructor :Legato.Control.WMSGetFeatureInfo,
  options : {
    /*
     * Property: hover
     *
     * See Also: <OpenLayers.Control.WMSGetFeatureInfo.hover>
     */
    hover :Legato.Lang.Boolean,

    /*
     * Property: maxFeatures
     *
     * See Also: <OpenLayers.Control.WMSGetFeatureInfo.maxFeatures>
     */
    maxFeatures :Legato.Lang.Integer,

    /*
     * Property: queryVisible
     *
     * See Also: <OpenLayers.Control.WMSGetFeatureInfo.queryVisible>
     */
    queryVisible :Legato.Lang.Boolean,

    /*
     * Property: url
     *
     * See Also: <OpenLayers.Control.WMSGetFeatureInfo.url>
     */
    url :Legato.Lang.String,

    /*
     * Property: infoFormat
     *
     * See Also: <OpenLayers.Control.WMSGetFeatureInfo.infoFormat>
     */
    infoFormat :Legato.Lang.String,

    /*
     * Property: autoActive If set to true the control will allways be enabled
     * and active, meaning that if the user hovers over the map the control will
     * always perform a WMSGetFeatureInfo request.
     */
    autoActive :Legato.Lang.Boolean,

    /*
     * Property: renderIfNoPopupExists If set to true the control will just render itself
     * when there is currently no other popup shown.
     */
    renderIfNoPopupExists :Legato.Lang.Boolean,

    /*
     * Property: delay Defines the delay in ms where a GetFeatureInfoRequest is
     * made. Default is 500 ms.
     */
    delay :Legato.Lang.Integer,

    /*
     * Property: popupType Defines the popuptype which will been used to render
     * the response. Possible values are Anchored, AnchroedBubble and
     * FramedCloud
     */
    popupType :Legato.Lang.String,

    /*
     * Property: popupBackgroundColor Defines the backgroundColor of the popup. Not
     * used if popuptype is set to AnchroedBubble, cause you can not set the
     * backgroundColor for this type.
     */
    popupBackgroundColor :Legato.Lang.String,

    /*
     * Property: popupMinSize
     *
     * See Also: <OpenLayers.Popup.minSize>
     */
    popupMinSize :OpenLayers.Size.Bean,

    /*
     * Property: popupMaxSize
     *
     * See Also: <OpenLayers.Popup.maxSize>
     */
    popupMaxSize :OpenLayers.Size.Bean,

    /*
     * Property: popupAutoSize
     *
     * See Also: <OpenLayers.Popup.maxSize>
     */
    popupAutoSize: Legato.Lang.Boolean,

    /*
     * Property: popupPanMapIfOutOfView
     *
     * See Also: <OpenLayers.Popup.panMapIfOutOfView>
     */
    popupPanMapIfOutOfView: Legato.Lang.Boolean,

    /*
     * Property: popupKeepInMap
     *
     * See Also: <OpenLayers.Popup.keepInMap>
     */
    popupKeepInMap:  Legato.Lang.Boolean,

    /*
     * Property: popupCloseOnMove
     *
     * See Also: <OpenLayers.Popup.closeOnMove>
     */
    popupCloseOnMove: Legato.Lang.Boolean,

    /*
     * Property: popupOpacity
     *
     * See Also: <OpenLayers.Popup.opacity>
     */
    popupOpacity :Legato.Lang.Number,

    /*
     * If set the specified custom popup is used instead the OpenLayers popup mechanism
     *
     * See also: <Legato.Popup>
     */
    popup: Legato.Popup,

    /*
     * A predicate definition which is used to filter the layers for the WMSGetFeatureInfoRequest
     *
     * See also: <Legato.Predicate>
     */
    layerFilter: Legato.Predicate,

    /*
     * Property: highlightGeometry
    *
    * If true the geometry will be highlights using GML and SVG, false otherwise.
    */
    highlightGeometry: Legato.Lang.Boolean,

    /*
     * If true, the order of query layers and selected layers will be reversed.
     */
    reverseSelectedLayers: Legato.Lang.Boolean
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: ViewContextValueProvider
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.ViewContextValueProvider = OpenLayers.Class(Legato.Control,
{
  /*
   * {Date} Holds the last timestamp where an viewcontext update has been
   * propagated to the configured url.
   */
  lastUpdate: null,

  /*
   * Property: frequency
   * {Double} This is the minimum interval in ms at which update AJAX requests are made.
   */
  frequency: null,

  /*
   * Property: delayedPropagation
   * {Number} Timeout id of delayed propagateValue.
   */
  delayedPropagation: null,

  /*
   * Property: url
   * {String} The URL which will been used for submitting the viewcontext.
   */
  url: null,

  /*
   * Property: method
   * {String} The HTTP method to use for the request
   */
  method: null,

  /*
   * Function: initialize
   * Basic ctor
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control
   * The following keys are supported
   * - observer {Object} A hashmap containing an observer
   *
   * The following keys are supported for an observer element
   * - url {String} any url which will been used for submitting all viewcontext changes
   * - frequency {Double} This is the minimum interval in ms at which update AJAX requests are made.
   * - method {String} The HTTP method to use for the request.
   */
  initialize : function(options) {
    Legato.Control.prototype.initialize.apply(this, arguments);
    this.lastUpdate = new Date();

    Legato.Util.Ensure.ensureNotEmptyString(this.url, 'To use the ViewContextValueProvider you have to specify at least an url.');

    if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.frequency) ||
        !Legato.Lang.ObjectUtils.isNumber(this.frequency) ||
        this.frequency < 500){
      this.frequency = 2000;
    }
    if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.method) ||
    !Legato.Lang.ObjectUtils.isString(this.method)){
      this.method = 'POST';
    }
  },

  /*
   * Function: destroy
   *
   * See Also:
   * <OpenLayer.Control>
   */
  destroy : function(){
    this.map.events.un({
      'move':                 this.propagateValue,
      'addlayer':             this.propagateValue,
      'removelayer':          this.propagateValue,
      'moveend':              this.propagateValueFreqControl,
      'changebaselayer':      this.propagateValue,
      'legato.selectlayer':   this.propagateValue,
      'legato.deselectlayer':   this.propagateValue,
      'resize':               this.propagateValue,
      scope:                  this
    });

    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  /*
   * Function: setMap
   *
   * See Also:
   * <OpenLayer.Control>
   */
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);

    this.map.events.on({
      'addlayer':             this.propagateValue,
      'removelayer':          this.propagateValue,
      'changelayer':          this.propagateValue,
      'changebaselayer':      this.propagateValue,
      'moveend':              this.propagateValueFreqControl,
      'legato.selectlayer':   this.propagateValue,
      'legato.deselectlayer':   this.propagateValue,
      'resize':               this.propagateValue,
      scope:                  this
    });
   },

  /*
   * Function: draw
   *
   * See Also:
   * <OpenLayer.Control>
   */
  draw : function() {
    return this.div;
  },

  propagateValueFreqControl: function() {
    if(Legato.Lang.ObjectUtils.exists(this.lastUpdate) &&
      (new Date().getTime() - this.lastUpdate.getTime() < this.frequency)) {
      if(Legato.Lang.ObjectUtils.isNullOrUndefined(this.delayedPropagation)) {
        this.delayedPropagation = window.setTimeout(
            OpenLayers.Function.bind(function() {
                this.propagateValue();
            }, this),
            this.frequency
        );
      }
      return;
    }
    this.propagateValue();
  },

  /*
   * Get the current map viewContext and reports it back to the server
   */
  propagateValue: function(){
    //May occur if the map is still constucting itself
    if(this.map.calculateBounds() === null){
      return;
    }

    if(Legato.Lang.ObjectUtils.exists(this.delayedPropagation)) {
      window.clearTimeout(this.delayedPropagation);
      this.delayedPropagation = null;
    }

    this.lastUpdate = new Date();

    var viewContext = {
        boundingbox: this.map.calculateBounds().toBBOX(),
        layers: Legato.OpenLayers.Map.Util.getLayerIds(Legato.OpenLayers.Map.Util.getLayersWithoutLegatoIgnore(this.map.layers)),
        hiddenlayers: Legato.OpenLayers.Map.Util.getLayerIds(Legato.OpenLayers.Map.Util.getLayersWithoutLegatoIgnore(Legato.OpenLayers.Map.Util.getInvisibleLayers(this.map.layers))),
        'mapsize.width': this.map.getSize().w,
        'mapsize.height': this.map.getSize().h,
        selectedlayer: Legato.OpenLayers.Map.Util.getLayerIds(Legato.OpenLayers.Map.Util.getLayersWithoutLegatoIgnore(Legato.OpenLayers.Map.Util.getSelectedLayers(this.map.layers))).toString()
    };

    var req;
    if(this.method == 'GET'){
      req = new OpenLayers.Request.GET({
        url: this.url,
        params: viewContext
      });
    } else {
      req = new OpenLayers.Request.POST({
        url: this.url,
        data: OpenLayers.Util.getParameterString(viewContext),
        headers: {
          "Content-Type": "application/x-www-form-urlencoded"
        }
      });
    }
  },


  CLASS_NAME : 'Legato.Control.ViewContextValueProvider'
});

/**
 * Structure: lc:ViewContextValueProvider
 * XML based config for a <Legato.Control.ViewContextValueProvider>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a ViewContextValueProvider would be:
 * (start code)
 * <lc:ViewContextValueProvider url="http://foo.com/viewContext" method="POST" frequency="2000" />
 * (end)
 */
Legato.Control.ViewContextValueProvider.Bean = Legato.Control.Bean.Extend(

  'Legato.Control.ViewContextValueProvider',

  /*
   * Property: QName
   * The qualified name for this control. Needed by XML config to instantiate it.
   */
  Legato.Control.QName('ViewContextValueProvider'),
  {
    _constructor: Legato.Control.ViewContextValueProvider,
    options:
    {
    /*
     * Property: url
     *
     * The url which will been used for providing the current viewcontext of the client.
     */
      url: Legato.Lang.String,

     /*
      * Property: method
      * The HTTP method to use for the request. Possible values are GET or POST
      */
      method: Legato.Lang.String.Enum('HTTPMETHOD', {
        'POST': 'POST',
        'GET': 'GET'
      }),

      /*
       * Property: frequency
       * This is the minimum interval in ms at which update AJAX requests are made.
       */
      frequency: Legato.Lang.Double
    }
  }
);

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ScaleInput = OpenLayers.Class(OpenLayers.Control, {
      element :null,
      labelElement :null,
      inputElement :null,
      format: null,
      initialize : function(options) {
        OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
        if (!Legato.Lang.ObjectUtils.exists(this.format))
        {
          this.format = new Legato.Text.PrecisionScaleFormat(3,0);
        }
      },
      draw : function() {
        var div = OpenLayers.Control.prototype.draw.apply(this, arguments);
        if (!Legato.Lang.ObjectUtils.exists(this.element)) {
          this.element = document.createElement('div');
          this.element.id = this.id + "_Element";
          this.element.className = this.displayClass + 'Element';
          div.appendChild(this.element);
        }
        if (!Legato.Lang.ObjectUtils.exists(this.labelElement)) {
          this.labelElement = document.createElement('span');
          this.labelElement.id = this.id + "_LabelElement";
          this.labelElement.className = this.displayClass + 'LabelElement';
          this.labelElement.innerHTML = '1:';
          this.element.appendChild(this.labelElement);
        }
        if (!Legato.Lang.ObjectUtils.exists(this.inputElement)) {
          this.inputElement = document.createElement('input');
          this.inputElement.id = this.id + "_InputElement";
          this.inputElement.name = this.id + "_InputElement";
          this.inputElement.className = this.displayClass + 'InputElement';
          this.inputElement.type = 'text';
          this.element.appendChild(this.inputElement);
        }
        this.updateInput();
        this.inputElement.onchange = OpenLayers.Function.bindAsEventListener(this.updateMap,
            this);

        OpenLayers.Event.observe(
            this.inputElement,
            'keypress',
            OpenLayers.Function.bindAsEventListener(function(event){
              if(event.keyCode == OpenLayers.Event.KEY_RETURN) {
                this.updateMap();
              }
            }, this)
        );

        return div;
      },

      updateInput : function() {
        var scale = this.getScale();
        if (Legato.Lang.ObjectUtils.exists(scale)) {
          this.inputElement.value = scale;
        }
      },

      updateMap : function() {
        var value = this.inputElement.value;
        var scale = this.format.parse(value);
        if (isNaN(scale)) {
        } else {
          this.setScale(scale, true);
        }
        this.updateInput();
      },
      getScale : function() {
        var mapScale = this.map.getScale();
        if (Legato.Lang.ObjectUtils.isNumber(mapScale)) {
          return this.format.format(mapScale);
        } else {
          return null;
        }
      },
      setScale : function(scale) {
        this.map.zoomToScale(scale, true);
      },
      setMap : function(map) {
        OpenLayers.Control.prototype.setMap.apply(this, arguments);
        this.map.events.on( {
          'zoomend' :this.updateInput,
          'changebaselayer' :this.updateInput,
          scope :this
        });
      },
      destroy : function() {
        if (this.inputElement !== null) {
          this.inputElement.onchange = null;
        }
        this.map.events.un( {
          'zoomend' :this.updateInput,
          'changebaselayer' :this.updateInput,
          scope :this
        });
        this.inputElement = null;
        this.labelElement = null;
        OpenLayers.Control.prototype.destroy.apply(this, arguments);
      },
      CLASS_NAME :"Legato.Control.ScaleInput"
    });

Legato.Control.ScaleInput.Bean = OpenLayers.Control.Bean.Extend(

'Legato.Control.ScaleInput',

Legato.Control.QName('ScaleInput'), {
  _constructor :Legato.Control.ScaleInput,
  options : {
    labelElement :Legato.Lang.Element,
    inputElement :Legato.Lang.Element,
    scale :Legato.Lang.Integer
  }
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Rev: 72369 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: SelectBounds
 * 
 * Inherits from: - <Legato.Control>
 */
Legato.Control.SelectBounds = OpenLayers.Class(Legato.Control, {
  /**
   * Property: type {OpenLayers.Control.TYPE}
   */
  type :OpenLayers.Control.TYPE_TOOL,

  /**
   * Property: callback {Function} callback function
   */
  callback :null,

  handler :null,

  /**
   * Constructor: Legato.Control.SelectBounds
   * 
   * Parameters: options - {Object} An optional object whose properties will be
   * set on this instance. currently no options are supported yet.
   */
  initialize : function(options) {
    Legato.Control.prototype.initialize.apply(this, arguments);
    // Legato.Util.Ensure.ensureFunction(this.callback,
  // 'To use ' + this.CLASS_NAME + ' you must specify a callback function.');
},

  /**
   * Method: draw
   */
  draw : function() {

    // Initializes the handler and callback methods
    this.handler = new OpenLayers.Handler.Box(this, {
      done :this.select
    });
  },

  select : function(draftBounds) {
    
    if (draftBounds instanceof OpenLayers.Bounds)
    {
      var lowerLeftLonLat = this.map.getLonLatFromPixel(new OpenLayers.Pixel(
        draftBounds.left, draftBounds.bottom));
      var upperRightLonLat = this.map.getLonLatFromPixel(new OpenLayers.Pixel(
        draftBounds.right, draftBounds.top));
      var bounds = new OpenLayers.Bounds(lowerLeftLonLat.lon,
        lowerLeftLonLat.lat, upperRightLonLat.lon, upperRightLonLat.lat);

      if (Legato.Lang.ObjectUtils.isFunction(this.callback)) {
        this.callback(bounds);
      }
    }
  },

  /**
   * APIMethod: destroy Deconstruct the control
   */
  destroy : function() {
    if (Legato.Lang.ObjectUtils.exists(this.handler)) {
      this.handler.destroy();
    }
  },

  CLASS_NAME :'Legato.Control.SelectBounds'
});

/**
 * Structure: lc:SelectBounds XML based config for a
 * <Legato.Control.SelectBounds>.
 * 
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory>
 * 
 * A valid config example for a SelectBounds would be: (start code)
 * <lc:SelectBounds/> (end)
 */
Legato.Control.SelectBounds.Bean = Legato.Control.Bean.Extend(

'Legato.Control.SelectBounds',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Control.QName('SelectBounds'), {
  _constructor :Legato.Control.SelectBounds,
  options : {
    callback :Legato.Lang.Function,
    displayClass :Legato.Lang.String
  }
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Rev: 72369 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: SelectLonLat
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.SelectLonLat = OpenLayers.Class(Legato.Control,
{
  /**
   * Property: type
   * {OpenLayers.Control.TYPE}
   */
  type: OpenLayers.Control.TYPE_TOOL,

  /**
   * Property: callback
   * {Function} callback function
   */
  callback: null,

  handler: null,

  /**
   * Constructor: Legato.Control.SelectLonLat
   *
   * Parameters:
   * options - {Object} An optional object whose properties will be set on this instance.
   *           currently no options are supported yet.
   */
  initialize : function(options) {
    Legato.Control.prototype.initialize.apply(this, arguments);
//    Legato.Util.Ensure.ensureFunction(this.callback,
//        'To use ' + this.CLASS_NAME + ' you must specify a callback function.');
  },

  /**
   * Method: draw
   */
  draw: function() {
    
    //Initializes the handler and callback methods
    this.handler = new OpenLayers.Handler.Point( this, {
      done: this.select
    },
    {
      persist: true
    });
  },
  
  select: function(draftPoint)
  {
    if (draftPoint instanceof OpenLayers.Geometry.Point)
    {
      var point = new OpenLayers.LonLat(draftPoint.x, draftPoint.y);
    
      if (Legato.Lang.ObjectUtils.isFunction(this.callback))
      {
        this.callback(point);
      }
    }
  },

  /**
   * APIMethod: destroy
   * Deconstruct the control
   */
  destroy: function() {
    if (Legato.Lang.ObjectUtils.exists(this.handler))
    {
      this.handler.destroy();
    }
  },

  CLASS_NAME: 'Legato.Control.SelectLonLat'
});

/**
 * Structure: lc:SelectLonLat
 * XML based config for a <Legato.Control.SelectLonLat>.
 *
 * See Also:
 * - <Legato.Control>
 * - <Legato.Beans.BeanFactory>
 *
 * A valid config example for a SelectLonLat would be:
 * (start code)
 * <lc:SelectLonLat/>
 * (end)
 */
Legato.Control.SelectLonLat.Bean = Legato.Control.Bean.Extend(

  'Legato.Control.SelectLonLat',

  /*
   * Property: QName
   * The qualified name for this control. Needed by XML config to instantiate it.
   */
  Legato.Control.QName('SelectLonLat'),
  {
    _constructor: Legato.Control.SelectLonLat,
    options:
    {
      callback: Legato.Lang.Function,
      displayClass: Legato.Lang.String
    }
  }
);

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.Separator = OpenLayers.Class(OpenLayers.Control, {

	initialize : function(options) {
		OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
	},

	CLASS_NAME : "Legato.Control.Separator"

});

/**
 * Component: lc:Separator
 * 
 * Inherits from:
 * - {<lc:Control>}
 * 
 * See Also:
 * - <lc> namespace
 * - {<Legato.Control.Separator>}
 * 
 * Configuration example:
 * (start code)
 * <lc:Separator />
 * (end)
 */
Legato.Control.Separator.Bean = Legato.Control.Bean.Extend(
		'Legato.Control.Separator', Legato.Control.QName('Separator'), {
			factoryFunction : function(options) {
				return new Legato.Control.Separator(options);
			},
			constructorOrder : []
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: Legato.Control.GeoLocation
 *
 * Control which zooms the current Map to the current position of the user if available.
 *
 * Inherits from: - <Legato.Control>
 */
Legato.Control.GeoLocation = OpenLayers.Class(Legato.Control, {


  currentPositionLayer: null,

  zoomLevel: null,

  icon: null,

  iconUrl: null,

  iconHeight: null,

  iconWidth: null,

  name: 'My Position',

  zoomToCurrentPosition: true,

  showInLegend: true,

  /**
   * Constructor: Legato.Control.WMSGetFeatureInfo Create a WMSGetFeatureInfo.
   *
   * Parameters:
   */
  initialize : function(options) {
    Legato.Control.prototype.initialize.apply(this, [ options ]);

    if(this.iconUrl !== null &&
       this.iconHeight !== null &&
       this.iconWidth !== null){
      var size = new OpenLayers.Size(this.iconWidth,this.iconHeight);
      var offset = new OpenLayers.Pixel(-(size.w/2), -size.h);
      this.icon = new OpenLayers.Icon(this.iconUrl,size,offset);
    }
  },

  /**
   * APIMethod: setMap
   *
   * See Also: <OpenLayer.Control>
   */
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);

    /*
     * Get max zoomLevel if not defined
     */
    if(this.zoomLevel === null){
      /*
       * We're decrementing the zoomLevel cause otherwise the isValidZoomLevel
       * method will allways return false which prevents the client from zooming
       * to the max level.
       */
      this.zoomLevel = this.map.getNumZoomLevels() - 1;
    }
  },

  /**
   * Function: draw
   *
   * See Also: <OpenLayer.Control>
   */
  draw : function() {
    OpenLayers.Control.prototype.draw.apply(this);
  },

  /**
   * APIMethod: destroy
   *
   * See Also: <OpenLayer.Control>
   */
  destroy : function() {
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  /**
   * APIMethod: activate
   *
   * See Also: <OpenLayer.Control>
   */
  activate : function() {
    if(!Legato.Util.GeoLocation.isAvailable()){
      return false;
    }

    OpenLayers.Control.prototype.activate.apply(this, arguments);

    /*
     * Might occur if user has deleted the layer via the legend control
     */
    if(this.currentPositionLayer !== null && this.map.getLayer(this.currentPositionLayer.id) === null){
      this.currentPositionLayer.setVisibility(true);
      this.map.addLayer(this.currentPositionLayer);
    }

    /*
     * Position has not been shown yet
     */
    if(this.currentPositionLayer === null){
      Legato.Util.GeoLocation.getCurrentPosition(
          this.onPositionDefined.bind(this), this.onPositionError.bind(this)
      );
    }

    if(this.zoomToCurrentPosition && this.map.isValidLonLat(this.currentPosition)){
      if(this.map.isValidZoomLevel(this.zoomLevel)){
        this.map.setCenter(this.currentPosition, this.zoomLevel);
      }
      this.map.setCenter(this.currentPosition);
    }
  },

  /**
   * APIMethod: deactivate
   *
   * See Also: <OpenLayer.Control>
   */
  deactivate : function() {
    OpenLayers.Control.prototype.deactivate.apply(this, arguments);
  },

  /**
   * triggered if some error occured
   */
  onPositionError: function(error){
    switch(error.code){
      case error.PERMISSION_DENIED:
        break;
      case error.POSITION_UNAVAILABLE:
        break;
      case error.TIMEOUT:
        break;
      default:
        break;
    }
    this.deactivate();
  },

  /**
   * Triggered if current Position could be located
   */
  onPositionDefined: function(position){
    this.currentPosition = new OpenLayers.LonLat(position.coords.longitude, position.coords.latitude);

    if(this.zoomToCurrentPosition){
      this.map.setCenter(this.currentPosition, this.zoomLevel);
    }

    if(this.icon === null){
      this.currentPositionLayer = new OpenLayers.Layer.Vector(
        this.name,
        {
          styleMap: new OpenLayers.StyleMap({
            // Set the external graphic and background graphic images.
            externalGraphic: "http://openlayers.org/dev/img/marker-gold.png",
            backgroundGraphic: "http://openlayers.org/dev/examples/marker_shadow.png",

            // Makes sure the background graphic is placed correctly relative
            // to the external graphic.
            backgroundXOffset: 0,
            backgroundYOffset: -7,

            // Set the z-indexes of both graphics to make sure the background
            // graphics stay in the background (shadows on top of markers looks
            // odd; let's not do that).
            graphicZIndex: 11,
            backgroundGraphicZIndex: 10,

            pointRadius: 10
          }),
          isBaseLayer: false,
          rendererOptions: {yOrdering: true}
        }
      );
      var features = [];
      features.push(new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point(position.coords.longitude, position.coords.latitude)));
      this.currentPositionLayer.addFeatures(features);
      this.currentPositionLayer.options.legatoIgnore = !this.showInLegend;
      this.map.addLayer(this.currentPositionLayer);
    } else {
      this.currentPositionLayer = new OpenLayers.Layer.Markers(this.name);
      this.currentPositionLayer.options.legatoIgnore = !this.showInLegend;
      this.map.addLayer(this.currentPositionLayer);
      this.currentPositionLayer.addMarker(new OpenLayers.Marker(this.currentPosition, this.icon));
    }
  },

  CLASS_NAME :'Legato.Control.GeoLocation'
});

/**
 * Structure: lc:WMSGetFeatureInfo XML based config for a
 * <Legato.Control.WMSGetFeatureInfo>.
 *
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory> - <QName>
 *
 * A valid config example for a WMSGetFeatureInfo would be:
 * (start code)
 * <lc:WMSGetFeatureInfo>
 *   <infoFormat>text/xml</infoFormat>
 *   <hover>true</hover>
 *   <maxFeatures>1</maxFeatures>
 *   <queryVisible>true</queryVisible>
 *   <handlerOptions>
 *   <hover>
 *    <delay>200</delay>
 *  </hover>
 *  </handlerOptions>
 * </lc:WMSGetFeatureInfo>
 * (end)
 */
Legato.Control.GeoLocation.Bean = Legato.Control.Bean.Extend(

'Legato.Control.GeoLocation',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Control.QName('GeoLocation'), {
  _constructor :Legato.Control.GeoLocation,
  options : {
    /*
     * Property: hover
     *
     * See Also: <OpenLayers.Control.WMSGetFeatureInfo.hover>
     */
    zoomLevel: Legato.Lang.Integer,
    iconUrl: Legato.Lang.String,
    iconHeight: Legato.Lang.Integer,
    iconWidth: Legato.Lang.Integer,
    name: Legato.Lang.String,
    zoomToCurrentPosition: Legato.Lang.Boolean,
    showInLegend: Legato.Lang.Boolean
  }
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.CallbackLocker = OpenLayers.Class(OpenLayers.Control, {
	targetElement : null,

	lock : null,

	unlock : null,

	initialize : function(options) {
		Legato.Util.Ensure.ensureExists(options.targetElement);
		Legato.Util.Ensure.ensureFunction(options.lock);
		Legato.Util.Ensure.ensureFunction(options.unlock);
		OpenLayers.Control.prototype.initialize.apply(this, arguments);
	},

	lockElement : function() {
		this.lock(this.targetElement);
	},

	unlockElement : function() {
		this.unlock(this.targetElement);
	},

	CLASS_NAME : 'Legato.Control.CallbackLocker'
});

Legato.Control.CallbackLocker.Bean = OpenLayers.Control.Bean.Extend(

'Legato.Control.CallbackLocker',

Legato.Control.QName('CallbackLocker'), {
	_constructor : Legato.Control.CallbackLocker,
	options : {
		targetElement : Legato.Lang.Element,

		lock : Legato.Lang.Function,

		unlock : Legato.Lang.Function
	}
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: Legato.Control.SynchronousSnappingResolver
 * 
 * Inherits from: - <Legato.Control>
 */
Legato.Control.SynchronousSnappingResolver = OpenLayers.Class(Legato.Control, {

  logger : null,

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
    this.logger = Legato.Util.Logger.getLogger();
  },

  getSnapPoint : function(layerid, resolution, worldPoint, callback) {
    var that = this;
    var onSuccess = function(result) {
      return that.onSuccess(result, callback);
    };
    var onFailure = function(message, exception) {
      return that.onFailure(message, exception);
    };

    this.locker.lockElement();
    var result = that.snappingResolver.getSnapPoint(layerid, resolution, worldPoint, {
      callback : onSuccess,
      exceptionHandler : onFailure
    });
  },

  getSnapPoints : function(layerid, resolution, lastPoint, worldPoint, callback) {
    var that = this;
    var onSuccess = function(result) {
      return that.onSuccess(result, callback);
    };
    var onFailure = function(message, exception) {
      return that.onFailure(message, exception);
    };
    this.locker.lockElement();
    var result = this.snappingResolver.getSnapPoints(layerid, resolution, lastPoint, worldPoint, {
      callback : onSuccess,
      exceptionHandler : onFailure
    });
  },

  onSuccess : function(result, callback) {
    this.locker.unlockElement();
    return callback(result);
  },

  onFailure : function(message, exception) {
    this.locker.unlockElement();
  },

  CLASS_NAME : 'Legato.Control.SynchronousSnappingResolver'
});

/**
 * Structure: lc:SynchronousSnappingResolver XML based config for a
 * <Legato.Control.SynchronousSnappingResolver>.
 * 
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory> - <QName>
 *     
 * A valid config example for a SynchronousSnappingResolver would be:
 * (start code)
 * <lc:SynchronousSnappingResolver>
 *   <snappingResolver>
 *    <lb:Reference target="DwrSnappingResolver"/>
 *   </snappingResolver>
 *   <locker>
 *     <lb:Reference target="CallbackLocker"/>
 *   </locker>
 * </lc:SynchronousSnappingResolver>
 * (end)
 */
Legato.Control.SynchronousSnappingResolver.Bean = Legato.Control.Bean.Extend(

'Legato.Control.SynchronousSnappingResolver',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Control.QName('SynchronousSnappingResolver'), {
  _constructor : Legato.Control.SynchronousSnappingResolver,
  options : {
    snappingResolver : Legato.Lang.Function,
    locker : Legato.Beans.Object
  }
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.SnappingController = OpenLayers.Class(Legato.Control, {
  map : null,

  snappingResolver : null,

  snappingLayer : null,

  layerId : null,

  logger : null,

  format : new OpenLayers.Format.GeoJSON(),

  initialize : function(options) {
    this.logger = Legato.Util.Logger.getLogger();

    OpenLayers.Control.prototype.initialize.apply(this, arguments);

    this.map.events.on({
      'addlayer' : this.registerFeatureLayerDrawEvents,
      'removelayer' : this.deregisterFeatureLayerDrawEvents,
      scope : this
    });
  },

  /*
   * Function: destroy
   *
   * See Also: <OpenLayer.Control>
   */
  destroy : function() {
    this.map.events.un({
      'addlayer' : this.registerFeatureLayerDrawEvents,
      'removelayer' : this.deregisterFeatureLayerDrawEvents,
      scope : this
    });

    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },

  deregisterFeatureLayerDrawEvents : function(options) {
    if (Legato.OpenLayers.Map.Util.isVectorLayer(options.layer)) {
      options.layer.events.un({
        'legato.sketchpointadded' : this.onSketchpointAdded,
        scope : this
      });
    }

    // Reset if snapping Layer has been removed
    if (Legato.Lang.ObjectUtils.exists(options.layer.layerId) && options.layer.layerId === this.layerId) {
      this.layerId = null;
      this.snappingLayer = null;
    }
  },

  registerFeatureLayerDrawEvents : function(options) {
    if (Legato.OpenLayers.Map.Util.isVectorLayer(options.layer)) {
      options.layer.events.on({
        'legato.sketchpointadded' : this.onSketchpointAdded,
        scope : this
      });
    }
  },

  /**
   * Method: setLayerId Enables snapping if the given layerId exists in current
   * map.
   *
   * Parameters: layerId - {String} The layerId on wich the snapping should be
   * based
   */
  setLayerId : function(layerId) {
    var layers = this.map.getLayersBy('layerId', layerId);
    this.snappingLayer = layers.length === 1 ? layers[0] : null;
    this.layerId = this.snappingLayer !== null ? layerId : null;
  },

  getLayerId : function() {
    return this.layerId;
  },

  /*
   * Triggered when the user as added a new point to its current sketch
   */
  onSketchpointAdded : function(event) {
    if (!this.isSnappingActive()) {
      return;
    }

    var snappableLayer = event.layer;
    var snappableGeometry = event.geometry;
    var snappablePoint = event.vertex.clone(null);

    /*
     * Done inline to ensure that this controller remains stateless.
     */

    this.snappingResolver.getSnapPoint(this.layerId, this.map.getResolution(), this.format.extract.geometry.call(this.format, snappablePoint), OpenLayers.Function
        .bind(function(snappedPoint) {
          snappedPoint = this.format.parseGeometry(snappedPoint);

          // Snapping occured?
          if (snappablePoint.equals(snappedPoint)) {
            // this.logger.debug('No snapping needed. Continue!');
          } else {
            if (this.updateGeometry(snappableGeometry, snappablePoint, snappedPoint)) {

//              this.logger.debug('Snappable point:');
//              this.logger.debug(snappablePoint);

              /*
               * If the given geometry has been updated trigger an event so that
               * every listener gets notified about this.
               */
              snappableLayer.events.triggerEvent('legato.sketchupdated', {
                layer : snappableLayer,
                geometry : snappableGeometry
              });
            }
          }
        }, this));
  },

  /*
   * Returns true if snapping is active, false otherwise
   */
  isSnappingActive : function() {
    /*
     * Might occur if snappingcontroller has been preconfigured by the legato
     * config. If so the control is created where there are no layers yet on the
     * map.
     */
    if (this.snappingLayer === null && this.layerId !== null) {
      this.setLayerId(this.layerId);
    }

    return this.snappingLayer !== null;
  },

  /*
   * Updates the given geometry by determining the given oldPoint and changing
   * this one to the given newpoint.
   *
   * Note: oldPoint needs to be a vertex otherwise this method want update the
   * geometry.
   */
  updateGeometry : function(geometry, oldPoint, newPoint) {

    var vertices = geometry.getVertices();
    for ( var i = 0; i < vertices.length; i++) {
      if (vertices[i].equals(oldPoint)) {
        vertices[i].x = newPoint.x;
        vertices[i].y = newPoint.y;
        return true;
      }
    }
    return false;
  },

  CLASS_NAME : 'Legato.Control.SnappingController'
});

Legato.Control.SnappingController.Bean = OpenLayers.Control.Bean.Extend(

'Legato.Control.SnappingController',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Control.QName('SnappingController'), {
  _constructor : Legato.Control.SnappingController,
  options : {
    map : OpenLayers.Map,
    snappingResolver : Legato.Control,
    layerId : Legato.Lang.String
  }
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.SnappableLayerSelector = OpenLayers.Class(Legato.Control,
{
  map :null,

  targetSnappingController: null,

  div: null,

  selectElement: null,
  
  selectLabel: null,

  txtSelect: 'Please choose an option',

  txtNoSnapping: 'No snapping',

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
  },

  /*
   * Function: setMap Set the map property for the control.
   *
   * Parameters: map - {<OpenLayers.Map>}
   */
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);
    this.map.events.on( {
      'addlayer' : this.layerAdded,
      'removelayer' : this.layerRemoved,
      scope : this
    });
  },

  /*
   * Function: destroy APIMethod: called if destroyed
   */
  destroy : function() {
    this.map.events.un( {
      'addlayer' : this.layerAdded,
      'removelayer' : this.layerRemoved,
      scope : this
    });
  },

  draw : function() {
    if (this.selectLabel !== null) {
      this.div.removeChild(this.selectLabel);
    }
    
    this.selectLabel = document.createElement('span');
    this.selectLabel.innerHTML = this.txtSelect + ' ';
    this.div.appendChild(this.selectLabel);
    
    if (this.selectElement !== null){
      this.div.removeChild(this.selectElement);
    }
    
    this.selectElement = document.createElement('select');
    this.selectElement.className = 'snappableLayerSelectionDropDown';

    this.selectElement.onchange = OpenLayers.Function.bindAsEventListener(
        this.selectionChanged, this);
    this.selectElement.appendChild(this.createOption(this.txtNoSnapping, null, false));

    this.div.appendChild(this.selectElement);

    var layerId = this.targetSnappingController.getLayerId();

    var snappableLayers = Legato.OpenLayers.Map.Util.getSnappableLayers(this.map.layers);

    for (var index = 0; index < snappableLayers.length; index++)
    {
      var layer = snappableLayers[index];
      this.selectElement.appendChild(this.createOption(layer.title, layer.layerId, (layerId === layer.layerId)));
    }

    return this.div;
  },

  selectionChanged: function(event) {
    var layerId = (event.target || event.srcElement).value;
    this.targetSnappingController.setLayerId(layerId);
  },

  createOption : function(name, value, selected) {
    var option = document.createElement('option');
    option.value = value;
    option.selected = selected;
    option.innerHTML = name;
    return option;
  },

  layerAdded: function(event){
    this.draw();
  },

  layerRemoved: function(event){
    this.draw();
  },

  CLASS_NAME : 'Legato.Control.SnappableLayerSelector'
});


Legato.Control.SnappableLayerSelector.Bean = OpenLayers.Control.Bean.Extend(

  'Legato.Control.SnappableLayerSelector',

 /*
   * Property: QName The qualified name for this control. Needed by XML config
   * to instantiate it.
   */
  Legato.Control.QName('SnappableLayerSelector'),
  {
    _constructor: Legato.Control.SnappableLayerSelector,
    options: {
      map: OpenLayers.Map,
      div: Legato.Lang.Element,
      targetSnappingController: Legato.Control.SnappingController.Bean,
      txtSelect: Legato.Lang.String,
      txtNoSnapping: Legato.Lang.String
    }
  }
);

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Revision: 69543 $
 * @requires Legato.js
 * @requires OpenLayers/Control.js
 */

/**
 * Namespace: Legato.Format Legato formats.
 */
Legato.Format = {};
/**
 * Space: lf
 * URI: Namespace URI
 * http://www.disy.net/legato/format
 */
Legato.Format.NAMESPACE_URI = 'http://www.disy.net/legato/format';
/**
 * Prefix: Default prefix
 * lf
 */
Legato.Format.PREFIX = 'lf';
Legato.Format.QName = function(localPart) {
	return new Legato.XML.QName(Legato.Format.NAMESPACE_URI, localPart,
			Legato.Format.PREFIX);
};
Legato.Format.Bean = Legato.Beans.Object.Extend('Legato.Format',
//
Legato.Control.QName('Format'),
//
{
	_constructor : Legato.Format
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @requires OpenLayers/Format/XML.js
 * @requires OpenLayers/Geometry/Polygon.js
 * @requires OpenLayers/Geometry/Point.js
 * @requires OpenLayers/Geometry/MultiPolygon.js
 * @requires OpenLayers/Geometry/LinearRing.js
 */

/**
 * Class: OpenLayers.Format.ArcXML
 * Read/Wite ArcXML. Create a new instance with the <OpenLayers.Format.ArcXML>
 *     constructor.
 *
 * Inherits from:
 *  - <OpenLayers.Format>
 */
OpenLayers.Format.ArcXML = OpenLayers.Class(OpenLayers.Format.XML, {

    /**
     * Property: fontStyleKeys
     * {Array} List of keys used in font styling.
     */
    fontStyleKeys: [
        'antialiasing', 'blockout', 'font', 'fontcolor','fontsize', 'fontstyle',
        'glowing', 'interval', 'outline', 'printmode', 'shadow', 'transparency'
    ],

    /**
     * Property: request
     * A get_image request destined for an ArcIMS server.
     */
    request: null,

    /**
     * Property: response
     * A parsed response from an ArcIMS server.
     */
    response: null,

    /**
     * Constructor: OpenLayers.Format.ArcXML
     * Create a new parser/writer for ArcXML.  Create an instance of this class
     *    to begin authoring a request to an ArcIMS service.  This is used
     *    primarily by the ArcIMS layer, but could be used to do other wild
     *    stuff, like geocoding.
     *
     * Parameters:
     * options - {Object} An optional object whose properties will be set on
     *     this instance.
     */
    initialize: function(options) {
        this.request = new OpenLayers.Format.ArcXML.Request();
        this.response = new OpenLayers.Format.ArcXML.Response();

        if (options) {
            if (options.requesttype == "feature") {
                this.request.get_image = null;

                var qry = this.request.get_feature.query;
                this.addCoordSys(qry.featurecoordsys, options.featureCoordSys);
                this.addCoordSys(qry.filtercoordsys, options.filterCoordSys);

                if (options.polygon) {
                    qry.isspatial = true;
                    qry.spatialfilter.polygon = options.polygon;
                } else if (options.envelope) {
                    qry.isspatial = true;
                    qry.spatialfilter.envelope = {minx:0, miny:0, maxx:0, maxy:0};
                    this.parseEnvelope(qry.spatialfilter.envelope, options.envelope);
                }
            } else if (options.requesttype == "image") {
                this.request.get_feature = null;

                var props = this.request.get_image.properties;
                this.parseEnvelope(props.envelope, options.envelope);

                this.addLayers(props.layerlist, options.layers);
                this.addImageSize(props.imagesize, options.tileSize);
                this.addBackground(props.background, options.background);
                this.addCoordSys(props.featurecoordsys, options.featureCoordSys);
                this.addCoordSys(props.filtercoordsys, options.filterCoordSys);
            } else {
                // if an arcxml object is being created with no request type, it is
                // probably going to consume a response, so do not throw an error if
                // the requesttype is not defined
                this.request = null;
            }
        }

        OpenLayers.Format.XML.prototype.initialize.apply(this, [options]);
    },

    /**
     * Method: parseEnvelope
     * Parse an array of coordinates into an ArcXML envelope structure.
     *
     * Parameters:
     * env - {Object} An envelope object that will contain the parsed coordinates.
     * arr - {Array(double)} An array of coordinates in the order: [ minx, miny, maxx, maxy ]
     */
    parseEnvelope: function(env, arr) {
        if (arr && arr.length == 4) {
            env.minx = arr[0];
            env.miny = arr[1];
            env.maxx = arr[2];
            env.maxy = arr[3];
        }
    },

    /**
     * Method: addLayers
     * Add a collection of layers to another collection of layers. Each layer in the list is tuple of
     * { id, visible }.  These layer collections represent the
     * /ARCXML/REQUEST/get_image/PROPERTIES/LAYERLIST/LAYERDEF items in ArcXML
     *
     * TODO: Add support for dynamic layer rendering.
     *
     * Parameters:
     * ll - {Array({id,visible})} A list of layer definitions.
     * lyrs - {Array({id,visible})} A list of layer definitions.
     */
    addLayers: function(ll, lyrs) {
        for(var lind = 0, len=lyrs.length; lind < len; lind++) {
            ll.push(lyrs[lind]);
        }
    },

    /**
     * Method: addImageSize
     * Set the size of the requested image.
     *
     * Parameters:
     * imsize - {Object} An ArcXML imagesize object.
     * olsize - {OpenLayers.Size} The image size to set.
     */
    addImageSize: function(imsize, olsize) {
        if (olsize !== null) {
            imsize.width = olsize.w;
            imsize.height = olsize.h;
            imsize.printwidth = olsize.w;
            imsize.printheight = olsize.h;
        }
    },

    /**
     * Method: addBackground
     * Set background color and transparent color if defined
     *
     * Parameters:
     * backgrnd - {Object} ArcXML background object.
     * olbackgrnd - {Object} Background colors to set.
     */
    addBackground: function(backgrnd, olbackgrnd) {
        if (olbackgrnd !== null) {
            backgrnd.color.r = olbackgrnd.color.r;
            backgrnd.color.g = olbackgrnd.color.g;
            backgrnd.color.b = olbackgrnd.color.b;
            if (olbackgrnd.transcolor !== null) {
                backgrnd.transcolor.r = olbackgrnd.transcolor.r;
                backgrnd.transcolor.g = olbackgrnd.transcolor.g;
                backgrnd.transcolor.b = olbackgrnd.transcolor.b;
            }
            else {
                backgrnd.transcolor = null;
            }
        }
        else {
            this.request.get_image.properties.background = null;
        }
    },

    /**
     * Method: addCoordSys
     * Add the coordinate system information to an object. The object may be
     *
     * Parameters:
     * featOrFilt - {Object} A featurecoordsys or filtercoordsys ArcXML structure.
     * fsys - {String} or {OpenLayers.Projection} or {filtercoordsys} or
     * {featurecoordsys} A projection representation. If it's a {String},
     * the value is assumed to be the SRID.  If it's a {OpenLayers.Projection}
     * AND Proj4js is available, the projection number and name are extracted
     * from there.  If it's a filter or feature ArcXML structure, it is copied.
     */
    addCoordSys: function(featOrFilt, fsys) {
        if (typeof fsys == "string") {
            featOrFilt.id = parseInt(fsys, 10);
            featOrFilt.string = fsys;
        }
        // is this a proj4js instance?
        else if (typeof fsys == "object" && fsys.proj !== null){
            featOrFilt.id = fsys.proj.srsProjNumber;
            featOrFilt.string = fsys.proj.srsCode;
        } else {
            featOrFilt = fsys;
        }
    },

    /**
     * APIMethod: iserror
     * Check to see if the response from the server was an error.
     *
     * Parameters:
     * data - {String} or {DOMElement} data to read/parse. If nothing is supplied,
     * the current response is examined.
     *
     * Returns:
     * {Boolean} true if the response was an error.
     */
    iserror: function(data) {
        var ret = null;

        if (!data) {
            ret = (this.response.error !== '');
        } else {
            data = OpenLayers.Format.XML.prototype.read.apply(this, [data]);
            var errorNodes = data.documentElement.getElementsByTagName("ERROR");
            ret = (errorNodes !== null && errorNodes.length > 0);
        }

        return ret;
    },

    /**
     * APIMethod: read
     * Read data from a string, and return an response.
     *
     * Parameters:
     * data - {String} or {DOMElement} data to read/parse.
     *
     * Returns:
     * {OpenLayers.Format.ArcXML.Response} An ArcXML response. Note that this response
     *     data may change in the future.
     */
    read: function(data) {
        if(typeof data == "string") {
            data = OpenLayers.Format.XML.prototype.read.apply(this, [data]);
        }

        var arcNode = null;
        if (data && data.documentElement) {
            if(data.documentElement.nodeName == "ARCXML") {
                arcNode = data.documentElement;
            } else {
                arcNode = data.documentElement.getElementsByTagName("ARCXML")[0];
            }
        }

        if (!arcNode) {
            var error, source;
            try {
                error = data.firstChild.nodeValue;
                source = data.firstChild.childNodes[1].firstChild.nodeValue;
            } catch (err) {
                // pass
            }
            throw {
                message: "Error parsing the ArcXML request",
                error: error,
                source: source
            };
        }

        var response = this.parseResponse(arcNode);
        return response;
    },

    /**
     * APIMethod: write
     * Generate an ArcXml document string for sending to an ArcIMS server.
     *
     * Returns:
     * {String} A string representing the ArcXML document request.
     */
    write: function(request) {
        if (!request) {
            request = this.request;
        }
        var root = this.createElementNS("", "ARCXML");
        root.setAttribute("version","1.1");

        var reqElem = this.createElementNS("", "REQUEST");

        var getElem;
        if (request.get_image !== null) {
            getElem = this.createElementNS("", "GET_IMAGE");
            reqElem.appendChild(getElem);

            var propElem = this.createElementNS("", "PROPERTIES");
            getElem.appendChild(propElem);

            var props = request.get_image.properties;
            if (props.featurecoordsys !== null) {
                var feat = this.createElementNS("", "FEATURECOORDSYS");
                propElem.appendChild(feat);

                if (props.featurecoordsys.id === 0) {
                    feat.setAttribute("string", props.featurecoordsys.string);
                }
                else {
                    feat.setAttribute("id", props.featurecoordsys.id);
                }
            }

            if (props.filtercoordsys !== null) {
                var filt = this.createElementNS("", "FILTERCOORDSYS");
                propElem.appendChild(filt);

                if (props.filtercoordsys.id === 0) {
                    filt.setAttribute("string", props.filtercoordsys.string);
                }
                else {
                    filt.setAttribute("id", props.filtercoordsys.id);
                }
            }

            if (props.envelope !== null) {
                var env = this.createElementNS("", "ENVELOPE");
                propElem.appendChild(env);

                env.setAttribute("minx", props.envelope.minx);
                env.setAttribute("miny", props.envelope.miny);
                env.setAttribute("maxx", props.envelope.maxx);
                env.setAttribute("maxy", props.envelope.maxy);
            }

            var imagesz = this.createElementNS("", "IMAGESIZE");
            propElem.appendChild(imagesz);

            imagesz.setAttribute("height", props.imagesize.height);
            imagesz.setAttribute("width", props.imagesize.width);

            if (props.imagesize.height != props.imagesize.printheight ||
                 props.imagesize.width != props.imagesize.printwidth) {
                imagesz.setAttribute("printheight", props.imagesize.printheight);
                imagesz.setArrtibute("printwidth", props.imagesize.printwidth);
            }

            if (props.background !== null) {
                var backgrnd = this.createElementNS("", "BACKGROUND");
                propElem.appendChild(backgrnd);

                backgrnd.setAttribute("color",
                    props.background.color.r + "," +
                    props.background.color.g + "," +
                    props.background.color.b);

                if (props.background.transcolor !== null) {
                    backgrnd.setAttribute("transcolor",
                        props.background.transcolor.r + "," +
                        props.background.transcolor.g + "," +
                        props.background.transcolor.b);
                }
            }

            if (props.layerlist !== null && props.layerlist.length > 0) {
                var layerlst = this.createElementNS("", "LAYERLIST");
                propElem.appendChild(layerlst);

                for (var ld = 0; ld < props.layerlist.length; ld++) {
                    var ldef = this.createElementNS("", "LAYERDEF");
                    layerlst.appendChild(ldef);

                    ldef.setAttribute("id", props.layerlist[ld].id);
                    ldef.setAttribute("visible", props.layerlist[ld].visible);

                    if (typeof props.layerlist[ld].query == "object") {
                        var query = props.layerlist[ld].query;

                        if (query.where.length < 0) {
                            continue;
                        }

                        var queryElem = null;
                        if (typeof query.spatialfilter == "boolean" && query.spatialfilter) {
                            // handle spatial filter madness
                            queryElem = this.createElementNS("", "SPATIALQUERY");
                        }
                        else {
                            queryElem = this.createElementNS("", "QUERY");
                        }

                        queryElem.setAttribute("where", query.where);

                        if (typeof query.accuracy == "number" && query.accuracy > 0) {
                            queryElem.setAttribute("accuracy", query.accuracy);
                        }
                        if (typeof query.featurelimit == "number" && query.featurelimit < 2000) {
                            queryElem.setAttribute("featurelimit", query.featurelimit);
                        }
                        if (typeof query.subfields == "string" && query.subfields != "#ALL#") {
                            queryElem.setAttribute("subfields", query.subfields);
                        }
                        if (typeof query.joinexpression == "string" && query.joinexpression.length > 0) {
                            queryElem.setAttribute("joinexpression", query.joinexpression);
                        }
                        if (typeof query.jointables == "string" && query.jointables.length > 0) {
                            queryElem.setAttribute("jointables", query.jointables);
                        }

                        ldef.appendChild(queryElem);
                    }

                    if (typeof props.layerlist[ld].renderer == "object") {
                        this.addRenderer(ldef, props.layerlist[ld].renderer);
                    }
                }
            }
        } else if (request.get_feature !== null) {
            getElem = this.createElementNS("", "GET_FEATURES");
            getElem.setAttribute("outputmode", "newxml");
            getElem.setAttribute("checkesc", "true");

            if (request.get_feature.geometry) {
                getElem.setAttribute("geometry", request.get_feature.geometry);
            }
            else {
                getElem.setAttribute("geometry", "false");
            }

            if (request.get_feature.compact) {
                getElem.setAttribute("compact", request.get_feature.compact);
            }

            if (request.get_feature.featurelimit == "number") {
                getElem.setAttribute("featurelimit", request.get_feature.featurelimit);
            }

            getElem.setAttribute("globalenvelope", "true");
            reqElem.appendChild(getElem);

            if (request.get_feature.layer !== null && request.get_feature.layer.length > 0) {
                var lyrElem = this.createElementNS("", "LAYER");
                lyrElem.setAttribute("id", request.get_feature.layer);
                getElem.appendChild(lyrElem);
            }

            var fquery = request.get_feature.query;
            if (fquery !== null) {
                var qElem = null;
                if (fquery.isspatial) {
                    qElem = this.createElementNS("", "SPATIALQUERY");
                } else {
                    qElem = this.createElementNS("", "QUERY");
                }
                getElem.appendChild(qElem);

                if (typeof fquery.accuracy == "number") {
                    qElem.setAttribute("accuracy", fquery.accuracy);
                }
                //qElem.setAttribute("featurelimit", "5");

                if (fquery.featurecoordsys !== null) {
                    var fcsElem1 = this.createElementNS("", "FEATURECOORDSYS");

                    if (fquery.featurecoordsys.id === 0) {
                        fcsElem1.setAttribute("string", fquery.featurecoordsys.string);
                    } else {
                        fcsElem1.setAttribute("id", fquery.featurecoordsys.id);
                    }
                    qElem.appendChild(fcsElem1);
                }

                if (fquery.filtercoordsys !== null) {
                    var fcsElem2 = this.createElementNS("", "FILTERCOORDSYS");

                    if (fquery.filtercoordsys.id === 0) {
                        fcsElem2.setAttribute("string", fquery.filtercoordsys.string);
                    } else {
                        fcsElem2.setAttribute("id", fquery.filtercoordsys.id);
                    }
                    qElem.appendChild(fcsElem2);
                }

                if (fquery.buffer > 0) {
                    var bufElem = this.createElementNS("", "BUFFER");
                    bufElem.setAttribute("distance", fquery.buffer);
                    qElem.appendChild(bufElem);
                }

                if (fquery.isspatial) {
                    var spfElem = this.createElementNS("", "SPATIALFILTER");
                    spfElem.setAttribute("relation", fquery.spatialfilter.relation);
                    qElem.appendChild(spfElem);

                    if (fquery.spatialfilter.envelope) {
                        var envElem = this.createElementNS("", "ENVELOPE");
                        envElem.setAttribute("minx", fquery.spatialfilter.envelope.minx);
                        envElem.setAttribute("miny", fquery.spatialfilter.envelope.miny);
                        envElem.setAttribute("maxx", fquery.spatialfilter.envelope.maxx);
                        envElem.setAttribute("maxy", fquery.spatialfilter.envelope.maxy);
                        spfElem.appendChild(envElem);
                    } else if(typeof fquery.spatialfilter.polygon == "object") {
                        spfElem.appendChild(this.writePolygonGeometry(fquery.spatialfilter.polygon));
                    }
                }

                if (fquery.where !== null && fquery.where.length > 0) {
                    qElem.setAttribute("where", fquery.where);
                }
            }
        }

        root.appendChild(reqElem);

        return OpenLayers.Format.XML.prototype.write.apply(this, [root]);
    },


    addGroupRenderer: function(ldef, toprenderer) {
        var topRelem = this.createElementNS("", "GROUPRENDERER");
        ldef.appendChild(topRelem);

        for (var rind = 0; rind < toprenderer.length; rind++) {
            var renderer = toprenderer[rind];
            this.addRenderer(topRelem, renderer);
        }
    },


    addRenderer: function(topRelem, renderer) {
        if (renderer instanceof Array) {
            this.addGroupRenderer(topRelem, renderer);
        } else {
            var renderElem = this.createElementNS("", renderer.type.toUpperCase() + "RENDERER");
            topRelem.appendChild(renderElem);

            if (renderElem.tagName == "VALUEMAPRENDERER") {
                this.addValueMapRenderer(renderElem, renderer);
            } else if (renderElem.tagName == "VALUEMAPLABELRENDERER") {
                this.addValueMapLabelRenderer(renderElem, renderer);
            } else if (renderElem.tagName == "SIMPLELABELRENDERER") {
                this.addSimpleLabelRenderer(renderElem, renderer);
            } else if (renderElem.tagName == "SCALEDEPENDENTRENDERER") {
                this.addScaleDependentRenderer(renderElem, renderer);
            }
        }
    },


    addScaleDependentRenderer: function(renderElem, renderer) {
        if (typeof renderer.lower == "string" || typeof renderer.lower == "number") {
            renderElem.setAttribute("lower", renderer.lower);
        }
        if (typeof renderer.upper == "string" || typeof renderer.upper == "number") {
            renderElem.setAttribute("upper", renderer.upper);
        }

        this.addRenderer(renderElem, renderer.renderer);
    },


    addValueMapLabelRenderer: function(renderElem, renderer) {
        renderElem.setAttribute("lookupfield", renderer.lookupfield);
        renderElem.setAttribute("labelfield", renderer.labelfield);

        if (typeof renderer.exacts == "object") {
            for (var ext=0, extlen=renderer.exacts.length; ext<extlen; ext++) {
                var exact = renderer.exacts[ext];

                var eelem = this.createElementNS("", "EXACT");

                if (typeof exact.value == "string") {
                    eelem.setAttribute("value", exact.value);
                }
                if (typeof exact.label == "string") {
                    eelem.setAttribute("label", exact.label);
                }
                if (typeof exact.method == "string") {
                    eelem.setAttribute("method", exact.method);
                }

                renderElem.appendChild(eelem);

                if (typeof exact.symbol == "object") {
                    var selem = null;

                    if (exact.symbol.type == "text") {
                        selem = this.createElementNS("", "TEXTSYMBOL");
                    }

                    if (selem !== null) {
                        var keys = this.fontStyleKeys;
                        for (var i = 0, len = keys.length; i < len; i++) {
                            var key = keys[i];
                            if (symbol[key]) {
                                selem.setAttribute(key, renderer[key]);
                            }
                        }
                        eelem.appendChild(selem);
                    }
                }
            } // for each exact
        }
    },

    addValueMapRenderer: function(renderElem, renderer) {
        var selem;
        renderElem.setAttribute("lookupfield", renderer.lookupfield);

        if (typeof renderer.ranges == "object") {
            for(var rng=0, rnglen=renderer.ranges.length; rng<rnglen; rng++) {
                var range = renderer.ranges[rng];

                var relem = this.createElementNS("", "RANGE");
                relem.setAttribute("lower", range.lower);
                relem.setAttribute("upper", range.upper);

                renderElem.appendChild(relem);

                if (typeof range.symbol == "object") {
                    selem = null;

                    if (range.symbol.type == "simplepolygon") {
                        selem = this.createElementNS("", "SIMPLEPOLYGONSYMBOL");
                    }

                    if (selem !== null) {
                        if (typeof range.symbol.boundarycolor == "string") {
                            selem.setAttribute("boundarycolor", range.symbol.boundarycolor);
                        }
                        if (typeof range.symbol.fillcolor == "string") {
                            selem.setAttribute("fillcolor", range.symbol.fillcolor);
                        }
                        if (typeof range.symbol.filltransparency == "number") {
                            selem.setAttribute("filltransparency", range.symbol.filltransparency);
                        }
                        relem.appendChild(selem);
                    }
                }
            } // for each range
        } else if (typeof renderer.exacts == "object") {
            for (var ext=0, extlen=renderer.exacts.length; ext<extlen; ext++) {
                var exact = renderer.exacts[ext];

                var eelem = this.createElementNS("", "EXACT");
                if (typeof exact.value == "string") {
                    eelem.setAttribute("value", exact.value);
                }
                if (typeof exact.label == "string") {
                    eelem.setAttribute("label", exact.label);
                }
                if (typeof exact.method == "string") {
                    eelem.setAttribute("method", exact.method);
                }

                renderElem.appendChild(eelem);

                if (typeof exact.symbol == "object") {
                    selem = null;

                    if (exact.symbol.type == "simplemarker") {
                        selem = this.createElementNS("", "SIMPLEMARKERSYMBOL");
                    }

                    if (selem !== null) {
                        if (typeof exact.symbol.antialiasing == "string") {
                            selem.setAttribute("antialiasing", exact.symbol.antialiasing);
                        }
                        if (typeof exact.symbol.color == "string") {
                            selem.setAttribute("color", exact.symbol.color);
                        }
                        if (typeof exact.symbol.outline == "string") {
                            selem.setAttribute("outline", exact.symbol.outline);
                        }
                        if (typeof exact.symbol.overlap == "string") {
                            selem.setAttribute("overlap", exact.symbol.overlap);
                        }
                        if (typeof exact.symbol.shadow == "string") {
                            selem.setAttribute("shadow", exact.symbol.shadow);
                        }
                        if (typeof exact.symbol.transparency == "number") {
                            selem.setAttribute("transparency", exact.symbol.transparency);
                        }
                        //if (typeof exact.symbol.type == "string")
                        //    selem.setAttribute("type", exact.symbol.type);
                        if (typeof exact.symbol.usecentroid == "string") {
                            selem.setAttribute("usecentroid", exact.symbol.usecentroid);
                        }
                        if (typeof exact.symbol.width == "number") {
                            selem.setAttribute("width", exact.symbol.width);
                        }

                        eelem.appendChild(selem);
                    }
                }
            } // for each exact
        }
    },


    addSimpleLabelRenderer: function(renderElem, renderer) {
        renderElem.setAttribute("field", renderer.field);
        var keys = ['featureweight', 'howmanylabels', 'labelbufferratio',
                    'labelpriorities', 'labelweight', 'linelabelposition',
                    'rotationalangles'];
        var key;
        for (var i=0, len=keys.length; i<len; i++) {
            key = keys[i];
            if (renderer[key]) {
                renderElem.setAttribute(key, renderer[key]);
            }
        }

        if (renderer.symbol.type == "text") {
            var symbol = renderer.symbol;
            var selem = this.createElementNS("", "TEXTSYMBOL");
            renderElem.appendChild(selem);

            keys = this.fontStyleKeys;
            for (i=0, len=keys.length; i<len; i++) {
                key = keys[i];
                if (symbol[key]) {
                    selem.setAttribute(key, renderer[key]);
                }
            }
        }
    },

    writePolygonGeometry: function(polygon) {
        if (!(polygon instanceof OpenLayers.Geometry.Polygon)) {
            throw {
                message:'Cannot write polygon geometry to ArcXML with an ' +
                    polygon.CLASS_NAME + ' object.',
                geometry: polygon
            };
        }

        var polyElem = this.createElementNS("", "POLYGON");

        for (var ln=0, lnlen=polygon.components.length; ln<lnlen; ln++) {
            var ring = polygon.components[ln];
            var ringElem = this.createElementNS("", "RING");

            for (var rn=0, rnlen=ring.components.length; rn<rnlen; rn++) {
                var point = ring.components[rn];
                var pointElem = this.createElementNS("", "POINT");

                pointElem.setAttribute("x", point.x);
                pointElem.setAttribute("y", point.y);

                ringElem.appendChild(pointElem);
            }

            polyElem.appendChild(ringElem);
        }

        return polyElem;
    },

    /**
     * Method: parseResponse
     * Take an ArcXML response, and parse in into this object's internal properties.
     *
     * Parameters:
     * data - {String} or {DOMElement} The ArcXML response, as either a string or the
     * top level DOMElement of the response.
     */
    parseResponse: function(data) {
        if(typeof data == "string") {
            var newData = new OpenLayers.Format.XML();
            data = newData.read(data);
        }
        var response = new OpenLayers.Format.ArcXML.Response();

        var errorNode = data.getElementsByTagName("ERROR");

        if (errorNode !== null && errorNode.length > 0) {
            response.error = this.getChildValue(errorNode, "Unknown error.");
        } else {
            var responseNode = data.getElementsByTagName("RESPONSE");

            if (responseNode === null || responseNode.length === 0) {
                response.error = "No RESPONSE tag found in ArcXML response.";
                return response;
            }

            var rtype = responseNode[0].firstChild.nodeName;
            if (rtype == "#text") {
                rtype = responseNode[0].firstChild.nextSibling.nodeName;
            }

            if (rtype == "IMAGE") {
                var envelopeNode = data.getElementsByTagName("ENVELOPE");
                var outputNode = data.getElementsByTagName("OUTPUT");

                if (envelopeNode === null || envelopeNode.length === 0) {
                    response.error = "No ENVELOPE tag found in ArcXML response.";
                } else if (outputNode === null || outputNode.length === 0) {
                    response.error = "No OUTPUT tag found in ArcXML response.";
                } else {
                    var envAttr = this.parseAttributes(envelopeNode[0]);
                    var outputAttr = this.parseAttributes(outputNode[0]);

                    if (typeof outputAttr.type == "string") {
                        response.image = {
                            envelope: envAttr,
                            output: {
                                type: outputAttr.type,
                                data: this.getChildValue(outputNode[0])
                            }
                        };
                    } else {
                        response.image = { envelope: envAttr, output: outputAttr };
                    }
                }
            } else if (rtype == "FEATURES") {
                var features = responseNode[0].getElementsByTagName("FEATURES");

                // get the feature count
                var featureCount = features[0].getElementsByTagName("FEATURECOUNT");
                response.features.featurecount = featureCount[0].getAttribute("count");

                if (response.features.featurecount > 0) {
                    // get the feature envelope
                    var envelope = features[0].getElementsByTagName("ENVELOPE");
                    response.features.envelope = this.parseAttributes(envelope[0], typeof(0));

                    // get the field values per feature
                    var featureList = features[0].getElementsByTagName("FEATURE");
                    for (var fn = 0; fn < featureList.length; fn++) {
                        var feature = new OpenLayers.Feature.Vector();
                        var fields = featureList[fn].getElementsByTagName("FIELD");

                        for (var fdn = 0; fdn < fields.length; fdn++) {
                            var fieldName = fields[fdn].getAttribute("name");
                            var fieldValue = fields[fdn].getAttribute("value");
                            feature.attributes[ fieldName ] = fieldValue;
                        }

                        var geom = featureList[fn].getElementsByTagName("POLYGON");

                        if (geom.length > 0) {
                            // if there is a polygon, create an openlayers polygon, and assign
                            // it to the .geometry property of the feature
                            var ring = geom[0].getElementsByTagName("RING");

                            var polys = [];
                            for (var rn = 0; rn < ring.length; rn++) {
                                var linearRings = [];
                                linearRings.push(this.parsePointGeometry(ring[rn]));

                                var holes = ring[rn].getElementsByTagName("HOLE");
                                for (var hn = 0; hn < holes.length; hn++) {
                                    linearRings.push(this.parsePointGeometry(holes[hn]));
                                }
                                holes = null;
                                polys.push(new OpenLayers.Geometry.Polygon(linearRings));
                                linearRings = null;
                            }
                            ring = null;

                            if (polys.length == 1) {
                                feature.geometry = polys[0];
                            } else
                            {
                                feature.geometry = new OpenLayers.Geometry.MultiPolygon(polys);
                            }
                        }

                        response.features.feature.push(feature);
                    }
                }
            } else {
                response.error = "Unidentified response type.";
            }
        }
        return response;
    },


    /**
     * Method: parseAttributes
     *
     * Parameters:
     * node - {<DOMElement>} An element to parse attributes from.
     *
     * Returns:
     * {Object} An attributes object, with properties set to attribute values.
     */
    parseAttributes: function(node,type) {
        var attributes = {};
        for(var attr = 0; attr < node.attributes.length; attr++) {
            if (type == "number") {
                attributes[node.attributes[attr].nodeName] = parseFloat(node.attributes[attr].nodeValue);
            } else {
                attributes[node.attributes[attr].nodeName] = node.attributes[attr].nodeValue;
            }
        }
        return attributes;
    },


    /**
     * Method: parsePointGeometry
     *
     * Parameters:
     * node - {<DOMElement>} An element to parse <COORDS> or <POINT> arcxml data from.
     *
     * Returns:
     * {OpenLayers.Geometry.LinearRing} A linear ring represented by the node's points.
     */
    parsePointGeometry: function(node) {
        var ringPoints = [];
        var coords = node.getElementsByTagName("COORDS");

        if (coords.length > 0) {
            // if coords is present, it's the only coords item
            var coordArr = this.getChildValue(coords[0]);
            coordArr = coordArr.split(/;/);
            for (var cn = 0; cn < coordArr.length; cn++) {
                var coordItems = coordArr[cn].split(/ /);
                ringPoints.push(new OpenLayers.Geometry.Point(parseFloat(coordItems[0]), parseFloat(coordItems[1])));
            }
            coords = null;
        } else {
            var point = node.getElementsByTagName("POINT");
            if (point.length > 0) {
                for (var pn = 0; pn < point.length; pn++) {
                    ringPoints.push(
                        new OpenLayers.Geometry.Point(
                            parseFloat(point[pn].getAttribute("x")),
                            parseFloat(point[pn].getAttribute("y"))
                        )
                    );
                }
            }
            point = null;
        }

        return new OpenLayers.Geometry.LinearRing(ringPoints);
    },

    CLASS_NAME: "OpenLayers.Format.ArcXML"
});

OpenLayers.Format.ArcXML.Request = OpenLayers.Class({
    initialize: function(params) {
        var defaults = {
            get_image: {
                properties: {
                    background:
                    {
                        color: { r:255, g:255, b:255 },
                        transcolor: { r:255, g:255, b:255 }
                    },
                    draw: true,
                    envelope: {
                        minx: 0,
                        miny: 0,
                        maxx: 0,
                        maxy: 0
                    },
                    featurecoordsys: {
                        id:0,
                        string:"",
                        datumtransformid:0,
                        datumtransformstring:""
                    },
                    filtercoordsys:{
                        id:0,
                        string:"",
                        datumtransformid:0,
                        datumtransformstring:""
                    },
                    imagesize:{
                        height:0,
                        width:0,
                        dpi:96,
                        printheight:0,
                        printwidth:0,
                        scalesymbols:false
                    },
                    layerlist:[],
                    /* no support for legends */
                    output:{
                        baseurl:"",
                        legendbaseurl:"",
                        legendname:"",
                        legendpath:"",
                        legendurl:"",
                        name:"",
                        path:"",
                        type:"jpg",
                        url:""
                    }
                }
            },

            get_feature: {
                layer: "",
                query: {
                    isspatial: false,
                    featurecoordsys: {
                        id:0,
                        string:"",
                        datumtransformid:0,
                        datumtransformstring:""
                    },
                    filtercoordsys: {
                        id:0,
                        string:"",
                        datumtransformid:0,
                        datumtransformstring:""
                    },
                    buffer:0,
                    where:"",
                    spatialfilter: {
                        relation: "envelope_intersection",
                        envelope: null
                    }
                }
            },

            environment: {
                separators: {
                    cs:" ",
                    ts:";"
                }
            },

            layer: [],
            workspaces: []
        };

        return OpenLayers.Util.extend(this, defaults);
    },

    CLASS_NAME: "OpenLayers.Format.ArcXML.Request"
});

OpenLayers.Format.ArcXML.Response = OpenLayers.Class({
    initialize: function(params) {
        var defaults = {
            image: {
                envelope:null,
                output:''
            },

            features: {
                featurecount: 0,
                envelope: null,
                feature: []
            },

            error:''
        };

        return OpenLayers.Util.extend(this, defaults);
    },

    CLASS_NAME: "OpenLayers.Format.ArcXML.Response"
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Format.GML3 = OpenLayers.Class(OpenLayers.Format.GML.v3, {

  featureNS :"http://www.opengis.net/gml/simple",
  featureName :"Feature",
  featureCollectionName :"FeatureCollection",
  featureGeometryName :"geometry",

  initialize : function(options) {
    OpenLayers.Format.GML.v3.prototype.initialize.apply(this, [ options ]);
    this.featureType = this.featureName;
    this.geometryName = this.featureGeometryName;
    this.namespaces.feature = this.featureNS;
    this.namespaceAlias[this.featureNS] = 'feature';

    this.writers.feature[this.featureCollectionName] = OpenLayers.Function
        .bind(this.writeFeatures, this);
    this.readers.feature[this.featureCollectionName] = OpenLayers.Function
        .bind(this.readFeatures, this);
  },

  writeFeatures : function(features) {
    var node = this
        .createElementNSPlus('feature:' + this.featureCollectionName);
    for ( var i = 0, len = features.length; i < len; ++i) {
      this.writeNode("gml:featureMember", features[i], node);
    }
    return node;

  },
  readFeatures : function(node, obj) {
    this.readChildNodes(node, obj);
  },
  write : function(features) {
    var root = this
        .writeNode('feature:' + this.featureCollectionName, features);
    return OpenLayers.Format.XML.prototype.write.apply(this, [ root ]);
  },
  CLASS_NAME :"Legato.Format.GML3"
});

Legato.Format.GML3.Bean = Legato.Format.Bean.Extend('Legato.Format.GML3',
//
    Legato.Format.QName('GML3'),
    //
    {
      _constructor :Legato.Format.GML3
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Author: valikov $
 * $Rev: 91043 $
 */

/**
 * Class: Legato.Format.ExtendedWMC
 * Main entry point to the extended WMC functionality
 */
Legato.Format.ExtendedWMC = OpenLayers
    .Class({

      parser : null,
      layerFactories : null,
      initialize : function(options) {
        this.layerFactories = {};
        for ( var layerType in Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES) {
          if (Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES
              .hasOwnProperty(layerType)) {
            this.layerFactories[layerType] = Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES[layerType];
          }
        }
        if (Legato.Lang.ObjectUtils.isObject(options)
            && Legato.Lang.ObjectUtils
                .exists(options.layerFactories)) {
          Legato.Util.Ensure.ensureObject(options.layerFactories);
          for (layerType in options.layerFactories) {
            if (options.layerFactories.hasOwnProperty(layerType)) {
              this.layerFactories[layerType] = options.layerFactories[layerType];
            }
          }
        }
        this.parser = new Legato.Format.ExtendedWMC.Parser({
          layerFactories : this.layerFactories
        });
      },
      beanFactory : null,
      setBeanFactory : function(beanFactory) {
        this.beanFactory = beanFactory;
        this.parser.setBeanFactory(beanFactory);
      },
      getBeanFactory : function() {
        if (this.beanFactory === null) {
          this.beanFactory = new Legato.Beans.XMLBeanFactory();
        }
        return this.beanFactory;
      },

      /**
       * Method: read
       * Read WMC data from a string, and return an object with a
       * list of layers and some window metadata.
       *
       * Parameters: data - {String} or {DOMElement} data to read/parse. options -
       * {Object} Some options that will be added to all created layers
       *
       * Returns: {<Legato.Format.ExtendedWMC.Result>} Parsed ExtendedWMC data and a
       * list of OpenLayers.Layer objects
       */
      read : function(data, options) {
        var model = this.parser.read(data);
        var result = this.modelToResult(model, options);
        return result;
      },

      /**
       * Transforms a <Legato.Format.ExtendedWMC.Model> to
       * <Legato.Format.ExtendedWMC.Result>
       */
      modelToResult : function(model, options) {
        var result = new Legato.Format.ExtendedWMC.Result();
        result.model = model;
        var layers = this.processLayers(model, options);
        result.layers = layers;
        return result;
      },

      /**
       * Transforms a the layerList of <Legato.Format.ExtendedWMC.Model> to
       * <Openlayers.Layer> objects
       */
      processLayers : function(model, options) {
        var layers = [];
        if (model.layerList) {
          if (!Legato.Lang.ObjectUtils.exists(options)) {
            options = {};
          }
          if (!Legato.Lang.ObjectUtils.exists(options.transparent)) {
            options.transparent = true;
          }
          var originalTransparent = options.transparent;
          for ( var i = 0; i < model.layerList.length; i++) {
            var layerInfo = model.layerList[i];
            var layerType = "OGC:WMS";
            if (layerInfo.server && layerInfo.server.service) {
              layerType = layerInfo.server.service;
            }

            var layerFactory = this.layerFactories[layerType];

            if (!Legato.Lang.ObjectUtils.exists(layerFactory)) {
              throw new Legato.Lang.Exception(
                  'Layer factory for the layer type ['
                      + layerType
                      + '] is not registered.');
            } else {
              options.formatList = layerInfo.formatList;
              if(layerInfo.currentFormat === 'image/jpeg' ){
                options.transparent = "false";
              } else {
                options.transparent = originalTransparent;
              }
              var layer = layerFactory.createLayer(layerInfo,
                  options, this.getBeanFactory());
              layers.push(layer);
            }
          }
        }
        return layers;
      },

      CLASS_NAME : 'Legato.Format.ExtendedWMC'
    });

Legato.Format.ExtendedWMC.Bean = Legato.Format.Bean.Extend(
    'Legato.Format.ExtendedWMC',
    //
    Legato.Format.QName('ExtendedWMC'),
    //
    {
      _constructor : Legato.Format.ExtendedWMC
    });

/**
 * Class: Legato.Format.ExtendedWMC.Result
 *
 * Represents the results of the read operation
 */
Legato.Format.ExtendedWMC.Result = OpenLayers.Class({

  initialize : function() {
    this.layers = [];
  },

  /**
   * Property: layers {Array} <OpenLayers.Layer> objects
   */
  layers : null,

  /**
   * Property: model {<Legato.Format.ExtendedWMC.Model>} the parsed ExtendedWMC model
   */
  model : null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Result'
});

Legato.Format.ExtendedWMCLoader = Legato.Lang
    .Class({
      map : null,
      url : null,
      params : null,
      defaultOptions : null,
      createDefaultBaseLayer : false,
      zoomToBoundingBox : true,
      resizeToWindow : true,
      initialize : function(options) {
        this.format = new Legato.Format.ExtendedWMC();
        this.map = options.map;
        var url = options.url;
        var questionMarkIndex = url.indexOf('?');
        if (questionMarkIndex > 0) {
          this.url = url.substring(0, questionMarkIndex);
          this.params = OpenLayers.Util.getParameters(url);
        } else {
          this.url = url;
          this.params = null;
        }
        this.defaultOptions = Legato.Lang.ObjectUtils
            .exists(options.defaultOptions) ? options.defaultOptions
            : {};
        this.zoomToBoundingBox = Legato.Lang.ObjectUtils
            .exists(options.zoomToBoundingBox) ? options.zoomToBoundingBox
            : true;
        this.resizeToWindow = Legato.Lang.ObjectUtils
            .exists(options.resizeToWindow) ? options.resizeToWindow
            : true;
        this.createDefaultBaseLayer = Legato.Lang.ObjectUtils
            .exists(options.createDefaultBaseLayer) ? options.createDefaultBaseLayer
            : false;
      },
      load : function() {
        var onSuccess = function(request) {
          try {
            var result = this.format.read(request.responseText,
                this.defaultOptions);

            if (this.resizeToWindow && result.model.window) {
              this.map.updateSize();
            }
            if (Legato.Lang.ObjectUtils
                .exists(result.model.extension)) {
              Legato.Lang.CollectionUtils.copyIfExists(
                  result.model.extension, this.map, [
                      'minExtent', 'maxExtent',
                      'minScale', 'maxScale',
                      'minResolution', 'maxResolution',
                      'units', 'tags' ]);
              if (Legato.Lang.ObjectUtils
                  .exists(result.model.extension.maxExtent)) {
                var maxExtent = result.model.extension.maxExtent;
                var viewSizeMax = this.map.getSize();
                var wResMax = maxExtent.getWidth()
                    / viewSizeMax.w;
                var hResMax = maxExtent.getHeight()
                    / viewSizeMax.h;
                this.map.maxResolution = Math.max(wResMax,
                    hResMax);
              }
              if (Legato.Lang.ObjectUtils
                  .exists(result.model.extension.minExtent)) {
                var minExtent = result.model.extension.minExtent;
                var viewSizeMin = this.map.getSize();
                var wResMin = minExtent.getWidth()
                    / viewSizeMin.w;
                var hResMin = minExtent.getHeight()
                    / viewSizeMin.h;
                this.map.minResolution = Math.min(wResMin,
                    hResMin);
              }
              if (Legato.Lang.ObjectUtils
                  .exists(result.model.extension.dpi)) {
                OpenLayers.DOTS_PER_INCH = result.model.extension.dpi;
              }
            }

            var layers = result.layers;

            for ( var i = 0; i < layers.length; i++) {
              var layer = layers[i];
              if (this.map.fractionalZoom
                  && Legato.Lang.ObjectUtils
                      .exists(layer.minScale)
                  && Legato.Lang.ObjectUtils
                      .exists(layer.maxScale)
                  && layer.minScale / layer.maxScale < 2.0) {
                // exactly 2 zoom levels because otherwise OpenLayers would otherwise create only one zoom level
                layer.options.numZoomLevels = 2;
              }
              this.map.addLayer(layer);
            }

            if (!Legato.Lang.ObjectUtils.exists(this.map.baseLayer)
                && this.createDefaultBaseLayer
                && layers.length > 0) {
              var firstLayer = layers[0];
              var projection = firstLayer.projection;
              var baseLayerOptions = {};

              // units
              // projection
              if (Legato.Lang.ObjectUtils.exists(projection)) {
                baseLayerOptions.projection = projection;
              }
              // maxExtent
              baseLayerOptions.layerId = "Legato.Layer.Blank";
              baseLayerOptions.legatoIgnore = true;
              baseLayerOptions.alpha = false;
              baseLayerOptions.isBaseLayer = true;
              baseLayerOptions.displayOutsideMaxExtent = false;
              baseLayerOptions.ratio = 1;

              var baseLayer = new OpenLayers.Layer.WMS(
                  "Default base layer", OpenLayers.Util
                      .getImagesLocation()
                      + "blank.gif?", null,
                  baseLayerOptions);
              this.map.addLayer(baseLayer);
            }
            if ((this.map.getExtent() === null || Legato.Lang.ObjectUtils
                .isTrue(this.zoomToBoundingBox))
                && Legato.Lang.ObjectUtils
                    .exists(result.model.boundingBox)
                && Legato.Lang.ObjectUtils
                    .exists(result.model.boundingBox.bounds)) {
              this.map.zoomToExtent(
                  result.model.boundingBox.bounds, true);
            }
            this.map.events.triggerEvent("legato.refresh", {});
          } catch (e) {
            Legato.Util.Logger.getLogger().fatal(
                'Could not parse ExtendedWMC from [' + this.url
                    + '].');
            Legato.Util.Logger.getLogger().fatal(e);
            throw e;
          }
        };

        var onFailure = function(request) {
          Legato.Util.Logger.getLogger().fatal(
              'Could not read ExtendedWMC from [' + this.url
                  + '].');
          throw new Legato.Lang.Exception(
              'Could not read ExtendedWMC from [' + this.url
                  + '].');
        };
        // Do the actual call.
        var that = this;
        OpenLayers.Request.GET({
          url: that.url,
          params: that.params,
          scope: that,
          success: onSuccess,
          failure: onFailure
        });
      },
      synchronize : function(onSuccessCallback, onFailureCallback) {

        var onSuccess = function(request) {
          try {
            var needsSynchronization = false;
            var result = this.format.read(request.responseText,
                this.defaultOptions);

            var mapLayerIds = new Legato.Util.HashSet();
            var resultLayerIds = new Legato.Util.HashSet();

            var openLayerIds = Legato.OpenLayers.Map.Util
                .getLayerIds(Legato.OpenLayers.Map.Util
                    .getLayersWithoutLegatoIgnore(this.map.layers));

            for ( var i = 0; i < openLayerIds.length; i++) {
              mapLayerIds.add(openLayerIds[i]);
            }

            openLayerIds = Legato.OpenLayers.Map.Util
                .getLayerIds(Legato.OpenLayers.Map.Util
                    .getLayersWithoutLegatoIgnore(result.layers));

            for (i = 0; i < openLayerIds.length; i++) {
              resultLayerIds.add(openLayerIds[i]);
            }

            var filteredLayers = Legato.OpenLayers.Map.Util
                .getLayersWithoutLegatoIgnore(result.layers);

            var layer, layerId;

            for (i = 0; i < filteredLayers.length; i++) {
              layer = filteredLayers[i];
              layerId = Legato.Lang.ObjectUtils
                  .exists(layer.layerId) ? layer.layerId
                  : layer.name;
              if (!mapLayerIds.contains(layerId)) {
                needsSynchronization = true;
                this.map.addLayer(layer);
              }
            }

            filteredLayers = Legato.OpenLayers.Map.Util
                .getLayersWithoutLegatoIgnore(this.map.layers);

            for (i = 0; i < filteredLayers.length; i++) {
              layer = filteredLayers[i];
              layerId = Legato.Lang.ObjectUtils
                  .exists(layer.layerId) ? layer.layerId
                  : layer.name;
              if (!resultLayerIds.contains(layerId)) {
                needsSynchronization = true;
                this.map.removeLayer(layer);
              }
            }

            if (needsSynchronization) {
              this.map.events.triggerEvent("legato.refresh", {});
            }
            if(Legato.Lang.ObjectUtils.isFunction(onSuccessCallback)){
              onSuccessCallback();
            }
          } catch (e) {
            Legato.Util.Logger.getLogger().error(
                'Could not parse synchronize viewcontext response ['
                    + this.url + '] with params '
                    + this.params);
            throw e;
          }
        };

        var onFailure = function(request) {
          Legato.Util.Logger.getLogger().error(
              'Could not synchronize viewcontext [' + this.url
                  + '] with params ' + this.params);
          if(Legato.Lang.ObjectUtils.isFunction(onFailureCallback)){
            onFailureCallback();
          }
        };

        // Do the actual call.
        var that = this;
        OpenLayers.Request.GET({
          url: that.url,
          params: that.params,
          scope: that,
          success: onSuccess,
          failure: onFailure
        });
      },

      CLASS_NAME : 'Legato.Format.ExtendedWMCLoader'

    });

/**
 * Component: lf:ExtendedWMCLoader
 *
 * See also:
 * - <lf> namespace
 * - {<Legato.Format.ExtendedWMCLoader>}
 */

Legato.Format.ExtendedWMCLoader.Bean = Legato.Beans.Object.Extend(
    'Legato.Format.ExtendedWMCLoader',
    //
    Legato.Format.QName('ExtendedWMCLoader'),
    //
    {
      _constructor : Legato.Format.ExtendedWMCLoader,
      options : {
        /**
         * Element: map
         * {<ol:Map>} Target map.
         */
        map : OpenLayers.Map.Bean,
        /**
         * Element: url
         * {String} URL of the WMC file.
         */
        url : Legato.Lang.String,
        /**
         * Element: defaultOptions
         * {String {}} Default layer options.
         */
        defaultOptions : Legato.Lang['String{}'],
        /**
         * Element: zoomToBoundingBox
         * {Boolean}
         */
        zoomToBoundingBox : Legato.Lang.Boolean,
        /**
         * Element: resizeToWindow
         * {Boolean}
         */
        resizeToWindow : Legato.Lang.Boolean,
        /**
         * Element: createDefaultBaseLayer
         * {Boolean}
         */
        createDefaultBaseLayer : Legato.Lang.Boolean
      },
      afterInstancePopulated : function(instance) {
        instance.load();
      }
    });

/* BACK This is for backwards compatibility. */
Legato.Format.SuperWMCLoader = {};

Legato.Format.SuperWMCLoader.Bean = Legato.Beans.Object.Extend(
    'Legato.Format.ExtendedWMCLoader',
    //
    Legato.Format.QName('SuperWMCLoader'),
    //
    {
      _constructor : Legato.Format.ExtendedWMCLoader,
      options : {
        map : OpenLayers.Map.Bean,
        url : Legato.Lang.String,
        defaultOptions : Legato.Lang['String{}'],
        zoomToBoundingBox : Legato.Lang.Boolean,
        resizeToWindow : Legato.Lang.Boolean,
        createDefaultBaseLayer : Legato.Lang.Boolean
      },
      afterInstancePopulated : function(instance) {
        instance.load();
      }
    });

Legato.Format.ExtendedWMC.LayerFactory = Legato.Lang
    .Class({
      layerType : OpenLayers.Layer.Bean,
      initialize : function(layerType) {
        if (Legato.Lang.ObjectUtils.exists(layerType)) {
          this.layerType = layerType;
        }
      },
      createLayer : function(layerInfo, options, beanFactory) {
        var definition = {};
        definition.visibility = !layerInfo.hidden;
        if (layerInfo.queryable) {
          definition.queryable = true;
        }
        definition.name = layerInfo.name;
        definition.id = layerInfo.id;
        definition.layerId = Legato.Lang.ObjectUtils
            .exists(layerInfo.layerId) ? layerInfo.layerId
            : layerInfo.name;
        definition.title = layerInfo.title;
        definition.url = layerInfo.server.onlineResource;
        if (Legato.Lang.ObjectUtils
            .exists(layerInfo.minScaleDenominator)) {
          definition.minScale = layerInfo.minScaleDenominator;
        }
        if (Legato.Lang.ObjectUtils
            .exists(layerInfo.maxScaleDenominator)) {
          definition.maxScale = layerInfo.maxScaleDenominator;
        }
        if (layerInfo.srs.length > 0) {
          definition.projection = new OpenLayers.Projection(
              layerInfo.srs[0]);
        }
        if (Legato.Lang.ObjectUtils.exists(layerInfo.currentFormat)) {
          definition.format = layerInfo.currentFormat;
        }
        if (Legato.Lang.ObjectUtils.exists(layerInfo.currentStyle)) {
          definition.style = layerInfo.currentStyle.name;
          if (Legato.Lang.ObjectUtils
              .exists(layerInfo.currentStyle.legend
                  && layerInfo.currentStyle.legend.onlineResource)) {
            definition.legend = new Legato.Layer.Legend(
                layerInfo.currentStyle.legend.onlineResource);
          }
        }
        var name;
        if (options) {
          for (name in options) {
            if (options.hasOwnProperty(name)) {
              definition[name] = options[name];
            }
          }
        }
        if (layerInfo.extension) {
          for (name in layerInfo.extension) {
            if (layerInfo.extension.hasOwnProperty(name)) {
              definition[name] = layerInfo.extension[name];
            }
          }
        }
        this.populateLayerDefinition(definition, layerInfo, options,
            beanFactory);
        var beanDefinition = this.layerType.define(definition);
        return beanFactory.retrieveBean(beanDefinition);
      },
      populateLayerDefinition : function(definition, layerInfo, options,
          beanFactory) {

      }
    });

Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES = {};
Legato.Format.ExtendedWMC.registerDefaultLayerType = function(name, layerType) {
  Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES[name] = new Legato.Format.ExtendedWMC.LayerFactory(
      layerType);
};
Legato.Format.ExtendedWMC.registerDefaultLayerFactory = function(name,
    layerFactory) {
  Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES[name] = layerFactory;
};
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 */

/**
 * Class: Legato.Format.ExtendedWMC.Model
 * Models an OGC ViewContext. Important: not all attributes are added,
 * only those that are actually used in Legato, or
 * which are required according to the OGC WMC standard
 */
Legato.Format.ExtendedWMC.Model = OpenLayers.Class({

  /**
   * constructor
   */
  initialize : function() {
    this.layerList = [];
  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: id
   * {String} id of the view context (required)
   */
  id: null,

  /**
   * Property: version
   * {String} version of the view context (required)
   */
  version: null,

  /**
   * Property: boundingBox
   * {<Legato.Format.ExtendedWMC.Model.BoundingBox>} the geographic extent that should be presented by the client (required)
   */
  boundingBox: null,

  /**
   * Property: window
   * {<Legato.Format.ExtendedWMC.Model.Window>} the size in pixels of the map the Context document describes (optional)
   */
  window: null,

  /**
   * Property: title
   * {String} contains a human readable title of the Context (required)
   */
  title: null,

  /**
   * Property: extensions
   * {<Legato.Format.ExtendedWMC.Model.Extensions>} Non-standard extensions
   */
  extensions: null,

  /**
   * Property: layerList
   * {Array(<Legato.Format.ExtendedWMC.Model.Layer>)} list of all layers to build a required view (map)
   */
  layerList: null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model'
});

/**
 * Class: Legato.Format.ExtendedWMC.Model.BoundingBox
 * Bounding box with geo reference system
 */
Legato.Format.ExtendedWMC.Model.BoundingBox = OpenLayers.Class({

  /**
   * constructor
   */
  initialize : function() {

    //do nothing

  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: SRS
   * {String} spatial reference system (required)
   */
  SRS: null,

  /**
   * Property: bounds
   * {OpenLayers.Bounds} the bounds of the bounding box (left, bottom, right, top)
   */
  bounds: null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.BoundingBox'
});

/**
 * Class: Legato.Format.ExtendedWMC.Model.Window
 * Map Window information
 */
Legato.Format.ExtendedWMC.Model.Window = OpenLayers.Class({

  /**
   * constructor
   */
  initialize : function() {
    //do nothing

  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: width
   * {Integer} the width in pixels (required)
   */
  width: null,

  /**
   * Property: height
   * {Integer} the height in pixels (required)
   */
  height: null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.Window'
});

/**
 * Class: Legato.Format.ExtendedWMC.Model.Extensions
 * Holds non-standard extensions for the whole WMC model
 */
Legato.Format.ExtendedWMC.Model.Extensions = OpenLayers.Class({

  initialize : function() {

   //do nothing

  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: legato
   * {<Legato.Format.ExtendedWMC.Model.Extensions.Legato>} Extensions specific for Legato
   */
  legato : null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.Extensions'
});


/**
 * Class: Legato.Format.ExtendedWMC.Model.Extensions.Legato
 * Non-standard legato extensions
 */
Legato.Format.ExtendedWMC.Model.Extensions.Legato = OpenLayers.Class({

  initialize : function() {
   this.capabilities = [];
  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: capabilities
   * {Array(String)} A list of capabilities URIs
   */
  capabilities: null,

  /**
   * Property: minScale
   * {Float} The minimum scale where the layer should be displayed (optional)
   */
  minScale: null,

  /**
   * Property: maxScale
   * {Float} The maximum scale where the layer should be displayed (optional)
   */
  maxScale: null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.Extensions.Legato'
});


/**
 * Class: Legato.Format.ExtendedWMC.Model.Layer
 * Bean to store layer information
 */
Legato.Format.ExtendedWMC.Model.Layer = OpenLayers.Class({

  /**
   * constructor
   */
  initialize : function() {
    this.formatList = [];
    this.styleList = [];
    this.extension = {};
    this.srs = [];
  },

  toString : function() {
    result = this.CLASS_NAME;
    result += (this.name) ? ': ' + this.name : '';
    return result;
  },

  /**
   * Property: hidden
   * {Boolean} contains true if the layer should be hidden in the client result map (required)
   */
  hidden : null,

  /**
   * Property: queryable
   * {Boolean} contains true if the layer is set queryable (required)
   */
  queryable : null,

  /**
   * Property: server
   * {<Legato.Format.ExtendedWMC.Model.Layer.Server>} defining the service from which the named Layer may be requested
   */
  server : null,

  /**
   * Property: name
   * {String} The name of the selected layer (required)
   */
  name : null,

  /**
   * Property: title
   * {String} The title of the selected layer (required)
   */
  title : null,

  /**
   * Property: layerAbstract
   * {String} The abstract of the selected layer (optional)
   */
  layerAbstract : null,

  /**
   * Property: minScaleDenominator
   * {Float} The denominator (1:X) part of minimum scale where the layer should be displayed (optional)
   */
  minScaleDenominator: null,

  /**
   * Property: maxScaleDenominator
   * {Float} The denominator (1:X) part of maximum scale where the layer should be displayed (optional)
   */
  maxScaleDenominator: null,

  /**
   * Property: srs
   * {Array(String)} coordinate systems of the layer
   */
  srs : null,

  /**
   * Property: formatList
   * {Array(String)} A list of strings specifying the available image format for this layer. Image formats
   * should be expressed with MIME types as described in WMS 1.1.1 Specification.
   */
  formatList : null,

  /**
   * Property: styleList
   * {Array(Legato.Format.ExtendedWMC.Model.Layer.Style)} A list of styles.
   */
  styleList : null,

  /**
   * Property: currentFormat
   * {String} The currently selected format (included also in the formatList)
   */
  currentFormat : null,

  /**
   * Property: extension
   * A map of layer-specific extensions
   */
  extension : null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.Layer'
});

/**
 * Class: Legato.Format.ExtendedWMC.Model.Layer.Server
 * Server information
 */
Legato.Format.ExtendedWMC.Model.Layer.Server = OpenLayers.Class({

  /**
   * constructor
   */
  initialize : function() {
    //do nothing
  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: service
   * {String} the type of the service according to OGC interfaces, such as WMS, WFS. (required)
   */
  service : null,

  /**
   * Property: version
   * {String} Version number of the OGC interface specification which corresponds to the service (required)
   */
  version : null,

  /**
   * Property: title
   * {String} the title of the service (extracted from the Capabilities by the Context document creator) (optional)
   */
  title : null,

  /**
   * Property: onlineResource
   * {String} the link (URI) to the online resource (required)
   */
  onlineResource : null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.Layer.Server'
});


/**
 * Class: Legato.Format.ExtendedWMC.Model.Layer.Style
 * Style information.
 */
Legato.Format.ExtendedWMC.Model.Layer.Style = OpenLayers.Class({

  /**
   * constructor
   */
  initialize : function() {
    //do nothing
  },

  toString : function() {
    return this.CLASS_NAME;
  },

  /**
   * Property: name
   * {String} name of the style.
   */
  name : null,

  /**
   * Property: title of the style
   * {String} title of the style.
   */
  title : null,

  /**
   * Property: abstract of the style
   * {String} abstract of the style.
   */
  styleAbstract: null,

  /**
   * Property: abstract of the style
   * {String} abstract of the style.
   */
  legendURL: null,

  CLASS_NAME : 'Legato.Format.ExtendedWMC.Model.Layer.Style'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 * @requires Legato.Format.ExtendedWMC.Model
 */

/**
 * Class: Legato.Format.ExtendedWMC.Parser
 * Parser for ExtendedWMC XML documents
 *
 * Inherits from:
 * - <OpenLayers.Format.XML>
 */
Legato.Format.ExtendedWMC.Parser = OpenLayers.Class(OpenLayers.Format.XML, {

    layerFactories: Legato.Format.ExtendedWMC.DEFAULT_LAYER_FACTORIES,

    /**
     * Mapping of namespace aliases to namespace URIs.
     */
    namespaces: {
        ol: "http://openlayers.org/context",
        l:  "http://www.disy.net/legato/extensions",
        lb:  "http://www.disy.net/legato/beans",
        wmc: "http://www.opengis.net/context",
        sld: "http://www.opengis.net/sld",
        xlink: "http://www.w3.org/1999/xlink",
        xsi: "http://www.w3.org/2001/XMLSchema-instance"
    },

    /**
     * Schema location for a particular minor version.
     */
    schemaLocation: "",

    /**
     * Get the namespace prefix for a given uri from the <namespaces> object.
     *
     * Parameters:
     * uri - {String} namespace uri
     *
     * Returns:
     * {String} A namespace prefix or null if none found.
     */
    getNamespacePrefix: function(uri) {
        var prefix = null;
        if(uri === null) {
            prefix = this.namespaces[this.defaultPrefix];
        } else {
            for(prefix in this.namespaces) {
                if(this.namespaces[prefix] == uri) {
                    break;
                }
            }
        }
        return prefix;
    },

    /**
     * Property: defaultPrefix
     * {String} Default prefix
     */
    defaultPrefix: "wmc",

    /**
     * Property: rootPrefix
     * {String} Prefix on the root node that maps to the context namespace URI.
     */
    rootPrefix: null,

    /**
     * Property: defaultStyleName
     * {String} Style name used if layer has no style param.  Default is "".
     */
    defaultStyleName: "",

    /**
     * Property: defaultStyleTitle
     * {String} Default style title.  Default is "Default".
     */
    defaultStyleTitle: "Default",

    /**
     * Constructor: initialize
     *
     * Parameters:
     *
     * options - {Object} An optional object whose properties will be set on this instance.
     */
    initialize: function(options) {
        OpenLayers.Format.XML.prototype.initialize.apply(this, [options]);
        if (Legato.Lang.ObjectUtils.isObject(options))
        {
          if (Legato.Lang.ObjectUtils.exists(options.layerFactories))
          {
            Legato.Util.Ensure.ensureObject(options.layerFactories);
            this.layerFactories = options.layerFactories;
          }
        }
    },

    /**
     * Property: beanFactory
     * {<Legato.Beans.XMLBeanFactory>} bean factory which will be used to parse extensions.
     */
    beanFactory: null,

    setBeanFactory: function(beanFactory)
    {
      Legato.Util.Ensure.ensureObject(beanFactory);
      this.beanFactory = beanFactory;
    },

    getBeanFactory: function()
    {
      if (this.beanFactory === null)
      {
        this.beanFactory = new Legato.Beans.XMLBeanFactory();
      }
      return this.beanFactory;
    },

    getLayerType: function(service)
    {
      Legato.Util.Ensure.ensureString(service);
      var layerFactory = this.layerFactories[service];
      Legato.Util.Ensure.ensureExists(layerFactory, 'Could not find the layer factory for service [' + service + '].');
      Legato.Util.Ensure.ensureExists(layerFactory.layerType, 'Layer factory for service [' + service + '] does not deliver a layer type.');
      return layerFactory.layerType;
    },

    /**
     * Function: read
     * Read capabilities data from a string, and returns a Legato.Format.ExtendedWMC.Model
     *
     * Parameters:
     * data - {String} or {DOMElement} data to read/parse.
     *
     * Returns:
     * {<Legato.Format.ExtendedWMC.Model>} the parsed model
     */
    read: function(data) {
        if(typeof data == "string") {
          var format = new OpenLayers.Format.XML();
          data = format.read(data);
          //data = OpenLayers.Format.XML.prototype.read.apply(this, [data]);
        }
        var root = data.documentElement;

        if(root === null){
          throw new Legato.Lang.Exception('ViewContext seems to be empty');
        }

        if(root.nodeName !== 'ViewContext'){
          throw new Legato.Lang.Exception('ViewContext seems to be incorrect. First node element must be named ViewContext');
        }

        this.rootPrefix = root.prefix;
        var model = new Legato.Format.ExtendedWMC.Model();
        model.id = root.getAttribute("id");
        model.version = root.getAttribute("version");
        this.runChildNodes(model, root);
        return model;
    },

    /**
     * Recursively process children of a node
     *
     * Parameters:
     * model - {Legato.Format.ExtendedWMC.Model} the model object
     * node - {DOMElement} the current XML node
     */
    runChildNodes: function(model, node) {
        var children = node.childNodes;
        var childNode, processor, prefix, local;
        for(var i=0, len=children.length; i<len; ++i) {
            childNode = children[i];
            if(childNode.nodeType == 1) {
                prefix = this.getNamespacePrefix(childNode.namespaceURI);
                local = childNode.nodeName.split(":").pop();
                processor = this["read_" + prefix + "_" + local];
                if(processor) {
                    processor.apply(this, [model, childNode]);
                }
            }
        }
    },

    /**
     * Internal methods to parse XML elements
     */

    read_wmc_General: function(model, node) {
        this.runChildNodes(model, node);
    },


    read_wmc_BoundingBox: function(model, node) {
      var SRS = node.getAttribute("SRS");
      if (SRS) {
        var bb = new Legato.Format.ExtendedWMC.Model.BoundingBox();
        model.boundingBox = bb;
        bb.SRS = SRS;
        bb.bounds = new OpenLayers.Bounds(
            parseFloat(node.getAttribute("minx")),
            parseFloat(node.getAttribute("miny")),
            parseFloat(node.getAttribute("maxx")),
            parseFloat(node.getAttribute("maxy"))
        );
      }
    },

    read_wmc_LayerList: function(model, node) {
        model.layers = [];
        this.runChildNodes(model, node);
    },

    read_wmc_Layer: function(model, node) {
      var l = new Legato.Format.ExtendedWMC.Model.Layer();
      model.layerList.push(l);
      l.hidden = (node.getAttribute("hidden") == "1");
      l.queryable = (node.getAttribute("queryable") == "1");
      var id = node.getAttribute("id");
      this.runChildNodes(l, node);
      if (Legato.Lang.ObjectUtils.isString(id))
      {
        l.layerId = id;
      }
      else
      {
        l.layerId = l.name;
      }
    },

    read_wmc_Extension: function(obj, node) {
      if (obj.CLASS_NAME && obj.CLASS_NAME === 'Legato.Format.ExtendedWMC.Model.Layer') {
        this.runChildNodes(obj, node);
      } else if (obj.CLASS_NAME && obj.CLASS_NAME === 'Legato.Format.ExtendedWMC.Model') {
        this.runChildNodes(obj, node);
      }
    },

    read_l_Extension: function(obj, node) {
      var beanFactory = this.getBeanFactory();
      var extension;
      if (obj.CLASS_NAME && obj.CLASS_NAME === 'Legato.Format.ExtendedWMC.Model.Layer') {
        var layerInfo = obj;
        var service = layerInfo.server.service;
        var layerType = this.getLayerType(service);
        extension = beanFactory.retrieveBeanFromElement(node, layerType.Components());
        layerInfo.extension = extension;
      }
      else if (obj.CLASS_NAME && obj.CLASS_NAME === 'Legato.Format.ExtendedWMC.Model') {
        var model = obj;
        extension = beanFactory.retrieveBeanFromElement(node, OpenLayers.Map.Bean.Components());
        model.extension = extension;
      }
    },

    read_lb_beans: function(obj, node) {
      var beanFactory = this.getBeanFactory();
      var beans = beanFactory.retrieveBeansFromElement(node);
      obj.beans = beans;
    },

    read_ol_units: function(layerInfo, node) {
      layerInfo.extension.units = this.getChildValue(node);
    },

    read_ol_maxExtent: function(layerInfo, node) {
      var bounds = new OpenLayers.Bounds(
          node.getAttribute("minx"), node.getAttribute("miny"),
          node.getAttribute("maxx"), node.getAttribute("maxy")
      );
      layerInfo.extension.maxExtent = bounds;
    },
    read_ol_minExtent: function(layerInfo, node) {
      var bounds = new OpenLayers.Bounds(
          node.getAttribute("minx"), node.getAttribute("miny"),
          node.getAttribute("maxx"), node.getAttribute("maxy")
      );
      layerInfo.extension.minExtent = bounds;
    },
    read_ol_transparent: function(layerInfo, node) {
      if (!layerInfo.extension.params)
      {
        layerInfo.extension.params = {};
      }
      layerInfo.extension.params.TRANSPARENT = this.getChildValue(node);
    },

    read_ol_numZoomLevels: function(layerInfo, node) {
      layerInfo.extension.numZoomLevels = parseInt(this.getChildValue(node), 10);
    },

    read_ol_opacity: function(layerInfo, node) {
      layerInfo.extension.opacity = parseFloat(this.getChildValue(node));
    },

    read_ol_singleTile: function(layerInfo, node) {
      layerInfo.extension.singleTile = (this.getChildValue(node) == "true");
    },

    read_ol_isBaseLayer: function(layerInfo, node) {
      layerInfo.extension.isBaseLayer = (this.getChildValue(node) == "true");
    },

    read_ol_displayInLayerSwitcher: function(layerInfo, node) {
      layerInfo.extension.displayInLayerSwitcher = (this.getChildValue(node) == "true");
    },
    read_wmc_Server: function(layerInfo, node) {
      if (layerInfo.server === null) {
        layerInfo.server = new Legato.Format.ExtendedWMC.Model.Layer.Server();
      }
      layerInfo.server.version = node.getAttribute("version");
      layerInfo.server.service = node.getAttribute("service");
      layerInfo.server.title = node.getAttribute("title");
      this.runChildNodes(layerInfo.server, node);
    },

    read_wmc_FormatList: function(layerInfo, node) {
      this.runChildNodes(layerInfo, node);
    },

    read_wmc_Format: function(layerInfo, node) {
        var format = this.getChildValue(node);
        layerInfo.formatList.push(format);
        if(node.getAttribute("current") == "1") {
            layerInfo.currentFormat = format;
        }
    },

    read_wmc_StyleList: function(layerInfo, node) {
        this.runChildNodes(layerInfo, node);
    },

    read_wmc_Style: function(layerInfo, node) {
        var style = new Legato.Format.ExtendedWMC.Model.Layer.Style();
        this.runChildNodes(style, node);
//        if(node.getAttribute("current") == "1") {
//            // three style types to consider
//            // 1) linked SLD
//            // 2) inline SLD
//            // 3) named style
//            // running child nodes always gets name, optionally gets href or body
//            if(style.href) {
//                layerInfo.params.sld = style.href;
//            } else if(style.body) {
//                layerInfo.params.sld_body = style.body;
//            } else {
//                layerInfo.params.styles = style.name;
//            }
//        }
        layerInfo.styleList.push(style);
        if(node.getAttribute("current") == "1") {
          layerInfo.currentStyle = style;
      }
    },


     //TODO Implement me later
     /*
    read_wmc_SLD: function(style, node) {
        this.runChildNodes(style, node);
        // style either comes back with an href or a body property
    },
    */


     //TODO Implement me later
     /*
    read_sld_StyledLayerDescriptor: function(sld, node) {
        var xml = OpenLayers.Format.XML.prototype.write.apply(this, [node]);
        sld.body = xml;
    },
    */

    read_wmc_OnlineResource: function(obj, node) {
      obj.onlineResource = this.getAttributeNS(
          node, this.namespaces.xlink, "href"
      );
    },

    read_wmc_Name: function(obj, node) {
        var name = this.getChildValue(node);
        if(name) {
            obj.name = name;
        }
    },

    read_wmc_Title: function(obj, node) {
        var title = this.getChildValue(node);
        if(title) {
            obj.title = title;
        }
    },

     // TODO Implement me later
     /*
    read_wmc_MetadataURL: function(layerInfo, node) {
        var metadataURL = {};
        var links = node.getElementsByTagName("OnlineResource");
        if(links.length > 0) {
            this.read_wmc_OnlineResource(metadataURL, links[0]);
        }
        layerInfo.options.metadataURL = metadataURL.href;

    },
    */

    read_wmc_Abstract: function(obj, node) {
        var abst = this.getChildValue(node);
        if(abst) {
          if (obj.CLASS_NAME && obj.CLASS_NAME == 'Legato.Format.ExtendedWMC.Model.Layer') {
            obj.layerAbstract = abst;
          }
          else if (obj.CLASS_NAME && obj.CLASS_NAME == 'Legato.Format.ExtendedWMC.Model.Layer.Style') {
            obj.styleAbstract = abst;
          }
        }
    },

    read_wmc_SRS: function(obj, node) {
      var srs = this.getChildValue(node);
      if(srs) {
        if (obj.CLASS_NAME && obj.CLASS_NAME === 'Legato.Format.ExtendedWMC.Model.Layer') {
          obj.srs.push(srs);
        }
      }
    },

    read_wmc_Window: function(model, node) {
      if (model.window === null) {
        model.window = new Legato.Format.ExtendedWMC.Model.Window();
      }
      model.window.width = parseInt(node.getAttribute("width"), 10);
      model.window.height = parseInt(node.getAttribute("height"), 10);
    },

    // TODO Implement me later
     /*
    read_wmc_LatLonBoundingBox: function(layer, node) {
        layer.llbbox = [
            parseFloat(node.getAttribute("minx")),
            parseFloat(node.getAttribute("miny")),
            parseFloat(node.getAttribute("maxx")),
            parseFloat(node.getAttribute("maxy"))
        ];
    },*/

    read_wmc_LegendURL: function(style, node) {
        var legend = {
            width: node.getAttribute('width'),
            height: node.getAttribute('height'),
            format: node.getAttribute('format')
        };
        this.runChildNodes(legend, node);
        style.legend = legend;
    },

    read_sld_MinScaleDenominator: function(layerInfo, node) {
      var minScale = this.getChildValue(node);
      if (minScale) {
        layerInfo.minScaleDenominator = parseFloat(minScale);
      }
    },

    read_sld_MaxScaleDenominator: function(layerInfo, node) {
      var maxScale = this.getChildValue(node);
      if (maxScale) {
        layerInfo.maxScaleDenominator = parseFloat(maxScale);
      }
    },

    /**
     * It is not implemented, it is only a parser!
     */
    write: function(context, options) {
      OpenLayers.Console.userError(OpenLayers.i18n("writeNotImplemented"));
    },

    CLASS_NAME: "Legato.Format.ExtendedWMC.Parser"

});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Layer.Image.Bean = OpenLayers.Layer.Bean.Extend(
  'OpenLayers.Layer.Image',
  Legato.OpenLayers.Layer.QName('Image'),
  {
    //_constructor :OpenLayers.Layer.Image,
    factoryFunction:function(name, url, options)
    {
      // Ensure that no port 80 is added, otherwise when using https this leads to an URL that
      // mixes https and port 80...
      var urlObject = OpenLayers.Util.createUrlObject(url, {ignorePort80: true});
      urlObject.args.w = options.size.w;
      urlObject.args.h = options.size.h;

      url = Legato.Util.getUrlString(urlObject);

      OpenLayers.Console.debug(url);

      options.isBaseLayer = true;
      options.visibility = true;

      var layer = new OpenLayers.Layer.Image(
        name,
        url,
        options.extent,
        options.size,
        options
      );
      return layer;
    },
    constructorArguments : {
      name :Legato.Lang.String,
      url :Legato.Lang.String
    },
    constructorOrder : [ 'name', 'url' ],
    options : {
      size: OpenLayers.Size.Bean,
      extent :OpenLayers.Bounds.Bean
    }
  }
);

OpenLayers.Layer.Image.LayerFactory = Legato.Lang.Class(
  Legato.Format.ExtendedWMC.LayerFactory,
  {
    layerType : OpenLayers.Layer.Image.Bean
  }
);

Legato.Format.ExtendedWMC.registerDefaultLayerFactory(
  'OpenLayer:Image',
  new OpenLayers.Layer.Image.LayerFactory()
);
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: oll:Markers
 * 
 * Inherits from:
 * - {<oll:Layer>}
 * 
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.Markers>}
 */
OpenLayers.Layer.Markers.Bean = OpenLayers.Layer.Bean.Extend(
		'OpenLayers.Layer.Markers',
		//
		Legato.OpenLayers.Layer.QName('Markers'),
		//
		{
			factoryFunction : function(name, options) {
				if (!Legato.Lang.ObjectUtils.exists(options)) {
					options = {};
				}
				options.isBaseLayer = false;

				return new OpenLayers.Layer.Markers(name, options);
			},
			constructorArguments : {
				/**
				 * Element: name
				 * {String}
				 */
				name : Legato.Lang.String
			},
			constructorOrder : [ 'name' ],
			properties : {
				/**
				 * Element: markers
				 * {Object []}
				 */
				markers : new Legato.Beans.Property(Legato.Beans['Object[]'],
						function(layer, markers) {
							Legato.Util.Ensure.ensureArray(markers);
							for ( var index = 0; index < markers; index++) {
								layer.addControls(markers[index]);
							}
						})
			}
		});

/**
 * Layer type: OL:Markers
 * 
 * See also:
 * - {<oll:Markers>}
 * - {<OpenLayers.Layer.Markers>}
 * 
 */
OpenLayers.Layer.Markers.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : OpenLayers.Layer.Markers.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OL:Markers',
		new OpenLayers.Layer.Markers.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: oll:GeoRSS
 *
 * Inherits from:
 * - {<oll:Markers>}
 *
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.GeoRSS>}
 */
OpenLayers.Layer.GeoRSS.Bean = OpenLayers.Layer.Markers.Bean.Extend(
    'OpenLayers.Layer.GeoRSS',
    //
    Legato.OpenLayers.Layer.QName('GeoRSS'),
    //
    {
      factoryFunction : function(name, url, options) {
        if (!Legato.Lang.ObjectUtils.exists(options)) {
          options = {};
        }

        options.isBaseLayer = false;

        return new OpenLayers.Layer.GeoRSS(name, url, options);
      },
      constructorArguments : {
        /**
         * Element: name
         * {String}
         */
        name : Legato.Lang.String,
        /**
         * Element: url
         * {String}
         */
        url : Legato.Lang.String
      },
      options : {

        /**
         * Element: icon
         * {<ol:Icon>}
         */
        icon : Legato.Beans.Object,

        /**
         * Element: popupSize
         * {<ol:Size>}
         */
        popupSize : OpenLayers.Size.Bean,

        /**
         * Element: useFeedTitle
         * {Boolean}
         */
        useFeedTitle : Legato.Lang.Boolean,

        /**
         * Element: formatOptions
         */
        formatOptions : Legato.Beans.Object
      },
      constructorOrder : [ 'name', 'url' ]
    });

/**
 * Layer type: OL:GeoRSS
 *
 * See also:
 * - {<oll:GeoRSS>}
 * - {<OpenLayers.Layer.GeoRSS>}
 *
 * WMC example:
 * (start code)
 * <Layer hidden="0" queryable="0">
 *   <Server service="OL:GeoRSS" title="OL:GeoRSS">
 *     <OnlineResource xlink:type="simple" xlink:href="georss.xml" />
 *   </Server>
 *   <Name>GeoRSS</Name>
 *   <Title>GeoRSS Layer</Title>
 *   <Extension>
 *     <le:Extension xmlns="">
 *       <popupSize>
 *         <ol:Size w="200" h="100"/>
 *       </popupSize>
 *       <icon>
 *         <ol:Icon url="pin.png">
 *           <offset>
 *             <ol:Pixel x="10" y="20"/>
 *           </offset>
 *           <size>
 *             <ol:Size w="30" h="40"/>
 *           </size>
 *         </ol:Icon>
 *       </icon>
 *     </le:Extension>
 *   </Extension>
 * </Layer>
 * (end)
 */
OpenLayers.Layer.GeoRSS.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
  layerType : OpenLayers.Layer.GeoRSS.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OL:GeoRSS',
    new OpenLayers.Layer.GeoRSS.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: oll:Grid
 * 
 * Inherits from:
 * - {<oll:Layer>}
 * 
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.Grid}
 */
OpenLayers.Layer.Grid.Bean = OpenLayers.Layer.Bean.Extend(
		'OpenLayers.Layer.Grid',
		//
		Legato.OpenLayers.Layer.QName('Grid'),
		//
		{
			_constructor : OpenLayers.Layer.Grid,
			constructorArguments : {
				/**
				 * Element: name
				 * {String}
				 */
				name : Legato.Lang.String,
				/**
				 * Element: url
				 * {String}
				 */
				url : Legato.Lang.String,
				/**
				 * Element: params
				 * {String {}}
				 */
				params : Legato.Lang['String{}']
			},
			constructorOrder : [ 'name', 'url', 'params' ],
			options : {
				/**
				 * Element: tileSize
				 * {<ol:Size>}
				 */
				tileSize : OpenLayers.Size.Bean,
				/**
				 * Element: singleTile
				 * {Boolean}
				 */
				singleTile : Legato.Lang.Boolean,
				/**
				 * Element: ratio
				 * {Number}
				 */
				ratio : Legato.Lang.Number,
				/**
				 * Element: buffer
				 * {Integer}
				 */
				buffer : Legato.Lang.Integer
			}
		});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Hack
/*
OpenLayers.Layer.Vector.prototype.EVENT_TYPES.push('legato.sketchpointadded');
OpenLayers.Layer.Vector.prototype.EVENT_TYPES.push('legato.sketchupdated');
*/
/**
 * Component: oll:Vector
 *
 * Used to render vector data from a variety of sources.
 * 
 * Inherits from:
 * - {<oll:Layer>}
 * 
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.Vector>}
 */
OpenLayers.Layer.Vector.Bean = OpenLayers.Layer.Bean.Extend(
		'OpenLayers.Layer.Vector',
		//
		Legato.OpenLayers.Layer.QName('Vector'),
		//
		{
			_constructor : OpenLayers.Layer.Vector,
			constructorArguments : {
				/**
				 * Element: name
				 * {String}
				 */
				name : Legato.Lang.String
			},
			constructorOrder : [ 'name' ],
			options : {
				/**
				 * Element: isFixed
				 * {Boolean} Whether the layer remains in one place while dragging the map.
				 */
				isFixed : Legato.Lang.Boolean,
				/**
				 * Element: isVector
				 * {Boolean} Whether the layer is a vector layer.
				 */
				isVector : Legato.Lang.Boolean,
				/**
				 * Element: features
				 * {Object []}
				 */
				features : Legato.Beans['Object[]'],
				/**
				 * Element: reportError
				 * {Boolean} Report friendly error message when loading of renderer fails.
				 */
				reportError : Legato.Lang.Boolean,
				/**
				 * Element: style
				 * {Object} Default style for the layer
				 */
				style: Legato.Lang['String{}'],
			    /**
			     * Element: rendererOptions
			     * {Object} Options for the renderer. See {<OpenLayers.Renderer>} for supported options.
			     */
				rendererOptions : Legato.Beans.Object,
				/**
				 * Element: geometryType
				 * {String} Allows limiting the types of geometries this layer supports. This should be set to something like "OpenLayers.Geometry.Point" to limit types.
				 */
				geometryType : Legato.Lang.String
			}
		});

OpenLayers.Layer.Vector.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : OpenLayers.Layer.Vector.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OL:Vector',
		new OpenLayers.Layer.Vector.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: oll:WMS
 * 
 * Inherits from:
 * - {<oll:Grid>}
 * 
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.WMS}}
 * - <OGC:WMS> layer type
 */
OpenLayers.Layer.WMS.Bean = OpenLayers.Layer.Grid.Bean
		.Extend('OpenLayers.Layer.WMS',
		//
		Legato.OpenLayers.Layer.QName('WMS'),
				//
				{
					factoryFunction : function(name, url, params, options) {
						if (!Legato.Lang.ObjectUtils.exists(params)) {
							params = {};
						}
						if (!Legato.Lang.ObjectUtils.exists(options)) {
							options = {};
						}
						if (!Legato.Lang.ObjectUtils.exists(params.LAYERS)) {
							params.LAYERS = name;
						}
						if (!Legato.Lang.ObjectUtils.exists(params.TRANSPARENT)
								&& Legato.Lang.ObjectUtils
										.exists(options.transparent)) {
							params.TRANSPARENT = options.transparent ? 'TRUE'
									: 'FALSE';
							delete options.transparent;
						}
						if (!Legato.Lang.ObjectUtils.exists(params.EXCEPTIONS)
								&& Legato.Lang.ObjectUtils
										.exists(options.exceptions)) {
							params.EXCEPTIONS = options.exceptions;
							delete options.exceptions;
						}
						if (!Legato.Lang.ObjectUtils.exists(params.FORMAT)
								&& Legato.Lang.ObjectUtils
										.exists(options.format)) {
							params.FORMAT = options.format;
							delete options.format;
						}

						return new OpenLayers.Layer.WMS(name, url, params,
								options);
					},
					constructorArguments : {
						/**
						 * Element: name
						 * {String}
						 */
						name : Legato.Lang.String,
						/**
						 * Element: url
						 * {String}
						 */
						url : Legato.Lang.String,
						/**
						 * Element: params
						 * {String {}}
						 */
						params : Legato.Lang['String{}']
					},
					constructorOrder : [ 'name', 'url', 'params' ],
					options : {
						/**
						 * Element: reproject
						 * {Boolean}
						 */
						reproject : Legato.Lang.Boolean,
						/**
						 * Element: encodeBBOX
						 * {Boolean}
						 */
						encodeBBOX : Legato.Lang.Boolean,
						/**
						 * Element: transparent
						 * {Boolean}
						 */
						transparent : Legato.Lang.Boolean,
						/**
						 * Element: exceptions
						 * {String}
						 */
						exceptions : Legato.Lang.String,
						/**
						 * Element: format
						 * {String}
						 */
						format : Legato.Lang.String,
						/**
						 * Element: style
						 * {String}
						 */
						style : Legato.Lang.String
					},
					afterInstancePopulated : function(layer) {
						if (!Legato.Lang.ObjectUtils.isObject(layer.params)) {
							layer.params = {};
						}
						if (!Legato.Lang.ObjectUtils
								.exists(layer.params.LAYERS)) {
							layer.params.LAYERS = layer.name;
						}
					}
				});

/**
 * Layer type: OGC:WMS
 * 
 * See also:
 * - {<oll:WMS>}
 * - {<OpenLayers.Layer.WMS>}
 * 
 * WMC example:
 * (start code)
 * <Layer queryable="0" hidden="0">                                                                       
 *   <Server service="OGC:WMS" version="1.1.1" title="OGC:WMS">                                           
 *     <OnlineResource xlink:type="simple" xlink:href="http://maps.opengeo.org/geowebcache/service/wms" />
 *   </Server>                                                                                            
 *   <Name>bluemarble</Name>                                                                              
 *   <Title>Blue Marble</Title>                                                                           
 *   <FormatList>                                                                                         
 *     <Format current="0">image/png</Format>                                                             
 *   </FormatList>                                                                                        
 * </Layer>                                                                                               
 * (end)
 */
OpenLayers.Layer.WMS.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : OpenLayers.Layer.WMS.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OGC:WMS',
		new OpenLayers.Layer.WMS.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Layer.WFS.Bean = OpenLayers.Layer.Vector.Bean.Extend(
    'OpenLayers.Layer.WFS',
    //
    Legato.OpenLayers.Layer.QName('WFS'),
    //
    {
      factoryFunction : function(name, url, params, options) {
        if (!Legato.Lang.ObjectUtils.exists(params)) {
          params = {};
        }
        if (!Legato.Lang.ObjectUtils.exists(options)) {
          options = {};
        }
        if (!Legato.Lang.ObjectUtils.exists(params.MAXFEATURES)
            && Legato.Lang.ObjectUtils.exists(options.maxFeatures)) {
          params.MAXFEATURES = options.maxFeatures;
          delete options.maxFeatures;
        }
        if (!Legato.Lang.ObjectUtils.exists(params.TYPENAME)) {
          params.TYPENAME = name;
        }

        return new OpenLayers.Layer.WFS(name, url, params, options);
      },
      constructorArguments : {
        name :Legato.Lang.String,
        url :Legato.Lang.String,
        params :Legato.Lang['String{}']
      },
      constructorOrder : [ 'name', 'url', 'params' ],
      options : {
        maxFeatures: Legato.Lang.Integer
      }
    });

OpenLayers.Layer.WFS.LayerFactory = Legato.Lang.Class(
//
    Legato.Format.ExtendedWMC.LayerFactory,
    //
    {
      layerType :OpenLayers.Layer.WFS.Bean
    });

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OGC:WFS',
    new OpenLayers.Layer.WFS.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Hack
OpenLayers.Layer.GML.prototype.requestSuccess = function(request) {
	var doc = request.responseXML;

	if (!doc || !doc.documentElement) {
		doc = request.responseText;
	}

	var options = {};

	OpenLayers.Util.extend(options, this.formatOptions);
	if (this.map && !this.projection.equals(this.map.getProjectionObject())) {
		options.externalProjection = this.projection;
		options.internalProjection = this.map.getProjectionObject();
	}

	var gml;

	if (Legato.Lang.ObjectUtils.exists(this.format)) {
		if (Legato.Lang.ObjectUtils.isFunction(this.format)) {
			gml = new this.format(options);
		} else {
			gml = this.format;
		}
	} else {
		gml = new OpenLayers.Format.GML(options);
	}
	this.addFeatures(gml.read(doc));
	this.events.triggerEvent("loadend");
};

/**
 * Component: oll:GML
 *
 * Creates a vector layer by parsing a GML resource.
 * 
 * Inherits from:
 * - {<oll:Vector>}
 * 
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.Vector>}
 */
OpenLayers.Layer.GML.Bean = OpenLayers.Layer.Vector.Bean.Extend(
		'OpenLayers.Layer.GML',
		//
		Legato.OpenLayers.Layer.QName('GML'),
		//
		{
			_constructor : OpenLayers.Layer.GML,
			constructorArguments : {
				/**
				 * Element: name
				 * {String}
				 */
				name : Legato.Lang.String,
				/**
				 * Element: url
				 * {String}
				 */
				url : Legato.Lang.String
			},
			constructorOrder : [ 'name', 'url' ],
			options : {
				/**
				 * Element: format
				 * {<lf:Format>} The format you want the data to be parsed with.
				 */
				format : Legato.Beans.Object,
				/**
				 * Element: formatOptions
				 * {Object} Hash of options which should be passed to the format when it is created.
				 */
				formatOptions : Legato.Beans.Object
			}
		});

/**
 * Layer type: OGC:GML
 * 
 * See also:
 * - {<oll:GML>}
 * - {<OpenLayers.Layer.GML>}
 * 
 * WMC example:
 * (start code)
 * <Layer hidden="0" queryable="0">
 *   <Server service="OGC:GML" version="3.1.1">
 *     <OnlineResource xlink:href="gml.xml" xlink:type="simple" />
 *   </Server>
 *   <Name>GML</Name>
 *   <Title>GML Layer</Title>
 * </Layer>
 * (end)
 */
OpenLayers.Layer.GML.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : OpenLayers.Layer.GML.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OGC:GML',
		new OpenLayers.Layer.GML.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Layer.Yahoo.MapType = null;

if (typeof YAHOO_MAP_REG != 'undefined') {
OpenLayers.Layer.Yahoo.MapType = Legato.Lang.String.Enum(
    'OpenLayers.Layer.Yahoo.MapType', {
      normal : YAHOO_MAP_REG,
      satellite : YAHOO_MAP_SAT,
      hybrid : YAHOO_MAP_HYB
    });
} else {
  OpenLayers.Layer.Yahoo.MapType = Legato.Lang.String.Enum(
      'OpenLayers.Layer.Yahoo.MapType', {
        //empty
      });
}

OpenLayers.Layer.Yahoo.Bean = OpenLayers.Layer.Bean.Extend(
    'OpenLayers.Layer.Yahoo',
    //
    Legato.OpenLayers.Layer.QName('Yahoo'),
    //
    {
      //_constructor :OpenLayers.Layer.Yahoo,
      factoryFunction:function(name, options)
      {

        if (Legato.Lang.ObjectUtils.exists(options) &&
            !Legato.Lang.ObjectUtils.exists(options.sphericalMercator))
        {
          options.sphericalMercator = true;
        }
        var layer = new OpenLayers.Layer.Yahoo(name, options);
        return layer;
      },
      constructorArguments : {
        name :Legato.Lang.String
      },
      constructorOrder : [ 'name'],
      options : {
        type : OpenLayers.Layer.Yahoo.MapType,
        sphericalMercator :Legato.Lang.Boolean
      }
    });

OpenLayers.Layer.Yahoo.LayerFactory = Legato.Lang.Class(
//
    Legato.Format.ExtendedWMC.LayerFactory,
    //
    {
      layerType: OpenLayers.Layer.Yahoo.Bean
    }
);


Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OL:Yahoo', new OpenLayers.Layer.Yahoo.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * File: OpenLayers.Layer.ArcIMS support
 */

/*
 * Class: OpenLayers.Layer.ArcIMS.ArcIMSLayer
 * Represents information of an ArcIMS layer
 */
OpenLayers.Layer.ArcIMS.ArcIMSLayer = Legato.Lang.Class({
  /*
   * Property: id
   * {String} the id of the layer
   */
  id: null,

  /*
   * Property: visible
   * {Boolean} whether the layer is visible
   */
  visible: true,

  initialize : function() {
    //do nothing
  },

  toString: function(){
    return this.CLASS_NAME + ': id:' + this.id;
  },

  CLASS_NAME: 'OpenLayers.Layer.ArcIMS.ArcIMSLayer'

});

/*
 * Class: OpenLayers.Layer.ArcIMS.Background
 * Represents the background color of ArcIMS layers
 */
OpenLayers.Layer.ArcIMS.Background = Legato.Lang.Class({
  /*
   * Property: color
   * {<Legato.Lang.RGBColor>} the background color
   */
  color: null,

  /*
   * Property: transcolor
   * {<Legato.Lang.RGBColor>} the transparent color
   */
  transcolor: null,
  initialize : function() {
    //do nothing
  },
  toString: function(){
    return this.CLASS_NAME;
  },

  CLASS_NAME: 'OpenLayers.Layer.ArcIMS.Background'

});


OpenLayers.Layer.ArcIMS.NAMESPACE_URI = 'http://www.disy.net/legato/arcims';
OpenLayers.Layer.ArcIMS.PREFIX = 'ai';

OpenLayers.Layer.ArcIMS.QName = function(localPart) {
  return new Legato.XML.QName(OpenLayers.Layer.ArcIMS.NAMESPACE_URI, localPart,
      OpenLayers.Layer.ArcIMS.PREFIX);
};

/*
 * Structure: ai:ArcIMSLayer
 * XML based config for a <OpenLayers.Layer.ArcIMS.ArcIMSLayer>.
 *
 * See Also:
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for an ArcIMSLayer would be:
 * (start code)
 * <ai:ArcIMSLayer id="1" visible="true" />
 * (end)
 */
OpenLayers.Layer.ArcIMS.ArcIMSLayer.Bean = Legato.Beans.Object.Extend('OpenLayers.Layer.ArcIMS.ArcIMSLayer',
//
    OpenLayers.Layer.ArcIMS.QName('ArcIMSLayer'),
    //
    {
      _constructor :OpenLayers.Layer.ArcIMS.ArcIMSLayer,
      constructorArguments : {
      },
      constructorOrder : [],
      fields : {
        /*
         * Property: id
         * {String} the id of the layer
         */
        id : Legato.Lang.String,

        /*
         * Property: visible
         * {Boolean} whether the layer is visible
         */
        visible : Legato.Lang.Boolean
      }
    });

/*
 * Structure: ai:Background
 * XML based config for a <OpenLayers.Layer.ArcIMS.Background>.
 *
 * See Also:
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a Background would be:
 * (start code)
 * <ai:Background>
 *   <color><ll:RGBColor r="255" g="255" b="255" /></color>
 *   <transcolor><ll:RGBColor r="255" g="255" b="255" /></transcolor>
 * </ai:Background>
 * (end)
 */
OpenLayers.Layer.ArcIMS.Background.Bean = Legato.Beans.Object.Extend('OpenLayers.Layer.ArcIMS.Background',
    //
        OpenLayers.Layer.ArcIMS.QName('Background'),
        //
        {
          _constructor :OpenLayers.Layer.ArcIMS.Background,
          constructorArguments : {
          },
          constructorOrder : [],
          fields : {
            /*
             * Property: color
             * {<Legato.Lang.RGBColor>} the background color
             */
            color : Legato.Lang.RGBColor,

            /*
             * Property: transcolor
             * {<Legato.Lang.RGBColor>} the transparent color
             */
            transcolor : Legato.Lang.RGBColor
          }
        });


/*
 * Structure: ESRI:ArcIMS extensions
 * XML based config for <OpenLayers.Layer.ArcIMS> extensions (service type: "ESRI:ArcIMS)".
 *
 * See Also:
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a Background would be:
 * (start code)
 * <Extension>
 *   <le:Extension xmlns="">
 *     <isBaseLayer>false</isBaseLayer>
 *      <background>
 *        <ai:Background>
 *          <color><ll:RGBColor r="255" g="255" b="255" /></color>
 *          <transcolor><ll:RGBColor r="255" g="255" b="255" /></transcolor>
 *        </ai:Background>
 *      </background>
 *      <layers>
 *        <ai:ArcIMSLayer id="1" visible="true" />
 *      </layers>
 *   </le:Extension>
 * </Extension>
 * (end)
 */
OpenLayers.Layer.ArcIMS.Bean = OpenLayers.Layer.Grid.Bean.Extend(
    'OpenLayers.Layer.ArcIMS',
    //
    Legato.OpenLayers.Layer.QName('ArcIMS'),
    //
    {
      //_constructor :OpenLayers.Layer.ArcIMS,
      factoryFunction:function(name, url, options)
      {
        if (Legato.Lang.ObjectUtils.exists(options) &&
            !Legato.Lang.ObjectUtils.exists(options.serviceName))
        {
          options.serviceName = name;
        }
        var layer = new OpenLayers.Layer.ArcIMS(name, url, options);
        return layer;
      },
      constructorArguments : {
        name :Legato.Lang.String,
        url :Legato.Lang.String
      },
      constructorOrder : [ 'name', 'url' ],
      options : {
        /*
         * Property: serviceName
         * {String} the name of the service (per default is the layer name)
         */
        serviceName :Legato.Lang.String,
        reproject :Legato.Lang.Boolean,
        encodeBBOX :Legato.Lang.Boolean,
        //transparent :Legato.Lang.Boolean,
        background: OpenLayers.Layer.ArcIMS.Background.Bean,
        featureCoordSys :Legato.Lang.String,
        filterCoordSys :Legato.Lang.String,
        layers : OpenLayers.Layer.ArcIMS.ArcIMSLayer.Bean.List(),
        async :Legato.Lang.Boolean
      }
    });

OpenLayers.Layer.ArcIMS.LayerFactory = Legato.Lang.Class(
//
    Legato.Format.ExtendedWMC.LayerFactory,
    //
    {
      layerType : OpenLayers.Layer.ArcIMS.Bean
    });

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('ESRI:ArcIMS',
    new OpenLayers.Layer.ArcIMS.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Layer.Google.MapType = null;

if (typeof G_NORMAL_MAP != 'undefined') {
  OpenLayers.Layer.Google.MapType = Legato.Beans.Object.Enum(
    'OpenLayers.Layer.Google.MapType', {
      normal : G_NORMAL_MAP,
      satellite : G_SATELLITE_MAP,
      hybrid : G_HYBRID_MAP
    });
} else {
  OpenLayers.Layer.Google.MapType = Legato.Beans.Object.Enum(
      'OpenLayers.Layer.Google.MapType', {
        // empty
      });
}

OpenLayers.Layer.Google.Bean = OpenLayers.Layer.Bean.Extend(
    'OpenLayers.Layer.Google',
    //
    Legato.OpenLayers.Layer.QName('Google'),
    //
    {
      //_constructor :OpenLayers.Layer.Google,
      factoryFunction : function(name, options) {

        if (Legato.Lang.ObjectUtils.exists(options)
            && !Legato.Lang.ObjectUtils.exists(options.sphericalMercator)) {
          options.sphericalMercator = true;
        }
        var layer = new OpenLayers.Layer.Google(name, options);
        return layer;
      },
      constructorArguments : {
        name : Legato.Lang.String
      },
      constructorOrder : [ 'name' ],
      options : {
        type : OpenLayers.Layer.Google.MapType,
        sphericalMercator : Legato.Lang.Boolean
      }
    });

OpenLayers.Layer.Google.LayerFactory = Legato.Lang.Class(
//
    Legato.Format.ExtendedWMC.LayerFactory,
    //
    {
      layerType : OpenLayers.Layer.Google.Bean
    });

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OL:Google',
    new OpenLayers.Layer.Google.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Structure: ESRI:ArcGIS93Rest extensions
 * XML based config for <OpenLayers.Layer.ArcGIS93Rest> extensions (service type: "ESRI:ArcGIS93Rest)".
 *
 * See Also:
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a Background would be:
 * (start code)
 * <Extension>
 *   <le:Extension xmlns="">
 *     <isBaseLayer>false</isBaseLayer>
 *      <background>
 *        <ai:Background>
 *          <color><ll:RGBColor r="255" g="255" b="255" /></color>
 *          <transcolor><ll:RGBColor r="255" g="255" b="255" /></transcolor>
 *        </ai:Background>
 *      </background>
 *      <layers>
 *        <ai:ArcIMSLayer id="1" visible="true" />
 *      </layers>
 *   </le:Extension>
 * </Extension>
 * (end)
 */
OpenLayers.Layer.ArcGIS93Rest.Bean = OpenLayers.Layer.Grid.Bean.Extend(
    'OpenLayers.Layer.ArcGIS93Rest',
    //
    Legato.OpenLayers.Layer.QName('ArcGIS93Rest'),
    //
    {
      factoryFunction : function(name, url, params, options) {
        if (!Legato.Lang.ObjectUtils.exists(params)) {
          params = {};
        }
        if (!Legato.Lang.ObjectUtils.exists(options)) {
          options = {};
        }
        if (!Legato.Lang.ObjectUtils.exists(params.TRANSPARENT)
            && Legato.Lang.ObjectUtils.exists(options.transparent)) {
          params.TRANSPARENT = options.transparent ? 'TRUE' : 'FALSE';
          delete options.transparent;
        }
        if (!Legato.Lang.ObjectUtils.exists(params.FORMAT)
            && Legato.Lang.ObjectUtils.exists(options.format)) {
          params.FORMAT = options.format.slice('image/'.length);
          delete options.format;
        }

        return new OpenLayers.Layer.ArcGIS93Rest(name, url, params, options);
      },
      constructorArguments : {
        name :Legato.Lang.String,
        url :Legato.Lang.String,
        params :Legato.Lang['String{}']
      },
      constructorOrder : [ 'name', 'url', 'params' ],
      options : {
        /*
         * Property: format
         * {String} MIME type of desired image type
         */
        format : Legato.Lang.String,

        /*
         * Property: transparent
         * {Boolean} if layer schould be rendered transparent
         */
        transparent :Legato.Lang.Boolean

      }
    });

OpenLayers.Layer.ArcGIS93Rest.LayerFactory = Legato.Lang.Class(
//
    Legato.Format.ExtendedWMC.LayerFactory,
    //
    {
      layerType : OpenLayers.Layer.ArcGIS93Rest.Bean
    });

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('ESRI:ArcGIS93Rest',
    new OpenLayers.Layer.ArcGIS93Rest.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: oll:XYZ
 * 
 * Supports standard XYZ grid. 
 * 
 * Inherits from:
 * - {<oll:Grid>}
 * 
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.XYZ}}
 * - {<OpenLayers.Layer.OSM}}
 * - <OL:XYZ> layer type
 * - <OL:OSM> layer type
 */
OpenLayers.Layer.XYZ.Bean = OpenLayers.Layer.Grid.Bean.Extend(
		'OpenLayers.Layer.XYZ',
		//
		Legato.OpenLayers.Layer.QName('XYZ'), {
			//
			_constructor : OpenLayers.Layer.XYZ,
			options : {
				/**
				 * Element: sphericalMercator
				 * {Boolean} Whether the tile extents should be set to the defaults for 
				 * spherical mercator. Useful for things like OpenStreetMap.
				 * Default is false.
				 */
				sphericalMercator : Legato.Lang.Boolean
			}
		});

/**
 * Layer type: OL:XYZ
 * 
 * See also:
 * - {<oll:XYZ>}
 * - {<oll:OSM>}
 * - {<OpenLayers.Layer.XYZ>}
 * - {<OpenLayers.Layer.OSM>}
 * 
 * Example:
 * (start code)
 * <Layer queryable="0" hidden="0">                                                                       
 *   <Server service="OL:XYZ" version="1.1.1" title="OL:XYZ">                                           
 *     <OnlineResource xlink:type="simple" xlink:href="http://tile.openstreetmap.org/${z}/${x}/${y}.png" />
 *   </Server>                                                                                            
 *   <Name>OpenStreetMap</Name>                                                                              
 *   <Title>OpenStreetMap</Title>                                                                           
 * </Layer>                                                                                               
 * (end)
 */
OpenLayers.Layer.XYZ.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : OpenLayers.Layer.XYZ.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OL:XYZ',
		new OpenLayers.Layer.XYZ.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: oll:OSM
 * 
 * Supports OpenStreetMap tiles.
 * 
 * Inherits from:
 * - {<oll:OSM>}
 * 
 * See also:
 * - <oll> namespace
 * - {<OpenLayers.Layer.XYZ}}
 * - {<OpenLayers.Layer.OSM}}
 * - <OL:XYZ> layer type
 * - <OL:OSM> layer type
 */
OpenLayers.Layer.OSM.Bean = OpenLayers.Layer.XYZ.Bean.Extend(
		'OpenLayers.Layer.OSM',
		//
		Legato.OpenLayers.Layer.QName('OSM'), {
			//
			_constructor : OpenLayers.Layer.OSM,
			options : {
				/**
				 * Element: sphericalMercator
				 * {Boolean} Whether the tile extents should be set to the defaults for 
				 * spherical mercator. Useful for things like OpenStreetMap.
				 * Default is true.
				 */
				sphericalMercator : Legato.Lang.Boolean
			}
		});

/**
 * Layer type: OL:OSM
 * 
 * See also:
 * - {<oll:XYZ>}
 * - {<oll:OSM>}
 * - {<OpenLayers.Layer.XYZ>}
 * - {<OpenLayers.Layer.OSM>}
 * 
 * Example:
 * (start code)
 * <Layer queryable="0" hidden="0">                                                                       
 *   <Server service="OL:OSM" version="1.1.1" title="OL:OSM">                                           
 *     <OnlineResource xlink:type="simple" xlink:href="http://tile.openstreetmap.org/${z}/${x}/${y}.png" />
 *   </Server>                                                                                            
 *   <Name>OpenStreetMap</Name>                                                                              
 *   <Title>OpenStreetMap</Title>                                                                           
 * </Layer>                                                                                               
 * (end)
 */
OpenLayers.Layer.OSM.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : OpenLayers.Layer.OSM.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OL:OSM',
		new OpenLayers.Layer.OSM.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author$
 * @version $Rev$
 */

/**
 * Class: Legato.Layer.Blank
 * This class is a specialized WMS Layer. It acts like
 * a usual wms layer but it will always be transparent. You could use this layer
 * as a baselayer if, e.g. you just want to add some overlays to your map but
 * you don't want to use a baselayer which is visible.
 *
 * Inherits from:
 * - <OpenLayers.Layer.WMS>
 */
Legato.Layer.Blank = OpenLayers.Class(OpenLayers.Layer.WMS, {

	/*
	 * Constructor: Legato.Layer.Blank Create a blank WMS layer object
	 *
	 * Example: (code) var wms = new Legato.Layer.Blank("Transparent Layer");
	 * (end)
	 *
	 * Parameters: name - {String} A name for the layer params - {Object} An
	 * object with key/value pairs representing the GetMap query string parameters
	 * and parameter values. options - {Ojbect} Hashtable of extra options to tag
	 * onto the layer
	 */
	initialize : function(name, params, options) {
		var newArguments = [];
		if (!Legato.Lang.ObjectUtils.exists(options)) {
			options = {};
		}
		if (!Legato.Lang.ObjectUtils.isBoolean(options.legatoIgnore)) {
			options.legatoIgnore = true;
		}
		newArguments.push(name, OpenLayers.Util.getImagesLocation()
				+ "blank.gif?", params, options);
		OpenLayers.Layer.WMS.prototype.initialize.apply(this, newArguments);
	},

	CLASS_NAME : 'Legato.Layer.Blank'

});

/**
 * Structure: lc:BBoxValueProvider XML based config for a
 * <Legato.Control.BBoxValueProvider>.
 *
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory> - <QName>
 *
 * A valid config example for a BBoxValueProvider would be:
 * (start code)
 * <lc:BBoxValueProvider left="bboxLeft" right="bboxRight" top="bboxTop" bottom="bboxBottom"/>
 * (end)
 */
Legato.Layer.Blank.Bean = Legato.Layer.Bean.Extend('Legato.Layer.Blank',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Layer.QName('BlankLayer'), {
	_constructor : Legato.Layer.Blank,
	constructorOrder : [ 'name', 'params' ],
	constructorArguments : {
		/*
		 * Property: name Defines the name of the blank layer instance.
		 *
		 * See Also: <OpenLayers.Layer>
		 */
		name : Legato.Lang.String,

		/*
		 * Property: params An object with key/value pairs representing the GetMap
		 * query string parameters and parameter values.
		 *
		 * See Also: <Legato.Layer.Blank>
		 */
		params : Legato.Lang.Object
	}
/*
 * factoryFunction : function(name, url, params, options) { var layer = new
 * OpenLayers.Layer.WMS(name, OpenLayers.Util .getImagesLocation() +
 * "blank.gif?", {}); return layer; }, constructorArguments : { name
 * :Legato.Lang.String }, constructorOrder : [ 'name' ]
 */

});

Legato.Layer.Blank.LayerFactory = Legato.Lang.Class(
		Legato.Format.ExtendedWMC.LayerFactory, {
			layerType : Legato.Layer.Blank.Bean
		});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('L:Blank',
		new Legato.Layer.Blank.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.VectorOSM = OpenLayers.Class(OpenLayers.Layer.GML, {
	format: OpenLayers.Format.OSM,
    projection: new OpenLayers.Projection("EPSG:4326"),
	CLASS_NAME : 'Legato.Layer.VectorOSM'

});


/**
 * Component: lla:VectorOSM
 * 
 * Supports OpenStreetMap vector data
 * 
 * Inherits from:
 * - {<oll:GML>}
 * 
 * See also:
 * - <lla> namespace
 * - <oll> namespace
 * - {<Legato.Layer.VectorOSM}}
 * - {<OpenLayers.Layer.GML}}
 * - {<OpenLayers.Layer.XYZ}}
 * - {<OpenLayers.Layer.OSM}}
 * - <Legato:VectorOSM> layer type
 * - <OL:XYZ> layer type
 * - <OL:OSM> layer type
 */
Legato.Layer.VectorOSM.Bean = OpenLayers.Layer.GML.Bean.Extend(
		'Legato.Layer.VectorOSM',
		//
		Legato.Layer.QName('VectorOSM'), {
			//
			_constructor : Legato.Layer.VectorOSM
		});

/**
 * Layer type: Legato:VectorOSM
 * 
 * See also:
 * - {<lla:VectorOSM>}
 * - {<oll:XYZ>}
 * - {<oll:OSM>}
 * - {<Legato.Layer.VectorOSM>}
 * - {<OpenLayers.Layer.XYZ>}
 * - {<OpenLayers.Layer.OSM>}
 * 
 * Example:
 * (start code)
 * <Layer queryable="0" hidden="0">                                                                       
 *   <Server service="Legato:VectorOSM" version="0.6" title="Legato:VectorOSM">                                           
 *     <OnlineResource xlink:type="simple" xlink:href="http://api.openstreetmap.org/api/0.6/relation/177453/full" />
 *   </Server>                                                                                            
 *   <Name>S2</Name>                                                                              
 * </Layer>                                                                                               
 * (end)
 */
Legato.Layer.VectorOSM.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : Legato.Layer.VectorOSM.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('Legato:VectorOSM',
		new Legato.Layer.VectorOSM.LayerFactory());
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.GetLegend = Legato.Lang
    .Class( {
      url :null,
      params :null,
      dynamic :true,
      initialize : function(url) {
        Legato.Util.Ensure.ensureString(url);
        var questionMarkIndex = url.indexOf('?');
        if (questionMarkIndex > 0) {
          this.url = url.substring(0, questionMarkIndex);
          this.params = OpenLayers.Util.upperCaseObject(OpenLayers.Util
              .getParameters(url));
        } else {
          this.url = url;
          this.params = {};
        }
      },
      getURL : function(layer) {
        Legato.Util.Ensure.ensureExists(layer);
        var params = OpenLayers.Util.extend( {}, this.params);
        var bounds = layer.map.getExtent();
        if (Legato.Lang.ObjectUtils.exists(bounds)) {
          params.BBOX = bounds.toArray();
        }

        var size = layer.map.getSize();
        if (Legato.Lang.ObjectUtils.exists(size)) {
          params.WIDTH = size.w;
          params.HEIGHT = size.h;
        }

        var projection = layer.map.getProjection();
        if (Legato.Lang.ObjectUtils.exists(projection) && projection != 'none') {
          params.SRS = projection;
        }

        params.LAYERS = Legato.Lang.ObjectUtils.exists(layer.layerId) ? layer.layerId
            : layer.name;

        var url = this.url + '?' + OpenLayers.Util.getParameterString(params);
        return url;
      },
      CLASS_NAME :'Legato.Layer.GetLegend'
    });
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Legend = Legato.Lang.Class( {
  url :null,
  dynamic :false,
  initialize : function(url) {
    Legato.Util.Ensure.ensureString(url);
    this.url = url;
  },
  getURL : function(layer) {
    return this.url;
  },
  CLASS_NAME :'Legato.Layer.Legend'
});
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.VectorUpdater = OpenLayers.Class( {
  url :null,
  params :null,
  layer :null,
  format :null,
  onSuccess : function(request) {
  },
  onFailure : function(request) {
    OpenLayers.Console.error(request);
  },
  initialize : function(options) {
    OpenLayers.Util.extend(this, options);
    var url = options.url;
    if (Legato.Lang.ObjectUtils.isString(url)) {
      var questionMarkIndex = url.indexOf('?');
      if (questionMarkIndex > 0) {
        this.url = url.substring(0, questionMarkIndex);
        this.params = OpenLayers.Util.getParameters(url);
      } else {
        this.url = url;
        this.params = null;
      }
      
      if (!Legato.Lang.ObjectUtils.exists(this.format)){
        this.format = new Legato.Format.GML3();
      }
      var layer = options.layer;
      if (Legato.Lang.ObjectUtils.exists(layer)
          && Legato.Lang.ObjectUtils.exists(layer.events)) {
        this.layer = layer;
        this.layer.events.on( {
          'featuresadded' :this.update,
          'featuresremoved' :this.update,
          'featuremodified' :this.update,
          scope :this
        });
      }
    } else {
      this.url = null;
      this.params = null;
    }
  },
  destroy : function() {
    if (Legato.Lang.ObjectUtils.exists(this.layer)) {
      this.layer.events.un( {
        'featuresadded' :this.update,
        'featuresremoved' :this.update,
        'featuremodified' :this.update,
        scope :this
      });
    }
    this.layer = null;
    this.url = null;
    this.params = null;
  },
  update : function() {
    var features = this.layer.features;
    if (Legato.Lang.ObjectUtils.isNotEmptyArray(features)) {
      var data = this.format.write(features);
      var request = new OpenLayers.Request.POST( {
        url :this.url,
        params :this.params,
        data :data,
        success :this.onSuccess,
        failure :this.onFailure,
        scope :this
      });
    }
  },
  CLASS_NAME :'Legato.Layer.VectorUpdater'
});
Legato.Layer.VectorUpdater.Bean = Legato.Beans.Object.Extend(
    'Legato.Layer.VectorUpdater',

    Legato.Layer.QName('VectorUpdater'), {
      _constructor :Legato.Layer.VectorUpdater,
      options : {
        url :Legato.Lang.String,
        format :Legato.Beans.Object,
        layer :Legato.Beans.Object
      }
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Legend.Bean = Legato.Beans.Object.Extend('Legato.Layer.Legend',

Legato.Layer.QName('Legend'), {
  _constructor :Legato.Layer.Legend,
  constructorOrder : [ 'url' ],
  constructorArguments : {
    url :Legato.Lang.String
  }
});

Legato.Layer.GetLegend.Bean = Legato.Beans.Object.Extend(
    'Legato.Layer.GetLegend',

    Legato.Layer.QName('GetLegend'), {
      _constructor :Legato.Layer.GetLegend,
      constructorOrder : [ 'url' ],
      constructorArguments : {
        url :Legato.Lang.String
      }
    });

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.OverviewMap
 * Represents an overview map
 *
 * Inherits from:
 *  - <OpenLayers.Map>
 */
Legato.OverviewMap =
  OpenLayers.Class(OpenLayers.Map, {

    Z_INDEX_BASE: {
      BaseLayer: 2100,
      Overlay: 2325,
      Feature: 2725,
      Popup: 2750,
      Control: 3000
    },

    CLASS_NAME: 'Legato.OverviewMap'
});


/**
 * Structure: l:OverviewMap
 * XML based config for a <Legato.OverviewMap>.
 *
 * See Also:
 * - <QName>
 * - <PREFIX>
 * - <Legato.Beans.BeanFactory>
 *
 * A valid example could be
 *
 * (start code)
 * <l:OverviewMap foo="bar"/>
 * (end)
 *
 * For detailed informations have a look at the <OpenLayers.Map> documentation.
 */
Legato.OverviewMap.Bean = OpenLayers.Map.Bean.Extend('Legato.OverviewMap',
    //
    Legato.QName('OverviewMap'),
    //
    {
      factoryFunction: function(id, options)
      {
        if (!Legato.Lang.ObjectUtils.exists(options))
        {
          options = {};
        }
        if (!Legato.Lang.ObjectUtils.exists(options.controls))
        {
          options.controls = [];
        }
        if (!Legato.Lang.ObjectUtils.exists(options.theme))
        {
          options.theme = null;
        }
        return new Legato.OverviewMap(id, options);
      }
    });




/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: jleine $
 * @version $Revision: 953 $
 * @requires Legato.js
 * @requires OpenLayers/Control.js
 */

/**
 * Class: Legato.Style
 * The Legato Style class allows to define a style map. This map may
 * then be used by an control to define the look of a feature layer.
 *
 *
 *
 * Inherits from:
 *  - <Legato.Lang.Class>
 */
Legato.Style = Legato.Lang.Class({

  name: null,

  styles: {},

  initialize : function(options) {
    this.name = options.name;
    this.styles = options.styles;
  },

  CLASS_NAME : 'Legato.Style'
});

/**
 * Space: lc
 * Namespace for Legato Style.
 */
/*
 * URI: Namespace URI
 * {http://www.disy.net/legato/style}
 */
Legato.Style.NAMESPACE_URI = 'http://www.disy.net/legato/style';

/*
 * Prefix: Default prefix
 * {ls}
 */
Legato.Style.PREFIX = 'ls';

Legato.Style.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Style.NAMESPACE_URI, localPart,
      Legato.Style.PREFIX);
};
/**
 * Component: ls:Style
 * Configuration component for Legato Style.
 * See also:
 * - <ls> namespace
 * - <Legato.Style>
 */
Legato.Style.Bean = OpenLayers.Control.Bean.Extend('Legato.Style',
//
Legato.Style.QName('Style'),
//
{
  _constructor : Legato.Style,
  options : {
    name : Legato.Lang.String,
    styles : Legato.Beans.Object.Map()
  }
});

/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Rev: 91043 $
 */

/**
 * Class: Legato.BootLoader
 * The Legato BootLoader Class gives you the possibility to configure
 * and load Legato without defining the body onload Event.
 *
 * You can specify the following js variables to use this class:
 *
 * - legatoBootLoader (must be set to true to enable the bootloader)
 * - legatoBootLoaderConfigUrl (define if not config.xml)
 * - legatoBootLoaderOnCreate (callBack method after BeanFactory has been created but did not loaded the config yet)
 * - legatoBootLoaderOnConfigured (callBack method after BeanFactory has been fully loaded)
 * - legatoBootLoaderOnDestroy (callBack method before BeanFactory destroys itself and the current map)
 *
 * Please be adviced that you must define them before including this class.
 *
 * Inherits from: - <Legato.Control>
 */
Legato.BootLoader = Legato.Lang.Class({

  /*
   * Property: configUrl
   * {String} the default configUrl for Legato
   */
  configUrl: 'config.xml',

  /*
   * Property: onCreateCallback
   * {Function} a configurable callback method which will been executed when
   * the Legato BeanFactory has been created but did not load the config yet.
   */
  onCreateCallback: null,

  /*
   * Property: onConfiguredCallback
   * {Function} a configurable callback method which will been executed when
   * the Legato BeanFactory has loaded the configuration.
   */
  onConfiguredCallback: null,

  /*
   * Property: onDestroyCallback
   * {Function} a configurable callback method which will been executed when
   * before the BeanFactory will destroy all objects and the current map.
   */
  onDestroyCallback: null,

  /*
   * Property: beanFactory
   * {Legato.Beans.BeanFactory}
   */
  beanFactory: null,

  /*
   * Property: beanFactory
   * {OpenLayers.Map}
   */
  map: null,

  /*
   * Function: initialize
   * Basic ctor
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control (currently not used)
   */
  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);

    if(typeof legatoI18nLocale != 'undefined' && Legato.Lang.ObjectUtils.isString(legatoI18nLocale)) {
      Legato.I18n.setLocale(legatoI18nLocale);
    }
    
    if(typeof legatoBootLoaderConfigUrl != 'undefined' &&
       !Legato.Lang.ObjectUtils.isNullOrUndefined(legatoBootLoaderConfigUrl)){
      this.configUrl = legatoBootLoaderConfigUrl;
    }

    if(typeof legatoBootLoaderOnCreate != 'undefined' &&
        Legato.Lang.ObjectUtils.isFunction(legatoBootLoaderOnCreate)){
      this.onCreateCallback = legatoBootLoaderOnCreate;
    }

    if(typeof legatoBootLoaderOnConfigured != 'undefined' &&
        Legato.Lang.ObjectUtils.isFunction(legatoBootLoaderOnConfigured)){
      this.onConfiguredCallback = legatoBootLoaderOnConfigured;
    }

    if(typeof legatoBootLoaderOnDestroy != 'undefined' &&
        Legato.Lang.ObjectUtils.isFunction(legatoBootLoaderOnDestroy)){
      this.onDestroyCallback = legatoBootLoaderOnDestroy;
    }

    this.load();
    Legato.Util.DOM.addDOMUnLoadEvent(OpenLayers.Function.bind(this.unload, this));
  },

  /*
   * Function: initialize
   * Basic ctor
   *
   * Parameters:
   * options - {Object} A Hashmap containing option parameters for this control (currently not used)
   */
  load: function(){
    this.beanFactory = new Legato.Beans.XMLBeanFactory();

    if(Legato.Lang.ObjectUtils.isFunction(this.onCreateCallback)){
      this.onCreateCallback(this.beanFactory);
    }

    this.beanFactory.loadURL({
      url: this.configUrl,
      onFailure : function(request) {
        OpenLayers.Console.error(request);
      },
      onSuccess : OpenLayers.Function.bind(function(request) {
          this.map = this.beanFactory.getBean('map');
          if (Legato.Lang.ObjectUtils.exists(this.onConfiguredCallback)) {
            this.onConfiguredCallback(this.beanFactory);
          }
        }, this)
    });
  },

  /*
   * Function: unload
   * Executed when the DOM unloads
   */
  unload: function(){
    if (Legato.Lang.ObjectUtils.exists(this.onDestroyCallback)) {
      this.onDestroyCallback(this.beanFactory);
    }
    if (Legato.Lang.ObjectUtils.exists(this.beanFactory)) {
      this.beanFactory.destroy();
    }
  },

  CLASS_NAME : 'Legato.BootLoader'
});

/*
 * The BootLoader creates itself if the js variable legatoBootLoader is
defined and is set to true
 */
Legato.Util.DOM.addDOMLoadEvent(function() {
  if(typeof legatoBootLoader != 'undefined' &&
      Legato.Lang.ObjectUtils.isTrue(legatoBootLoader)){
      legatoBootLoader = new Legato.BootLoader();
    }
  }
);
/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Util.EventListener = OpenLayers.Class( {
  events :null,
  types :null,
  scope :null,
  callback :null,
  initialize : function(target, types, scope, callback) {
    this.events = target.events;
    this.types = types;
    this.callback = callback;

    for ( var index = 0; index < this.types.length; index++) {
      var type = this.types[index];
      this.events.register(type, null, this.callback);
    }
  },

  destroy : function() {
    for ( var index = 0; index < this.types.length; index++) {
      var type = this.types[index];
      this.events.unregister(type, null, this.callback);
    }
  },

  CLASS_NAME :'Legato.Util.EventListener'
});

Legato.Util.EventListener.Bean = Legato.Beans.Object.Extend(

'Legato.Util.EventListener',

Legato.Util.QName('EventListener'), {
  _constructor :Legato.Util.EventListener,
  constructorArguments : {
    target :Legato.Beans.Object,
    types :Legato.Lang['String[]'],
    scope :Legato.Beans.Object,
    callback :Legato.Lang.Function
  },
  constructorOrder : [ 'target', 'types', 'scope', 'callback' ]
});

