/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Structure: ESRI:ArcGIS93Rest extensions
 * XML based config for <OpenLayers.Layer.ArcGIS93Rest> extensions (service type: "ESRI:ArcGIS93Rest)".
 *
 * See Also:
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a Background would be:
 * (start code)
 * <Extension>
 *   <le:Extension xmlns="">
 *     <isBaseLayer>false</isBaseLayer>
 *      <background>
 *        <ai:Background>
 *          <color><ll:RGBColor r="255" g="255" b="255" /></color>
 *          <transcolor><ll:RGBColor r="255" g="255" b="255" /></transcolor>
 *        </ai:Background>
 *      </background>
 *      <layers>
 *        <ai:ArcIMSLayer id="1" visible="true" />
 *      </layers>
 *   </le:Extension>
 * </Extension>
 * (end)
 */
OpenLayers.Layer.ArcGIS93Rest.Bean = OpenLayers.Layer.Grid.Bean.Extend(
    'OpenLayers.Layer.ArcGIS93Rest',
    //
    Legato.OpenLayers.Layer.QName('ArcGIS93Rest'),
    //
    {
      factoryFunction : function(name, url, params, options) {
        if (!Legato.Lang.ObjectUtils.exists(params)) {
          params = {};
        }
        if (!Legato.Lang.ObjectUtils.exists(options)) {
          options = {};
        }
        if (!Legato.Lang.ObjectUtils.exists(params.TRANSPARENT)
            && Legato.Lang.ObjectUtils.exists(options.transparent)) {
          params.TRANSPARENT = options.transparent ? 'TRUE' : 'FALSE';
          delete options.transparent;
        }
        if (!Legato.Lang.ObjectUtils.exists(params.FORMAT)
            && Legato.Lang.ObjectUtils.exists(options.format)) {
          params.FORMAT = options.format.slice('image/'.length);
          delete options.format;
        }

        return new OpenLayers.Layer.ArcGIS93Rest(name, url, params, options);
      },
      constructorArguments : {
        name :Legato.Lang.String,
        url :Legato.Lang.String,
        params :Legato.Lang['String{}']
      },
      constructorOrder : [ 'name', 'url', 'params' ],
      options : {
        /*
         * Property: format
         * {String} MIME type of desired image type
         */
        format : Legato.Lang.String,

        /*
         * Property: transparent
         * {Boolean} if layer schould be rendered transparent
         */
        transparent :Legato.Lang.Boolean

      }
    });

OpenLayers.Layer.ArcGIS93Rest.LayerFactory = Legato.Lang.Class(
//
    Legato.Format.ExtendedWMC.LayerFactory,
    //
    {
      layerType : OpenLayers.Layer.ArcGIS93Rest.Bean
    });

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('ESRI:ArcGIS93Rest',
    new OpenLayers.Layer.ArcGIS93Rest.LayerFactory());