/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Transformer = Legato.Lang.Class({

  initialize : function() {
  },

  transform : function(layer) {
    throw new Legato.Lang.Exception(this.CLASS_NAME
        + ' must implement the transform function from from abstract class '
        + Legato.Layer.Transformer.CLASS_NAME);
  },

  CLASS_NAME : 'Legato.Layer.Transformer'

});

/**
 * Space: lltr
 * Namespace for Legato layer transformers.
 */
/**
 * URI: Namespace URI
 * {http://www.disy.net/legato/layer/transformer}
 */
Legato.Layer.Transformer.NAMESPACE_URI = 'http://www.disy.net/legato/layer/transformer';
/**
 * Prefix: Default prefix
 * {lltr}
 */
Legato.Layer.Transformer.PREFIX = 'lltr';

Legato.Layer.Transformer.QName = function(localPart) {
  return new Legato.XML.QName(Legato.Layer.Transformer.NAMESPACE_URI,
      localPart, Legato.Layer.Transformer.PREFIX);
};

/**
 * Component: lltr:Transformer
 *
 * Transforms the layer.
 *
 * See also:
 * - <lltr> namespace
 * - <Legato.Layer.Transformer>
 */
Legato.Layer.Transformer.Bean = Legato.Beans.Object.Extend(
    'Legato.Layer.Transformer', Legato.Layer.Transformer.QName('Transformer'),
    {
      _constructor : Legato.Layer.Transformer
    });
