/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.ToggleDiv
 *
 * This simple control switches the visibility of its given control
 *
 * Inherits from:
 * - <Legato.Control>
 *
 */
Legato.Control.ToggleDisplay = OpenLayers
		.Class(Legato.Control,
				{
					control : null,
					type : OpenLayers.Control.TYPE_TOGGLE,
					initialize : function(options) {
						OpenLayers.Control.prototype.initialize.apply(this,
								arguments);
						if (!Legato.Lang.ObjectUtils
								.exists(options.displayClass)
								&& Legato.Lang.ObjectUtils
										.exists(options.control.displayClass)) {
							this.displayClass = options.control.displayClass
									+ 'Toggle';
						}
					},

					/**
					 * Function: activate
					 * Invoked when the control is activated in toggle mode
					 */
					activate : function() {
						if (Legato.Lang.ObjectUtils.exists(this.control.div)) {
							OpenLayers.Element.show(this.control.div);
						}
						this.active = true;
						Legato.Control.prototype.activate
								.apply(this, arguments);
					},

					/**
					 * Function: trigger
					 * Invoked when the control is deactivated in toggle mode
					 */
					deactivate : function() {
						if (Legato.Lang.ObjectUtils.exists(this.control.div)) {
							OpenLayers.Element.hide(this.control.div);
						}
						this.active = false;
						Legato.Control.prototype.deactivate.apply(this,
								arguments);
					},

					CLASS_NAME : "Legato.Control.ToggleDisplay"
				});

/**
 * Component: lc:ToggleDisplay
 * 
 * Inherits from:
 * - <olc:Control>
 * 
 * See also:
 * - <lc> namsepace
 * - {<Legato.Control.ToggleDisplay>}
 */
Legato.Control.ToggleDisplay.Bean = OpenLayers.Control.Bean.Extend(
		'Legato.Control.ToggleDisplay', Legato.Control.QName('ToggleDisplay'),
		{
			_constructor : Legato.Control.ToggleDisplay,
			options : {
				/**
				 * Element: control
				 * {<olc:Control>} Control to be toggled.
				 */
				control : OpenLayers.Control.Bean
			}
		});
