/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: nedkov $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerDropDownMenu
 */
Legato.Control.Legend.Plugin.LayerDropDownMenu = OpenLayers.Class(
    Legato.Control.Legend.Plugin, {

      plugins : null,

      dropDownMenuContainer : null,

      /**
       * Function: create Creates the plugin div
       */
      create : function() {
        Legato.Control.Legend.Plugin.prototype.create.apply(this, arguments);

        var divDropDownMenu = document.createElement('div');
        divDropDownMenu.className = 'LegatoControlLegendPluginLayerDropDownMenuDiv';

        this.dropDownMenuContainer = document.createElement('div');
        this.dropDownMenuContainer.className = 'LegatoControlLegendPluginLayerDropDownMenuDivContainer';

        divDropDownMenu.appendChild(this.div);
        divDropDownMenu.appendChild(this.dropDownMenuContainer);

        this.div = divDropDownMenu;

        for ( var j = 0; j < this.plugins.length; j++) {
          this.dropDownMenuContainer.appendChild(this.plugins[j].draw());
        }

        OpenLayers.Element.hide(this.dropDownMenuContainer);
        if(this.plugins.length === 0){
          OpenLayers.Element.hide(this.div);
        }
      },

      /**
       * Function: afterSetup
       */
      afterSetup : function() {
        this.div.onclick = OpenLayers.Function.bindAsEventListener(
            this.onclick, this);
      },

      /**
       * Function: beforeDestroyed
       */
      beforeDestroyed : function() {
        this.div.onclick = null;
      },

      /**
       * Function: onclick
       */
      onclick : function(event) {
        if(!OpenLayers.Element.visible(this.dropDownMenuContainer)){
          for(var i = 0; i < this.dropDownMenuContainer.childNodes.length; i++){
            if(OpenLayers.Element.visible(this.dropDownMenuContainer.childNodes[i])){
              OpenLayers.Element.toggle(this.dropDownMenuContainer);
              break;
            }
          }
        }else{
          OpenLayers.Element.toggle(this.dropDownMenuContainer);
        }
        if (Legato.Lang.ObjectUtils.exists(event)) {
          OpenLayers.Event.stop(event, true);
        }
      },

      /**
       * Function: destroy
       */
      destroy : function() {
        if(Legato.Lang.ObjectUtils.isNotEmptyArray(this.plugins)){
          for ( var index = 0; index < this.plugins.length; index++) {
            this.plugins[index].destroy();
          }
        }
        this.plugins = null;
        Legato.Control.Legend.Plugin.prototype.destroy.apply(
            this, arguments);

      },

      CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerDropDownMenu'
    });

/**
 * Class: Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory
 * Factory class wich is able to create a <Legato.Control.Legend.Plugin.LayerDropDownMenu>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory = OpenLayers.Class(
    Legato.Control.Legend.Plugin.Factory, {

      /**
       * Function: create
       * Factory method for creating a <Legato.Control.Legend.Plugin.LayerDropDownMenu> instance.
       */
      create : function(layer) {
        var pluginOptions = OpenLayers.Util.extend({},
            this.pluginOptions);
        pluginOptions.plugins = [];

        var pluginFactories = this.pluginOptions.plugins;

        if(Legato.Lang.ObjectUtils.isNotEmptyArray(pluginFactories)){
          for ( var j = 0; j < pluginFactories.length; j++) {
            if (pluginFactories[j].supports(layer)) {
              var plugin = pluginFactories[j].create(layer);
              plugin.setRenderWithTitle(true);
              pluginOptions.plugins.push(plugin);
            }
          }
        }

        return new Legato.Control.Legend.Plugin.LayerDropDownMenu(layer,
            pluginOptions);
      },

      CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory'
    });

/**
 * Component: llp:LayerDropDownMenu
 *
 * Inherits from:
 * - <llp:Plugin>
 *
 * See Also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin.LayerDropDownMenu>}
 */
Legato.Control.Legend.Plugin.LayerDropDownMenu.Bean = Legato.Control.Legend.Plugin.Bean
    .Extend('Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory',

    Legato.Control.Legend.Plugin.QName('LayerDropDownMenu'), {
      _constructor : Legato.Control.Legend.Plugin.LayerDropDownMenu.Factory,
      options : {
        plugins : Legato.Beans.Object.List()
      }
    });