/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ArgParser = OpenLayers.Class(OpenLayers.Control.ArgParser, {

  /**
   * Parameter: bounds {Array(<OpenLayers.Bounds>)}
   */
  bounds : null,

  /**
   * Constructor: OpenLayers.Control.ArgParser
   * 
   * Parameters: options - {Object}
   */
  initialize : function(options) {
    OpenLayers.Control.ArgParser.prototype.initialize.apply(this, arguments);
  },

  /**
   * Method: setMap Set the map property for the control.
   * 
   * Parameters: map - {<OpenLayers.Map>}
   */
  setMap : function(map) {
    OpenLayers.Control.ArgParser.prototype.setMap.apply(this, arguments);

    var bounds = this.getBounds();

    if (Legato.OpenLayers.Map.Util.isValidBBox(bounds)) {
      this.bounds = bounds;
      this.map.events.register('legato.refresh', this, this.setBounds);
      this.setBounds();
    } else {
      this.bounds = null;
    }
  },

  /**
   * Method: getBounds Tries to parse from current request the BBOX query
   * parameter and returns a bounds instance.
   * 
   * Returns: {<OpenLayers.Bounds>}
   */
  getBounds : function() {
    var args = OpenLayers.Util.getParameters();
    if (Legato.Lang.ObjectUtils.isNullOrUndefined(args.BBOX) || !Legato.Lang.ObjectUtils.isArray(args.BBOX) || args.BBOX.length !== 4) {
      return null;
    }

    try {
      return new OpenLayers.Bounds(Legato.Lang.NumberUtils.toFloat(args.BBOX[0]), Legato.Lang.NumberUtils.toFloat(args.BBOX[1]), Legato.Lang.NumberUtils
          .toFloat(args.BBOX[2]), Legato.Lang.NumberUtils.toFloat(args.BBOX[3]));
    } catch (ex) {
      Legato.Util.Logger.getLogger().warn('Could not parse given parameter BBOX: ' + args.BBOX + ' into a valid Bounds object.');
      Legato.Util.Logger.getLogger().warn(ex);
      return null;
    }
  },

  /**
   * Method: setBounds As soon as the legato.refresh event is triggered we try
   * to zoom to given bounding box and remove ourself from the handler
   */
  setBounds : function() {
    if (this.map.baseLayer) {
      // dont need to listen for this one anymore
      this.map.events.unregister('legato.refresh', this, this.setBounds);
      this.map.setCenter(this.bounds.getCenterLonLat(), this.map.getZoomForExtent(this.bounds, true));
    }
  },

  CLASS_NAME : 'Legato.Control.ArgParser'
});

/**
 * Structure: lc:ArgParser XML based config for a <Legato.Control.ArgParser>.
 * 
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory> - <QName>
 * 
 * A valid config example for a ArgParser would be:
 * (start code)
 * <lc:ArgParser />
 * (end)
 */
Legato.Control.ArgParser.Bean = OpenLayers.Control.ArgParser.Bean.Extend(

'Legato.Control.ArgParser',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Control.QName('ArgParser'),
//
{
  _constructor : Legato.Control.ArgParser,
  options : {
    displayProjection : OpenLayers.Projection.Bean
  }
});