/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Layer.WFS.Bean = OpenLayers.Layer.Vector.Bean.Extend(
    'OpenLayers.Layer.WFS',
    //
    Legato.OpenLayers.Layer.QName('WFS'),
    //
    {
      factoryFunction : function(name, url, params, options) {
        if (!Legato.Lang.ObjectUtils.exists(params)) {
          params = {};
        }
        if (!Legato.Lang.ObjectUtils.exists(options)) {
          options = {};
        }
        if (!Legato.Lang.ObjectUtils.exists(params.MAXFEATURES)
            && Legato.Lang.ObjectUtils.exists(options.maxFeatures)) {
          params.MAXFEATURES = options.maxFeatures;
          delete options.maxFeatures;
        }
        if (!Legato.Lang.ObjectUtils.exists(params.TYPENAME)) {
          params.TYPENAME = name;
        }

        return new OpenLayers.Layer.WFS(name, url, params, options);
      },
      constructorArguments : {
        name :Legato.Lang.String,
        url :Legato.Lang.String,
        params :Legato.Lang['String{}']
      },
      constructorOrder : [ 'name', 'url', 'params' ],
      options : {
        maxFeatures: Legato.Lang.Integer
      }
    });

OpenLayers.Layer.WFS.LayerFactory = Legato.Lang.Class(
//
    Legato.Format.ExtendedWMC.LayerFactory,
    //
    {
      layerType :OpenLayers.Layer.WFS.Bean
    });

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('OGC:WFS',
    new OpenLayers.Layer.WFS.LayerFactory());