/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Namespace: Legato.Lang.StringUtils
 * 
 * Contains convenience functions for string manipulation.
 */
Legato.Lang.StringUtils = {
  /*
   * Function: startsWith
   * 
   * Checks if given strings starts with a certain prefix.
   * 
   * Parameters:
   * 
   * string - {String} String to check.
   * 
   * prefix - {String} Prefix.
   * 
   */
  startsWith : function(string, prefix) {
    if (!Legato.Lang.ObjectUtils.isString(string)
        || !Legato.Lang.ObjectUtils.isString(prefix)) {
      return false;
    }
    return (string.length >= prefix.length)
        && (string.substring(0, prefix.length) == prefix);

  },
  /*
   * Function: trim
   * 
   * Removes leading and trailing whitespace characters from a string.
   * 
   * Parameters:
   * 
   * string - {String} The (potentially) space padded string. This string is not
   * modified.
   * 
   * Returns:
   * 
   * {String} A trimmed version of the string with all leading and trailing
   * spaces removed.
   */
  trim : function(string) {
    if (Legato.Lang.ObjectUtils.isUndefined(string)) {
      return undefined;
    } else if (Legato.Lang.ObjectUtils.isNull(string)) {
      return null;
    } else {
      Legato.Util.Ensure.ensureString(string);
      return string.replace(/^\s*(.*?)\s*$/, "$1");
    }
  },
  /*
   * Function: isEmpty
   * 
   * Checks if given string is empty.
   * 
   * Returns:
   * 
   * true if the string is null, undefined or empty, false otherwise.
   * 
   * Parameters:
   * 
   * string - string to check.
   */
  isEmpty : function(string) {
    if (!Legato.Lang.ObjectUtils.exists(string)) {
      return true;
    } else {
      Legato.Util.Ensure.ensureString(string);
      if (string.length === 0) {
        return true;
      } else {
        /*
         * for ( var index = 0; index < string.length; index++) { var ch =
         * string.charAt(index); if (!(ch == ' ' || ch == '\t' || ch == '\n' ||
         * ch == '\v' || ch == '\f' || ch == '\r' || ch == '\0')) { return
         * false; } } return true;
         */
        return false;
      }
    }
  }
};