/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Control.ScaleLine.Bean = OpenLayers.Control.Bean.Extend(
    'OpenLayers.Control.ScaleLine',
    //
    Legato.OpenLayers.Control.QName('ScaleLine'),
    //
    {
      //_constructor :OpenLayers.Control.ScaleLine,
      factoryFunction : function(options) {

        if (!Legato.Lang.ObjectUtils.exists(options)) {
          options = [];
        }

        if (!Legato.Lang.ObjectUtils.exists(options.bottomInUnits)) {
          options.bottomInUnits = "";
        }

        if (!Legato.Lang.ObjectUtils.exists(options.bottomOutUnits)) {
          options.bottomOutUnits = "";
        }

        var control = new OpenLayers.Control.ScaleLine(options);
        return control;
      },
      options:
      {
        maxWidth:Legato.Lang.Integer,
        topOutUnits: Legato.Lang.String,
        topInUnits:  Legato.Lang.String,
        bottomOutUnits:  Legato.Lang.String,
        bottomInUnits:  Legato.Lang.String,
        eTop: Legato.Lang.Element,
        eBottom: Legato.Lang.Element
      }
    });