/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author $Author: valikov $
 * @version $Rev: 70574 $
 */

/*
 * Class: Legato.Beans.Field
 */
Legato.Beans.Field = Legato.Lang.Class( {
	/*
	 * Property: target
	 * 
	 * Target bean.
	 */
	target :null,
	/*
	 * Property: name
	 * 
	 * Name of the field of the target bean.
	 */
	name :null,
	/*
	 * Constructor: initialize
	 * 
	 * Parameters:
	 * 
	 * target - target bean.
	 * 
	 * field - {String} name of the field.
	 */
	initialize : function(target, name) {
		Legato.Util.Ensure.ensureObject(target);
		this.target = target;
		Legato.Util.Ensure.ensureString(name);
		this.name = name;
	},
	/*
	 * Function: getInstance
	 * 
	 * Returns:
	 * 
	 * Value of the field of the target bean.
	 * 
	 * Parameters:
	 * 
	 * beanFactory - {<Legato.Beans.BeanFactory>} bean factory.
	 */
	getInstance : function(beanFactory) {
		return this.target[this.name];
	}
});

Legato.Beans.Field.Bean = Legato.Beans.Object.Extend(
		'Legato.Beans.Field', Legato.Beans.QName('Field'), {
			_constructor :Legato.Beans.Field,
			constructorArguments : {
				target :Legato.Beans.Object,
				name :Legato.Lang.String
			},
			constructorOrder : [ 'target', 'name' ]
		});