/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

OpenLayers.Layer.prototype.selected = false;
OpenLayers.Layer.prototype.queryable = false;
OpenLayers.Layer.prototype.isFeatureLayer = false;
Legato.OpenLayers.Layer = {};

/**
 * Space: oll
 * Namespace for OpenLayers layers.
 */
/**
 * URI: Namespace URI
 * {http://www.openlayers.org/layer}
 */
Legato.OpenLayers.Layer.NAMESPACE_URI = 'http://www.openlayers.org/layer';
/**
 * Prefix: Default prefix
 * oll
 */
Legato.OpenLayers.Layer.PREFIX = 'oll';

Legato.OpenLayers.Layer.QName = function(localPart) {
  return new Legato.XML.QName(Legato.OpenLayers.Layer.NAMESPACE_URI,
      localPart, Legato.OpenLayers.Layer.PREFIX);
};

/**
 * Component: oll:Layer
 *
 * Abstract base component for layer configurations.
 *
 *  See also:
 *  - <oll> namespace
 *  - {<OpenLayers.Layer>}
 */
OpenLayers.Layer.Bean = Legato.Beans.Object.Extend('OpenLayers.Layer',
    Legato.OpenLayers.QName('Layer'), {
      _constructor : OpenLayers.Layer,
      constructorArguments : {
        /**
         * Element: name
         * {String}
         */
        name : Legato.Lang.String
      },
      constructorOrder : [ 'name' ],
      options : {
        /**
         * Element: id
         * {String}
         */
        id : Legato.Lang.String,
        /**
         * Element: layerId
         * {String}
         */
        layerId : Legato.Lang.String,
        /**
         * Element: title
         * {String}
         */
        title : Legato.Lang.String,
        /**
         * Element: opacity
         * {Number}
         */
        opacity : Legato.Lang.Number,
        /**
         * Element: alwaysInRange
         * {Boolean}
         */
        alwaysInRange : Legato.Lang.Boolean,
        // events ???
        /**
         * Element: isBaseLayer
         * {Boolean}
         */
        isBaseLayer : Legato.Lang.Boolean,
        /**
         * Element: isFeatureLayer
         * {Boolean}
         */
        isFeatureLayer : Legato.Lang.Boolean,
        /**
         * Element: alpha
         * {Boolean}
         */
        alpha : Legato.Lang.Boolean,
        /**
         * Element: displayInLayerSwitcher
         * {Boolean}
         */
        displayInLayerSwitcher : Legato.Lang.Boolean,
        /**
         * Element: visibility
         * {Boolean}
         */
        visibility : Legato.Lang.Boolean,
        /**
         * Element: attribution
         * {String}
         */
        attribution : Legato.Lang.String,
        // eventListeners ???,
        /**
         * Element: gutter
         * {Integer}
         */
        gutter : Legato.Lang.Integer,
        /**
         * Element: projection
         * {<ol:Projection>}
         */
        projection : OpenLayers.Projection.Bean,
        /**
         * Element: units
         * {String}
         */
        units : Legato.Lang.String,
        // scales???
        /**
         * Element: resolutions
         * {Double[]}
         */
        resolutions : Legato.Lang['Double[]'],
        /**
         * Element: maxExtent
         * {<ol:Bounds>}
         */
        maxExtent : OpenLayers.Bounds.Bean,
        /**
         * Element: minExtent
         * {<ol:Bounds>}
         */
        minExtent : OpenLayers.Bounds.Bean,
        /**
         * Element: maxResolution
         * {Number}
         */
        maxResolution : Legato.Lang.Number,
        /**
         * Element: minResolution
         * {Number}
         */
        minResolution : Legato.Lang.Number,
        /**
         * Element: numZoomLevels
         * {Integer}
         */
        numZoomLevels : Legato.Lang.Integer,
        /**
         * Element: maxScale
         * {Number}
         */
        maxScale : Legato.Lang.Number,
        /**
         * Element: minScale
         * {Number}
         */
        minScale : Legato.Lang.Number,
        /**
         * Element: maxScaleDenominator
         * {Number}
         */
        maxScaleDenominator : Legato.Lang.Number,
        /**
         * Element: minScaleDenominator
         * {Number}
         */
        minScaleDenominator : Legato.Lang.Number,
        /**
         * Element: displayOutsideMaxExtent
         * {Boolean}
         */
        displayOutsideMaxExtent : Legato.Lang.Boolean,
        /**
         * Element: wrapDateLine
         * {Boolean}
         */
        wrapDateLine : Legato.Lang.Boolean,
        /**
         * Element: transitionEffect
         * {String}
         */
        transitionEffect : Legato.Lang.String,
        /**
         * Element: legend
         * {Object} Legend provider
         */
        legend : Legato.Beans.Object,
        /**
         * Element: selected
         * {Boolean}
         */
        selected : Legato.Lang.Boolean,
        /**
         * Element: queryable
         * {Boolean}
         */
        queryable : Legato.Lang.Boolean,
        // Future music
        //  plugins :Legato.Beans.Object.List(),
        /**
         * Element: attributes
         */
        attributes : Legato.Beans.Object.Map(),

        /**
         * Element: formatList
         * {String[]}
         */
        formatList : Legato.Lang['String[]']
      }
    });