/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author$
 * @version $Rev$
 */

/**
 * Class: Legato.Layer.Blank
 * This class is a specialized WMS Layer. It acts like
 * a usual wms layer but it will always be transparent. You could use this layer
 * as a baselayer if, e.g. you just want to add some overlays to your map but
 * you don't want to use a baselayer which is visible.
 *
 * Inherits from:
 * - <OpenLayers.Layer.WMS>
 */
Legato.Layer.Blank = OpenLayers.Class(OpenLayers.Layer.WMS, {

	/*
	 * Constructor: Legato.Layer.Blank Create a blank WMS layer object
	 *
	 * Example: (code) var wms = new Legato.Layer.Blank("Transparent Layer");
	 * (end)
	 *
	 * Parameters: name - {String} A name for the layer params - {Object} An
	 * object with key/value pairs representing the GetMap query string parameters
	 * and parameter values. options - {Ojbect} Hashtable of extra options to tag
	 * onto the layer
	 */
	initialize : function(name, params, options) {
		var newArguments = [];
		if (!Legato.Lang.ObjectUtils.exists(options)) {
			options = {};
		}
		if (!Legato.Lang.ObjectUtils.isBoolean(options.legatoIgnore)) {
			options.legatoIgnore = true;
		}
		newArguments.push(name, OpenLayers.Util.getImagesLocation()
				+ "blank.gif?", params, options);
		OpenLayers.Layer.WMS.prototype.initialize.apply(this, newArguments);
	},

	CLASS_NAME : 'Legato.Layer.Blank'

});

/**
 * Structure: lc:BBoxValueProvider XML based config for a
 * <Legato.Control.BBoxValueProvider>.
 *
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory> - <QName>
 *
 * A valid config example for a BBoxValueProvider would be:
 * (start code)
 * <lc:BBoxValueProvider left="bboxLeft" right="bboxRight" top="bboxTop" bottom="bboxBottom"/>
 * (end)
 */
Legato.Layer.Blank.Bean = Legato.Layer.Bean.Extend('Legato.Layer.Blank',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Layer.QName('BlankLayer'), {
	_constructor : Legato.Layer.Blank,
	constructorOrder : [ 'name', 'params' ],
	constructorArguments : {
		/*
		 * Property: name Defines the name of the blank layer instance.
		 *
		 * See Also: <OpenLayers.Layer>
		 */
		name : Legato.Lang.String,

		/*
		 * Property: params An object with key/value pairs representing the GetMap
		 * query string parameters and parameter values.
		 *
		 * See Also: <Legato.Layer.Blank>
		 */
		params : Legato.Lang.Object
	}
/*
 * factoryFunction : function(name, url, params, options) { var layer = new
 * OpenLayers.Layer.WMS(name, OpenLayers.Util .getImagesLocation() +
 * "blank.gif?", {}); return layer; }, constructorArguments : { name
 * :Legato.Lang.String }, constructorOrder : [ 'name' ]
 */

});

Legato.Layer.Blank.LayerFactory = Legato.Lang.Class(
		Legato.Format.ExtendedWMC.LayerFactory, {
			layerType : Legato.Layer.Blank.Bean
		});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('L:Blank',
		new Legato.Layer.Blank.LayerFactory());