/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.PanZoomBar = OpenLayers.Class(OpenLayers.Control.PanZoomBar, {
	initialize : function(options) {
		OpenLayers.Control.PanZoomBar.prototype.initialize.apply(this,
				arguments);
	},

	draw : function(px) {
		// initialize our internal div
		OpenLayers.Control.prototype.draw.apply(this, arguments);
		px = this.position.clone();

		// place the controls
		this.buttons = [];

		var sz = new OpenLayers.Size(18, 18);
		var centered = new OpenLayers.Pixel(px.x + sz.w / 2, px.y);
		var wposition = sz.w;

		if (this.zoomWorldIcon) {
			centered = new OpenLayers.Pixel(px.x + sz.w, px.y);
		}

		this._addButton("panup", this.displayClass + 'Up', centered, sz);
		px.y = centered.y + sz.h;
		this._addButton("panleft", this.displayClass + 'Left', px, sz);
		if (this.zoomWorldIcon) {
			this._addButton("zoomworld", this.displayClass + 'World', px.add(
					sz.w, 0), sz);

			wposition *= 2;
		}
		this._addButton("panright", this.displayClass + 'Right', px.add(
				wposition, 0), sz);
		this._addButton("pandown", this.displayClass + 'Down', centered.add(0,
				sz.h * 2), sz);
		this._addButton("zoomin", this.displayClass + 'In', centered.add(0,
				sz.h * 3 + 5), sz);
		centered = this._addZoomBar(centered.add(0, sz.h * 4 + 5));
		this._addButton("zoomout", this.displayClass + 'Out', centered, sz);
		return this.div;
	},

	_addZoomBar : function(centered) {
		var imgLocation = OpenLayers.Util.getImagesLocation();

		var id = this.id + "_" + this.map.id;
		var zoomsToEnd = this.map.getNumZoomLevels() - 1 - this.map.getZoom();
		var sliderXY = centered.add(-1, zoomsToEnd * this.zoomStopHeight);
		var sliderSZ = new OpenLayers.Size(20, 9);
		var slider = document.createElement('div');
		slider.className = this.displayClass + 'Slider';
		slider.style.position = 'absolute';
		slider.style.left = sliderXY.x + "px";
		slider.style.top = sliderXY.y + "px";
		slider.style.width = sliderSZ.w + "px";
		slider.style.height = sliderSZ.h + "px";
		this.slider = slider;

		this.sliderEvents = new OpenLayers.Events(this, slider, null, true, {
			includeXY : true
		});
		this.sliderEvents.on({
			"mousedown" : this.zoomBarDown,
			"mousemove" : this.zoomBarDrag,
			"mouseup" : this.zoomBarUp,
			"dblclick" : this.doubleClick,
			"click" : this.doubleClick
		});

		var sz = new OpenLayers.Size();
		sz.h = this.zoomStopHeight * this.map.getNumZoomLevels();
		sz.w = this.zoomStopWidth;
		var div = document.createElement('div');
		div.className = this.displayClass + 'Scroller';
		div.style.position = 'absolute';
		div.style.left = centered.x + "px";
		div.style.top = centered.y + "px";
		div.style.width = sz.w + "px";
		div.style.height = sz.h + "px";

		this.zoombarDiv = div;

		this.divEvents = new OpenLayers.Events(this, div, null, true, {
			includeXY : true
		});
		this.divEvents.on({
			"mousedown" : this.divClick,
			"mousemove" : this.passEventToSlider,
			"dblclick" : this.doubleClick,
			"click" : this.doubleClick
		});

		this.div.appendChild(div);

		this.startTop = parseInt(div.style.top, 10);
		this.div.appendChild(slider);

		this.map.events.register("zoomend", this, this.moveZoomBar);

		centered = centered.add(0, this.zoomStopHeight
				* this.map.getNumZoomLevels());
		return centered;
	},

	_addButton : function(id, _class, xy, sz) {
		var btn = document.createElement('div');
		btn.className = _class;
		btn.style.position = 'absolute';
		if (xy) {
			btn.style.left = xy.x + "px";
			btn.style.top = xy.y + "px";
		}
		if (sz) {
			btn.style.width = sz.w + "px";
			btn.style.height = sz.h + "px";
		}

		// we want to add the outer div
		this.div.appendChild(btn);

		OpenLayers.Event.observe(btn, "mousedown", OpenLayers.Function
				.bindAsEventListener(this.buttonDown, btn));
		OpenLayers.Event.observe(btn, "dblclick", OpenLayers.Function
				.bindAsEventListener(this.doubleClick, btn));
		OpenLayers.Event.observe(btn, "click", OpenLayers.Function
				.bindAsEventListener(this.doubleClick, btn));
		btn.action = id;
		btn.map = this.map;

		var getSlideFactor;
		if (!this.slideRatio) {
			var slideFactorPixels = this.slideFactor;
			getSlideFactor = function() {
				return slideFactorPixels;
			};
		} else {
			var slideRatio = this.slideRatio;
			getSlideFactor = function(dim) {
				return this.map.getSize()[dim] * slideRatio;
			};
		}

		btn.getSlideFactor = getSlideFactor;

		// we want to remember/reference the outer div
		this.buttons.push(btn);
		return btn;
	},

	CLASS_NAME : "Legato.Control.PanZoomBar"
});

/**
 * Component: lc:PanZoomBar
 * 
 * Inherits from:
 * - {<olc:PanZoomBar>}
 * 
 * See also:
 * - <lc> namespace
 * - {<Legato.Control.PanZoomBar>}
 * - <olc> namespace
 * - {<OpenLayers.Control.PanZoomBar>}
 */
Legato.Control.PanZoomBar.Bean = OpenLayers.Control.PanZoomBar.Bean.Extend(
//
'Legato.Control.PanZoomBar',
//
Legato.Control.QName('PanZoomBar'),
//
{
	_constructor : Legato.Control.PanZoomBar
});