/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.MeasurePolygon = OpenLayers.Class(OpenLayers.Control.Measure, {
  /*
   * Function: initialize Basic control for the legend control
   *
   * Parameters: options - {Object} A Hashmap containing option parameters for
   * this control The following keys are supported - div {DOMElement} an
   * optional DOMElement instance where this control should been rendered. If
   * not defined the legend control will render itself inside the map DOMElement
   */
  initialize : function(options) {
    if (!Legato.Lang.ObjectUtils.exists(options)) {
      options = [];
    }

    // style the sketch fancy
    var sketchSymbolizers = {
      Point : Legato.Feature.Style.DEFAULT_POINT,
      Line : Legato.Feature.Style.DEFAULT_LINE,
      Polygon : Legato.Feature.Style.DEFAULT_POLYGON
    };

    if (Legato.Lang.ObjectUtils.isArray(options.styles)) {
      for ( var i = 0; i < options.styles.length; i++) {
        var configuredStyle = options.styles[i];
        switch (configuredStyle.name.toUpperCase()) {
        case 'POINT':
          OpenLayers.Util.extend(sketchSymbolizers.Point,
              configuredStyle.styles);
          break;
        case 'LINE':
          OpenLayers.Util.extend(sketchSymbolizers.Line,
              configuredStyle.styles);
          break;
        case 'POLYGON':
          OpenLayers.Util.extend(sketchSymbolizers.Polygon,
              configuredStyle.styles);
          break;
        default:
          // IGNORE IT
          break;
        }
      }
    }

    var style = new OpenLayers.Style();

    style.addRules([ new OpenLayers.Rule({
      symbolizer : sketchSymbolizers
    }) ]);

    var styleMap = new OpenLayers.StyleMap({
      "default" : style
    });

    options.handlerOptions = {
      layerOptions : {
        styleMap : styleMap,
        legatoIgnore : true
      }
    };

    // options.geodesic = true;

    OpenLayers.Control.Measure.prototype.initialize.apply(this, [
        OpenLayers.Handler.Polygon, options ]);
    this.events.on({
      "measure" : this.handleMeasurements,
      "measurepartial" : this.handleMeasurements
    });

  },

  /*
   * Function: destroy APIMethod: called if destroyed
   */
  destroy : function() {
    this.events.un({
      "measure" : this.handleMeasurements,
      "measurepartial" : this.handleMeasurements
    });

    OpenLayers.Control.Measure.prototype.destroy.apply(this, arguments);
  },

  /*
   * Function: deactivate APIMethod: called when component is deactivated
   */
  deactivate : function() {
    this.div.innerHTML = "";
    OpenLayers.Control.Measure.prototype.deactivate.apply(this, arguments);
  },

  handleMeasurements : function(event) {
    var geometry = event.geometry;
    var units = event.units;
    var order = event.order;
    var measure = event.measure;
    var out = measure.toFixed(3) + " " + units + "<sup>2</" + "sup>";
    this.div.innerHTML = out;
  },

  CLASS_NAME : 'Legato.Control.MeasurePolygon'
});

Legato.Control.MeasurePolygon.Bean = OpenLayers.Control.Bean.Extend(
    'Legato.Control.MeasurePolygon',
    //
    Legato.Control.QName('MeasurePolygon'),
    //
    {
      _constructor : Legato.Control.MeasurePolygon,
      options : {
        persist : Legato.Lang.Boolean,
        styles : Legato.Beans.Object.List()
      }
    });