/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.DrawFeature = OpenLayers.Class(OpenLayers.Control.DrawFeature, {

  mode : 1,

  callback : null,

  style : null,

  attributes : {},

  /*
   * Defined by subclass
   */
  handlerConstructor : null,

  initialize : function(layer, options) {

    this.callbacks = OpenLayers.Util.extend({
      point : function(vertex, geometry) {
        this.layer.events.triggerEvent('legato.sketchpointadded', {
          layer : this.layer,
          vertex : vertex,
          geometry : geometry
        });
      }
    }, this.callbacks);

    /*
     * By default we want to be notified if a new point has been added to this
     * new geometry. If this happenes we're tiggering an layer event which
     * somebody may subscribe or not.
     */
    this.handlerOptions = {
      freehandToggle : null,
      layerOptions : {
        isFeatureLayer : true
      }
    };

    this.style = options.style || null ;
    this.attributes = options.attributes || {} ;

    OpenLayers.Control.DrawFeature.prototype.initialize.apply(this, [ layer,
        this.handlerConstructor, options ]);

    /*
     * by default we subscribe for an event which is triggered when somebody has
     * changed the drawn geometry from outside. If this may happens we want ot
     * be notified about this.
     */
    layer.events.on({
      'legato.sketchupdated' : this.onSketchUpdated,
      scope : this
    });
  },

  destroy : function() {
    OpenLayers.Control.DrawFeature.prototype.destroy.apply(this, arguments);
  },

  setMap : function(map) {
    OpenLayers.Control.DrawFeature.prototype.setMap.apply(this, arguments);
  },

  drawFeature : function(geometry) {
    var attributes = OpenLayers.Util.extend({}, this.attributes);
    var style = this.style !== null ? OpenLayers.Util.extend({}, this.style) : null;

    var feature = new OpenLayers.Feature.Vector(geometry, attributes, style);
    var proceed = this.layer.events.triggerEvent('sketchcomplete', {
      feature : feature
    });
    if (proceed !== false) {
      feature.state = OpenLayers.State.INSERT;
      if (this.mode == 1) {
        this.layer.addFeatures([ feature ]);
        this.featureAdded(feature);
        this.events.triggerEvent('featureadded', {
          feature : feature
        });
      }
      if (this.mode == 2) {
        this.layer.destroyFeatures();
        this.layer.addFeatures([ feature ]);
        this.featureAdded(feature);
        this.events.triggerEvent('featureadded', {
          feature : feature
        });
      }
    }
    if (Legato.Lang.ObjectUtils.isFunction(this.callback)) {
      this.callback(geometry);
    }
  },

  /*
   * If someone may have changed the geometry withing this layer we're ensuring
   * that this layer gets redrawn so the the shown geometry is allways up to
   * date.
   */
  onSketchUpdated : function(event) {
    if (this.handler.drawing) {
      this.handler.drawFeature();
    } else {
      this.layer.redraw();
    }
  },

  CLASS_NAME : 'Legato.Control.DrawFeature'
});

Legato.Control.DrawFeature.MODE_ADD_FEATURE = 1;
Legato.Control.DrawFeature.MODE_REPLACE_FEATURE = 2;

Legato.Control.DrawFeature.Bean = OpenLayers.Control.DrawFeature.Bean.Extend(
//
'Legato.Control.DrawFeature',
//
Legato.Control.QName('DrawFeature'),
//
{
  _constructor : Legato.Control.DrawFeature,
  constructorArguments : {
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ],
  options : {
    mode : Legato.Lang.Integer.Enum('Legato.Control.DrawFeature.MODE', {
      'MODE_ADD_FEATURE' : 1,
      'MODE_REPLACE_FEATURE' : 2
    }),
    callback : Legato.Lang.Function
  }
});