/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author$
 * @version $Revision$
 * @requires Legato.js
 * @requires Legato/Util.js
 */

/**
 * Class: Legato.Lang.NumberUtils Some common util methods for numbers
 */
Legato.Lang.NumberUtils = {};

/**
 * Function: Legato.Lang.NumberUtils.toFloat Try to parse given param into a
 * number and returns it if possible. Throws Exception otherwise.
 *
 * Parameters: value - {String} The String you want to parse into a number
 *
 * Returns: {Number} The parsed value as Number
 */
Legato.Lang.NumberUtils.toFloat = function(value) {
  if (Legato.Lang.ObjectUtils.isNumber(value)) {
    return value;
  }

  if (Legato.Lang.ObjectUtils.isNull(value)) {
    return null;
  }

  if (Legato.Lang.ObjectUtils.isString(value)) {
    var parsedFloat = parseFloat(value);
    if (isNaN(parsedFloat)) {
      throw Error('Given string is not parsable into a float');
    }
    return parsedFloat;
  }

  throw new Error('The object type \'' + typeof value + '\' is not supported');
};

Legato.Lang.NumberUtils.roundScale = function(value, scale) {
  Legato.Util.Ensure.ensureNumber(value);
  var power = Math.round(scale);
  var multiplicator = Math.pow(10, power);
  return Math.round(value * multiplicator) / multiplicator;
};