/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: valikov $
 * @version $Rev: 72369 $
 * @base Legato.Control
 * @requires Legato/Control.js
 */

/**
 * Class: SelectBounds
 * 
 * Inherits from: - <Legato.Control>
 */
Legato.Control.SelectBounds = OpenLayers.Class(Legato.Control, {
  /**
   * Property: type {OpenLayers.Control.TYPE}
   */
  type :OpenLayers.Control.TYPE_TOOL,

  /**
   * Property: callback {Function} callback function
   */
  callback :null,

  handler :null,

  /**
   * Constructor: Legato.Control.SelectBounds
   * 
   * Parameters: options - {Object} An optional object whose properties will be
   * set on this instance. currently no options are supported yet.
   */
  initialize : function(options) {
    Legato.Control.prototype.initialize.apply(this, arguments);
    // Legato.Util.Ensure.ensureFunction(this.callback,
  // 'To use ' + this.CLASS_NAME + ' you must specify a callback function.');
},

  /**
   * Method: draw
   */
  draw : function() {

    // Initializes the handler and callback methods
    this.handler = new OpenLayers.Handler.Box(this, {
      done :this.select
    });
  },

  select : function(draftBounds) {
    
    if (draftBounds instanceof OpenLayers.Bounds)
    {
      var lowerLeftLonLat = this.map.getLonLatFromPixel(new OpenLayers.Pixel(
        draftBounds.left, draftBounds.bottom));
      var upperRightLonLat = this.map.getLonLatFromPixel(new OpenLayers.Pixel(
        draftBounds.right, draftBounds.top));
      var bounds = new OpenLayers.Bounds(lowerLeftLonLat.lon,
        lowerLeftLonLat.lat, upperRightLonLat.lon, upperRightLonLat.lat);

      if (Legato.Lang.ObjectUtils.isFunction(this.callback)) {
        this.callback(bounds);
      }
    }
  },

  /**
   * APIMethod: destroy Deconstruct the control
   */
  destroy : function() {
    if (Legato.Lang.ObjectUtils.exists(this.handler)) {
      this.handler.destroy();
    }
  },

  CLASS_NAME :'Legato.Control.SelectBounds'
});

/**
 * Structure: lc:SelectBounds XML based config for a
 * <Legato.Control.SelectBounds>.
 * 
 * See Also: - <Legato.Control> - <Legato.Beans.BeanFactory>
 * 
 * A valid config example for a SelectBounds would be: (start code)
 * <lc:SelectBounds/> (end)
 */
Legato.Control.SelectBounds.Bean = Legato.Control.Bean.Extend(

'Legato.Control.SelectBounds',

/*
 * Property: QName The qualified name for this control. Needed by XML config to
 * instantiate it.
 */
Legato.Control.QName('SelectBounds'), {
  _constructor :Legato.Control.SelectBounds,
  options : {
    callback :Legato.Lang.Function,
    displayClass :Legato.Lang.String
  }
});
