/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 */

/**
 * Class: Legato.Control.Legend.Plugin
 * 
 * Abstract base class for all <Legato.Legend.Plugin> subclasses.
 * Defines some common behaviour for all plugins.
 * Controlled and used by <Legato.Control.Legend> class.
 */
Legato.Control.Legend.Plugin = OpenLayers.Class({

	/**
	 * Property: id {String}
	 */
	id : null,

	/**
	 * Property: map {<OpenLayers.Map>} The current map
	 */
	map : null,

	/**
	 * Property: layer {<OpenLayers.Layer>} layer associated with the plugin
	 * instance
	 */
	layer : null,

	/**
	 * Property: div {DOMElement}
	 */
	div : null,

	/**
	 * Property: displayClass {string} This property is used for CSS related to
	 * the drawing of the Control.
	 */
	displayClass : '',

	/**
	 * Property: title {string} This property is used for showing a tooltip over
	 * the Control.
	 */
	title : '',

	/**
	 * Function: initialize Basic ctor
	 *
	 * Parameters: layer - {<OpenLayers.Layer>} The layer where this plugin
	 * should be associated with options - {Object} A Hashmap containing option
	 * parameters for this control
	 */
	initialize : function(layer, options) {
		Legato.Util.Ensure.ensureObject(layer);
		this.map = layer.map;
		this.layer = layer;
		this.displayClass = this.CLASS_NAME.replace(/\./g, "");
		OpenLayers.Util.extend(this, options);
		if (this.id === null) {
			this.id = OpenLayers.Util.createUniqueID(this.CLASS_NAME + "_")
					+ ':' + this.layer.id;
		}
		this.afterInitialized();
	},

	/**
	 * Function: afterInitialized
	 *
	 * Called after the initialize method. Overwrite to validate your custom
	 * legend plugin
	 */
	afterInitialized : function() {
	},

	/**
	 * Function: draw
	 *
	 * Draws this legend plugin
	 */
	draw : function() {
		this.setup();
		return this.div;
	},

	/**
	 * Function: setup
	 *
	 * Draws this legend plugin by creating a plugin div, calling the update
	 * function and afterSetup method.
	 */
	setup : function() {
		if (this.div === null) {
			this.create();
		}
		this.update();
		this.afterSetup();
	},

	/**
	 * Function: create Creates the plugin div
	 */
	create : function() {
		this.div = document.createElement('div');
		this.div.id = this.id;
		this.div.title = this.title;
		this.div.className = this.displayClass;
		if (this.title != '') {
			this.div.title = this.title;
		}
	},

	/**
	 * Function: update Implemented by plugin subclasses. Used to update the
	 * associated plugin div.
	 */
	update : function() {
	},

	/**
	 * Function: afterSetup Optional implemented by plugin subclasses. Basically
	 * used to register some event handlers, like user clicks the legend plugin
	 * div and such.
	 */
	afterSetup : function() {
	},

	/**
	 * Function: destroy
	 *
	 * See Also: <OpenLayer.Control>
	 */
	destroy : function() {
		this.beforeDestroyed();
		this.layer = null;
		this.div = null;
	},

	/**
	 * Function: beforeDestroyed Optionally implemented by subclasses. Basically
	 * used to remove all event handlers and such.
	 */
	beforeDestroyed : function() {
	},

	isListedBaseLayer : function(layer) {
		return Legato.OpenLayers.Map.Util.isListedBaseLayer(layer);
	},

	isListedOverlay : function(layer) {
		return Legato.OpenLayers.Map.Util.isListedOverlay(layer);
	},
	CLASS_NAME : 'Legato.Control.Legend.Plugin'
});

Legato.Control.Legend.Plugin.Factory = OpenLayers
		.Class({
			pluginOptions : null,
			predicate : null,
			initialize : function(options) {
				var pluginOptions = {};
				OpenLayers.Util.extend(pluginOptions, options);

				if (Legato.Lang.ObjectUtils.isObject(pluginOptions.supports)
						&& Legato.Lang.ObjectUtils
								.isFunction(pluginOptions.supports.evaluate)) {
					this.predicate = pluginOptions.supports;
					delete pluginOptions.supports;
				}
				this.pluginOptions = pluginOptions;
			},
			destroy : function() {
				this.pluginOptions = null;
			},
			create : function(layer) {
				return new Legato.Control.Legend.Plugin(layer,
						this.pluginOptions);
			},
			supports : function(layer) {
				if (!Legato.Lang.ObjectUtils.exists(layer)) {
					return false;
				} else if (Legato.Lang.ObjectUtils.isObject(this.predicate)
						&& Legato.Lang.ObjectUtils
								.isFunction(this.predicate.evaluate)) {
					return this.predicate.evaluate(layer);
				} else {
					return true;
				}
			},
			CLASS_NAME : 'Legato.Control.Legend.Plugin.Factory'

		});

/**
 * Space: llp
 * 
 * URI: Namespace URI
 * http://www.disy.net/legato/legend/plugin
 */
Legato.Control.Legend.Plugin.NAMESPACE_URI = 'http://www.disy.net/legato/legend/plugin';
/**
 * Prefix: Default prefix
 * llp
 */
Legato.Control.Legend.Plugin.PREFIX = 'llp';
Legato.Control.Legend.Plugin.QName = function(localPart) {
	return new Legato.XML.QName(Legato.Control.Legend.Plugin.NAMESPACE_URI,
			localPart, Legato.Control.Legend.Plugin.PREFIX);
};

/**
 * Component: llp:Plugin
 * 
 * See also:
 * - <llp> namespace
 * - {<Legato.Control.Legend.Plugin>}
 */
Legato.Control.Legend.Plugin.Bean = Legato.Beans.Object.Extend(
		'Legato.Control.Legend.Plugin.Factory',

		Legato.Control.Legend.Plugin.QName('Plugin'), {
			_constructor : Legato.Control.Legend.Plugin.Factory,
			options : {
				/**
				 * Element: supports
				 * {<lp:Predicate>}
				 */
				supports : Legato.Beans.Object,
				/**
				 * Element: displayClass
				 * {String}
				 */
				displayClass : Legato.Lang.String,
				/**
				 * Element: title
				 * {String}
				 */
				title : Legato.Lang.String
			}
		});
