/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.Transformer.SublayerFilteringTransformer = OpenLayers.Class(
    Legato.Layer.Transformer, {

      predicate : null,

      initialize : function(predicate) {
        Legato.Layer.Transformer.prototype.initialize.apply(this);
        Legato.Util.Ensure.ensureObject(predicate);
        this.predicate = predicate;
      },

      transform : function(layer) {
        var id = layer.layerId.split(',');

        if (id.length === 1) {
          if (this.predicate.evaluate(layer)) {
            return layer;
          }
          return null;
        }

        var evaluatedLayerIds = [];
        var clonedLayer = layer.clone();

        for ( var i = 0; i < id.length; i++) {
          clonedLayer.layerId = id[i];
          clonedLayer.params.LAYERS = id[i];
          if (this.predicate.evaluate(clonedLayer)) {
            evaluatedLayerIds.push(id[i]);
          }
        }

        if (evaluatedLayerIds.length !== 0) {
          var transformedId =  evaluatedLayerIds.join(",");
          clonedLayer.layerId = transformedId;
          clonedLayer.params.LAYERS = transformedId;
          return clonedLayer;
        }
        return null;
      },
      CLASS_NAME : 'Legato.Layer.Transformer.SublayerFilteringTransformer'
    });

/**
 * Component: lltr:SublayerFilteringTransformer
 *
 * The SublayerFilteringTransformer transforms the layer params attribute if configured
 * predicate matches.
 *
 * See also:
 * - <lla> namespace
 */
Legato.Layer.Transformer.SublayerFilteringTransformer.Bean = Legato.Layer.Transformer.Bean
    .Extend(
    //
    'Legato.Layer.Transformer.SublayerFilteringTransformer',
    //
    Legato.Layer.QName('SublayerFilteringTransformer'),
    //
    {
      _constructor : Legato.Layer.Transformer.SublayerFilteringTransformer,
      options : {
        /**
         * Element: predicate
         * {<lp:Predicate>} A predicate. If predicate matches the layer will been transformed.
         */
        predicate : Legato.Predicate
      }
    });
