/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Lang.Integer = new (Legato.Lang.Class(Legato.Lang.AnySimpleType, {
  typeName: 'Legato.Lang.Integer',
  isInstance : function(value) {
    return ((typeof value) == 'number' && (value % 1 === 0));
  },
  fromStringSafe : function(value) {
    var number = Number(value);
    if (isNaN(number)) {
      throw Error('Could not parse [' + value + '].');
    } else if ((number % 1) !== 0) {
      throw Error('Number is not an integer [' + value + '].');
    } else {
      return number;
    }
  }
}))();

Legato.Lang['Integer{}'] = Legato.Lang.Integer.Map();
Legato.Lang['Integer[]'] = Legato.Lang.Integer.List();