/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerDescription
 */
Legato.Control.Legend.Plugin.LayerDescription = OpenLayers.Class(
    Legato.Control.Legend.Plugin, {

      /**
       * Property: plugins {Array}
       */
      image :null,

      /**
       * Function: create
       */
      create : function() {
        Legato.Control.Legend.Plugin.prototype.create.apply(this, arguments);
        this.image = document.createElement('img');
        this.image.className = this.displayClass + "Image";
        this.div.appendChild(this.image);
      },

      /**
       * Function: update
       */
      update : function() {
        if(!this.layer.visibility || !this.layer.inRange){
          OpenLayers.Element.hide(this.div);
        } else {
          var legendURL = this.layer.legend.getURL(this.layer);
          this.image.src = legendURL;
          OpenLayers.Element.show(this.div);
        }
      },

      /**
       * Function: update
       * Parameters:
       * evt - {Object} event
       */
      updateVisibility : function(evt) {
        if (evt.layer && evt.layer === this.layer && evt.property && evt.property === "visibility") {
          this.update();
        }
      },

      /**
       * Function: afterSetup
       */
      afterSetup : function() {
        this.map.events.on( {
          'changelayer' : this.updateVisibility,
          scope : this
        });
        this.layer.events.on( {
          'moveend' : this.update,
          scope : this
        });
        this.layer.events.on( {
          'visibilitychanged' :this.updateVisibility,
          scope :this
        });
      },

      /**
       * Function: beforeDestroyed
       */
      beforeDestroyed : function() {
        this.map.events.un( {
          'changelayer' : this.updateVisibility,
          scope : this
        });
        this.layer.events.un( {
          'moveend' : this.update,
          scope : this
        });
        this.layer.events.un( {
          'visibilitychanged' :this.updateVisibility,
          scope :this
        });
      },
      CLASS_NAME :'Legato.Control.Legend.Plugin.LayerDescription'
    });

/**
 * Class: Legato.Control.Legend.Plugin.LayerDescription.Factory Factory class
 * wich is able to create a <Legato.Control.Legend.Plugin.LayerDescription>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerDescription.Factory = OpenLayers.Class(
    Legato.Control.Legend.Plugin.Factory, {

      /**
       * Function: create Factory method for creating a
       * <Legato.Control.Legend.Plugin.LayerDescription> instance.
       */
      create : function(layer) {
        return new Legato.Control.Legend.Plugin.LayerDescription(layer,
            this.pluginOptions);
      },

      /**
       * Function: supports Just layers wich provide the getURL method are
       * supported.
       */
      supports : function(layer) {
        return Legato.Control.Legend.Plugin.Factory.prototype.supports.apply(this,
            arguments)
            && Legato.Lang.ObjectUtils.exists(layer.legend)
            && Legato.Lang.ObjectUtils.isFunction(layer.legend.getURL);
      },
      CLASS_NAME :'Legato.Control.Legend.Plugin.LayerDescription.Factory'
    });

/**
 * Structure: llp:LayerDescription XML based config for
 * <Legato.Control.Legend.Plugin.LayerDescription>.
 *
 * See Also: - <Legato.Control.Legend.Plugin> - <Legato.Beans.BeanFactory> -
 * <QName>
 *
 * A valid config example for a Layer Plugin would be:
 * (start code)
 * <llp:LayerDescription />
 * (end)
 */
Legato.Control.Legend.Plugin.LayerDescription.Bean = Legato.Control.Legend.Plugin.Bean
    .Extend(

    'Legato.Control.Legend.Plugin.LayerDescription.Factory',

    /**
     * Property: QName The qualified name for this control. Needed by XML config
     * to instantiate it.
     */
    Legato.Control.Legend.Plugin.QName('LayerDescription'), {
      _constructor :Legato.Control.Legend.Plugin.LayerDescription.Factory
    });