/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: FeatureSelector
 * 
 * Inherits from: - <OpenLayers.Control>
 */
Legato.Control.FeatureSelector = OpenLayers.Class(OpenLayers.Control, {

  type : OpenLayers.Control.TYPE_TOOL,

  eventTypes : [ 'addlayer', 'removelayer', 'changebaselayer', 'legato.selectlayer', 'legato.deselectlayer' ],

  layerPredicate : null,

  controller : null,

  callback : null,

  exceptionHandler : null,

  handlerConstructor : Legato.Handler.Box,

  handler : null,

  enabled : false,

  initialize : function(options) {
    OpenLayers.Control.prototype.initialize.apply(this, arguments);
    if (!Legato.Lang.ObjectUtils.isFunction(this.callback)) {
      this.callback = function(result) {
      };
    }
    if (!Legato.Lang.ObjectUtils.isFunction(this.exceptionHandler)) {
      this.exceptionHandler = function(message, exception) {
        alert(message);
      };
    }
    if (!Legato.Lang.ObjectUtils.isFunction(this.controller)) {
      this.controller = function(layers, selectionGeometry, mode, callbacks) {
        return callbacks.callback({
          layers : layers,
          selectionGeometry : selectionGeometry,
          mode : mode
        });
      };
    }
    if (!Legato.Lang.ObjectUtils.isObject(this.layerPredicate)) {
      this.layerPredicate = new Legato.Predicate.True();
    }
    if (!Legato.Lang.ObjectUtils.isObject(this.handler)) {
      this.handler = new this.handlerConstructor(this, {
        done : OpenLayers.Function.bind(this.selectGeometry, this, OpenLayers.Handler.MOD_NONE)
      }, {
        keyMask : OpenLayers.Handler.MOD_NONE
      });
    }
  },
  destroy : function() {
    for ( var index = 0; index < this.eventTypes.length; index++) {
      var eventType = this.eventTypes[index];
      this.map.events.unregister(eventType, this, this.refresh);
    }
    this.layerPredicate = null;
    this.controller = null;
    this.handlerConstructor = null;
    this.enabled = false;
    OpenLayers.Control.prototype.destroy.apply(this, arguments);
  },
  getLayers : function() {
    var layers = [];
    for ( var index = 0; index < this.map.layers.length; index++) {
      var layer = this.map.layers[index];
      if (this.layerPredicate.evaluate(layer)) {
        layers.push(layer);
      }
    }
    return layers;

  },
  selectGeometry : function(mode, selectionGeometry) {
    this.controller(this.getLayers(), selectionGeometry, mode, {
      callback: this.callback,
      exceptionHandler: this.exceptionHandler
    });
  },
  refresh : function() {
    var layers = this.getLayers();
    this.enabled = (layers.length > 0);
    if (!this.enabled) {
      OpenLayers.Element.removeClass(this.panel_div, 'enabled');
      OpenLayers.Element.addClass(this.panel_div, 'disabled');
      this.deactivate();
    } else {
      OpenLayers.Element.removeClass(this.panel_div, 'disabled');
      OpenLayers.Element.addClass(this.panel_div, 'enabled');
    }
  },
  activate : function() {
    if (!this.enabled) {
      return false;
    } else {
      this.handler.activate();
      OpenLayers.Control.prototype.activate.apply(this, arguments);
    }
  },
  deactivate : function() {
    this.handler.deactivate();
    OpenLayers.Control.prototype.deactivate.apply(this, arguments);
  },
  setMap : function(map) {
    OpenLayers.Control.prototype.setMap.apply(this, arguments);
    for ( var index = 0; index < this.eventTypes.length; index++) {
      var eventType = this.eventTypes[index];
      this.map.events.register(eventType, this, this.refresh);
    }
    this.refresh();
  },

  CLASS_NAME : 'Legato.Control.FeatureSelector'
});

Legato.Control.FeatureSelector.Bean = Legato.Control.Bean.Extend(

'Legato.Control.FeatureSelector',

Legato.Control.QName('FeatureSelector'), {
  _constructor : Legato.Control.FeatureSelector,
  options : {
    /*
     * Property: layerPredicate
     * 
     * Predicate which tells if a layer should be considered for feature
     * selection or not.
     */
    layerPredicate : Legato.Beans.Object,

    /*
     * Property: controller
     * 
     * Feature selection function. Function with an interface function(layers,
     * selectionGeometry, mode, { callback: callback, exceptionHandler: exceptionHandler }).
     */
    controller : Legato.Lang.Function,

    /*
     * Property: callback
     * 
     * Callback for selection results. Function with an interface
     * function(result).
     */
    callback : Legato.Lang.Function,
    /*
     * Property: exceptionHandler
     * 
     * Callback for exception handler. Function with an interface
     * function(message, exception).
     */
    exceptionHandler : Legato.Lang.Function,

    /*
     * Property: eventTypes
     * 
     * Types of map events this control should react to.
     */
    eventTypes : Legato.Lang['String[]']
  }
});