/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.CallbackLocker = OpenLayers.Class(OpenLayers.Control, {
	targetElement : null,

	lock : null,

	unlock : null,

	initialize : function(options) {
		Legato.Util.Ensure.ensureExists(options.targetElement);
		Legato.Util.Ensure.ensureFunction(options.lock);
		Legato.Util.Ensure.ensureFunction(options.unlock);
		OpenLayers.Control.prototype.initialize.apply(this, arguments);
	},

	lockElement : function() {
		this.lock(this.targetElement);
	},

	unlockElement : function() {
		this.unlock(this.targetElement);
	},

	CLASS_NAME : 'Legato.Control.CallbackLocker'
});

Legato.Control.CallbackLocker.Bean = OpenLayers.Control.Bean.Extend(

'Legato.Control.CallbackLocker',

Legato.Control.QName('CallbackLocker'), {
	_constructor : Legato.Control.CallbackLocker,
	options : {
		targetElement : Legato.Lang.Element,

		lock : Legato.Lang.Function,

		unlock : Legato.Lang.Function
	}
});
