/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Text.PrecisionScaleFormat = OpenLayers.Class(Legato.Text.Format, {
  precision :20,
  scale :10,
  numberFormat :null,
  initialize : function(precision, scale, options) {
    if (Legato.Lang.ObjectUtils.exists(precision)) {
      this.precision = precision;
    }
    if (Legato.Lang.ObjectUtils.exists(scale)) {
      this.scale = scale;
    }
    if (Legato.Lang.ObjectUtils.exists(options)) {
      OpenLayers.Util.extend(this, options);
    }
    if (!Legato.Lang.ObjectUtils.exists(this.numberFormat)) {
      this.numberFormat = new Legato.Text.DecimalFormat();
    }
  },
  format : function(number) {

    var precised;
    if (this.precision > 0) {
      var digitsRude = Math.floor(Math.log(number) / Math.log(10));
      var digits = (Math.pow(10, digitsRude) < number ? digitsRude + 1
          : digitsRude);
      precised = Math.round(number * Math.pow(10, this.precision - digits))
          * Math.pow(10, digits - this.precision);
    } else {
      precised = number;
    }
    var precisedAndScaled;
    if (this.scale >= 0) {
      precisedAndScaled = Math.round(precised * Math.pow(10, this.scale))
          * Math.pow(10, -this.scale);
    } else {
      precisedAndScaled = precised;
    }
    return this.numberFormat.format(precisedAndScaled);
  },
  parse : function(string) {
    return this.numberFormat.parse(string);
  },
  destroy : function() {
  },
  CLASS_NAME :"Legato.Text.DecimalFormat"
});

Legato.Text.PrecisionScaleFormat.Bean = Legato.Beans.Object.Extend(
    'Legato.Text.PrecisionScaleFormat',
    //
    Legato.Text.QName('PrecisionScaleFormat'),
    //
    {
      _constructor :Legato.Text.PrecisionScaleFormat,
      options : {
        precision :Legato.Lang.Integer,
        scale :Legato.Lang.Integer,
        format :Legato.Beans.Object
      }
    });
