/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.PanZoom = OpenLayers.Class(OpenLayers.Control.PanZoom,
    {
      initialize : function(options) {
        OpenLayers.Control.PanZoom.prototype.initialize.apply(this, arguments);
      },
      draw : function(px) {
        // initialize our internal div
      OpenLayers.Control.prototype.draw.apply(this, arguments);
      px = this.position;

      // place the controls
      this.buttons = [];

      var sz = new OpenLayers.Size(18, 18);
      var centered = new OpenLayers.Pixel(px.x + sz.w / 2, px.y);

      this._addButton("panup", this.displayClass + 'Up', centered, sz);
      px.y = centered.y + sz.h;
      this._addButton("panleft", this.displayClass + 'Left', px, sz);
      this._addButton("panright", this.displayClass + 'Right', px.add(sz.w, 0),
          sz);
      this._addButton("pandown", this.displayClass + 'Down', centered.add(0,
          sz.h * 2), sz);
      this._addButton("zoomin", this.displayClass + 'In', centered.add(0,
          sz.h * 3 + 5), sz);
      this._addButton("zoomworld", this.displayClass + 'World', centered.add(0,
          sz.h * 4 + 5), sz);
      this._addButton("zoomout", this.displayClass + 'Out', centered.add(0,
          sz.h * 5 + 5), sz);
      return this.div;
    },

    _addButton : function(id, _class, xy, sz) {
      var btn = document.createElement('div');
      btn.className = _class;
      btn.style.position = 'absolute';
      if (xy) {
        btn.style.left = xy.x + "px";
        btn.style.top = xy.y + "px";
      }
      if (sz) {
        btn.style.width = sz.w + "px";
        btn.style.height = sz.h + "px";
      }

      // we want to add the outer div
      this.div.appendChild(btn);

      OpenLayers.Event.observe(btn, "mousedown", OpenLayers.Function
          .bindAsEventListener(this.buttonDown, btn));
      OpenLayers.Event.observe(btn, "dblclick", OpenLayers.Function
          .bindAsEventListener(this.doubleClick, btn));
      OpenLayers.Event.observe(btn, "click", OpenLayers.Function
          .bindAsEventListener(this.doubleClick, btn));
      btn.action = id;
      btn.map = this.map;

      var getSlideFactor;

      if (!this.slideRatio) {
        var slideFactorPixels = this.slideFactor;
        getSlideFactor = function() {
          return slideFactorPixels;
        };
      } else {
        var slideRatio = this.slideRatio;
        getSlideFactor = function(dim) {
          return this.map.getSize()[dim] * slideRatio;
        };
      }

      btn.getSlideFactor = getSlideFactor;

      // we want to remember/reference the outer div
      this.buttons.push(btn);
      return btn;
    },

    CLASS_NAME :"Legato.Control.PanZoom"
    });

Legato.Control.PanZoom.Bean = OpenLayers.Control.PanZoom.Bean.Extend(
//
    'Legato.Control.PanZoom',
    //
    Legato.Control.QName('PanZoom'),
    //
    {
      _constructor :Legato.Control.PanZoom
    });