/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Class: Legato.Control.NavigationHistory
 * 
 * 
 * Inherits from: - <OpenLayers.Control.NavigationHistory>
 */
Legato.Control.NavigationHistory = OpenLayers.Class(
    OpenLayers.Control.NavigationHistory, {

      EVENT_TYPES : [ "previousChange", "nextChange" ],

      /**
       * Constructor: OpenLayers.Control.NavigationHistory
       * 
       * Parameters: options - {Object}
       */
      initialize : function(options) {
        /* HACK OpenLayers Start */
        // To avoid creation of buttons we just copy parts of
        // OpenLayers.Control.NavigationHistory constructor
        OpenLayers.Control.prototype.initialize.apply(this, [ options ]);

        this.registry = OpenLayers.Util.extend({
          "moveend" : function() {
            return {
              center : this.map.getCenter(),
              resolution : this.map.getResolution()
            };
          }
        }, this.registry);

        this.clear();
        /* HACK OpenLayers End */
      },
      
      /**
       * APIMethod: destroy
       * Destroy the control.
       */
      destroy : function() {
        /* HACK OpenLayers Start */
        // To avoid creation of buttons we just copy parts of
        // OpenLayers.Control.NavigationHistory constructor
        OpenLayers.Control.prototype.destroy.apply(this);
        this.deactivate();
        this.registry = null;
        this.nextStack = null;
        this.previousStack = null;
        this.listeners = null;
        /* HACK OpenLayers End */
      },

      /**
       * Method: onPreviousChange Called when the previous history stack
       * changes.
       * 
       * Parameters: state - {Object} An object representing the state to be
       * restored if previous is triggered again or null if no previous states
       * remain. length - {Integer} The number of remaining previous states that
       * can be restored.
       */
      onPreviousChange : function(state, length) {
        this.events.triggerEvent('previousChange', {
          state : state,
          length : length
        });
      },

      /**
       * Method: onNextChange Called when the next history stack changes.
       * 
       * Parameters: state - {Object} An object representing the state to be
       * restored if next is triggered again or null if no next states remain.
       * length - {Integer} The number of remaining next states that can be
       * restored.
       */
      onNextChange : function(state, length) {
        this.events.triggerEvent('nextChange', {
          state : state,
          length : length
        });
      },

      /**
       * Method: draw Called when the control is added to the map.
       */
      draw : function() {
        OpenLayers.Control.prototype.draw.apply(this, arguments);
        if (this.activateOnDraw) {
          this.activate();
        }
      },

      /** 
       * Method: setMap
       * Set the map property for the control.
       *
       * Parameters:
       * map - {<OpenLayers.Map>} 
       */
      setMap : function(map) {
        this.map = map;
      },

      CLASS_NAME : "Legato.Control.NavigationHistory"

    });

/**
 * Structure: lc:NavigationHistory XML based config for a
 * <Legato.Control.NavigationHistory>.
 *
 * See Also: - <OpenLayers.Control.NavigationHistory> - <Legato.Beans.BeanFactory> - <QName>
 *
 * A valid config example for a NavigationHistory would be:
 * (start code)
 * <lc:NavigationHistory limit="50" activateOnDraw="true" clearOnDeactivate="false" />
 * (end)
 */
Legato.Control.NavigationHistory.Bean = Legato.Control.Bean.Extend(
    'Legato.Control.NavigationHistory', Legato.Control
        .QName('NavigationHistory'), {
      _constructor : Legato.Control.NavigationHistory,
      options : {
        limit : Legato.Lang.Integer,

        activateOnDraw : Legato.Lang.Boolean,

        clearOnDeactivate : Legato.Lang.Boolean
      }
    });