/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Layer.VectorOSM = OpenLayers.Class(OpenLayers.Layer.GML, {
	format: OpenLayers.Format.OSM,
    projection: new OpenLayers.Projection("EPSG:4326"),
	CLASS_NAME : 'Legato.Layer.VectorOSM'

});


/**
 * Component: lla:VectorOSM
 * 
 * Supports OpenStreetMap vector data
 * 
 * Inherits from:
 * - {<oll:GML>}
 * 
 * See also:
 * - <lla> namespace
 * - <oll> namespace
 * - {<Legato.Layer.VectorOSM}}
 * - {<OpenLayers.Layer.GML}}
 * - {<OpenLayers.Layer.XYZ}}
 * - {<OpenLayers.Layer.OSM}}
 * - <Legato:VectorOSM> layer type
 * - <OL:XYZ> layer type
 * - <OL:OSM> layer type
 */
Legato.Layer.VectorOSM.Bean = OpenLayers.Layer.GML.Bean.Extend(
		'Legato.Layer.VectorOSM',
		//
		Legato.Layer.QName('VectorOSM'), {
			//
			_constructor : Legato.Layer.VectorOSM
		});

/**
 * Layer type: Legato:VectorOSM
 * 
 * See also:
 * - {<lla:VectorOSM>}
 * - {<oll:XYZ>}
 * - {<oll:OSM>}
 * - {<Legato.Layer.VectorOSM>}
 * - {<OpenLayers.Layer.XYZ>}
 * - {<OpenLayers.Layer.OSM>}
 * 
 * Example:
 * (start code)
 * <Layer queryable="0" hidden="0">                                                                       
 *   <Server service="Legato:VectorOSM" version="0.6" title="Legato:VectorOSM">                                           
 *     <OnlineResource xlink:type="simple" xlink:href="http://api.openstreetmap.org/api/0.6/relation/177453/full" />
 *   </Server>                                                                                            
 *   <Name>S2</Name>                                                                              
 * </Layer>                                                                                               
 * (end)
 */
Legato.Layer.VectorOSM.LayerFactory = Legato.Lang.Class(
//
Legato.Format.ExtendedWMC.LayerFactory,
//
{
	layerType : Legato.Layer.VectorOSM.Bean
});

Legato.Format.ExtendedWMC.registerDefaultLayerFactory('Legato:VectorOSM',
		new Legato.Layer.VectorOSM.LayerFactory());