/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Format.GML3 = OpenLayers.Class(OpenLayers.Format.GML.v3, {

  featureNS :"http://www.opengis.net/gml/simple",
  featureName :"Feature",
  featureCollectionName :"FeatureCollection",
  featureGeometryName :"geometry",

  initialize : function(options) {
    OpenLayers.Format.GML.v3.prototype.initialize.apply(this, [ options ]);
    this.featureType = this.featureName;
    this.geometryName = this.featureGeometryName;
    this.namespaces.feature = this.featureNS;
    this.namespaceAlias[this.featureNS] = 'feature';

    this.writers.feature[this.featureCollectionName] = OpenLayers.Function
        .bind(this.writeFeatures, this);
    this.readers.feature[this.featureCollectionName] = OpenLayers.Function
        .bind(this.readFeatures, this);
  },

  writeFeatures : function(features) {
    var node = this
        .createElementNSPlus('feature:' + this.featureCollectionName);
    for ( var i = 0, len = features.length; i < len; ++i) {
      this.writeNode("gml:featureMember", features[i], node);
    }
    return node;

  },
  readFeatures : function(node, obj) {
    this.readChildNodes(node, obj);
  },
  write : function(features) {
    var root = this
        .writeNode('feature:' + this.featureCollectionName, features);
    return OpenLayers.Format.XML.prototype.write.apply(this, [ root ]);
  },
  CLASS_NAME :"Legato.Format.GML3"
});

Legato.Format.GML3.Bean = Legato.Format.Bean.Extend('Legato.Format.GML3',
//
    Legato.Format.QName('GML3'),
    //
    {
      _constructor :Legato.Format.GML3
    });