/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @author $Author: leine $
 * @version $Rev: 72369 $
 * @base Legato.Control.Legend.Plugin
 * @requires Legato/Control.js
 * @requires Legato/Legend.js
 * @requires Legato/Legend/Plugin.js
 */

/**
 * Class: Legato.Control.Legend.Plugin.LayerFunction
 * Legend Plugin wich gives you the control over the associated layer by configuring
 * this plugin with a custom javascript function.
 */
Legato.Control.Legend.Plugin.LayerFunction = OpenLayers.Class(Legato.Control.Legend.Plugin, {

  /**
   * Function: afterInitialized
   * Validates that this instance has been configured right. Throws exception if not.
   */
  afterInitialized : function() {
    Legato.Util.Ensure.ensureFunction(this.callback,
      'To use ' + this.CLASS_NAME + ' you must specify a callback function.');
  },

  /**
   * Function: afterSetup
   * Register the onclick event handler
   */
  afterSetup : function() {
    this.div.onclick = OpenLayers.Function.bindAsEventListener(this.onclick, this);
  },

  /**
   * Function: beforeDestroy
   * Destroys the created plugin div.
   */
  beforeDestroy : function() {
    this.div.onclick = null;
  },

  /**
   * Function: onclick
   * Triggered if users clicks the plugin div
   */
  onclick : function(event) {
    var result = this.callback(this.layer);
    if (Legato.Lang.ObjectUtils.exists(event)) {
      OpenLayers.Event.stop(event, true);
    }
    return result;
  },
  CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerFunction'
});

/**
 * Class: Legato.Control.Legend.Plugin.LayerFunction.Factory
 * Factory class wich is able to create a <Legato.Control.Legend.Plugin.LayerFunction>
 * instance.
 */
Legato.Control.Legend.Plugin.LayerFunction.Factory = OpenLayers.Class(
  Legato.Control.Legend.Plugin.Factory, {

    /**
     * Function: create
     * Factory method for creating a <Legato.Control.Legend.Plugin.LayerFunction> instance.
     */
    create : function(layer) {
        return new Legato.Control.Legend.Plugin.LayerFunction(layer,
            this.pluginOptions);
    },
    CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerFunction.Factory'
  }
);

/**
 * Structure: lpp:LayerFunction
 * XML based config for <Legato.Control.Legend.Plugin.LayerFunction>.
 * If configured this plugin renders a div with a configurable css class. If clicked
 * the associated layer will been passed to configured js callback.
 *
 * See Also:
 * - <Legato.Control.Legend.Plugin>
 * - <Legato.Beans.BeanFactory>
 * - <QName>
 *
 * A valid config example for a LayerLegend Plugin would be:
 * (start code)
 * <llp:LayerFunction>
 *   <callback><lb:Reference target="callbackBean" /></callback>
 *   <displayClass>Foo</displayClass>
 * </llp:LayerFunction>
 * (end)
 */
Legato.Control.Legend.Plugin.LayerFunction.Bean = Legato.Control.Legend.Plugin.Bean.Extend(

  'Legato.Control.Legend.Plugin.LayerFunction.Factory',

 /**
  * Property: QName
  * The qualified name for this control. Needed by XML config to instantiate it.
  */
  Legato.Control.Legend.Plugin.QName('LayerFunction'), {
    _constructor : Legato.Control.Legend.Plugin.LayerFunction.Factory,
    options:
    {
      callback: Legato.Lang.Function
    }
  }
);