/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Predicate.And = OpenLayers.Class({
  predicates : null,
  initialize : function(predicates) {
    Legato.Util.Ensure.ensureArray(predicates, 'Predicates must be an array.');
    for ( var index = 0; index < predicates.length; index++) {
      Legato.Util.Ensure.ensureObject(predicates[index], 'Predicate must be an object.');
      Legato.Util.Ensure.ensureFunction(predicates[index].evaluate, 'Predicate must provide an [evaluate] function.');
    }
    this.predicates = predicates;
  },
  destroy : function() {
    this.predicates = null;
  },
  evaluate : function(element) {
    for ( var index = 0; index < this.predicates.length; index++) {
      var predicate = this.predicates[index];
      if (!predicate.evaluate(element)) {
        return false;
      }
    }
    return true;
  },
  CLASS_NAME : 'Legato.Predicate.And'
});

Legato.Predicate.And.Bean = Legato.Predicate.Bean.Extend('Legato.Predicate.And',
//
Legato.Predicate.QName('And'),
//
{
  _constructor : Legato.Predicate.And,
  constructorArguments : {
    predicates : Legato.Beans['Object[]']
  },
  constructorOrder : [ 'predicates' ]

});
