/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:Panel
 * 
 * Inherits from:
 * - {<olc:Control>}
 * 
 * See also:
 * - <olc> namespace
 * - {<OpenLayers.Control.Panel>}
 */
OpenLayers.Control.Panel.Bean = OpenLayers.Control.Bean.Extend(
		'OpenLayers.Control.Panel', Legato.OpenLayers.Control.QName('Panel'), {
			_constructor : OpenLayers.Control.Panel,
			fields : {
				/**
				 * Element: defaultControl
				 * {<olc:Control>}
				 */
				defaultControl : OpenLayers.Control.Bean,
				/**
				 * Element: activeControls
				 * {<olc:Control> []}
				 */
				activeControls : OpenLayers.Control.Bean.List()
			},
			properties : {
				/**
				 * Element: controls
				 * {<olc:Control> []}
				 */
				controls : new Legato.Beans.Property(OpenLayers.Control.Bean
						.List(), function(panel, controls) {
					panel.addControls(controls);
				})
			},
			afterInstancePopulated : function(panel) {
				if (Legato.Lang.ObjectUtils.exists(panel.activeControls)) {
					for ( var i = 0; i < panel.activeControls.size(); i++) {
						panel.activateControl(panel.activeControls[i]);
					}
				}
				if (Legato.Lang.ObjectUtils.exists(panel.defaultControl)) {
					panel.activateControl(panel.defaultControl);
				}
			}
		});