/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Component: olc:EditingToolbar
 *
 * A panel of 4 controls to draw polygons, lines, points, or to navigate
 * the map by panning.
 * By default it appears in the upper right corner of the map.
 *
 * Inherits from:
 *  - <olc:Panel>
 *
 *  See also:
 *  - <olc> namespace
 *  - <OpenLayers.Control.EditingToolbar>
 *  - <olc:DrawFeature>
 */
OpenLayers.Control.EditingToolbar.Bean = OpenLayers.Control.Panel.Bean.Extend(
//
'OpenLayers.Control.EditingToolbar',
//
Legato.OpenLayers.Control.QName('EditingToolbar'),
//
{
  _constructor : OpenLayers.Control.EditingToolbar,
  constructorArguments : {
    /**
     * Element: layer
     * {<oll:Vector>}
     */
    layer : OpenLayers.Layer.Bean
  },
  constructorOrder : [ 'layer' ]
});